/*
 * Decompiled with CFR 0.152.
 */
package jpiere.base.plugin.org.adempiere.base;

import java.sql.Timestamp;
import jpiere.base.plugin.org.adempiere.model.MBill;
import jpiere.base.plugin.org.adempiere.model.X_JP_Bill;
import org.compiere.model.MClient;
import org.compiere.model.MPayment;
import org.compiere.model.MSysConfig;
import org.compiere.model.ModelValidationEngine;
import org.compiere.model.ModelValidator;
import org.compiere.model.PO;
import org.compiere.model.Query;
import org.compiere.util.CLogger;
import org.compiere.util.DB;
import org.compiere.util.Env;

public class JPiereBillModelValidator
implements ModelValidator {
    private static CLogger log = CLogger.getCLogger(JPiereBillModelValidator.class);
    private int AD_Client_ID = -1;
    public static final String JP_UPDATE_LAST_BILL_INFO = "JP_UPDATE_LAST_BILL_INFO";
    private static final String JP_UPDATE_LAST_BILL_INFO_BOTH = "BOTH";
    private static final String JP_UPDATE_LAST_BILL_INFO_AR = "AR";
    private static final String JP_UPDATE_LAST_BILL_INFO_AP = "AP";

    public void initialize(ModelValidationEngine engine, MClient client) {
        if (client != null) {
            this.AD_Client_ID = client.getAD_Client_ID();
        }
        engine.addModelChange("JP_Bill", (ModelValidator)this);
    }

    public int getAD_Client_ID() {
        return this.AD_Client_ID;
    }

    public String login(int AD_Org_ID, int AD_Role_ID, int AD_User_ID) {
        return null;
    }

    public String modelChange(PO po, int type) throws Exception {
        MBill bill;
        String updateLastBillInfo;
        if (type == 1 && po instanceof MBill && (JP_UPDATE_LAST_BILL_INFO_BOTH.equals(updateLastBillInfo = MSysConfig.getValue((String)JP_UPDATE_LAST_BILL_INFO, (String)JP_UPDATE_LAST_BILL_INFO_BOTH, (int)(bill = (MBill)po).getAD_Client_ID(), (int)bill.getAD_Org_ID())) || bill.isSOTrx() && JP_UPDATE_LAST_BILL_INFO_AR.equals(updateLastBillInfo) || !bill.isSOTrx() && JP_UPDATE_LAST_BILL_INFO_AP.equals(updateLastBillInfo))) {
            String sql;
            X_JP_Bill lastBill = null;
            if (bill.getJP_LastBill_ID() == 0 && bill.getJPLastBillAmt().compareTo(Env.ZERO) == 0) {
                String whereClause = " C_BPartner_ID =? AND C_DocType_ID = ? AND AD_Org_ID =? AND C_PaymentTerm_ID = ?  AND C_Currency_ID = ? AND DocStatus in ('CO','CL') AND JPDateBilled < ? AND IsSOTrx=? ";
                String orderClause = " JPDateBilled DESC, JP_Bill_ID DESC";
                lastBill = (MBill)new Query(po.getCtx(), "JP_Bill", whereClause, po.get_TrxName()).setParameters(new Object[]{bill.getC_BPartner_ID(), bill.getC_DocType_ID(), bill.getAD_Org_ID(), bill.getC_PaymentTerm_ID(), bill.getC_Currency_ID(), bill.getJPDateBilled(), bill.isSOTrx() ? "Y" : "N"}).setOrderBy(orderClause).first();
                if (lastBill != null) {
                    bill.setJP_LastBill_ID(lastBill.getJP_Bill_ID());
                    bill.setJPLastBillAmt(lastBill.getJPBillAmt());
                }
            }
            MPayment lastPayment = null;
            if (bill.getJP_LastBill_ID() != 0 && bill.getC_Payment_ID() == 0 && bill.getJPLastPayAmt().compareTo(Env.ZERO) == 0) {
                String whereClause = " JP_Bill_ID =? AND DocStatus in ('CO','CL') AND IsReceipt = ? AND PayAmt > 0 ";
                String orderClause = " DateTrx DESC, C_Payment_ID DESC";
                lastPayment = (MPayment)new Query(po.getCtx(), "C_Payment", whereClause, po.get_TrxName()).setParameters(new Object[]{lastBill.getJP_Bill_ID(), bill.isSOTrx() ? "Y" : "N"}).setOrderBy(orderClause).first();
                if (lastPayment != null) {
                    bill.setC_Payment_ID(lastPayment.getC_Payment_ID());
                    bill.setJPLastPayAmt(lastPayment.getPayAmt());
                }
            }
            bill.setJPCarriedForwardAmt(bill.getJPLastBillAmt().subtract(bill.getJPLastPayAmt()));
            bill.setJPBillAmt(bill.getJPCarriedForwardAmt().add(bill.getOpenAmt()));
            if (bill.getJP_PromisedPayDate() == null && bill.getC_PaymentTerm_ID() > 0) {
                sql = "SELECT JP_PaymentTermDueDate(?,?) FROM DUAL";
                Timestamp dueDate = DB.getSQLValueTS((String)po.get_TrxName(), (String)sql, (Object[])new Object[]{bill.getC_PaymentTerm_ID(), bill.getDateAcct()});
                bill.setJP_PromisedPayDate(dueDate);
            }
            if (bill.getC_BankAccount_ID() == 0) {
                sql = null;
                sql = bill.isSOTrx() ? "SELECT bs.C_BankAccount_ID FROM JP_BillSchema bs INNER JOIN C_BPartner bp ON (bs.JP_BillSchema_ID = bp.JP_BillSchema_ID) WHERE bp.C_BPartner_ID = ?" : "SELECT bs.C_BankAccount_ID FROM JP_BillSchema bs INNER JOIN C_BPartner bp ON (bs.JP_BillSchema_ID = bp.JP_BillSchemaPO_ID) WHERE bp.C_BPartner_ID = ?";
                int C_BankAccount_ID = DB.getSQLValue((String)po.get_TrxName(), (String)sql, (int)bill.getC_BPartner_ID());
                bill.setC_BankAccount_ID(C_BankAccount_ID);
                if (bill.getC_BankAccount_ID() == 0 && lastPayment != null) {
                    bill.setC_BankAccount_ID(lastPayment.getC_BankAccount_ID());
                }
            }
        }
        return null;
    }

    public String docValidate(PO po, int timing) {
        return null;
    }
}

