/*
 * Decompiled with CFR 0.152.
 */
package jpiere.base.plugin.org.adempiere.base;

import java.util.Properties;
import java.util.logging.Level;
import org.compiere.model.MBankStatement;
import org.compiere.model.MBankStatementLine;
import org.compiere.model.MClient;
import org.compiere.model.MDocType;
import org.compiere.model.MPayment;
import org.compiere.model.ModelValidationEngine;
import org.compiere.model.ModelValidator;
import org.compiere.model.PO;
import org.compiere.util.CLogger;
import org.compiere.util.Msg;

public class JPiereBankStatementModelValidator
implements ModelValidator {
    private static CLogger log = CLogger.getCLogger(JPiereBankStatementModelValidator.class);
    private int AD_Client_ID = -1;

    public void initialize(ModelValidationEngine engine, MClient client) {
        if (client != null) {
            this.AD_Client_ID = client.getAD_Client_ID();
        }
        engine.addDocValidate("C_BankStatement", (ModelValidator)this);
        if (log.isLoggable(Level.FINE)) {
            log.fine("Initialize JPiereBankStatementModelValidator");
        }
    }

    public int getAD_Client_ID() {
        return this.AD_Client_ID;
    }

    public String login(int AD_Org_ID, int AD_Role_ID, int AD_User_ID) {
        return null;
    }

    public String modelChange(PO po, int type) throws Exception {
        return null;
    }

    public String docValidate(PO po, int timing) {
        MPayment payment;
        int i;
        MBankStatementLine[] bsls;
        MBankStatement bs;
        if (timing == 7) {
            bs = (MBankStatement)po;
            bsls = bs.getLines(false);
            i = 0;
            while (i < bsls.length) {
                if (bsls[i].getC_Payment_ID() > 0) {
                    payment = new MPayment(po.getCtx(), bsls[i].getC_Payment_ID(), po.get_TrxName());
                    String dosStatus = payment.getDocStatus();
                    if (dosStatus.equals("VO") || dosStatus.equals("RE")) {
                        return String.valueOf(Msg.getElement((Properties)po.getCtx(), (String)"Line")) + " : " + bsls[i].getLine() + " - " + Msg.getMsg((Properties)po.getCtx(), (String)"JP_PaymentVOorRE");
                    }
                    if (payment.isReceipt() ? bsls[i].getTrxAmt().compareTo(payment.getPayAmt()) != 0 : bsls[i].getTrxAmt().compareTo(payment.getPayAmt().negate()) != 0) {
                        return String.valueOf(Msg.getElement((Properties)po.getCtx(), (String)"Line")) + " : " + bsls[i].getLine() + " - " + Msg.getMsg((Properties)po.getCtx(), (String)"JP_AmtNotSamePaymentAndBSLine");
                    }
                }
                ++i;
            }
        }
        if (timing == 9) {
            bs = (MBankStatement)po;
            bsls = bs.getLines(false);
            i = 0;
            while (i < bsls.length) {
                if (bsls[i].getC_Payment_ID() > 0) {
                    payment = new MPayment(po.getCtx(), bsls[i].getC_Payment_ID(), po.get_TrxName());
                    if (payment.getDocStatus().equals("VO") || payment.getDocStatus().equals("RE") || payment.getDocStatus().equals("IN")) {
                        return String.valueOf(Msg.getElement((Properties)po.getCtx(), (String)"Line")) + " : " + bsls[i].getLine() + " - " + Msg.getMsg((Properties)po.getCtx(), (String)"JP_NotValidDocStatus");
                    }
                    if (!payment.getDocStatus().equals("CO") && !payment.getDocStatus().equals("CL")) {
                        MDocType dt = new MDocType(po.getCtx(), payment.getC_DocType_ID(), po.get_TrxName());
                        if (dt.get_ValueAsBoolean("IsReconcileCompleteJP")) {
                            payment.setDateAcct(bs.getDateAcct());
                            if (!payment.processIt("CO")) {
                                return String.valueOf(Msg.getElement((Properties)po.getCtx(), (String)"Line")) + " : " + bsls[i].getLine() + " - " + Msg.getMsg((Properties)po.getCtx(), (String)"JP_UnexpectedErrorPaymentComplete");
                            }
                            payment.saveEx(po.get_TrxName());
                            if (!payment.getDocStatus().equals("CO")) {
                                return String.valueOf(Msg.getElement((Properties)po.getCtx(), (String)"Line")) + " : " + bsls[i].getLine() + " - " + Msg.getMsg((Properties)po.getCtx(), (String)"JP_UnexpectedErrorPaymentComplete");
                            }
                        } else {
                            return String.valueOf(Msg.getElement((Properties)po.getCtx(), (String)"Line")) + " : " + bsls[i].getLine() + " - " + Msg.getMsg((Properties)po.getCtx(), (String)"JP_IncompletePayment");
                        }
                    }
                }
                ++i;
            }
        }
        return null;
    }
}

