/*
 * Decompiled with CFR 0.152.
 */
package jpiere.base.plugin.org.adempiere.base;

import java.math.BigDecimal;
import java.util.Properties;
import java.util.logging.Level;
import jpiere.base.plugin.org.adempiere.model.JPiereBankStatementTaxProvider;
import jpiere.base.plugin.org.adempiere.model.MBankStatementTax;
import org.compiere.model.MBankAccount;
import org.compiere.model.MBankStatement;
import org.compiere.model.MBankStatementLine;
import org.compiere.model.MClient;
import org.compiere.model.MInvoice;
import org.compiere.model.MPayment;
import org.compiere.model.MTax;
import org.compiere.model.MTaxProvider;
import org.compiere.model.ModelValidationEngine;
import org.compiere.model.ModelValidator;
import org.compiere.model.PO;
import org.compiere.util.CLogger;
import org.compiere.util.Env;
import org.compiere.util.Msg;

public class JPiereBankStatementLineModelValidator
implements ModelValidator {
    private static CLogger log = CLogger.getCLogger(JPiereBankStatementLineModelValidator.class);
    private int AD_Client_ID = -1;

    public void initialize(ModelValidationEngine engine, MClient client) {
        if (client != null) {
            this.AD_Client_ID = client.getAD_Client_ID();
        }
        engine.addModelChange("C_BankStatementLine", (ModelValidator)this);
        if (log.isLoggable(Level.FINE)) {
            log.fine("Initialize JPiereBankStatementLineModelValidator");
        }
    }

    public int getAD_Client_ID() {
        return this.AD_Client_ID;
    }

    public String login(int AD_Org_ID, int AD_Role_ID, int AD_User_ID) {
        return null;
    }

    public String modelChange(PO po, int type) throws Exception {
        PO bst;
        MBankStatementLine bsl;
        if (type == 1 || type == 2) {
            bsl = (MBankStatementLine)po;
            if (bsl.getChargeAmt().compareTo(Env.ZERO) == 0) {
                bsl.setC_Charge_ID(0);
                bsl.set_ValueNoCheck("C_Tax_ID", null);
                bsl.set_ValueNoCheck("JP_SOPOType", null);
            } else {
                Object C_Tax_ID = bsl.get_Value("C_Tax_ID");
                Object JP_SOPOType = bsl.get_Value("JP_SOPOType");
                if (C_Tax_ID != null && JP_SOPOType == null) {
                    if (bsl.getChargeAmt().compareTo(Env.ZERO) > 0) {
                        bsl.set_ValueNoCheck("JP_SOPOType", (Object)"S");
                    } else if (bsl.getChargeAmt().compareTo(Env.ZERO) < 0) {
                        bsl.set_ValueNoCheck("JP_SOPOType", (Object)"P");
                    } else {
                        bsl.set_ValueNoCheck("JP_SOPOType", (Object)"N");
                    }
                } else if (C_Tax_ID == null) {
                    bsl.set_ValueNoCheck("JP_SOPOType", null);
                }
            }
            MBankAccount ba = MBankAccount.get((Properties)bsl.getCtx(), (int)bsl.getParent().getC_BankAccount_ID());
            if (bsl.getAD_Org_ID() != ba.getAD_Org_ID()) {
                return Msg.getMsg((Properties)bsl.getCtx(), (String)"JP_DifferentOrg");
            }
            if (bsl.getC_Currency_ID() != ba.getC_Currency_ID()) {
                return Msg.getMsg((Properties)bsl.getCtx(), (String)"JP_DifferentCurrency");
            }
        }
        if (type == 4 || type == 5) {
            bsl = (MBankStatementLine)po;
            if (type == 4 || bsl.is_ValueChanged("C_Payment_ID")) {
                int new_Payment_ID = bsl.getC_Payment_ID();
                int old_Payment_ID = bsl.get_ValueOldAsInt("C_Payment_ID");
                if (new_Payment_ID > 0) {
                    MPayment newPayment = new MPayment(bsl.getCtx(), new_Payment_ID, bsl.get_TrxName());
                    if (!newPayment.getDocStatus().equals("CO") && !newPayment.getDocStatus().equals("CL")) {
                        if (newPayment.getDocStatus().equals("VO") || newPayment.getDocStatus().equals("RE") || newPayment.getDocStatus().equals("IN")) {
                            return Msg.getMsg((Properties)bsl.getCtx(), (String)"JP_NotValidDocStatus");
                        }
                        MBankStatement bs = bsl.getParent();
                        if (bs.getDocStatus().equals("CO") || bs.getDocStatus().equals("CL")) {
                            return Msg.getMsg((Properties)bsl.getCtx(), (String)"JP_NotMatchIncompletePaymentAndCompleteBS");
                        }
                    }
                    if (newPayment.isReconciled()) {
                        return Msg.getMsg((Properties)bsl.getCtx(), (String)"JP_AlreadyReconciled");
                    }
                    if (bsl.getC_BPartner_ID() != newPayment.getC_BPartner_ID()) {
                        return Msg.getMsg((Properties)bsl.getCtx(), (String)"JP_DifferentBusinessPartner_Payment");
                    }
                    BigDecimal payAmt = newPayment.getPayAmt();
                    if (!newPayment.isReceipt()) {
                        payAmt = payAmt.negate();
                    }
                    if (bsl.getTrxAmt().compareTo(payAmt) != 0) {
                        return Msg.getMsg((Properties)bsl.getCtx(), (String)"JP_DifferentAmt");
                    }
                    MBankStatement bs = bsl.getParent();
                    if (bs.getDocStatus().equals("CO") || bs.getDocStatus().equals("CL")) {
                        newPayment.setIsReconciled(true);
                        newPayment.saveEx(bsl.get_TrxName());
                    }
                }
                if (old_Payment_ID > 0 && new_Payment_ID != old_Payment_ID) {
                    old_Payment_ID = bsl.get_ValueOldAsInt("C_Payment_ID");
                    MPayment oldPayment = new MPayment(bsl.getCtx(), old_Payment_ID, bsl.get_TrxName());
                    oldPayment.setIsReconciled(false);
                    oldPayment.saveEx(bsl.get_TrxName());
                }
            }
            if (type == 4 || bsl.is_ValueChanged("C_BPartner_ID")) {
                MInvoice invoice;
                MPayment payment;
                int new_BPartner_ID = bsl.getC_BPartner_ID();
                int C_Payment_ID = bsl.getC_Payment_ID();
                if (C_Payment_ID > 0 && new_BPartner_ID != (payment = new MPayment(bsl.getCtx(), C_Payment_ID, bsl.get_TrxName())).getC_BPartner_ID()) {
                    return Msg.getMsg((Properties)bsl.getCtx(), (String)"JP_DifferentBusinessPartner_Payment");
                }
                int C_Invoice_ID = bsl.getC_Invoice_ID();
                if (C_Invoice_ID > 0 && new_BPartner_ID != (invoice = new MInvoice(bsl.getCtx(), C_Invoice_ID, bsl.get_TrxName())).getC_BPartner_ID()) {
                    return Msg.getMsg((Properties)bsl.getCtx(), (String)"JP_DifferentBusinessPartner_Invoice");
                }
            }
            boolean newRecord = true;
            if (type == 5) {
                newRecord = false;
            }
            if (bsl.getChargeAmt().compareTo(Env.ZERO) == 0) {
                PO bst2 = MBankStatementTax.get(bsl.getCtx(), bsl.getC_BankStatementLine_ID());
                if (bst2 != null) {
                    bst2.deleteEx(false);
                }
                return null;
            }
            Object C_Tax_ID = bsl.get_Value("C_Tax_ID");
            if (C_Tax_ID == null) {
                PO bst3 = MBankStatementTax.get(bsl.getCtx(), bsl.getC_BankStatementLine_ID());
                if (bst3 != null) {
                    bst3.deleteEx(false);
                }
                return null;
            }
            String JP_SOPOType = bsl.get_ValueAsString("JP_SOPOType");
            if (JP_SOPOType == null || "N".equals(JP_SOPOType)) {
                PO bst4 = MBankStatementTax.get(bsl.getCtx(), bsl.getC_BankStatementLine_ID());
                if (bst4 != null) {
                    bst4.deleteEx(false);
                }
                return null;
            }
            MTax tax = new MTax(po.getCtx(), Integer.valueOf(C_Tax_ID.toString()).intValue(), po.get_TrxName());
            if (tax.getC_TaxProvider_ID() == 0) {
                return Msg.getMsg((Properties)bsl.getCtx(), (String)"JP_SetTaxProvider");
            }
            MTaxProvider provider = new MTaxProvider(tax.getCtx(), tax.getC_TaxProvider_ID(), tax.get_TrxName());
            if (provider.getTaxProviderClass().equals("jpiere.base.plugin.org.adempiere.model.JPiereTaxProvider")) {
                Class<?> ppClass = Class.forName("jpiere.base.plugin.org.adempiere.model.JPiereBankStatementTaxProvider");
                JPiereBankStatementTaxProvider calculator = (JPiereBankStatementTaxProvider)ppClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                boolean isCalculate = calculator.recalculateTax(provider, bsl, newRecord);
                if (!isCalculate) {
                    return Msg.getMsg((Properties)bsl.getCtx(), (String)"Error");
                }
            } else {
                return Msg.getMsg((Properties)bsl.getCtx(), (String)"JP_InvalidTaxProvider");
            }
        }
        if (type == 6 && (bst = MBankStatementTax.get((bsl = (MBankStatementLine)po).getCtx(), bsl.getC_BankStatementLine_ID())) != null) {
            bst.deleteEx(false);
        }
        return null;
    }

    public String docValidate(PO po, int timing) {
        return null;
    }
}

