/*
 * Decompiled with CFR 0.152.
 */
package jpiere.base.plugin.org.adempiere.base;

import java.util.Properties;
import java.util.logging.Level;
import jpiere.base.plugin.util.ZenginCheck;
import org.compiere.model.MBank;
import org.compiere.model.MClient;
import org.compiere.model.ModelValidationEngine;
import org.compiere.model.ModelValidator;
import org.compiere.model.PO;
import org.compiere.util.CLogger;
import org.compiere.util.Env;
import org.compiere.util.Msg;

public class JPiereBankModelValidator
implements ModelValidator {
    private static CLogger log = CLogger.getCLogger(JPiereBankModelValidator.class);
    private int AD_Client_ID = -1;

    public void initialize(ModelValidationEngine engine, MClient client) {
        if (client != null) {
            this.AD_Client_ID = client.getAD_Client_ID();
        }
        engine.addModelChange("C_Bank", (ModelValidator)this);
        if (log.isLoggable(Level.FINE)) {
            log.fine("Initialize JPiereBankModelValidator");
        }
    }

    public int getAD_Client_ID() {
        return this.AD_Client_ID;
    }

    public String login(int AD_Org_ID, int AD_Role_ID, int AD_User_ID) {
        return null;
    }

    public String modelChange(PO po, int type) throws Exception {
        MBank bank;
        String characters;
        if ((type == 1 || type == 2) && (characters = (String)(bank = (MBank)po).get_Value("JP_BankName_Kana")) != null) {
            int i = 0;
            while (i < characters.length()) {
                if (!ZenginCheck.charCheck(characters.charAt(i))) {
                    Object[] objs = new Object[]{Character.valueOf(characters.charAt(i))};
                    return Msg.getMsg((Properties)Env.getCtx(), (String)"JP_CanNotUseChar", (Object[])objs);
                }
                ++i;
            }
            if (characters.length() > 15) {
                Object[] objs = new Object[]{Msg.getElement((Properties)Env.getCtx(), (String)"JP_BankName_Kana"), 15};
                return Msg.getMsg((Properties)Env.getCtx(), (String)"JP_LessThanChars", (Object[])objs);
            }
            if (bank.getRoutingNo().length() != 4) {
                Object[] objs = new Object[]{Msg.getElement((Properties)Env.getCtx(), (String)"RoutingNo"), 4};
                return Msg.getMsg((Properties)Env.getCtx(), (String)"JP_Characters", (Object[])objs);
            }
            if (!ZenginCheck.numStringCheck(bank.getRoutingNo())) {
                Object[] objs = new Object[]{bank.getRoutingNo()};
                return String.valueOf(Msg.getElement((Properties)Env.getCtx(), (String)"RoutingNo")) + " : " + Msg.getMsg((Properties)Env.getCtx(), (String)"JP_CanNotUseString", (Object[])objs);
            }
        }
        return null;
    }

    public String docValidate(PO po, int timing) {
        return null;
    }
}

