/*
 * Decompiled with CFR 0.152.
 */
package jpiere.base.plugin.org.adempiere.base;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Properties;
import java.util.logging.Level;
import jpiere.base.plugin.org.adempiere.model.JPiereTaxProvider;
import jpiere.base.plugin.org.adempiere.model.MBill;
import jpiere.base.plugin.org.adempiere.model.MBillLine;
import jpiere.base.plugin.org.adempiere.model.MBillTax;
import jpiere.base.plugin.org.adempiere.model.MContractContent;
import jpiere.base.plugin.org.adempiere.model.MContractContentTax;
import jpiere.base.plugin.org.adempiere.model.MContractLine;
import jpiere.base.plugin.org.adempiere.model.MEstimation;
import jpiere.base.plugin.org.adempiere.model.MEstimationLine;
import jpiere.base.plugin.org.adempiere.model.MGLJournalTax;
import jpiere.base.plugin.org.adempiere.model.MRecognition;
import jpiere.base.plugin.org.adempiere.model.MRecognitionLine;
import org.adempiere.exceptions.AdempiereException;
import org.adempiere.exceptions.DBException;
import org.compiere.model.I_C_TaxProvider;
import org.compiere.model.MCharge;
import org.compiere.model.MCurrency;
import org.compiere.model.MInvoice;
import org.compiere.model.MInvoiceTax;
import org.compiere.model.MJournalLine;
import org.compiere.model.MTax;
import org.compiere.model.MTaxProvider;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.compiere.util.Util;

public interface IJPiereTaxProvider {
    public static final CLogger log = CLogger.getCLogger((String)"IJPiereTaxProvider");

    public BigDecimal calculateTax(MTax var1, BigDecimal var2, boolean var3, int var4, RoundingMode var5);

    public boolean calculateEstimationTaxTotal(MTaxProvider var1, MEstimation var2);

    public boolean recalculateTax(MTaxProvider var1, MEstimationLine var2, boolean var3);

    public boolean updateEstimationTax(MTaxProvider var1, MEstimationLine var2);

    public boolean updateHeaderTax(MTaxProvider var1, MEstimationLine var2);

    public boolean calculateRecognitionTaxTotal(MTaxProvider var1, MRecognition var2);

    public boolean recalculateTax(MTaxProvider var1, MRecognitionLine var2, boolean var3);

    public boolean updateRecognitionTax(MTaxProvider var1, MRecognitionLine var2);

    public boolean updateHeaderTax(MTaxProvider var1, MRecognitionLine var2);

    default public boolean calculateBillTaxTotal(MTaxProvider provider, MBill bill) {
        return true;
    }

    default public boolean recalculateTax(MTaxProvider provider, MBillLine billLine, MInvoice invoice, MInvoiceTax invoiceTax, boolean isOldTax) {
        if (!this.updateBillTax(provider, billLine, invoice, invoiceTax)) {
            return false;
        }
        if (isOldTax) {
            return true;
        }
        return this.updateHeaderTax(provider, billLine);
    }

    default public boolean updateBillTax(MTaxProvider provider, MBillLine billLine, MInvoice invoice, MInvoiceTax invoiceTax) {
        MCurrency currency = MCurrency.get((int)billLine.getParent().getC_Currency_ID());
        MBillTax billTax = MBillTax.get(billLine, invoiceTax, currency.getStdPrecision(), billLine.get_TrxName());
        if (billTax != null) {
            if (!this.calculateTaxFromInvoices(billLine, billTax, invoice, invoiceTax)) {
                return false;
            }
            if (billTax.getTaxAmt().signum() != 0 || billTax.getTaxBaseAmt().signum() != 0 ? !billTax.save(billLine.get_TrxName()) : !billTax.is_new() && !billTax.isProcessed() && !billTax.delete(false, billLine.get_TrxName())) {
                return false;
            }
        }
        return true;
    }

    default public boolean updateHeaderTax(MTaxProvider provider, MBillLine billLine) {
        BigDecimal TotalLines = Env.ZERO;
        BigDecimal GrandTotal = Env.ZERO;
        BigDecimal TaxBaseAmt = Env.ZERO;
        BigDecimal TaxAmt = Env.ZERO;
        BigDecimal PayAmt = Env.ZERO;
        BigDecimal OpenAmt = Env.ZERO;
        BigDecimal OverUnderAmt = Env.ZERO;
        BigDecimal JPBillAmt = Env.ZERO;
        String sql = " SELECT COALESCE(SUM(TotalLines),0)  ,COALESCE(SUM(GrandTotal),0)  ,COALESCE(SUM(TaxBaseAmt),0)  ,COALESCE(SUM(TaxAmt),0)  ,COALESCE(SUM(PayAmt),0)  ,COALESCE(SUM(OpenAmt),0)  ,COALESCE(SUM(OverUnderAmt),0) FROM JP_BillLine  WHERE JP_Bill_ID=? AND IsTaxAdjustLineJP='N' ";
        CPreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            try {
                pstmt = DB.prepareStatement((String)sql, (String)billLine.get_TrxName());
                pstmt.setInt(1, billLine.getJP_Bill_ID());
                rs = pstmt.executeQuery();
                if (rs.next()) {
                    TotalLines = rs.getBigDecimal(1);
                    GrandTotal = rs.getBigDecimal(2);
                    TaxBaseAmt = rs.getBigDecimal(3);
                    TaxAmt = rs.getBigDecimal(4);
                    PayAmt = rs.getBigDecimal(5);
                    OpenAmt = rs.getBigDecimal(6);
                    OverUnderAmt = rs.getBigDecimal(7);
                }
            }
            catch (SQLException e) {
                throw new DBException(e, sql);
            }
        }
        catch (Throwable throwable) {
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
            throw throwable;
        }
        DB.close((ResultSet)rs, (Statement)pstmt);
        rs = null;
        pstmt = null;
        BigDecimal JP_TaxBaseAmt = Env.ZERO;
        BigDecimal JP_TaxAmt = Env.ZERO;
        BigDecimal JP_RecalculatedTaxBaseAmt = Env.ZERO;
        BigDecimal JP_RecalculatedTaxAmt = Env.ZERO;
        BigDecimal JP_TaxAdjust_TaxAmt = Env.ZERO;
        sql = "SELECT   COALESCE(SUM(TaxBaseAmt),0) ,COALESCE(SUM(TaxAmt),0) ,COALESCE(SUM(JP_RecalculatedTaxBaseAmt),0) ,COALESCE(SUM(JP_RecalculatedTaxAmt),0) ,COALESCE(SUM(JP_TaxAdjust_TaxAmt),0) FROM JP_BillTax WHERE JP_Bill_ID=? ";
        try {
            try {
                pstmt = DB.prepareStatement((String)sql, (String)billLine.get_TrxName());
                pstmt.setInt(1, billLine.getJP_Bill_ID());
                rs = pstmt.executeQuery();
                if (rs.next()) {
                    JP_TaxBaseAmt = rs.getBigDecimal(1);
                    JP_TaxAmt = rs.getBigDecimal(2);
                    JP_RecalculatedTaxBaseAmt = rs.getBigDecimal(3);
                    JP_RecalculatedTaxAmt = rs.getBigDecimal(4);
                    JP_TaxAdjust_TaxAmt = rs.getBigDecimal(5);
                }
            }
            catch (SQLException e) {
                throw new DBException(e, sql);
            }
        }
        finally {
            DB.close((ResultSet)rs, (Statement)pstmt);
            rs = null;
            pstmt = null;
        }
        if (JP_TaxBaseAmt.compareTo(TaxBaseAmt) != 0) {
            // empty if block
        }
        if (JP_TaxAmt.compareTo(TaxAmt) != 0) {
            // empty if block
        }
        GrandTotal = GrandTotal.add(JP_TaxAdjust_TaxAmt);
        OpenAmt = OpenAmt.add(JP_TaxAdjust_TaxAmt);
        billLine.clearParent();
        BigDecimal JPCarriedForwardAmt = Env.ZERO;
        MBill bill = billLine.getParent();
        JPCarriedForwardAmt = bill.getJPCarriedForwardAmt();
        JPBillAmt = JPCarriedForwardAmt.add(OpenAmt);
        sql = "UPDATE JP_Bill b SET TotalLines = ? ,GrandTotal= ? ,TaxBaseAmt= ? ,TaxAmt= ? ,PayAmt= ? ,OpenAmt= ? ,OverUnderAmt = ? ,JPBillAmt = ? WHERE JP_Bill_ID= ? ";
        Object[] para = new Object[]{TotalLines, GrandTotal, JP_RecalculatedTaxBaseAmt, JP_RecalculatedTaxAmt, PayAmt, OpenAmt, OverUnderAmt, JPBillAmt, billLine.getJP_Bill_ID()};
        int no = DB.executeUpdate((String)sql, (Object[])para, (boolean)false, (String)billLine.get_TrxName());
        if (no != 1) {
            return false;
        }
        billLine.clearParent();
        return true;
    }

    private boolean calculateTaxFromInvoices(MBillLine billLine, MBillTax billTax, MInvoice invoice, MInvoiceTax invoiceTax) {
        BigDecimal taxBaseAmt = Env.ZERO;
        BigDecimal taxAmt = Env.ZERO;
        MTax tax = MTax.get((int)billTax.getC_Tax_ID());
        boolean documentLevel = tax.isDocumentLevel();
        RoundingMode roundingMode = JPiereTaxProvider.getRoundingMode(billLine.getParent().getC_BPartner_ID(), billLine.getParent().isSOTrx(), tax.getC_TaxProvider());
        String sql = " SELECT COALESCE(SUM(CASE WHEN dt.DocBaseType='APC' THEN it.TaxBaseAmt*-1 WHEN dt.DocBaseType='ARC' THEN it.TaxBaseAmt*-1\tELSE it.TaxBaseAmt END),0)  ,COALESCE(SUM(CASE WHEN dt.DocBaseType='APC' THEN it.TaxAmt*-1 WHEN dt.DocBaseType='ARC' THEN it.TaxAmt*-1 ELSE it.TaxAmt END),0) FROM C_InvoiceTax it  INNER JOIN C_Invoice i ON (it.C_Invoice_ID = i.C_Invoice_ID)  INNER JOIN C_DocType dt ON (i.C_DocTypeTarget_ID = dt.C_DocType_ID)  INNER JOIN JP_BillLine bl ON (i.C_Invoice_ID = bl.C_Invoice_ID)  WHERE bl.JP_Bill_ID=? AND it.C_Tax_ID = ? AND it.IsTaxIncluded=? ";
        CPreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            try {
                pstmt = DB.prepareStatement((String)sql, (String)billLine.get_TrxName());
                pstmt.setInt(1, billTax.getJP_Bill_ID());
                pstmt.setInt(2, billTax.getC_Tax_ID());
                pstmt.setString(3, billTax.isTaxIncluded() ? "Y" : "N");
                rs = pstmt.executeQuery();
                if (rs.next()) {
                    taxBaseAmt = rs.getBigDecimal(1);
                    taxAmt = rs.getBigDecimal(2);
                }
            }
            catch (SQLException e) {
                throw new DBException(e, sql);
            }
        }
        catch (Throwable throwable) {
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
            throw throwable;
        }
        DB.close((ResultSet)rs, (Statement)pstmt);
        rs = null;
        pstmt = null;
        billTax.setTaxBaseAmt(taxBaseAmt);
        billTax.setTaxAmt(taxAmt);
        billTax.setJP_RecalculatedTaxBaseAmt(taxBaseAmt);
        billTax.setJP_RecalculatedTaxAmt(taxAmt);
        billTax.setJP_TaxAdjust_TaxAmt(Env.ZERO);
        if (documentLevel && billLine.getParent().isTaxRecalculateJP()) {
            if (invoice.isTaxIncluded() == invoiceTax.isTaxIncluded()) {
                BigDecimal lineNetAmt = Env.ZERO;
                sql = "SELECT COALESCE(sum(CASE  WHEN dt.DocBaseType='APC' THEN il.LineNetAmt*-1  WHEN dt.DocBaseType='ARC' THEN il.LineNetAmt*-1 ELSE il.LineNetAmt END),0) FROM C_InvoiceLine il INNER JOIN C_Invoice i \tON (il.C_Invoice_ID = i.C_Invoice_ID)  INNER JOIN C_DocType dt ON (i.C_DocTypeTarget_ID = dt.C_DocType_ID)  INNER JOIN JP_BillLine bl ON (i.C_Invoice_ID=bl.C_Invoice_ID)  WHERE bl.JP_Bill_ID=? AND il.C_Tax_ID=? AND i.IsTaxIncluded=? ";
                lineNetAmt = DB.getSQLValueBD((String)billLine.get_TrxName(), (String)sql, (Object[])new Object[]{billTax.getJP_Bill_ID(), billTax.getC_Tax_ID(), billTax.isTaxIncluded() ? "Y" : "N"});
                taxAmt = this.calculateTax(tax, lineNetAmt, billTax.isTaxIncluded(), billTax.getPrecision(), roundingMode);
                billTax.setJP_RecalculatedTaxAmt(taxAmt);
                if (billTax.isTaxIncluded()) {
                    billTax.setJP_RecalculatedTaxBaseAmt(lineNetAmt.subtract(taxAmt));
                } else {
                    billTax.setJP_RecalculatedTaxBaseAmt(lineNetAmt);
                }
                billTax.setJP_TaxAdjust_TaxAmt(billTax.getJP_RecalculatedTaxAmt().subtract(billTax.getTaxAmt()));
            } else {
                throw new AdempiereException(String.valueOf(Msg.getMsg((Properties)Env.getCtx(), (String)"JP_TaxAdjust_ErrorOfMixTax")) + " - " + invoice.getDocumentNo() + " : " + tax.getName());
            }
        }
        return true;
    }

    /*
     * Unable to fully structure code
     */
    default public boolean calculateContractContentTaxTotal(MTaxProvider provider, MContractContent contractContent) {
        totalLines = Env.ZERO;
        taxList = new ArrayList<Integer>();
        lines = contractContent.getLines();
        i = 0;
        while (i < lines.length) {
            block17: {
                line = lines[i];
                totalLines = totalLines.add(line.getLineNetAmt());
                taxID = line.getC_Tax_ID();
                if (taxList.contains(taxID)) break block17;
                eTax = MContractContentTax.get(line, contractContent.getPrecision(), false, contractContent.get_TrxName());
                if (eTax.isTaxIncluded() == contractContent.isTaxIncluded()) ** GOTO lbl26
                if (line.getC_Charge_ID() != 0) {
                    charge = MCharge.get((Properties)Env.getCtx(), (int)line.getC_Charge_ID());
                    if (charge.isSameTax()) {
                        IJPiereTaxProvider.log.saveError("Error", Msg.getMsg((Properties)Env.getCtx(), (String)"JP_NotSet_Common_TaxRate"));
                        return false;
                    }
                    if (eTax.isTaxIncluded() != charge.isTaxIncluded()) {
                        IJPiereTaxProvider.log.saveError("Error", Msg.getMsg((Properties)Env.getCtx(), (String)"JP_NotSet_Common_TaxRate"));
                        return false;
                    }
                } else {
                    IJPiereTaxProvider.log.saveError("Error", Msg.getMsg((Properties)Env.getCtx(), (String)"JP_NotSet_Common_TaxRate"));
                    return false;
lbl26:
                    // 1 sources

                    if (line.getC_Charge_ID() != 0 && !(charge = MCharge.get((Properties)Env.getCtx(), (int)line.getC_Charge_ID())).isSameTax() && eTax.isTaxIncluded() != charge.isTaxIncluded()) {
                        IJPiereTaxProvider.log.saveError("Error", Msg.getMsg((Properties)Env.getCtx(), (String)"JP_NotSet_Common_TaxRate"));
                        return false;
                    }
                }
                if (!this.calculateTaxFromContractLines(line, eTax)) {
                    return false;
                }
                if (!eTax.save(contractContent.get_TrxName())) {
                    return false;
                }
                taxList.add(taxID);
            }
            ++i;
        }
        grandTotal = totalLines;
        taxes = contractContent.getTaxes(true);
        roundingMode = JPiereTaxProvider.getRoundingMode(lines[0].getParent().getC_BPartner_ID(), lines[0].getParent().isSOTrx(), (I_C_TaxProvider)provider);
        i = 0;
        while (i < taxes.length) {
            eTax = taxes[i];
            tax = MTax.get((Properties)eTax.getCtx(), (int)eTax.getC_Tax_ID());
            if (tax.isSummary()) {
                cTaxes = tax.getChildTaxes(false);
                j = 0;
                while (j < cTaxes.length) {
                    cTax = cTaxes[j];
                    taxAmt = this.calculateTax(cTax, eTax.getTaxBaseAmt(), eTax.isTaxIncluded(), contractContent.getPrecision(), roundingMode);
                    newOTax = new MContractContentTax(contractContent.getCtx(), 0, contractContent.get_TrxName());
                    newOTax.set_ValueOfColumn("AD_Client_ID", contractContent.getAD_Client_ID());
                    newOTax.setAD_Org_ID(contractContent.getAD_Org_ID());
                    newOTax.setJP_ContractContent_ID(contractContent.getJP_ContractContent_ID());
                    newOTax.setC_Tax_ID(cTax.getC_Tax_ID());
                    newOTax.setIsTaxIncluded(eTax.isTaxIncluded());
                    newOTax.setTaxBaseAmt(eTax.getTaxBaseAmt());
                    newOTax.setTaxAmt(taxAmt);
                    if (!newOTax.save(contractContent.get_TrxName())) {
                        return false;
                    }
                    if (!eTax.isTaxIncluded()) {
                        grandTotal = grandTotal.add(taxAmt);
                    }
                    ++j;
                }
                if (!eTax.delete(true, contractContent.get_TrxName())) {
                    return false;
                }
                if (!eTax.save(contractContent.get_TrxName())) {
                    return false;
                }
            } else if (!eTax.isTaxIncluded()) {
                grandTotal = grandTotal.add(eTax.getTaxAmt());
            }
            ++i;
        }
        contractContent.setTotalLines(totalLines);
        contractContent.setGrandTotal(grandTotal);
        return true;
    }

    default public boolean recalculateTax(MTaxProvider provider, MContractLine line, boolean newRecord) {
        if (!newRecord && line.is_ValueChanged("C_Tax_ID") && !line.getParent().isProcessed() && !this.updateContractContentTax(line, true)) {
            return false;
        }
        if (!this.updateContractContentTax(line, false)) {
            return false;
        }
        return this.updateHeaderTax(provider, line);
    }

    default public boolean updateContractContentTax(MTaxProvider provider, MContractLine line) {
        return this.updateContractContentTax(line, false);
    }

    /*
     * Enabled aggressive block sorting
     */
    private boolean updateContractContentTax(MContractLine line, boolean oldTax) {
        MContractContentTax tax = MContractContentTax.get(line, line.getPrecision(), oldTax, line.get_TrxName());
        if (tax != null) {
            MCharge charge;
            if (tax.isTaxIncluded() != line.getParent().isTaxIncluded()) {
                if (line.getC_Charge_ID() == 0) {
                    log.saveError("Error", Msg.getMsg((Properties)Env.getCtx(), (String)"JP_NotSet_Common_TaxRate"));
                    return false;
                }
                MCharge charge2 = MCharge.get((Properties)Env.getCtx(), (int)line.getC_Charge_ID());
                if (charge2.isSameTax()) {
                    log.saveError("Error", Msg.getMsg((Properties)Env.getCtx(), (String)"JP_NotSet_Common_TaxRate"));
                    return false;
                }
                if (tax.isTaxIncluded() != charge2.isTaxIncluded()) {
                    log.saveError("Error", Msg.getMsg((Properties)Env.getCtx(), (String)"JP_NotSet_Common_TaxRate"));
                    return false;
                }
            } else if (line.getC_Charge_ID() != 0 && !(charge = MCharge.get((Properties)Env.getCtx(), (int)line.getC_Charge_ID())).isSameTax() && tax.isTaxIncluded() != charge.isTaxIncluded()) {
                log.saveError("Error", Msg.getMsg((Properties)Env.getCtx(), (String)"JP_NotSet_Common_TaxRate"));
                return false;
            }
            if (!this.calculateTaxFromContractLines(line, tax)) {
                return false;
            }
            if (tax.getTaxAmt().signum() != 0 || tax.getTaxBaseAmt().signum() != 0 ? !tax.save(line.get_TrxName()) : !tax.is_new() && !tax.delete(false, line.get_TrxName())) {
                return false;
            }
        }
        return true;
    }

    default public boolean updateHeaderTax(MTaxProvider provider, MContractLine line) {
        String sql = "UPDATE JP_ContractContent cc SET TotalLines = (SELECT COALESCE(SUM(LineNetAmt),0) FROM JP_ContractLine cl WHERE cc.JP_ContractContent_ID=cl.JP_ContractContent_ID)WHERE JP_ContractContent_ID=?";
        int no = DB.executeUpdate((String)sql, (Object[])new Object[]{line.getJP_ContractContent_ID()}, (boolean)false, (String)line.get_TrxName(), (int)0);
        if (no != 1) {
            log.warning("(1) #" + no);
            return false;
        }
        sql = "UPDATE JP_ContractContent cc  SET GrandTotal=TotalLines+(SELECT COALESCE(SUM(TaxAmt),0) FROM JP_ContractContentTax cct WHERE cc.JP_ContractContent_ID=cct.JP_ContractContent_ID AND cct.IsTaxIncluded='N' ) WHERE JP_ContractContent_ID=?";
        no = DB.executeUpdate((String)sql, (Object[])new Object[]{line.getJP_ContractContent_ID()}, (boolean)false, (String)line.get_TrxName(), (int)0);
        if (no != 1) {
            log.warning("(2) #" + no);
        }
        line.clearParent();
        return no == 1;
    }

    private boolean calculateTaxFromContractLines(MContractLine line, MContractContentTax m_ContractContentTax) {
        RoundingMode roundingMode;
        boolean documentLevel;
        MTax tax;
        BigDecimal taxAmt;
        BigDecimal taxBaseAmt;
        block11: {
            taxBaseAmt = Env.ZERO;
            taxAmt = Env.ZERO;
            tax = MTax.get((Properties)m_ContractContentTax.getCtx(), (int)m_ContractContentTax.getC_Tax_ID());
            documentLevel = tax.isDocumentLevel();
            roundingMode = JPiereTaxProvider.getRoundingMode(line.getParent().getC_BPartner_ID(), line.getParent().isSOTrx(), tax.getC_TaxProvider());
            String sql = "SELECT LineNetAmt FROM JP_ContractLine WHERE JP_ContractContent_ID=? AND C_Tax_ID=?";
            CPreparedStatement pstmt = null;
            ResultSet rs = null;
            try {
                try {
                    pstmt = DB.prepareStatement((String)sql, (String)m_ContractContentTax.get_TrxName());
                    pstmt.setInt(1, m_ContractContentTax.getJP_ContractContent_ID());
                    pstmt.setInt(2, m_ContractContentTax.getC_Tax_ID());
                    rs = pstmt.executeQuery();
                    while (rs.next()) {
                        BigDecimal baseAmt = rs.getBigDecimal(1);
                        taxBaseAmt = taxBaseAmt.add(baseAmt);
                        if (documentLevel) continue;
                        taxAmt = taxAmt.add(this.calculateTax(tax, baseAmt, m_ContractContentTax.isTaxIncluded(), line.getPrecision(), roundingMode));
                    }
                }
                catch (Exception e) {
                    log.log(Level.SEVERE, m_ContractContentTax.get_TrxName(), (Throwable)e);
                    taxBaseAmt = null;
                    DB.close(rs, (Statement)pstmt);
                    rs = null;
                    pstmt = null;
                    break block11;
                }
            }
            catch (Throwable throwable) {
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
            DB.close((ResultSet)rs, (Statement)pstmt);
            rs = null;
            pstmt = null;
        }
        if (taxBaseAmt == null) {
            return false;
        }
        if (documentLevel) {
            taxAmt = this.calculateTax(tax, taxBaseAmt, m_ContractContentTax.isTaxIncluded(), line.getPrecision(), roundingMode);
        }
        m_ContractContentTax.setTaxAmt(taxAmt);
        if (m_ContractContentTax.isTaxIncluded()) {
            m_ContractContentTax.setTaxBaseAmt(taxBaseAmt.subtract(taxAmt));
        } else {
            m_ContractContentTax.setTaxBaseAmt(taxBaseAmt);
        }
        if (log.isLoggable(Level.FINE)) {
            log.fine(this.toString());
        }
        return true;
    }

    default public boolean recalculateTax(MTaxProvider provider, MJournalLine line, boolean newRecord) {
        if (!newRecord && !line.getParent().isProcessed() && (line.is_ValueChanged("C_Tax_ID") || line.is_ValueChanged("JP_SOPOType") || line.is_ValueChanged("AmtSourceDr") || line.is_ValueChanged("AmtSourceCr")) && !this.updateGLJournalTax(line, true)) {
            return false;
        }
        String JP_SOPOType = line.get_ValueAsString("JP_SOPOType");
        return !"S".equals(JP_SOPOType) && !"P".equals(JP_SOPOType) || this.updateGLJournalTax(line, false);
    }

    private boolean updateGLJournalTax(MJournalLine line, boolean oldTax) {
        MGLJournalTax tax;
        String JP_SOPOType = null;
        if (oldTax) {
            Object obj = line.get_ValueOld("JP_SOPOType");
            if (obj != null) {
                JP_SOPOType = (String)obj;
            }
        } else {
            JP_SOPOType = line.get_ValueAsString("JP_SOPOType");
        }
        if ((tax = MGLJournalTax.get(line, line.getPrecision(), oldTax, line.get_TrxName())) != null) {
            if (!this.calculateTaxFromJournalLines(line, tax, JP_SOPOType)) {
                return false;
            }
            if (tax.getTaxAmt().signum() != 0 || tax.getTaxBaseAmt().signum() != 0 ? !tax.save(line.get_TrxName()) : !tax.is_new() && !tax.delete(false, line.get_TrxName())) {
                return false;
            }
        }
        return true;
    }

    private boolean calculateTaxFromJournalLines(MJournalLine line, MGLJournalTax m_GLJournalTax, String JP_SOPOType) {
        int Precision;
        RoundingMode roundingMode;
        boolean documentLevel;
        MTax tax;
        BigDecimal taxAmt;
        BigDecimal taxBaseAmt;
        block15: {
            if (Util.isEmpty((String)JP_SOPOType) || "N".equals(JP_SOPOType)) {
                return true;
            }
            taxBaseAmt = Env.ZERO;
            taxAmt = Env.ZERO;
            tax = MTax.get((Properties)m_GLJournalTax.getCtx(), (int)m_GLJournalTax.getC_Tax_ID());
            documentLevel = tax.isDocumentLevel();
            roundingMode = JPiereTaxProvider.getRoundingMode(line.getC_BPartner_ID(), JP_SOPOType.equals("S"), tax.getC_TaxProvider());
            Precision = MCurrency.getStdPrecision((Properties)Env.getCtx(), (int)line.getC_Currency_ID());
            String sql = null;
            if (JP_SOPOType.equals("S")) {
                sql = "SELECT AmtSourceCr - AmtSourceDr FROM GL_JournalLine WHERE GL_Journal_ID=? AND JP_SOPOType=? AND C_Tax_ID=?";
            } else if (JP_SOPOType.equals("P")) {
                sql = "SELECT AmtSourceDr - AmtSourceCr FROM GL_JournalLine WHERE GL_Journal_ID=? AND JP_SOPOType=? AND C_Tax_ID=?";
            }
            CPreparedStatement pstmt = null;
            ResultSet rs = null;
            try {
                try {
                    pstmt = DB.prepareStatement((String)sql, (String)m_GLJournalTax.get_TrxName());
                    pstmt.setInt(1, m_GLJournalTax.getGL_Journal_ID());
                    pstmt.setString(2, JP_SOPOType);
                    pstmt.setInt(3, m_GLJournalTax.getC_Tax_ID());
                    rs = pstmt.executeQuery();
                    while (rs.next()) {
                        BigDecimal baseAmt = rs.getBigDecimal(1);
                        taxBaseAmt = taxBaseAmt.add(baseAmt);
                        if (documentLevel) continue;
                        taxAmt = taxAmt.add(this.calculateTax(tax, baseAmt, m_GLJournalTax.isTaxIncluded(), Precision, roundingMode));
                    }
                }
                catch (Exception e) {
                    log.log(Level.SEVERE, m_GLJournalTax.get_TrxName(), (Throwable)e);
                    taxBaseAmt = null;
                    DB.close(rs, (Statement)pstmt);
                    rs = null;
                    pstmt = null;
                    break block15;
                }
            }
            catch (Throwable throwable) {
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
            DB.close((ResultSet)rs, (Statement)pstmt);
            rs = null;
            pstmt = null;
        }
        if (taxBaseAmt == null) {
            return false;
        }
        if (documentLevel) {
            taxAmt = this.calculateTax(tax, taxBaseAmt, m_GLJournalTax.isTaxIncluded(), Precision, roundingMode);
        }
        m_GLJournalTax.setTaxAmt(taxAmt);
        if (m_GLJournalTax.isTaxIncluded()) {
            m_GLJournalTax.setTaxBaseAmt(taxBaseAmt.subtract(taxAmt));
        } else {
            m_GLJournalTax.setTaxBaseAmt(taxBaseAmt);
        }
        if (log.isLoggable(Level.FINE)) {
            log.fine(this.toString());
        }
        return true;
    }
}

