/*
 * Decompiled with CFR 0.152.
 */
package jpiere.base.plugin.factory;

import java.lang.reflect.Method;
import java.util.logging.Level;
import org.adempiere.base.ICalloutFactory;
import org.adempiere.base.equinox.EquinoxExtensionLocator;
import org.compiere.model.Callout;
import org.compiere.util.CLogger;

public class JPiereBasePluginCalloutFactory
implements ICalloutFactory {
    private static final CLogger log = CLogger.getCLogger(JPiereBasePluginCalloutFactory.class);

    public Callout getCallout(String className, String methodName) {
        if (className.startsWith("jpiere.base.plugin")) {
            Callout callout = null;
            callout = (Callout)EquinoxExtensionLocator.instance().locate(Callout.class, Callout.class.getName(), className, null).getExtension();
            if (callout == null) {
                ClassLoader classLoader;
                Class<?> calloutClass;
                block13: {
                    calloutClass = null;
                    classLoader = Thread.currentThread().getContextClassLoader();
                    if (classLoader != null) {
                        try {
                            calloutClass = classLoader.loadClass(className);
                        }
                        catch (ClassNotFoundException ex) {
                            if (!log.isLoggable(Level.FINE)) break block13;
                            log.log(Level.FINE, className, (Throwable)ex);
                        }
                    }
                }
                if (calloutClass == null) {
                    classLoader = this.getClass().getClassLoader();
                    try {
                        calloutClass = classLoader.loadClass(className);
                    }
                    catch (ClassNotFoundException ex) {
                        log.log(Level.WARNING, className, (Throwable)ex);
                        return null;
                    }
                }
                if (calloutClass == null) {
                    return null;
                }
                try {
                    callout = (Callout)calloutClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                }
                catch (Exception ex) {
                    log.log(Level.WARNING, "Instance for " + className, (Throwable)ex);
                    return null;
                }
                Method[] methods = calloutClass.getDeclaredMethods();
                int i = 0;
                while (i < methods.length) {
                    if (methods[i].getName().equals(methodName)) {
                        return callout;
                    }
                    ++i;
                }
            }
            log.log(Level.FINE, "Required method " + methodName + " not found in class " + className);
        }
        return null;
    }
}

