/*
 * Decompiled with CFR 0.152.
 */
package jpiere.plugin.simpleinputwindow.window;

import java.text.SimpleDateFormat;
import java.util.Properties;
import jpiere.plugin.simpleinputwindow.component.SimpleInputWindowDocumentLink;
import jpiere.plugin.simpleinputwindow.form.JPiereSimpleInputWindow;
import org.adempiere.webui.apps.ProcessModalDialog;
import org.adempiere.webui.theme.ThemeManager;
import org.compiere.process.ProcessInfo;
import org.compiere.process.ProcessInfoLog;
import org.compiere.process.ProcessInfoUtil;
import org.compiere.util.DisplayType;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.zkoss.zhtml.Table;
import org.zkoss.zhtml.Td;
import org.zkoss.zhtml.Text;
import org.zkoss.zhtml.Tr;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.HtmlBasedComponent;
import org.zkoss.zk.ui.event.Event;
import org.zkoss.zk.ui.event.EventListener;
import org.zkoss.zul.Div;
import org.zkoss.zul.Html;
import org.zkoss.zul.Label;
import org.zkoss.zul.Vlayout;

public class SimpleInputWindowProcessModelDialog
extends ProcessModalDialog {
    private JPiereSimpleInputWindow simpleInputWindow;
    private HtmlBasedComponent resultPanelLayout;
    private HtmlBasedComponent messageResultContent;
    private HtmlBasedComponent infoResultContent;
    private Table logMessageTable;

    public SimpleInputWindowProcessModelDialog(int WindowNo, ProcessInfo pi, boolean autoStart, JPiereSimpleInputWindow simpleInputWindow) {
        super(WindowNo, pi, autoStart);
        this.simpleInputWindow = simpleInputWindow;
    }

    public SimpleInputWindowProcessModelDialog(EventListener<Event> listener, int WindowNo, ProcessInfo pi, boolean autoStart) {
        super(listener, WindowNo, pi, autoStart);
    }

    public SimpleInputWindowProcessModelDialog(int WindowNo, int AD_Process_ID, int tableId, int recordId, boolean autoStart, JPiereSimpleInputWindow simpleInputWindow) {
        super(WindowNo, AD_Process_ID, tableId, recordId, autoStart);
        this.simpleInputWindow = simpleInputWindow;
    }

    public SimpleInputWindowProcessModelDialog(EventListener<Event> listener, int WindowNo, int AD_Process_ID, int tableId, int recordId, boolean autoStart) {
        super(listener, WindowNo, AD_Process_ID, tableId, recordId, autoStart);
    }

    public void onEvent(Event event) {
        super.onEvent(event);
        if (event.getName().equals("onComplete")) {
            try {
                this.simpleInputWindow.onEvent(event);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public HtmlBasedComponent getInfoResultContent() {
        return this.infoResultContent;
    }

    public void updateUI() {
        this.swithToFinishScreen();
    }

    protected void swithToFinishScreen() {
        ProcessInfo pi = this.getProcessInfo();
        ProcessInfoUtil.setLogFromDB((ProcessInfo)pi);
        this.layoutResultPanel(this.topParameterLayout);
        StringBuilder buildMsg = new StringBuilder(this.getInitialMessage());
        buildMsg.append("<p><font color=\"").append(pi.isError() ? "#FF0000" : "#0000FF").append("\">** ").append(pi.getSummary()).append("</font></p>");
        ((Html)this.messageResultContent).setContent(buildMsg.toString());
        this.infoResultContent.getChildren().removeAll(this.infoResultContent.getChildren());
        this.appendRecordLogInfo(pi.getLogs(), this.infoResultContent);
        this.bOK.setLabel(Msg.getMsg((Properties)Env.getCtx(), (String)"Parameter"));
        this.bOK.setImage(ThemeManager.getThemeResource((String)"images/Reset16.png"));
        this.bCancel.setLabel(Msg.getMsg((Properties)Env.getCtx(), (String)"Close"));
        this.bCancel.setImage(ThemeManager.getThemeResource((String)"images/Cancel16.png"));
    }

    private void layoutResultPanel(HtmlBasedComponent topParameterLayout) {
        if (this.resultPanelLayout == null) {
            this.resultPanelLayout = new Vlayout();
            this.resultPanelLayout.setSclass("result-parameter-layout");
            this.resultPanelLayout.setVflex("true");
            this.messageResultContent = this.setHeadMessage(this.resultPanelLayout, null);
            this.infoResultContent = new Div();
            this.resultPanelLayout.appendChild((Component)this.infoResultContent);
        }
    }

    protected void replaceComponent(HtmlBasedComponent newComponent, HtmlBasedComponent oldComponent) {
    }

    private void appendRecordLogInfo(ProcessInfoLog[] m_logs, HtmlBasedComponent infoResultContent) {
        if (m_logs == null) {
            return;
        }
        SimpleDateFormat dateFormat = DisplayType.getDateFormat((int)15);
        this.logMessageTable = new Table();
        this.logMessageTable.setId("logrecords");
        this.logMessageTable.setDynamicProperty("border", (Object)"1");
        this.logMessageTable.setDynamicProperty("cellpadding", (Object)"0");
        this.logMessageTable.setDynamicProperty("cellspacing", (Object)"0");
        this.logMessageTable.setDynamicProperty("width", (Object)"100%");
        infoResultContent.appendChild((Component)this.logMessageTable);
        boolean datePresents = false;
        boolean numberPresents = false;
        boolean msgPresents = false;
        ProcessInfoLog[] processInfoLogArray = m_logs;
        int n = m_logs.length;
        int n2 = 0;
        while (n2 < n) {
            ProcessInfoLog log = processInfoLogArray[n2];
            if (log.getP_Date() != null) {
                datePresents = true;
            }
            if (log.getP_Number() != null) {
                numberPresents = true;
            }
            if (log.getP_Msg() != null) {
                msgPresents = true;
            }
            ++n2;
        }
        int i = 0;
        while (i < m_logs.length) {
            Td td;
            Tr tr = new Tr();
            this.logMessageTable.appendChild((Component)tr);
            ProcessInfoLog log = m_logs[i];
            if (datePresents) {
                td = new Td();
                if (log.getP_Date() != null) {
                    Label label = new Label(dateFormat.format(log.getP_Date()));
                    td.appendChild((Component)label);
                }
                tr.appendChild((Component)td);
            }
            if (numberPresents) {
                td = new Td();
                if (log.getP_Number() != null) {
                    Label labelPno = new Label("" + log.getP_Number());
                    td.appendChild((Component)labelPno);
                }
                tr.appendChild((Component)td);
            }
            if (msgPresents) {
                td = new Td();
                if (log.getP_Msg() != null) {
                    if (log.getAD_Table_ID() > 0 && log.getRecord_ID() > 0) {
                        SimpleInputWindowDocumentLink recordLink = new SimpleInputWindowDocumentLink(log.getP_Msg(), log.getAD_Table_ID(), log.getRecord_ID());
                        td.appendChild((Component)recordLink);
                    } else {
                        Text t = new Text();
                        t.setEncode(false);
                        t.setValue(log.getP_Msg());
                        td.appendChild((Component)t);
                    }
                }
                tr.appendChild((Component)td);
            }
            ++i;
        }
    }
}

