/*
 * Decompiled with CFR 0.152.
 */
package jpiere.plugin.simpleinputwindow.process;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import org.adempiere.base.IModelFactory;
import org.adempiere.base.Service;
import org.compiere.model.MInventory;
import org.compiere.model.MInventoryLine;
import org.compiere.model.MInventoryLineMA;
import org.compiere.model.MStorageOnHand;
import org.compiere.model.PO;
import org.compiere.process.DocAction;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.util.AdempiereSystemError;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Msg;

public class SimpleInputWindowInventoryCountUpdate
extends SvrProcess {
    private int p_M_Inventory_ID = 0;
    private boolean p_InventoryCountSetZero = false;

    protected void prepare() {
        ProcessInfoParameter[] para = this.getParameter();
        int i = 0;
        while (i < para.length) {
            String name = para[i].getParameterName();
            if (para[i].getParameter() != null) {
                if (name.equals("InventoryCountSet")) {
                    this.p_InventoryCountSetZero = "Z".equals(para[i].getParameter());
                } else if (name.equals("M_Inventory_ID")) {
                    this.p_M_Inventory_ID = para[i].getParameterAsInt();
                } else {
                    this.log.log(Level.SEVERE, "Unknown Parameter: " + name);
                }
            }
            ++i;
        }
    }

    protected String doIt() throws Exception {
        MInventory inventory;
        if (this.log.isLoggable(Level.INFO)) {
            this.log.info("M_Inventory_ID=" + this.p_M_Inventory_ID);
        }
        if ((inventory = new MInventory(this.getCtx(), this.p_M_Inventory_ID, this.get_TrxName())).get_ID() == 0) {
            throw new AdempiereSystemError("Not found: M_Inventory_ID=" + this.p_M_Inventory_ID);
        }
        List factoryList = Service.locator().list(IModelFactory.class).getServices();
        if (factoryList == null) {
            // empty if block
        }
        PO po = null;
        DocAction document = null;
        for (IModelFactory factory : factoryList) {
            po = factory.getPO("M_Inventory", this.p_M_Inventory_ID, null);
            if (po == null || !(po instanceof DocAction)) continue;
            document = (DocAction)po;
            if (document.getDocStatus().equals("DR")) break;
            return Msg.getMsg((Properties)this.getCtx(), (String)"JP_Process_Cannot_Perform");
        }
        if (document == null) {
            return Msg.getMsg((Properties)this.getCtx(), (String)"Error");
        }
        StringBuilder sql = new StringBuilder("UPDATE M_InventoryLine SET IsActive='N' ").append("WHERE M_Inventory_ID=").append(this.p_M_Inventory_ID).append(" AND (M_Product_ID, M_Locator_ID, M_AttributeSetInstance_ID) IN ").append("(SELECT M_Product_ID, M_Locator_ID, M_AttributeSetInstance_ID ").append("FROM M_InventoryLine ").append("WHERE M_Inventory_ID=").append(this.p_M_Inventory_ID).append(" GROUP BY M_Product_ID, M_Locator_ID, M_AttributeSetInstance_ID ").append("HAVING COUNT(*) > 1)");
        int multiple = DB.executeUpdate((String)sql.toString(), (String)this.get_TrxName());
        if (this.log.isLoggable(Level.INFO)) {
            this.log.info("Multiple=" + multiple);
        }
        int delMA = MInventoryLineMA.deleteInventoryMA((int)this.p_M_Inventory_ID, (String)this.get_TrxName());
        if (this.log.isLoggable(Level.INFO)) {
            this.log.info("DeletedMA=" + delMA);
        }
        sql = new StringBuilder("UPDATE M_InventoryLine l ").append("SET (QtyBook,QtyCount) = ").append("(SELECT QtyOnHand,QtyOnHand FROM M_StorageOnHand s ").append("WHERE s.M_Product_ID=l.M_Product_ID AND s.M_Locator_ID=l.M_Locator_ID").append(" AND s.M_AttributeSetInstance_ID=l.M_AttributeSetInstance_ID),").append(" Updated=SysDate,").append(" UpdatedBy=").append(this.getAD_User_ID()).append(" WHERE M_Inventory_ID=").append(this.p_M_Inventory_ID).append(" AND EXISTS (SELECT * FROM M_StorageOnHand s ").append("WHERE s.M_Product_ID=l.M_Product_ID AND s.M_Locator_ID=l.M_Locator_ID").append(" AND s.M_AttributeSetInstance_ID=l.M_AttributeSetInstance_ID)");
        int no = DB.executeUpdate((String)sql.toString(), (String)this.get_TrxName());
        if (this.log.isLoggable(Level.INFO)) {
            this.log.info("Update with ASI=" + no);
        }
        int noMA = this.updateWithMA();
        if (this.p_InventoryCountSetZero) {
            sql = new StringBuilder("UPDATE M_InventoryLine l ").append("SET QtyCount=0 ").append("WHERE M_Inventory_ID=").append(this.p_M_Inventory_ID);
            no = DB.executeUpdate((String)sql.toString(), (String)this.get_TrxName());
            if (this.log.isLoggable(Level.INFO)) {
                this.log.info("Set Count to Zero=" + no);
            }
        }
        if (multiple > 0) {
            StringBuilder msgreturn = new StringBuilder("@M_InventoryLine_ID@ - #").append(no + noMA).append(" --> @InventoryProductMultiple@");
            return msgreturn.toString();
        }
        StringBuilder msgreturn = new StringBuilder("@M_InventoryLine_ID@ - #").append(no);
        return msgreturn.toString();
    }

    private int updateWithMA() {
        int no;
        block10: {
            no = 0;
            String sql = "SELECT * FROM M_InventoryLine WHERE M_Inventory_ID=? AND M_AttributeSetInstance_ID=0";
            CPreparedStatement pstmt = null;
            ResultSet rs = null;
            try {
                try {
                    pstmt = DB.prepareStatement((String)sql, (String)this.get_TrxName());
                    pstmt.setInt(1, this.p_M_Inventory_ID);
                    rs = pstmt.executeQuery();
                    while (rs.next()) {
                        MInventoryLine il = new MInventoryLine(this.getCtx(), rs, this.get_TrxName());
                        BigDecimal onHand = Env.ZERO;
                        MStorageOnHand[] storages = MStorageOnHand.getAll((Properties)this.getCtx(), (int)il.getM_Product_ID(), (int)il.getM_Locator_ID(), (String)this.get_TrxName());
                        MInventoryLineMA ma = null;
                        int i = 0;
                        while (i < storages.length) {
                            MStorageOnHand storage = storages[i];
                            if (storage.getQtyOnHand().signum() != 0) {
                                onHand = onHand.add(storage.getQtyOnHand());
                                if (storage.getM_AttributeSetInstance_ID() == 0 && storages.length == 1 || !(ma = new MInventoryLineMA(il, storage.getM_AttributeSetInstance_ID(), storage.getQtyOnHand(), storage.getDateMaterialPolicy(), true)).save()) {
                                    // empty if block
                                }
                            }
                            ++i;
                        }
                        il.setQtyBook(onHand);
                        il.setQtyCount(onHand);
                        if (!il.save()) continue;
                        ++no;
                    }
                }
                catch (Exception e) {
                    this.log.log(Level.SEVERE, sql, (Throwable)e);
                    DB.close(rs, (Statement)pstmt);
                    rs = null;
                    pstmt = null;
                    break block10;
                }
            }
            catch (Throwable throwable) {
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
            DB.close((ResultSet)rs, (Statement)pstmt);
            rs = null;
            pstmt = null;
        }
        if (this.log.isLoggable(Level.INFO)) {
            this.log.info("#" + no);
        }
        return no;
    }
}

