/*
 * Decompiled with CFR 0.152.
 */
package jpiere.plugin.simpleinputwindow.form;

import java.util.ArrayList;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import jpiere.plugin.simpleinputwindow.form.SimpleInputWindowGridTable;
import org.adempiere.webui.event.WTableModelEvent;
import org.adempiere.webui.event.WTableModelListener;
import org.compiere.model.GridField;
import org.compiere.model.PO;
import org.zkoss.zk.ui.Executions;
import org.zkoss.zul.AbstractListModel;
import org.zkoss.zul.ListModel;

public class SimpleInputWindowListModel
extends AbstractListModel<Object>
implements TableModelListener {
    private static final long serialVersionUID = 698185856751242764L;
    private SimpleInputWindowGridTable tableModel;
    private GridField[] gridField;
    private int windowNo;
    private int pageSize = -1;
    private int pageNo = 0;
    private boolean editing = false;
    private ArrayList<Integer> selection = null;
    protected ArrayList<WTableModelListener> m_listeners = new ArrayList();

    public SimpleInputWindowListModel(SimpleInputWindowGridTable tableModel, int windowNo) {
        this.tableModel = tableModel;
        this.windowNo = windowNo;
        this.gridField = tableModel.getFields();
        tableModel.addTableModelListener(this);
        this.selection = new ArrayList();
    }

    public Object getElementAt(int rowIndex) {
        int columnCount = this.tableModel.getColumnCount();
        Object[] values = new Object[columnCount];
        if (this.pageSize > 0) {
            rowIndex = this.pageNo * this.pageSize + rowIndex;
        }
        if (rowIndex < this.tableModel.getRowCount()) {
            int i = 0;
            while (i < columnCount) {
                values[i] = this.tableModel.getValueAt(rowIndex, i);
                ++i;
            }
        }
        return values;
    }

    public PO getPO(int rowIndex) {
        if (this.pageSize > 0) {
            rowIndex = this.pageNo * this.pageSize + rowIndex;
        }
        if (rowIndex < this.tableModel.getRowCount()) {
            return this.tableModel.getPOs().get(rowIndex);
        }
        return null;
    }

    public int getRowIndexFromID(int po_id) {
        ArrayList<PO> list_POs = this.tableModel.getPOs();
        int i = 0;
        for (PO po : list_POs) {
            if (po.get_ID() == po_id) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public void setPO(PO po) {
        this.tableModel.setPO(po);
        WTableModelEvent tcEvent = new WTableModelEvent((ListModel)this, 0, 0);
        this.fireTableChange(tcEvent);
    }

    public void removePO(int rowIndex) {
        this.tableModel.removePO(rowIndex);
    }

    public void setValueAt(Object value, int row, GridField gridField) {
        this.tableModel.setValueAt(value, row, gridField);
    }

    public Object getValueAt(int rowIndex, GridField gridField) {
        return this.tableModel.getValueAt(rowIndex, gridField);
    }

    public Object getValueAt(int rowIndex, String columnName) {
        return this.tableModel.getValueAt(rowIndex, columnName);
    }

    public void addToSelection(int rowIndex) {
        if (!this.selection.contains(rowIndex)) {
            this.selection.add(rowIndex);
        }
    }

    public boolean removeFromSelection(int rowIndex) {
        return this.selection.remove((Object)rowIndex);
    }

    public void removeAllSelection() {
        this.selection.clear();
    }

    public int[] getSelections() {
        int[] selected = new int[this.selection.size()];
        int i = 0;
        for (Integer row : this.selection) {
            selected[i++] = row;
        }
        return selected;
    }

    public boolean isSelected(int rowIndex) {
        return this.selection.contains(rowIndex);
    }

    public int getSize() {
        int total = this.tableModel.getRowCount();
        if (this.pageSize <= 0) {
            return total;
        }
        if (total - this.pageNo * this.pageSize < 0) {
            this.pageNo = 0;
            return this.pageSize > total ? total : this.pageSize;
        }
        int end = (this.pageNo + 1) * this.pageSize;
        if (end > total) {
            return total - this.pageNo * this.pageSize;
        }
        return this.pageSize;
    }

    public void updateComponent(int row) {
        this.updateComponent(row, row);
    }

    public void updateComponent(int fromRow, int toRow) {
        if (Executions.getCurrent() != null) {
            this.fireEvent(0, fromRow, toRow);
        }
    }

    private void fireTableChange(WTableModelEvent event) {
        for (WTableModelListener listener : this.m_listeners) {
            listener.tableChanged(event);
        }
    }

    public void addTableModelListener(WTableModelListener listener) {
        if (listener == null) {
            return;
        }
        if (!this.m_listeners.contains(listener)) {
            this.m_listeners.add(listener);
        }
    }

    @Override
    public void tableChanged(TableModelEvent e) {
        if (Executions.getCurrent() != null) {
            if (e.getType() == -1) {
                if (this.pageSize > 0) {
                    int pgIndex = e.getFirstRow() % this.pageSize;
                    this.fireEvent(0, pgIndex, this.getSize());
                } else {
                    this.fireEvent(2, e.getFirstRow(), e.getLastRow());
                }
            } else if (e.getType() == 1) {
                if (this.pageSize > 0) {
                    int pgIndex = e.getFirstRow() % this.pageSize;
                    this.fireEvent(0, pgIndex, this.getSize());
                } else {
                    this.fireEvent(1, e.getFirstRow(), e.getLastRow());
                }
            } else if (e.getLastRow() == Integer.MAX_VALUE) {
                this.fireEvent(0, -1, -1);
            } else if (!this.editing) {
                this.fireEvent(0, e.getFirstRow(), e.getLastRow());
            }
        }
    }

    public void setEditing(boolean b) {
        this.editing = b;
    }
}

