/*
 * Decompiled with CFR 0.152.
 */
package jpiere.plugin.simpleinputwindow.form;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import jpiere.plugin.simpleinputwindow.base.ISimpleInputWindowCallout;
import jpiere.plugin.simpleinputwindow.base.ISimpleInputWindowCalloutFactory;
import jpiere.plugin.simpleinputwindow.form.JPiereSimpleInputWindow;
import jpiere.plugin.simpleinputwindow.form.SimpleInputWindowGridRowRenderer;
import jpiere.plugin.simpleinputwindow.form.SimpleInputWindowListModel;
import org.adempiere.base.Service;
import org.adempiere.webui.editor.WEditor;
import org.adempiere.webui.event.ValueChangeEvent;
import org.adempiere.webui.event.ValueChangeListener;
import org.adempiere.webui.window.Dialog;
import org.compiere.model.GridField;
import org.compiere.model.MLookup;
import org.compiere.model.PO;
import org.compiere.util.CLogger;
import org.zkoss.zul.Cell;
import org.zkoss.zul.Label;

public class SimpleInputWindowDataBinder
implements ValueChangeListener {
    private static final CLogger logger = CLogger.getCLogger(SimpleInputWindowDataBinder.class);
    private SimpleInputWindowGridRowRenderer rendere;
    private SimpleInputWindowListModel listModel;
    private HashMap<Integer, PO> dirtyModel;
    private HashMap<Integer, Integer> dirtyLineNo;
    private JPiereSimpleInputWindow simpleInputWindow;

    public SimpleInputWindowDataBinder(JPiereSimpleInputWindow simpleInputWindow, SimpleInputWindowGridRowRenderer rendere, SimpleInputWindowListModel listModel) {
        this.simpleInputWindow = simpleInputWindow;
        this.rendere = rendere;
        this.listModel = listModel;
        this.dirtyModel = simpleInputWindow.getDirtyModel();
        this.dirtyLineNo = simpleInputWindow.getDirtyLineNo();
    }

    public void valueChange(ValueChangeEvent e) {
        Object newValue = e.getNewValue();
        Object source = e.getSource();
        if (source instanceof WEditor) {
            WEditor editor = (WEditor)source;
            GridField gridField = editor.getGridField();
            Object oldValue = this.listModel.getValueAt(this.rendere.getCurrentRowIndex(), gridField);
            this.listModel.setValueAt(newValue, this.rendere.getCurrentRowIndex(), gridField);
            gridField.setValue(newValue, false);
            PO po = this.listModel.getPO(this.rendere.getCurrentRowIndex());
            if (!this.dirtyModel.containsKey(po.get_ID()) && po.get_ID() != 0) {
                Cell lineNoCell = (Cell)editor.getComponent().getParent().getParent().getChildren().get(1);
                Label lineNoLabel = (Label)lineNoCell.getChildren().get(0);
                lineNoLabel.setValue("*" + lineNoLabel.getValue());
            }
            if (po.get_ID() != 0) {
                this.dirtyModel.put(po.get_ID(), po);
                this.dirtyLineNo.put(po.get_ID(), this.rendere.getCurrentRowIndex());
            }
            List factories = Service.locator().list(ISimpleInputWindowCalloutFactory.class).getServices();
            if (factories != null) {
                String calloutMessage = null;
                for (ISimpleInputWindowCalloutFactory factory : factories) {
                    ArrayList dependants;
                    ISimpleInputWindowCallout callout = factory.getCallout(po.get_TableName(), editor.getColumnName());
                    if (callout == null) continue;
                    calloutMessage = callout.start(this, this.rendere.getCurrentRowIndex(), gridField.getColumnName(), newValue, oldValue);
                    if (calloutMessage != null && !calloutMessage.equals("")) {
                        Dialog.error((int)this.simpleInputWindow.getForm().getWindowNo(), (String)calloutMessage);
                        logger.saveError("Error", new Exception(calloutMessage));
                    }
                    if ((dependants = this.simpleInputWindow.getGridTab().getDependantFields(editor.getColumnName())).size() <= 0) break;
                    for (GridField dependentField : dependants) {
                        MLookup mLookup;
                        if (dependentField == null || !(dependentField.getLookup() instanceof MLookup) || (mLookup = (MLookup)dependentField.getLookup()).getValidation().indexOf("@" + gridField.getColumnName() + "@") == -1) continue;
                        mLookup.refresh();
                    }
                }
            }
            return;
        }
    }

    public void setValue(int rowIndex, String columnName, Object newValue) {
        List<WEditor> editors = this.rendere.getEditors();
        boolean haveEditor = false;
        for (WEditor editor : editors) {
            if (!editor.getColumnName().equals(columnName)) continue;
            editor.setValue(newValue);
            this.listModel.setValueAt(newValue, this.rendere.getCurrentRowIndex(), editor.getGridField());
            editor.getGridField().setValue(newValue, false);
            PO po = this.listModel.getPO(this.rendere.getCurrentRowIndex());
            if (!this.dirtyModel.containsKey(po.get_ID()) && po.get_ID() != 0) {
                Cell lineNoCell = (Cell)editor.getComponent().getParent().getParent().getChildren().get(1);
                Label lineNoLabel = (Label)lineNoCell.getChildren().get(0);
                lineNoLabel.setValue("*" + lineNoLabel.getValue());
            }
            haveEditor = true;
            break;
        }
        if (!haveEditor) {
            PO po = this.listModel.getPO(this.rendere.getCurrentRowIndex());
            po.set_ValueNoCheck(columnName, newValue);
        }
    }

    public Object getValue(int rowIndex, String columnName) {
        return this.listModel.getValueAt(rowIndex, columnName);
    }

    public JPiereSimpleInputWindow getSimpleInputWindow() {
        return this.simpleInputWindow;
    }
}

