/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.print;

import java.util.Properties;
import java.util.logging.Level;
import org.adempiere.base.IServiceReferenceHolder;
import org.adempiere.base.Service;
import org.adempiere.exceptions.AdempiereException;
import org.adempiere.util.IProcessUI;
import org.compiere.model.MPInstance;
import org.compiere.model.MPaySelectionCheck;
import org.compiere.model.MProcess;
import org.compiere.model.MQuery;
import org.compiere.model.MTable;
import org.compiere.model.PrintInfo;
import org.compiere.print.MPrintFormat;
import org.compiere.print.ReportEngine;
import org.compiere.print.ReportViewerProvider;
import org.compiere.print.ServerReportCtl;
import org.compiere.process.ProcessInfo;
import org.compiere.util.CLogger;
import org.compiere.util.Env;

public class ReportCtl {
    public static final String PARAM_PRINTER_NAME = "PRINTER_NAME";
    public static final String PARAM_PRINT_FORMAT = "PRINT_FORMAT";
    public static final String PARAM_PRINT_INFO = "PRINT_INFO";
    private static final CLogger s_log = CLogger.getCLogger(ReportCtl.class);
    private static volatile ProcessInfo m_pi;
    private static IServiceReferenceHolder<ReportViewerProvider> s_reportViewerProviderReference;

    static {
        s_reportViewerProviderReference = null;
    }

    private ReportCtl() {
    }

    public static boolean start(ProcessInfo pi, boolean IsDirectPrint) {
        return ReportCtl.start(null, -1, pi, IsDirectPrint);
    }

    public static boolean start(IProcessUI parent, int WindowNo, ProcessInfo pi, boolean IsDirectPrint) {
        pi.setPrintPreview(!IsDirectPrint);
        return ReportCtl.start(parent, WindowNo, pi);
    }

    public static boolean start(IProcessUI parent, int WindowNo, ProcessInfo pi) {
        if (s_log.isLoggable(Level.INFO)) {
            s_log.info("start - " + pi);
        }
        m_pi = pi;
        MPInstance instance = new MPInstance(Env.getCtx(), pi.getAD_PInstance_ID(), null);
        if (pi.getSerializableObject() != null) {
            instance.setAD_PrintFormat_ID(((MPrintFormat)pi.getSerializableObject()).getAD_PrintFormat_ID());
        }
        if (pi.getReportType() != null) {
            instance.setReportType(pi.getReportType());
        } else if (instance.getAD_PrintFormat_ID() > 0) {
            ReportEngine.setDefaultReportTypeToPInstance((Properties)Env.getCtx(), (MPInstance)instance, (int)instance.getAD_PrintFormat_ID());
        }
        instance.setIsSummary(pi.isSummary());
        instance.setAD_Language_ID(pi.getLanguageID());
        instance.setIsProcessing(true);
        instance.saveEx();
        try {
            if (pi.getAD_Process_ID() == 110) {
                boolean bl = ReportCtl.startDocumentPrint(0, pi.getRecord_ID(), parent, WindowNo, !pi.isPrintPreview());
                return bl;
            }
            if (pi.getAD_Process_ID() == MProcess.getProcess_ID((String)"Rpt PP_Order", null)) {
                boolean bl = ReportCtl.startDocumentPrint(8, pi.getRecord_ID(), parent, WindowNo, !pi.isPrintPreview());
                return bl;
            }
            if (pi.getAD_Process_ID() == MProcess.getProcess_ID((String)"Rpt DD_Order", null)) {
                boolean bl = ReportCtl.startDocumentPrint(9, pi.getRecord_ID(), parent, WindowNo, !pi.isPrintPreview());
                return bl;
            }
            if (pi.getAD_Process_ID() == 116) {
                boolean bl = ReportCtl.startDocumentPrint(2, pi.getRecord_ID(), parent, WindowNo, !pi.isPrintPreview());
                return bl;
            }
            if (pi.getAD_Process_ID() == 117) {
                boolean bl = ReportCtl.startDocumentPrint(1, pi.getRecord_ID(), parent, WindowNo, !pi.isPrintPreview());
                return bl;
            }
            if (pi.getAD_Process_ID() == 217) {
                boolean bl = ReportCtl.startDocumentPrint(3, pi.getRecord_ID(), parent, WindowNo, !pi.isPrintPreview());
                return bl;
            }
            if (pi.getAD_Process_ID() == 276) {
                boolean bl = ReportCtl.startDocumentPrint(4, pi.getRecord_ID(), parent, WindowNo, !pi.isPrintPreview());
                return bl;
            }
            if (pi.getAD_Process_ID() == 313) {
                boolean bl = ReportCtl.startCheckPrint(pi.getRecord_ID(), !pi.isPrintPreview());
                return bl;
            }
            if (pi.getAD_Process_ID() == 291) {
                boolean bl = ReportCtl.startDocumentPrint(10, pi.getRecord_ID(), parent, WindowNo, !pi.isPrintPreview());
                return bl;
            }
            if (pi.getAD_Process_ID() == 290) {
                boolean bl = ReportCtl.startDocumentPrint(11, pi.getRecord_ID(), parent, WindowNo, !pi.isPrintPreview());
                return bl;
            }
            if (pi.getAD_Process_ID() == 159) {
                boolean bl = ReportCtl.startDocumentPrint(7, pi.getRecord_ID(), parent, WindowNo, !pi.isPrintPreview());
                return bl;
            }
            if (pi.getAD_Process_ID() == 202 || pi.getAD_Process_ID() == 204) {
                boolean bl = ReportCtl.startFinReport(pi, WindowNo);
                return bl;
            }
            boolean bl = ReportCtl.startStandardReport(pi, WindowNo);
            return bl;
        }
        finally {
            instance.setIsProcessing(false);
            instance.saveEx();
        }
    }

    public static boolean startStandardReport(ProcessInfo pi, boolean IsDirectPrint) {
        return ReportCtl.startStandardReport(pi, -1, IsDirectPrint);
    }

    public static boolean startStandardReport(ProcessInfo pi, int WindowNo, boolean IsDirectPrint) {
        pi.setPrintPreview(!IsDirectPrint);
        return ReportCtl.startStandardReport(pi, WindowNo);
    }

    public static boolean startStandardReport(ProcessInfo pi) {
        return ReportCtl.startStandardReport(pi, -1);
    }

    public static boolean startStandardReport(ProcessInfo pi, int WindowNo) {
        ReportEngine re = null;
        Object o = pi.getTransientObject();
        if (o == null) {
            o = pi.getSerializableObject();
        }
        if (o != null && o instanceof MPrintFormat) {
            Properties ctx = Env.getCtx();
            MPrintFormat format = (MPrintFormat)o;
            String TableName = MTable.getTableName((Properties)ctx, (int)format.getAD_Table_ID());
            MQuery query = MQuery.get((Properties)ctx, (int)pi.getAD_PInstance_ID(), (String)TableName);
            PrintInfo info = new PrintInfo(pi);
            re = new ReportEngine(ctx, format, query, info, pi.isSummary(), null, WindowNo);
        } else {
            re = ReportEngine.get((Properties)Env.getCtx(), (ProcessInfo)pi, (int)WindowNo);
            if (re == null) {
                pi.setSummary("No ReportEngine");
                return false;
            }
        }
        if (pi.getReportType() != null) {
            re.setReportType(pi.getReportType());
        }
        re.setLanguageID(pi.getLanguageID());
        re.setIsReplaceTabContent(pi.isReplaceTabContent());
        ReportCtl.createOutput(re, pi.isPrintPreview(), null);
        return true;
    }

    public static boolean startFinReport(ProcessInfo pi) {
        return ReportCtl.startFinReport(pi, -1);
    }

    public static boolean startFinReport(ProcessInfo pi, int WindowNo) {
        int AD_Client_ID = Env.getAD_Client_ID((Properties)Env.getCtx());
        String TableName = pi.getAD_Process_ID() == 202 ? "T_Report" : "T_ReportStatement";
        MQuery query = MQuery.get((Properties)Env.getCtx(), (int)pi.getAD_PInstance_ID(), (String)TableName);
        MPrintFormat format = (MPrintFormat)pi.getTransientObject();
        if (format == null) {
            format = (MPrintFormat)pi.getSerializableObject();
        }
        if (format == null) {
            s_log.log(Level.SEVERE, "startFinReport - No PrintFormat");
            return false;
        }
        PrintInfo info = new PrintInfo(pi);
        ReportEngine re = new ReportEngine(Env.getCtx(), format, query, info, pi.isSummary(), null, WindowNo);
        if (pi.getReportType() != null) {
            re.setReportType(pi.getReportType());
        }
        re.setLanguageID(pi.getLanguageID());
        ReportCtl.createOutput(re, pi.isPrintPreview(), null);
        return true;
    }

    public static boolean startDocumentPrint(int type, int Record_ID, boolean IsDirectPrint) {
        return ReportCtl.startDocumentPrint(type, Record_ID, null, -1, IsDirectPrint);
    }

    public static boolean startDocumentPrint(int type, MPrintFormat customPrintFormat, int Record_ID, IProcessUI parent, int WindowNo, String printerName) {
        return ReportCtl.startDocumentPrint(type, customPrintFormat, Record_ID, parent, WindowNo, true, printerName);
    }

    public static boolean startDocumentPrint(int type, int Record_ID, IProcessUI parent, int WindowNo, boolean IsDirectPrint) {
        return ReportCtl.startDocumentPrint(type, null, Record_ID, parent, WindowNo, IsDirectPrint, null);
    }

    public static boolean startDocumentPrint(int type, MPrintFormat customPrintFormat, int Record_ID, IProcessUI parent, int WindowNo, boolean IsDirectPrint, String printerName) {
        ReportEngine re = ReportEngine.get((Properties)Env.getCtx(), (int)type, (int)Record_ID, (int)WindowNo);
        if (re == null) {
            throw new AdempiereException("NoDocPrintFormat");
        }
        if (customPrintFormat != null) {
            re.setPrintFormat(customPrintFormat);
        }
        if (re.getPrintFormat() != null) {
            MPrintFormat format = re.getPrintFormat();
            if (format.getJasperProcess_ID() > 0) {
                ServerReportCtl.runJasperProcess((int)Record_ID, (ReportEngine)re, (boolean)IsDirectPrint, (String)printerName);
                if (IsDirectPrint) {
                    ReportEngine.printConfirm((int)type, (int)Record_ID);
                }
            } else {
                ReportCtl.createOutput(re, !IsDirectPrint, printerName);
                if (IsDirectPrint) {
                    ReportEngine.printConfirm((int)type, (int)Record_ID);
                }
            }
        }
        return true;
    }

    public static boolean startCheckPrint(int C_Payment_ID, boolean IsDirectPrint) {
        boolean ok = MPaySelectionCheck.deleteGeneratedDraft((Properties)Env.getCtx(), (int)C_Payment_ID, null);
        int C_PaySelectionCheck_ID = 0;
        MPaySelectionCheck psc = MPaySelectionCheck.getOfPayment((Properties)Env.getCtx(), (int)C_Payment_ID, null);
        if (psc != null) {
            C_PaySelectionCheck_ID = psc.getC_PaySelectionCheck_ID();
        } else {
            psc = MPaySelectionCheck.createForPayment((Properties)Env.getCtx(), (int)C_Payment_ID, null);
            if (psc != null) {
                C_PaySelectionCheck_ID = psc.getC_PaySelectionCheck_ID();
            }
        }
        return ReportCtl.startDocumentPrint(6, C_PaySelectionCheck_ID, null, -1, IsDirectPrint);
    }

    private static void createOutput(ReportEngine re, boolean printPreview, String printerName) {
        if (m_pi != null) {
            m_pi.setRowCount(re.getPrintData().getRowCount());
        }
        if (printPreview) {
            ReportCtl.preview(re);
        } else {
            if (printerName != null) {
                re.getPrintInfo().setPrinterName(printerName);
            }
            re.print();
        }
    }

    public static void preview(ReportEngine re) {
        ReportViewerProvider viewer = ReportCtl.getReportViewerProvider();
        viewer.openViewer(re);
    }

    public static synchronized ReportViewerProvider getReportViewerProvider() {
        ReportViewerProvider viewer = null;
        if (s_reportViewerProviderReference != null && (viewer = (ReportViewerProvider)s_reportViewerProviderReference.getService()) != null) {
            return viewer;
        }
        IServiceReferenceHolder viewerReference = Service.locator().locate(ReportViewerProvider.class).getServiceReference();
        if (viewerReference != null) {
            s_reportViewerProviderReference = viewerReference;
            viewer = (ReportViewerProvider)viewerReference.getService();
        }
        return viewer;
    }
}

