/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.print;

import java.io.Serializable;
import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.model.MProcess;
import org.compiere.model.MProcessDrillRule;
import org.compiere.model.MProcessDrillRulePara;
import org.compiere.model.MProcessPara;
import org.compiere.model.MQuery;
import org.compiere.model.MReportView;
import org.compiere.model.MRole;
import org.compiere.model.MTable;
import org.compiere.model.PrintInfo;
import org.compiere.model.Query;
import org.compiere.print.MPrintFormat;
import org.compiere.print.ReportCtl;
import org.compiere.print.ReportEngine;
import org.compiere.process.ProcessInfo;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.DisplayType;
import org.compiere.util.Env;
import org.compiere.util.KeyNamePair;
import org.compiere.util.Msg;
import org.compiere.util.Util;

public class DrillReportCtl {
    private static final CLogger log = CLogger.getCLogger(DrillReportCtl.class);
    private int m_WindowNo = 0;
    private String m_TableName;
    private String m_ColumnName;
    private Object m_Value;
    private MQuery m_Query;
    private Integer m_AD_Table_ID;
    private String m_DisplayValue;
    private int m_AD_Process_ID;
    private KeyNamePair[] drillTables;
    private KeyNamePair[] drillProcessList;
    private HashMap<Integer, KeyNamePair[]> drillProcesRules;
    private HashMap<Integer, KeyNamePair[]> drillProcessRulesPrintFormatMap = new HashMap();

    public DrillReportCtl(String TableName, MQuery query, String ColumnName, Object Value, String displayValue, int WindowNo, int processID) {
        this.m_TableName = TableName;
        this.m_ColumnName = ColumnName;
        this.m_Value = Value;
        this.m_WindowNo = WindowNo;
        this.m_DisplayValue = displayValue;
        this.m_AD_Process_ID = processID;
        this.m_Query = query;
        this.initProcessDrillRuleMaps();
    }

    public KeyNamePair[] getDrillTables() {
        return this.drillTables;
    }

    public HashMap<Integer, KeyNamePair[]> getDrillProcesRules() {
        return this.drillProcesRules;
    }

    public KeyNamePair[] getDrillProcessRulesPrintFormatMap(int AD_Process_DrillRule_ID) {
        return this.drillProcessRulesPrintFormatMap.get(AD_Process_DrillRule_ID);
    }

    public String getDisplayValue() {
        return this.m_DisplayValue;
    }

    public Object getValue() {
        return this.m_Value;
    }

    private void initProcessDrillRuleMaps() {
        this.m_AD_Table_ID = MTable.getTable_ID((String)this.m_TableName);
        this.initProcessDrillRuleMap();
        this.initDrillProcessRulePrintFormatMap();
    }

    private void initProcessDrillRuleMap() {
        HashMap<Integer, String> drillProcessMap = new HashMap<Integer, String>();
        HashMap<Integer, ArrayList<KeyNamePair>> drillProcessRuleMap = new HashMap<Integer, ArrayList<KeyNamePair>>();
        if (!Util.isEmpty((String)this.m_ColumnName)) {
            MProcessDrillRule[] processDrillRules;
            MProcessDrillRule[] mProcessDrillRuleArray = processDrillRules = MProcessDrillRule.getByColumnName((Properties)Env.getCtx(), (String)this.m_ColumnName, null);
            int n = processDrillRules.length;
            int n2 = 0;
            while (n2 < n) {
                MProcessDrillRule drillProcesRule = mProcessDrillRuleArray[n2];
                if (drillProcesRule.getAD_Process_ID() != 0 && drillProcesRule.getAD_Process_ID() != this.m_AD_Process_ID) {
                    MProcess process = MProcess.get((int)drillProcesRule.getAD_Process_ID());
                    drillProcessMap.put(drillProcesRule.getAD_Process_ID(), process.get_Translation("Name"));
                    ArrayList<KeyNamePair> drillProcessRuleList = (ArrayList<KeyNamePair>)drillProcessRuleMap.get(drillProcesRule.getAD_Process_ID());
                    if (drillProcessRuleList == null) {
                        drillProcessRuleList = new ArrayList<KeyNamePair>();
                        drillProcessRuleMap.put(drillProcesRule.getAD_Process_ID(), drillProcessRuleList);
                    }
                    drillProcessRuleList.add(new KeyNamePair(drillProcesRule.getAD_Process_DrillRule_ID(), drillProcesRule.getName()));
                }
                ++n2;
            }
        }
        ArrayList<KeyNamePair> drillProcessList = new ArrayList<KeyNamePair>();
        for (Map.Entry drillProcessEntry : drillProcessMap.entrySet()) {
            drillProcessList.add(new KeyNamePair(((Integer)drillProcessEntry.getKey()).intValue(), (String)drillProcessEntry.getValue()));
        }
        this.drillProcessList = drillProcessList.toArray(new KeyNamePair[drillProcessList.size()]);
        HashMap<Integer, KeyNamePair[]> drillProcessRuleMapOut = new HashMap<Integer, KeyNamePair[]>();
        for (Map.Entry drillProcessRuleEntry : drillProcessRuleMap.entrySet()) {
            drillProcessRuleMapOut.put((Integer)drillProcessRuleEntry.getKey(), ((ArrayList)drillProcessRuleEntry.getValue()).toArray(new KeyNamePair[((ArrayList)drillProcessRuleEntry.getValue()).size()]));
        }
        this.drillProcesRules = drillProcessRuleMapOut;
    }

    public void initDrillTableMap() {
        ArrayList<KeyNamePair> drillTableList;
        block9: {
            boolean trl;
            drillTableList = new ArrayList<KeyNamePair>();
            String sql = "SELECT t.AD_Table_ID, t.TableName, e.PrintName, NULLIF(e.PO_PrintName,e.PrintName) FROM AD_Column c  INNER JOIN AD_Column used ON (c.ColumnName=used.ColumnName) INNER JOIN AD_Table t ON (used.AD_Table_ID=t.AD_Table_ID AND t.IsView='N' AND t.AD_Table_ID <> c.AD_Table_ID AND t.IsShowInDrillOptions='Y') INNER JOIN AD_Column cKey ON (t.AD_Table_ID=cKey.AD_Table_ID AND cKey.IsKey='Y') INNER JOIN AD_Element e ON (cKey.ColumnName=e.ColumnName) WHERE c.AD_Table_ID=? AND c.IsKey='Y' ORDER BY 3 ";
            boolean bl = trl = !Env.isBaseLanguage((Properties)Env.getCtx(), (String)"AD_Element");
            if (trl) {
                sql = "SELECT t.AD_Table_ID, t.TableName, et.PrintName, NULLIF(et.PO_PrintName,et.PrintName) FROM AD_Column c INNER JOIN AD_Column used ON (c.ColumnName=used.ColumnName) INNER JOIN AD_Table t ON (used.AD_Table_ID=t.AD_Table_ID AND t.IsView='N' AND t.AD_Table_ID <> c.AD_Table_ID AND t.IsShowInDrillOptions='Y') INNER JOIN AD_Column cKey ON (t.AD_Table_ID=cKey.AD_Table_ID AND cKey.IsKey='Y') INNER JOIN AD_Element e ON (cKey.ColumnName=e.ColumnName) INNER JOIN AD_Element_Trl et ON (e.AD_Element_ID=et.AD_Element_ID) WHERE c.AD_Table_ID=? AND c.IsKey='Y' AND et.AD_Language=? ORDER BY 3 ";
            }
            CPreparedStatement pstmt = null;
            ResultSet rs = null;
            try {
                try {
                    pstmt = DB.prepareStatement((String)sql, null);
                    pstmt.setInt(1, this.m_AD_Table_ID);
                    if (trl) {
                        pstmt.setString(2, Env.getAD_Language((Properties)Env.getCtx()));
                    }
                    rs = pstmt.executeQuery();
                    while (rs.next()) {
                        int ad_Table_ID = rs.getInt(1);
                        String name = rs.getString(3);
                        String poName = rs.getString(4);
                        if (poName != null) {
                            name = String.valueOf(name) + "/" + poName;
                        }
                        drillTableList.add(new KeyNamePair(ad_Table_ID, name));
                    }
                }
                catch (SQLException e) {
                    log.log(Level.SEVERE, sql, (Throwable)e);
                    DB.close(rs, (Statement)pstmt);
                    rs = null;
                    pstmt = null;
                    break block9;
                }
            }
            catch (Throwable throwable) {
                DB.close(rs, (Statement)pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
            DB.close((ResultSet)rs, (Statement)pstmt);
            rs = null;
            pstmt = null;
        }
        this.drillTables = drillTableList.toArray(new KeyNamePair[drillTableList.size()]);
    }

    private void initDrillProcessRulePrintFormatMap() {
        int AD_Window_ID = Env.getContextAsInt((Properties)Env.getCtx(), (int)this.m_WindowNo, (String)"_WinInfo_AD_Window_ID", (boolean)true);
        if (AD_Window_ID == 0) {
            AD_Window_ID = Env.getZoomWindowID((MQuery)this.m_Query);
        }
        Iterator<KeyNamePair[]> iterator = this.drillProcesRules.values().iterator();
        while (iterator.hasNext()) {
            KeyNamePair[] drilProcessRuleList;
            KeyNamePair[] keyNamePairArray = drilProcessRuleList = iterator.next();
            int n = drilProcessRuleList.length;
            int n2 = 0;
            while (n2 < n) {
                block11: {
                    KeyNamePair[] m_list;
                    KeyNamePair drillProcessRule;
                    block9: {
                        MProcessDrillRule processDrillRule;
                        block10: {
                            block8: {
                                drillProcessRule = keyNamePairArray[n2];
                                processDrillRule = MProcessDrillRule.get((Properties)Env.getCtx(), (int)drillProcessRule.getKey());
                                m_list = null;
                                if (processDrillRule.getAD_PrintFormat_ID() <= 0) break block8;
                                MPrintFormat pf = MPrintFormat.get((int)processDrillRule.getAD_PrintFormat_ID());
                                if (pf != null) {
                                    m_list = new KeyNamePair[]{new KeyNamePair(pf.getAD_PrintFormat_ID(), drillProcessRule.getName())};
                                }
                                break block9;
                            }
                            if (processDrillRule.getAD_ReportView_ID() <= 0) break block10;
                            MReportView reportView = MReportView.get((int)processDrillRule.getAD_ReportView_ID());
                            m_list = this.getPrintFormats(reportView.getAD_Table_ID(), reportView.getAD_ReportView_ID());
                            break block9;
                        }
                        MProcess process = MProcess.get((int)processDrillRule.getAD_Process_ID());
                        if (process == null || process.getAD_ReportView_ID() <= 0) break block11;
                        MReportView reportView = MReportView.get((int)process.getAD_ReportView_ID());
                        m_list = this.getPrintFormats(reportView.getAD_Table_ID(), reportView.getAD_ReportView_ID());
                    }
                    this.drillProcessRulesPrintFormatMap.put(drillProcessRule.getKey(), m_list);
                }
                ++n2;
            }
        }
    }

    private KeyNamePair[] getPrintFormats(int table_ID, int reportView_ID) {
        ArrayList<KeyNamePair> printFormatList;
        block7: {
            printFormatList = new ArrayList<KeyNamePair>();
            String sql = MRole.getDefault().addAccessSQL("SELECT * FROM AD_PrintFormat WHERE AD_Table_ID=? AND IsActive='Y' " + (reportView_ID > 0 ? "AND AD_ReportView_ID=? " : "") + "ORDER BY AD_Client_ID, Name", "AD_PrintFormat", false, false);
            CPreparedStatement pstmt = null;
            ResultSet rs = null;
            try {
                try {
                    pstmt = DB.prepareStatement((String)sql, null);
                    int idx = 1;
                    pstmt.setInt(idx++, table_ID);
                    if (reportView_ID > 0) {
                        pstmt.setInt(idx++, reportView_ID);
                    }
                    rs = pstmt.executeQuery();
                    while (rs.next()) {
                        MPrintFormat printFormat = new MPrintFormat(Env.getCtx(), rs, null);
                        KeyNamePair pp = new KeyNamePair(printFormat.get_ID(), printFormat.get_Translation("Name", Env.getAD_Language((Properties)Env.getCtx()), true));
                        printFormatList.add(pp);
                    }
                }
                catch (SQLException e) {
                    log.log(Level.SEVERE, sql, (Throwable)e);
                    DB.close(rs, (Statement)pstmt);
                    rs = null;
                    pstmt = null;
                    break block7;
                }
            }
            catch (Throwable throwable) {
                DB.close(rs, (Statement)pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
            DB.close((ResultSet)rs, (Statement)pstmt);
            rs = null;
            pstmt = null;
        }
        return printFormatList.toArray(new KeyNamePair[printFormatList.size()]);
    }

    public void launchTableDrillReport(int ad_PrintFormat_ID, String tableName) {
        MPrintFormat pf = null;
        if (ad_PrintFormat_ID == 0) {
            int AD_Table_ID = new Query(Env.getCtx(), "AD_Table", " Name = ? ", null).setParameters(new Object[]{tableName}).firstId();
            pf = MPrintFormat.createFromTable((Properties)Env.getCtx(), (int)(AD_Table_ID > 0 ? AD_Table_ID : this.m_AD_Table_ID));
        } else {
            pf = MPrintFormat.get((int)ad_PrintFormat_ID);
        }
        int Record_ID = 0;
        if (this.m_Query.getRestrictionCount() == 1 && this.m_Query.getColumnName(0).equals(String.valueOf(this.m_Query.getTableName()) + "_ID")) {
            Object vrec = this.m_Query.getCode(0);
            if (vrec instanceof Integer) {
                Record_ID = (Integer)vrec;
            } else {
                try {
                    if (vrec != null) {
                        Record_ID = Integer.parseInt(this.m_Query.getCode(0).toString());
                    }
                }
                catch (NumberFormatException e) {
                    log.info(e.getMessage());
                }
            }
        }
        PrintInfo info = new PrintInfo(pf.getName(), pf.getAD_Table_ID(), Record_ID);
        info.setDescription(this.m_Query.getInfo());
        ReportEngine re = new ReportEngine(Env.getCtx(), pf, this.m_Query, info, null, this.m_WindowNo);
        ReportCtl.preview(re);
    }

    public ProcessInfo getDrillProcessProcessInfo(int AD_Process_DrillRule_ID, int AD_PrintFormat_ID) throws Exception {
        MProcessDrillRule drillRule = MProcessDrillRule.get((Properties)Env.getCtx(), (int)AD_Process_DrillRule_ID);
        MProcess process = new MProcess(Env.getCtx(), drillRule.getAD_Process_ID(), null);
        return this.prepareProcessInfo(process, drillRule, AD_PrintFormat_ID);
    }

    protected ProcessInfo prepareProcessInfo(MProcess process, MProcessDrillRule processDrillRule, int ad_PrintFormat_ID) throws Exception {
        int AD_PrintFormat_ID;
        if (log.isLoggable(Level.INFO)) {
            log.info(process.toString());
        }
        ProcessInfo pi = new ProcessInfo(process.getName(), process.getAD_Process_ID());
        pi.setAD_User_ID(Env.getAD_User_ID((Properties)Env.getCtx()));
        pi.setAD_Client_ID(processDrillRule.getAD_Client_ID());
        pi.setAD_Process_UU(process.getAD_Process_UU());
        pi.setIsBatch(true);
        pi.setPrintPreview(true);
        this.fillParameter(pi, processDrillRule);
        int n = AD_PrintFormat_ID = ad_PrintFormat_ID > 0 ? ad_PrintFormat_ID : processDrillRule.getAD_PrintFormat_ID();
        if (AD_PrintFormat_ID > 0) {
            MPrintFormat format = new MPrintFormat(Env.getCtx(), AD_PrintFormat_ID, null);
            pi.setSerializableObject((Serializable)format);
        }
        if (!Util.isEmpty((String)process.getJasperReport())) {
            pi.setExport(true);
            if ("HTML".equals(pi.getReportType())) {
                pi.setExportFileExtension("html");
            } else if ("CSV".equals(pi.getReportType())) {
                pi.setExportFileExtension("csv");
            } else if ("XLS".equals(pi.getReportType())) {
                pi.setExportFileExtension("xls");
            } else if ("XLSX".equals(pi.getReportType())) {
                pi.setExportFileExtension("xlsx");
            } else {
                pi.setExportFileExtension("pdf");
            }
        }
        return pi;
    }

    protected void fillParameter(ProcessInfo pi, MProcessDrillRule processDrillRule) {
        boolean isKeyParameterSet = false;
        MProcessDrillRulePara[] sParams = processDrillRule.getParameters(true);
        ArrayList<ProcessInfoParameter> iParams = new ArrayList<ProcessInfoParameter>();
        MProcess process = (MProcess)processDrillRule.getAD_Process();
        ArrayList<MProcessPara> processParasExclDrillRuleParas = new ArrayList<MProcessPara>(Arrays.asList(process.getParameters()));
        int i = 0;
        while (i < sParams.length) {
            if (sParams[i].getAD_Process_Para().getColumnName().equals(this.m_ColumnName)) {
                isKeyParameterSet = true;
            }
            ++i;
        }
        if (!isKeyParameterSet) {
            MProcessDrillRulePara keyPara = new MProcessDrillRulePara(Env.getCtx(), 0, null);
            keyPara.setAD_Process_DrillRule_ID(processDrillRule.getAD_Process_DrillRule_ID());
            keyPara.setAD_Process_Para_ID(processDrillRule.getAD_Process_Para_ID());
            MProcessDrillRulePara[] sParamsTmp = (MProcessDrillRulePara[])Arrays.stream(sParams).toArray(MProcessDrillRulePara[]::new);
            sParams = new MProcessDrillRulePara[sParamsTmp.length + 1];
            int idx = 0;
            idx = 0;
            while (idx < sParamsTmp.length) {
                sParams[idx] = sParamsTmp[idx];
                ++idx;
            }
            sParams[idx] = keyPara;
            isKeyParameterSet = true;
        }
        int p = 0;
        while (p < sParams.length) {
            MProcessPara processPara = (MProcessPara)sParams[p].getAD_Process_Para();
            ProcessInfoParameter iPara = new ProcessInfoParameter(processPara.getColumnName(), null, null, null, null);
            MProcessDrillRulePara sPara = sParams[p];
            if (processPara.getColumnName().equals(this.m_ColumnName)) {
                iPara.setParameter(DisplayType.isID((int)sPara.getDisplayType()) ? new BigDecimal(String.valueOf(this.m_Value)) : String.valueOf(this.m_Value));
                iPara.setInfo(!Util.isEmpty((String)this.m_DisplayValue) ? this.m_DisplayValue : String.valueOf(this.m_Value));
                iParams.add(iPara);
                processParasExclDrillRuleParas.remove(processPara);
            } else {
                Object toValue;
                String paraDesc = sPara.getDescription();
                if (paraDesc != null && paraDesc.trim().length() > 0) {
                    iPara.setInfo(sPara.getDescription());
                }
                String variable = sPara.getParameterDefault();
                String toVariable = sPara.getParameterToDefault();
                if (log.isLoggable(Level.FINE)) {
                    log.fine(String.valueOf(sPara.getColumnName()) + " = " + variable);
                }
                Object value = this.parseVariable(sPara, variable);
                Object object = toValue = toVariable != null ? this.parseVariable(sPara, toVariable) : null;
                if (value == null && toValue == null) {
                    if (log.isLoggable(Level.FINE)) {
                        log.fine(String.valueOf(sPara.getColumnName()) + " - empty");
                    }
                } else {
                    try {
                        String info;
                        if (DisplayType.isNumeric((int)sPara.getDisplayType()) || DisplayType.isID((int)sPara.getDisplayType())) {
                            DecimalFormat decimalFormat = DisplayType.getNumberFormat((int)sPara.getDisplayType());
                            BigDecimal bd = this.toBigDecimal(value);
                            iPara.setParameter((Object)bd);
                            if (toValue != null) {
                                bd = this.toBigDecimal(toValue);
                                iPara.setParameter_To((Object)bd);
                            }
                            if (Util.isEmpty((String)paraDesc)) {
                                info = decimalFormat.format(iPara.getParameterAsBigDecimal());
                                if (iPara.getParameter_ToAsBigDecimal() != null) {
                                    info = String.valueOf(info) + " - " + decimalFormat.format(iPara.getParameter_ToAsBigDecimal());
                                }
                                iPara.setInfo(info);
                            }
                            if (log.isLoggable(Level.FINE)) {
                                log.fine(String.valueOf(sPara.getColumnName()) + " = " + variable + " (=" + bd + "=)");
                            }
                        } else if (DisplayType.isDate((int)sPara.getDisplayType())) {
                            SimpleDateFormat dateFormat = DisplayType.getDateFormat((int)sPara.getDisplayType());
                            Timestamp ts = this.toTimestamp(value);
                            iPara.setParameter((Object)ts);
                            if (toValue != null) {
                                ts = this.toTimestamp(toValue);
                                iPara.setParameter_To((Object)ts);
                            }
                            if (Util.isEmpty((String)paraDesc)) {
                                info = dateFormat.format(iPara.getParameterAsTimestamp());
                                if (iPara.getParameter_ToAsTimestamp() != null) {
                                    info = String.valueOf(info) + " - " + dateFormat.format(iPara.getParameter_ToAsTimestamp());
                                }
                                iPara.setInfo(info);
                            }
                            if (log.isLoggable(Level.FINE)) {
                                log.fine(String.valueOf(sPara.getColumnName()) + " = " + variable + " (=" + ts + "=)");
                            }
                        } else {
                            iPara.setParameter((Object)value.toString());
                            if (toValue != null) {
                                iPara.setParameter_To((Object)toValue.toString());
                            }
                            if (Util.isEmpty((String)paraDesc)) {
                                String info2 = iPara.getParameterAsString();
                                if (iPara.getParameter_ToAsString() != null) {
                                    info2 = String.valueOf(info2) + " - " + iPara.getParameter_ToAsString();
                                }
                                iPara.setInfo(info2);
                            }
                            if (log.isLoggable(Level.FINE)) {
                                log.fine(String.valueOf(sPara.getColumnName()) + " = " + variable + " (=" + value + "=) " + value.getClass().getName());
                            }
                        }
                        if (processPara.isMandatory() && Util.isEmpty((String)sPara.getParameterDefault()) && !"Y".equalsIgnoreCase(processDrillRule.getShowHelp()) && (!processPara.isRange() || processPara.isRange() && Util.isEmpty((String)sPara.getParameterToDefault()))) {
                            throw new AdempiereException(Msg.parseTranslation((Properties)Env.getCtx(), (String)"@FillMandatoryDrillRulePara@"));
                        }
                        processParasExclDrillRuleParas.remove(processPara);
                        iParams.add(iPara);
                    }
                    catch (Exception e) {
                        log.warning(String.valueOf(sPara.getColumnName()) + " = " + variable + " (" + value + ") " + value.getClass().getName() + " - " + e.getLocalizedMessage());
                    }
                }
            }
            ++p;
        }
        if (!"Y".equalsIgnoreCase(processDrillRule.getShowHelp())) {
            for (MProcessPara unsetProcessPara : processParasExclDrillRuleParas) {
                if (!unsetProcessPara.isMandatory()) continue;
                throw new AdempiereException(Msg.parseTranslation((Properties)Env.getCtx(), (String)"@FillMandatoryDrillRulePara@"));
            }
        }
        pi.setParameter(iParams.toArray(new ProcessInfoParameter[0]));
        if (!isKeyParameterSet) {
            throw new AdempiereException(Msg.parseTranslation((Properties)Env.getCtx(), (String)"@NoDrillKeyParameterSet@"));
        }
    }

    private Timestamp toTimestamp(Object value) {
        Timestamp ts = null;
        ts = value instanceof Timestamp ? (Timestamp)value : Timestamp.valueOf(value.toString());
        return ts;
    }

    private BigDecimal toBigDecimal(Object value) {
        BigDecimal bd = null;
        bd = value instanceof BigDecimal ? (BigDecimal)value : (value instanceof Integer ? new BigDecimal((Integer)value) : new BigDecimal(value.toString()));
        return bd;
    }

    private Object parseVariable(MProcessDrillRulePara sPara, String variable) {
        Object value = variable;
        if (variable == null || variable != null && variable.length() == 0) {
            value = null;
        } else if (variable.startsWith("@SQL=")) {
            String defStr;
            block30: {
                defStr = "";
                String sql = variable.substring(5);
                sql = Env.parseContext((Properties)Env.getCtx(), (int)0, (String)sql, (boolean)false, (boolean)false);
                if (sql.equals("")) {
                    log.log(Level.WARNING, "(" + sPara.getColumnName() + ") - Default SQL variable parse failed: " + variable);
                } else {
                    CPreparedStatement stmt = null;
                    ResultSet rs = null;
                    try {
                        try {
                            stmt = DB.prepareStatement((String)sql, null);
                            rs = stmt.executeQuery();
                            if (rs.next()) {
                                defStr = rs.getString(1);
                            } else if (log.isLoggable(Level.INFO)) {
                                log.log(Level.INFO, "(" + sPara.getColumnName() + ") - no Result: " + sql);
                            }
                        }
                        catch (SQLException e) {
                            log.log(Level.WARNING, "(" + sPara.getColumnName() + ") " + sql, (Throwable)e);
                            DB.close((ResultSet)rs, (Statement)stmt);
                            rs = null;
                            stmt = null;
                            break block30;
                        }
                    }
                    catch (Throwable throwable) {
                        DB.close(rs, (Statement)stmt);
                        rs = null;
                        stmt = null;
                        throw throwable;
                    }
                    DB.close((ResultSet)rs, (Statement)stmt);
                    rs = null;
                    stmt = null;
                }
            }
            if (!Util.isEmpty((String)defStr)) {
                value = defStr;
            }
        } else if (variable.indexOf(64) != -1 && variable.indexOf(64) != variable.lastIndexOf(64)) {
            int index = variable.indexOf(64);
            String columnName = variable.substring(index + 1);
            if ((index = columnName.indexOf(64)) == -1) {
                log.warning(String.valueOf(sPara.getColumnName()) + " - cannot evaluate=" + variable);
                return null;
            }
            String tail = index < columnName.length() - 1 ? columnName.substring(index + 1) : null;
            columnName = columnName.substring(0, index);
            String env = Env.getContext((Properties)Env.getCtx(), (String)columnName);
            if (env == null || env.length() == 0) {
                env = Env.getContext((Properties)Env.getCtx(), (String)columnName);
            }
            if (env.length() == 0) {
                log.warning(String.valueOf(sPara.getColumnName()) + " - not in environment =" + columnName + "(" + variable + ")");
                if (DisplayType.isDate((int)sPara.getDisplayType())) {
                    return Env.getContext((Properties)Env.getCtx(), (String)"#Date");
                }
                return null;
            }
            value = env;
            if (tail != null && columnName.equals("#Date") && ((tail = tail.trim()).startsWith("-") || tail.startsWith("+"))) {
                boolean negate = tail.startsWith("-");
                int type = 5;
                if ((tail = tail.substring(1)).endsWith("d")) {
                    tail = tail.substring(0, tail.length() - 1);
                } else if (tail.endsWith("m")) {
                    type = 2;
                    tail = tail.substring(0, tail.length() - 1);
                } else if (tail.endsWith("y")) {
                    type = 1;
                    tail = tail.substring(0, tail.length() - 1);
                }
                int toApply = 0;
                try {
                    toApply = Integer.parseInt(tail);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (toApply > 0) {
                    if (negate) {
                        toApply *= -1;
                    }
                    Timestamp ts = this.toTimestamp(value);
                    Calendar cal = Calendar.getInstance();
                    cal.setTimeInMillis(ts.getTime());
                    cal.add(type, toApply);
                    value = new Timestamp(cal.getTimeInMillis());
                }
            }
        }
        return value;
    }

    public String getTableName() {
        return this.m_TableName;
    }

    public KeyNamePair[] getDrillProcessList() {
        return this.drillProcessList;
    }

    public HashMap<Integer, KeyNamePair[]> getDrillProcessRulesPrintFormatMap() {
        return this.drillProcessRulesPrintFormatMap;
    }
}

