/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.apps.form;

import java.sql.ResultSet;
import java.sql.Statement;
import java.util.Properties;
import java.util.logging.Level;
import org.compiere.model.MBPartner;
import org.compiere.model.MInvoice;
import org.compiere.model.MPayment;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Trx;

public class Merge {
    protected int m_WindowNo = 0;
    protected int m_totalCount = 0;
    protected StringBuffer m_errorLog = new StringBuffer();
    private Trx m_trx = null;
    protected static final CLogger log = CLogger.getCLogger(Merge.class);
    public static String AD_ORG_ID = "AD_Org_ID";
    public static String C_BPARTNER_ID = "C_BPartner_ID";
    public static String AD_USER_ID = "AD_User_ID";
    public static String M_PRODUCT_ID = "M_Product_ID";
    protected static String[] s_delete_Org = new String[]{"AD_OrgInfo", "AD_Role_OrgAccess"};
    protected static String[] s_delete_User = new String[]{"AD_User_Roles"};
    protected static String[] s_delete_BPartner = new String[]{"C_BP_Employee_Acct", "C_BP_Vendor_Acct", "C_BP_Customer_Acct", "T_Aging"};
    protected static String[] s_delete_Product = new String[]{"M_Product_PO", "M_Replenish", "T_Replenish", "M_ProductPrice", "M_Cost", "M_Product_Trl", "M_Product_Acct"};
    protected String[] m_columnName = null;
    protected String[] m_deleteTables = null;

    protected void updateDeleteTable(String columnName) {
        if (columnName.equals(AD_ORG_ID)) {
            this.m_deleteTables = s_delete_Org;
        } else if (columnName.equals(AD_USER_ID)) {
            this.m_deleteTables = s_delete_User;
        } else if (columnName.equals(C_BPARTNER_ID)) {
            this.m_deleteTables = s_delete_BPartner;
        } else if (columnName.equals(M_PRODUCT_ID)) {
            this.m_deleteTables = s_delete_Product;
        }
    }

    public boolean merge(String ColumnName, int from_ID, int to_ID) {
        boolean success;
        block19: {
            ResultSet rs;
            CPreparedStatement pstmt;
            block16: {
                block17: {
                    block20: {
                        block18: {
                            String TableName = ColumnName.substring(0, ColumnName.length() - 3);
                            if (log.isLoggable(Level.CONFIG)) {
                                log.config(String.valueOf(ColumnName) + " - From=" + from_ID + ",To=" + to_ID);
                            }
                            this.updateDeleteTable(ColumnName);
                            success = true;
                            this.m_totalCount = 0;
                            this.m_errorLog = new StringBuffer();
                            String sql = "SELECT t.TableName, c.ColumnName FROM AD_Table t INNER JOIN AD_Column c ON (t.AD_Table_ID=c.AD_Table_ID) WHERE t.IsView='N' AND t.TableName NOT IN ('C_TaxDeclarationAcct') AND ((c.ColumnName=? AND c.IsKey='N') OR c.AD_Reference_Value_ID IN (SELECT rt.AD_Reference_ID FROM AD_Ref_Table rt INNER JOIN AD_Column cc ON (rt.AD_Table_ID=cc.AD_Table_ID AND rt.AD_Key=cc.AD_Column_ID) WHERE cc.IsKey='Y' AND cc.ColumnName=?)) AND c.ColumnSQL IS NULL ORDER BY t.LoadSeq DESC";
                            pstmt = null;
                            rs = null;
                            try {
                                this.m_trx = Trx.get((String)Trx.createTrxName((String)"merge"), (boolean)true);
                                this.m_trx.setDisplayName(String.valueOf(this.getClass().getName()) + "_merge");
                                pstmt = DB.prepareStatement((String)sql, (String)this.m_trx.getTrxName());
                                pstmt.setString(1, ColumnName);
                                pstmt.setString(2, ColumnName);
                                rs = pstmt.executeQuery();
                                while (rs.next()) {
                                    String tName = rs.getString(1);
                                    String cName = rs.getString(2);
                                    if (TableName.equals(tName)) continue;
                                    int count = this.mergeTable(tName, cName, from_ID, to_ID);
                                    if (count < 0) {
                                        success = false;
                                        continue;
                                    }
                                    this.m_totalCount += count;
                                }
                                if (log.isLoggable(Level.CONFIG)) {
                                    log.config("Success=" + success + " - " + ColumnName + " - From=" + from_ID + ",To=" + to_ID);
                                }
                                if (!success || DB.executeUpdateEx((String)(sql = "DELETE FROM " + TableName + " WHERE " + ColumnName + "=" + from_ID), (String)this.m_trx.getTrxName()) >= 0) break block16;
                                this.m_errorLog.append(Env.NL).append("DELETE FROM ").append(TableName).append(" - ");
                                success = false;
                                if (log.isLoggable(Level.CONFIG)) {
                                    log.config(this.m_errorLog.toString());
                                }
                                this.m_trx.rollback();
                                if (this.m_trx == null) break block17;
                                if (!success) break block18;
                            }
                            catch (Exception ex) {
                                log.log(Level.SEVERE, ColumnName, (Throwable)ex);
                                success = false;
                                break block19;
                            }
                            finally {
                                if (this.m_trx != null) {
                                    if (success) {
                                        success = this.m_trx.commit();
                                    } else {
                                        this.m_trx.rollback();
                                    }
                                    this.m_trx.close();
                                }
                                DB.close(rs, pstmt);
                                rs = null;
                                pstmt = null;
                            }
                            success = this.m_trx.commit();
                            break block20;
                        }
                        this.m_trx.rollback();
                    }
                    this.m_trx.close();
                }
                DB.close((ResultSet)rs, (Statement)pstmt);
                rs = null;
                pstmt = null;
                return false;
            }
            if (this.m_trx != null) {
                if (success) {
                    success = this.m_trx.commit();
                } else {
                    this.m_trx.rollback();
                }
                this.m_trx.close();
            }
            DB.close((ResultSet)rs, (Statement)pstmt);
            rs = null;
            pstmt = null;
        }
        return success;
    }

    protected int mergeTable(String TableName, String ColumnName, int from_ID, int to_ID) {
        int count;
        if (log.isLoggable(Level.FINE)) {
            log.fine(String.valueOf(TableName) + "." + ColumnName + " - From=" + from_ID + ",To=" + to_ID);
        }
        String sql = "UPDATE " + TableName + " SET " + ColumnName + "=" + to_ID + " WHERE " + ColumnName + "=" + from_ID;
        boolean delete = false;
        int i = 0;
        while (i < this.m_deleteTables.length) {
            if (this.m_deleteTables[i].equals(TableName)) {
                delete = true;
                sql = "DELETE FROM " + TableName + " WHERE " + ColumnName + "=" + from_ID;
            }
            ++i;
        }
        if (delete && "M_Cost".equals(TableName) && M_PRODUCT_ID.equals(ColumnName)) {
            sql = String.valueOf(sql) + " AND CurrentCostPrice=0 AND CurrentQty=0 AND CumulatedAmt=0 AND CumulatedQty=0";
        }
        if ((count = DB.executeUpdateEx((String)sql, (String)this.m_trx.getTrxName())) < 0) {
            count = -1;
            this.m_errorLog.append(Env.NL).append(delete ? "DELETE FROM " : "UPDATE ").append(TableName).append(" - ").append(" - ").append(sql);
            if (log.isLoggable(Level.CONFIG)) {
                log.config(this.m_errorLog.toString());
            }
            this.m_trx.rollback();
        }
        if (log.isLoggable(Level.FINE)) {
            log.fine(String.valueOf(count) + (delete ? " -Delete- " : " -Update- ") + TableName);
        }
        return count;
    }

    public void postMerge(String ColumnName, int to_ID) {
        if (!ColumnName.equals(AD_ORG_ID) && !ColumnName.equals(AD_USER_ID)) {
            if (ColumnName.equals(C_BPARTNER_ID)) {
                MBPartner bp = new MBPartner(Env.getCtx(), to_ID, null);
                if (bp.get_ID() != 0) {
                    MPayment[] payments = MPayment.getOfBPartner((Properties)Env.getCtx(), (int)bp.getC_BPartner_ID(), null);
                    int i = 0;
                    while (i < payments.length) {
                        MPayment payment = payments[i];
                        if (payment.testAllocation()) {
                            payment.saveEx();
                        }
                        ++i;
                    }
                    MInvoice[] invoices = MInvoice.getOfBPartner((Properties)Env.getCtx(), (int)bp.getC_BPartner_ID(), null);
                    int i2 = 0;
                    while (i2 < invoices.length) {
                        MInvoice invoice = invoices[i2];
                        if (invoice.testAllocation()) {
                            invoice.saveEx();
                        }
                        ++i2;
                    }
                    bp.setTotalOpenBalance();
                    bp.setActualLifeTimeValue();
                    bp.saveEx();
                }
            } else {
                ColumnName.equals(M_PRODUCT_ID);
            }
        }
    }
}

