/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.apps.form;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.List;
import java.util.Properties;
import java.util.Vector;
import java.util.logging.Level;
import org.compiere.minigrid.IMiniTable;
import org.compiere.model.MFactReconciliation;
import org.compiere.model.MRole;
import org.compiere.model.Query;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.KeyNamePair;
import org.compiere.util.Msg;

public class FactReconcile {
    protected static final CLogger log = CLogger.getCLogger(FactReconcile.class);
    protected int m_AD_Client_ID = 0;
    protected int m_AD_Org_ID = 0;
    protected int m_Account_ID = 0;
    protected int m_C_AcctSchema_ID = 0;
    protected boolean m_isReconciled = false;
    protected int m_C_BPartner_ID = 0;
    protected int m_M_Product_ID = 0;
    protected Timestamp m_DateAcct = null;
    protected Timestamp m_DateAcct2 = null;
    public int selectedColIndex = 2;
    public int idColIndex = 8;
    public int amtColIndex = 0;
    protected static int col_C_AcctSchema_ID = 2513;
    protected static int col_AD_Org_ID = 839;
    protected static int col_C_BPartner_ID = 3499;
    protected static int col_M_Product_ID = 2527;
    protected String m_trxName;
    protected int m_noSelected;
    protected BigDecimal m_selectedAmt;

    public void dynInit() throws Exception {
        this.m_AD_Client_ID = Env.getAD_Client_ID((Properties)Env.getCtx());
    }

    public Vector<String> getColumnNames() {
        Vector<String> columnNames = new Vector<String>();
        columnNames.add(Msg.translate((Properties)Env.getCtx(), (String)"Amt"));
        columnNames.add(Msg.translate((Properties)Env.getCtx(), (String)"DR/CR"));
        columnNames.add(Msg.translate((Properties)Env.getCtx(), (String)"Selected"));
        columnNames.add(Msg.translate((Properties)Env.getCtx(), (String)"C_BPartner_ID"));
        columnNames.add(Msg.translate((Properties)Env.getCtx(), (String)"DateAcct"));
        columnNames.add(Msg.translate((Properties)Env.getCtx(), (String)"GL_Category_ID"));
        columnNames.add(Msg.translate((Properties)Env.getCtx(), (String)"M_Product_ID"));
        columnNames.add(Msg.translate((Properties)Env.getCtx(), (String)"Qty"));
        columnNames.add(Msg.translate((Properties)Env.getCtx(), (String)"Description"));
        columnNames.add(Msg.translate((Properties)Env.getCtx(), (String)"MatchCode"));
        columnNames.add(Msg.translate((Properties)Env.getCtx(), (String)"DateTrx"));
        columnNames.add(Msg.translate((Properties)Env.getCtx(), (String)"AD_Org_ID"));
        return columnNames;
    }

    public Vector<Vector<Object>> getData() {
        Vector<Vector<Object>> data;
        block23: {
            data = new Vector<Vector<Object>>();
            StringBuilder sql = new StringBuilder("SELECT abs(fa.amtacctdr-fa.amtacctcr), (fa.amtacctdr-fa.amtacctcr),").append(" (CASE WHEN (fa.amtacctdr-fa.amtacctcr) < 0 THEN ").append(DB.TO_STRING((String)Msg.translate((Properties)Env.getCtx(), (String)"CR"))).append(" ELSE ").append(DB.TO_STRING((String)Msg.translate((Properties)Env.getCtx(), (String)"DR"))).append(" END), fa.Fact_Acct_ID, bp.name, DateAcct,").append(" glc.name, p.name, Qty, fa.Description, r.MatchCode, fa.DateTrx, o.value").append(" FROM Fact_Acct fa").append(" LEFT OUTER JOIN Fact_Reconciliation r ON (fa.Fact_Acct_ID=r.Fact_Acct_ID)").append(" LEFT OUTER JOIN C_BPartner bp ON (fa.C_BPartner_ID=bp.C_BPartner_ID)").append(" LEFT OUTER JOIN AD_Org o ON (o.AD_Org_ID=fa.AD_Org_ID)").append(" LEFT OUTER JOIN M_Product p ON (p.M_Product_ID=fa.M_Product_ID)").append(" LEFT OUTER JOIN GL_Category glc ON (fa.GL_Category_ID=glc.GL_Category_ID)").append(" WHERE fa.AD_Client_ID=?");
            sql = new StringBuilder(MRole.getDefault((Properties)Env.getCtx(), (boolean)false).addAccessSQL(sql.toString(), "fa", true, false));
            if (this.m_AD_Org_ID > 0) {
                sql.append(" AND fa.AD_Org_ID=?");
            }
            if (this.m_Account_ID > 0) {
                sql.append(" AND fa.Account_ID=?");
            }
            if (this.m_C_AcctSchema_ID > 0) {
                sql.append(" AND fa.C_AcctSchema_ID=?");
            }
            sql.append(" AND ((SELECT SUM(f.amtacctdr-f.amtacctcr) FROM Fact_Reconciliation rec  INNER JOIN Fact_Acct f ON (f.Fact_Acct_ID = rec.Fact_Acct_ID)  WHERE r.MatchCode=rec.MatchCode) ");
            if (this.m_isReconciled) {
                sql.append(" =0)");
            } else {
                sql.append(" <> 0 OR r.MatchCode IS NULL)");
            }
            if (this.m_C_BPartner_ID > 0) {
                sql.append(" AND fa.C_BPartner_ID=?");
            }
            if (this.m_M_Product_ID > 0) {
                sql.append(" AND fa.M_Product_ID=?");
            }
            if (this.m_DateAcct != null) {
                sql.append(" AND fa.DateAcct>=?");
            }
            if (this.m_DateAcct2 != null) {
                sql.append(" AND fa.DateAcct<=?");
            }
            sql.append(" ORDER BY 1,5,3,6");
            if (log.isLoggable(Level.FINE)) {
                log.fine("SQL=" + sql.toString());
            }
            CPreparedStatement pstmt = null;
            ResultSet rs = null;
            try {
                try {
                    pstmt = DB.prepareStatement((String)sql.toString(), (String)this.m_trxName);
                    int i = 1;
                    pstmt.setInt(i++, this.m_AD_Client_ID);
                    if (this.m_AD_Org_ID > 0) {
                        pstmt.setInt(i++, this.m_AD_Org_ID);
                    }
                    if (this.m_Account_ID > 0) {
                        pstmt.setInt(i++, this.m_Account_ID);
                    }
                    if (this.m_C_AcctSchema_ID > 0) {
                        pstmt.setInt(i++, this.m_C_AcctSchema_ID);
                    }
                    if (this.m_C_BPartner_ID > 0) {
                        pstmt.setInt(i++, this.m_C_BPartner_ID);
                    }
                    if (this.m_M_Product_ID > 0) {
                        pstmt.setInt(i++, this.m_M_Product_ID);
                    }
                    if (this.m_DateAcct != null) {
                        pstmt.setTimestamp(i++, this.m_DateAcct);
                    }
                    if (this.m_DateAcct2 != null) {
                        pstmt.setTimestamp(i++, this.m_DateAcct2);
                    }
                    rs = pstmt.executeQuery();
                    while (rs.next()) {
                        Vector<Object> line = new Vector<Object>();
                        line.add(rs.getBigDecimal(2));
                        line.add(rs.getString(3));
                        line.add(Boolean.FALSE);
                        line.add(rs.getString(5));
                        line.add(rs.getTimestamp(6));
                        line.add(rs.getString(7));
                        line.add(rs.getString(8));
                        line.add(rs.getBigDecimal(9));
                        KeyNamePair pp = new KeyNamePair(rs.getInt(4), rs.getString(10));
                        line.add(pp);
                        line.add(rs.getString(11));
                        line.add(rs.getTimestamp(12));
                        line.add(rs.getString(13));
                        data.add(line);
                    }
                }
                catch (SQLException e) {
                    log.log(Level.SEVERE, sql.toString(), (Throwable)e);
                    DB.close(rs, (Statement)pstmt);
                    rs = null;
                    pstmt = null;
                    break block23;
                }
            }
            catch (Throwable throwable) {
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
            DB.close((ResultSet)rs, (Statement)pstmt);
            rs = null;
            pstmt = null;
        }
        return data;
    }

    public void setColumnClass(IMiniTable miniTable) {
        int i = 0;
        miniTable.setColumnClass(i++, BigDecimal.class, true);
        miniTable.setColumnClass(i++, String.class, true);
        miniTable.setColumnClass(i++, Boolean.class, false);
        miniTable.setColumnClass(i++, String.class, true);
        miniTable.setColumnClass(i++, Timestamp.class, true);
        miniTable.setColumnClass(i++, String.class, true);
        miniTable.setColumnClass(i++, String.class, true);
        miniTable.setColumnClass(i++, BigDecimal.class, true);
        miniTable.setColumnClass(i++, String.class, true);
        miniTable.setColumnClass(i++, String.class, true);
        miniTable.setColumnClass(i++, Timestamp.class, true);
        miniTable.setColumnClass(i++, String.class, true);
        miniTable.autoSize();
    }

    public void calculateSelection(IMiniTable miniTable) {
        this.m_noSelected = 0;
        this.m_selectedAmt = Env.ZERO;
        int rows = miniTable.getRowCount();
        int i = 0;
        while (i < rows) {
            boolean isSelected = (Boolean)miniTable.getValueAt(i, this.selectedColIndex);
            if (isSelected) {
                BigDecimal amt = (BigDecimal)miniTable.getValueAt(i, this.amtColIndex);
                if (amt != null) {
                    this.m_selectedAmt = this.m_selectedAmt.add(amt);
                }
                ++this.m_noSelected;
            }
            ++i;
        }
    }

    public void generate(IMiniTable miniTable, List<Integer> generatedIndexes) {
        String format = "yyyy-MM-dd HH:mm:ss.SSS";
        Calendar cal = Calendar.getInstance();
        SimpleDateFormat sdf = new SimpleDateFormat(format);
        String time = sdf.format(cal.getTime());
        int r = 0;
        while (r < miniTable.getRowCount()) {
            KeyNamePair pp;
            int factId;
            boolean result;
            boolean isSelected = (Boolean)miniTable.getValueAt(r, this.selectedColIndex);
            if (isSelected && (result = this.generate(factId = (pp = (KeyNamePair)miniTable.getValueAt(r, this.idColIndex)).getKey(), time)) && generatedIndexes != null) {
                generatedIndexes.add(r);
            }
            ++r;
        }
    }

    public boolean generate(int factId, String time) {
        String matchcode = "Manual: " + Env.getContext((Properties)Env.getCtx(), (String)"#AD_User_Name") + " " + time;
        MFactReconciliation rec = (MFactReconciliation)new Query(Env.getCtx(), "Fact_Reconciliation", "Fact_Acct_ID = ?", this.m_trxName).setParameters(new Object[]{factId}).first();
        if (rec == null) {
            rec = new MFactReconciliation(Env.getCtx(), 0, this.m_trxName);
            rec.setFact_Acct_ID(factId);
        }
        rec.setMatchCode(matchcode);
        return rec.save();
    }

    public void reset(IMiniTable miniTable, List<Integer> resetedIndexes) {
        int r = 0;
        while (r < miniTable.getRowCount()) {
            KeyNamePair pp;
            int factId;
            boolean result;
            boolean isSelected = (Boolean)miniTable.getValueAt(r, this.selectedColIndex);
            if (isSelected && (result = this.reset(factId = (pp = (KeyNamePair)miniTable.getValueAt(r, this.idColIndex)).getKey())) && resetedIndexes != null) {
                resetedIndexes.add(r);
            }
            ++r;
        }
    }

    public boolean reset(int factId) {
        MFactReconciliation rec = (MFactReconciliation)new Query(Env.getCtx(), "Fact_Reconciliation", "Fact_Acct_ID = ?", this.m_trxName).setParameters(new Object[]{factId}).first();
        if (rec == null) {
            return false;
        }
        return rec.delete(false);
    }

    protected Vector<KeyNamePair> getAccount() {
        Vector<KeyNamePair> vector;
        block6: {
            vector = new Vector<KeyNamePair>();
            String sql = String.valueOf(MRole.getDefault().addAccessSQL("SELECT ev.C_ElementValue_ID, ev.Value || ' ' || ev.Name FROM C_ElementValue ev", "ev", true, false)) + " AND ev.IsActive='Y' AND ev.IsSummary='N' " + "AND EXISTS (SELECT 1 FROM C_AcctSchema_Element ase " + "WHERE ase.C_Element_ID=ev.C_Element_ID AND ase.ElementType='AC' " + "AND ase.C_AcctSchema_ID=" + this.m_C_AcctSchema_ID + " AND ase.AD_Client_ID=" + this.m_AD_Client_ID + ") " + "ORDER BY 2";
            CPreparedStatement pstmt = null;
            ResultSet rs = null;
            try {
                try {
                    pstmt = DB.prepareStatement((String)sql, (String)this.m_trxName);
                    rs = pstmt.executeQuery();
                    while (rs.next()) {
                        vector.add(new KeyNamePair(rs.getInt(1), rs.getString(2)));
                    }
                }
                catch (SQLException e) {
                    log.log(Level.SEVERE, sql, (Throwable)e);
                    DB.close((ResultSet)rs, (Statement)pstmt);
                    rs = null;
                    pstmt = null;
                    break block6;
                }
            }
            catch (Throwable throwable) {
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
            DB.close((ResultSet)rs, (Statement)pstmt);
            rs = null;
            pstmt = null;
        }
        return vector;
    }
}

