/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.apps.form;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Properties;
import java.util.logging.Level;
import org.compiere.model.MArchive;
import org.compiere.model.MRole;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.KeyNamePair;
import org.compiere.util.TimeUtil;

public class Archive {
    protected int m_WindowNo = 0;
    protected MArchive[] m_archives = new MArchive[0];
    protected int m_index = 0;
    protected int m_AD_Table_ID = 0;
    protected int m_Record_ID = 0;
    protected static final CLogger log = CLogger.getCLogger(Archive.class);
    private String m_trxName = null;

    public KeyNamePair[] getProcessData() {
        MRole role = MRole.getDefault();
        boolean trl = !Env.isBaseLanguage((Properties)Env.getCtx(), (String)"AD_Process");
        String lang = Env.getAD_Language((Properties)Env.getCtx());
        String sql = "SELECT p.AD_Process_ID," + (trl ? "trl.Name" : "p.Name ") + " FROM AD_Process p " + (trl ? "LEFT JOIN AD_Process_Trl trl on (trl.AD_Process_ID=p.AD_Process_ID and trl.AD_Language=" + DB.TO_STRING((String)lang) + ")" : "") + " WHERE p.IsReport='Y' AND p.IsActive='Y' " + "ORDER BY 2";
        ArrayList<KeyNamePair> list = new ArrayList<KeyNamePair>();
        list.add(new KeyNamePair(-1, ""));
        try {
            Throwable throwable = null;
            Object var7_9 = null;
            try (CPreparedStatement pstmt = DB.prepareStatement((String)sql, (String)this.m_trxName);){
                ResultSet rs = pstmt.executeQuery();
                while (rs.next()) {
                    int AD_Process_ID = rs.getInt(1);
                    String name = rs.getString(2);
                    Boolean access = role.getProcessAccess(AD_Process_ID);
                    if (access == null) continue;
                    list.add(new KeyNamePair(AD_Process_ID, name));
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (SQLException e) {
            log.log(Level.SEVERE, e.getMessage(), (Throwable)e);
        }
        return list.toArray(new KeyNamePair[0]);
    }

    public KeyNamePair[] getTableData() {
        MRole role = MRole.getDefault();
        boolean trl = !Env.isBaseLanguage((Properties)Env.getCtx(), (String)"AD_Table");
        String lang = Env.getAD_Language((Properties)Env.getCtx());
        String sql = "SELECT DISTINCT t.AD_Table_ID," + (trl ? "trl.Name" : "t.Name") + " FROM AD_Table t INNER JOIN AD_Tab tab ON (tab.AD_Table_ID=t.AD_Table_ID)" + " INNER JOIN AD_Window_Access wa ON (tab.AD_Window_ID=wa.AD_Window_ID) " + (trl ? "LEFT JOIN AD_Table_Trl trl on (trl.AD_Table_ID=t.AD_Table_ID and trl.AD_Language=" + DB.TO_STRING((String)lang) + ")" : "") + " WHERE " + role.getIncludedRolesWhereClause("wa.AD_Role_ID", null) + " AND t.IsActive='Y' AND tab.IsActive='Y' " + "ORDER BY 2";
        return DB.getKeyNamePairs((String)this.m_trxName, (String)sql, (boolean)true, (Object[])new Object[0]);
    }

    public KeyNamePair[] getUserData() {
        String sql = "SELECT AD_User_ID, Name FROM AD_User u WHERE EXISTS (SELECT * FROM AD_User_Roles ur WHERE u.AD_User_ID=ur.AD_User_ID) ORDER BY 2";
        MRole role = MRole.getDefault();
        sql = role.addAccessSQL(sql, "u", true, false);
        return DB.getKeyNamePairs((String)this.m_trxName, (String)sql, (boolean)true, (Object[])new Object[0]);
    }

    public boolean isSame(String s1, String s2) {
        return Objects.equals(s1, s2);
    }

    public void cmd_query(boolean reports, KeyNamePair process, KeyNamePair table, Integer C_BPartner_ID, String name, String description, String help, KeyNamePair createdBy, Timestamp createdFrom, Timestamp createdTo) {
        this.m_archives = new MArchive[0];
        StringBuilder sql = new StringBuilder();
        MRole role = MRole.getDefault();
        if (!role.isCanReport()) {
            log.warning("User/Role cannot Report AD_User_ID=" + Env.getAD_User_ID((Properties)Env.getCtx()));
            return;
        }
        sql.append(" AND IsReport=").append(reports ? "'Y'" : "'N'");
        if (reports && process != null && process.getKey() > 0) {
            sql.append(" AND AD_Process_ID=").append(process.getKey());
        }
        if (this.m_AD_Table_ID > 0) {
            sql.append(" AND ((AD_Table_ID=").append(this.m_AD_Table_ID);
            if (this.m_Record_ID > 0) {
                sql.append(" AND Record_ID=").append(this.m_Record_ID);
            }
            sql.append(")");
            if (this.m_AD_Table_ID == 291 && this.m_Record_ID > 0) {
                sql.append(" OR C_BPartner_ID=").append(this.m_Record_ID);
            }
            sql.append(")");
            this.m_AD_Table_ID = 0;
            this.m_Record_ID = 0;
        } else if (table != null && table.getKey() > 0) {
            sql.append(" AND AD_Table_ID=").append(table.getKey());
        }
        if (!reports) {
            if (C_BPartner_ID != null) {
                sql.append(" AND C_BPartner_ID=").append(C_BPartner_ID);
            } else {
                sql.append(" AND C_BPartner_ID IS NOT NULL");
            }
        }
        if (name != null && name.length() > 0) {
            if (name.indexOf(37) != -1 || name.indexOf(95) != -1) {
                sql.append(" AND Name LIKE ").append(DB.TO_STRING((String)name));
            } else {
                sql.append(" AND Name=").append(DB.TO_STRING((String)name));
            }
        }
        if (description != null && description.length() > 0) {
            if (description.indexOf(37) != -1 || description.indexOf(95) != -1) {
                sql.append(" AND Description LIKE ").append(DB.TO_STRING((String)description));
            } else {
                sql.append(" AND Description=").append(DB.TO_STRING((String)description));
            }
        }
        if (help != null && help.length() > 0) {
            if (help.indexOf(37) != -1 || help.indexOf(95) != -1) {
                sql.append(" AND Help LIKE ").append(DB.TO_STRING((String)help));
            } else {
                sql.append(" AND Help=").append(DB.TO_STRING((String)help));
            }
        }
        if (createdBy != null && createdBy.getKey() > 0) {
            sql.append(" AND CreatedBy=").append(createdBy.getKey());
        }
        if (createdFrom != null) {
            sql.append(" AND Created>=").append(DB.TO_DATE((Timestamp)createdFrom, (boolean)true));
        }
        if (createdTo != null) {
            sql.append(" AND Created<").append(DB.TO_DATE((Timestamp)TimeUtil.addDays((Timestamp)createdTo, (int)1), (boolean)true));
        }
        if (log.isLoggable(Level.FINE)) {
            log.fine(sql.toString());
        }
        sql.append(" AND (AD_Process_ID IS NULL OR AD_Process_ID IN (SELECT AD_Process_ID FROM AD_Process_Access WHERE AD_Role_ID=").append(role.getAD_Role_ID()).append(" OR ").append(role.getIncludedRolesWhereClause("AD_Role_ID", null)).append("))");
        sql.append(" AND (AD_Table_ID IS NULL OR (AD_Table_ID IS NOT NULL AND AD_Process_ID IS NOT NULL) OR AD_Table_ID IN (SELECT t.AD_Table_ID FROM AD_Tab t INNER JOIN AD_Window_Access wa ON (t.AD_Window_ID=wa.AD_Window_ID) WHERE wa.AD_Role_ID=").append(role.getAD_Role_ID()).append(" OR ").append(role.getIncludedRolesWhereClause("wa.AD_Role_ID", null)).append("))");
        if (log.isLoggable(Level.FINEST)) {
            log.finest(sql.toString());
        }
        this.m_archives = MArchive.get((Properties)Env.getCtx(), (String)sql.toString(), (String)this.m_trxName);
        if (log.isLoggable(Level.INFO)) {
            log.info("Length=" + this.m_archives.length);
        }
    }

    public MArchive[] getArchives() {
        return this.m_archives;
    }

    public void setTrxName(String trxName) {
        this.m_trxName = trxName;
    }
}

