/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.apps.form;

import java.math.BigDecimal;
import java.sql.Timestamp;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Properties;
import java.util.Vector;
import java.util.logging.Level;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.minigrid.IMiniTable;
import org.compiere.model.MAllocationHdr;
import org.compiere.model.MAllocationLine;
import org.compiere.model.MDocType;
import org.compiere.model.MInvoice;
import org.compiere.model.MPayment;
import org.compiere.model.MSysConfig;
import org.compiere.util.CLogger;
import org.compiere.util.DB;
import org.compiere.util.DisplayType;
import org.compiere.util.Env;
import org.compiere.util.KeyNamePair;
import org.compiere.util.Msg;
import org.compiere.util.TimeUtil;
import org.compiere.util.Util;

public class Allocation {
    protected DecimalFormat format = DisplayType.getNumberFormat((int)12);
    protected static final CLogger log = CLogger.getCLogger(Allocation.class);
    private boolean m_calculating = false;
    protected int m_C_Currency_ID = 0;
    protected int m_C_Charge_ID = 0;
    protected int m_C_DocType_ID = 0;
    protected int m_C_BPartner_ID = 0;
    private int m_noInvoices = 0;
    private int m_noPayments = 0;
    protected BigDecimal totalInv = Env.ZERO;
    protected BigDecimal totalPay = Env.ZERO;
    protected BigDecimal totalDiff = Env.ZERO;
    protected Timestamp allocDate = null;
    private int i_payment = 7;
    private int i_open = 6;
    private int i_discount = 7;
    private int i_writeOff = 8;
    private int i_applied = 9;
    private int i_overUnder = 10;
    protected int m_AD_Org_ID = 0;
    private ArrayList<Integer> m_bpartnerCheck = new ArrayList();

    protected void dynInit() throws Exception {
        this.m_C_Currency_ID = Env.getContextAsInt((Properties)Env.getCtx(), (String)"$C_Currency_ID");
        if (log.isLoggable(Level.INFO)) {
            log.info("Currency=" + this.m_C_Currency_ID);
        }
        this.m_AD_Org_ID = Env.getAD_Org_ID((Properties)Env.getCtx());
        this.m_C_DocType_ID = MDocType.getDocType((String)"CMA");
    }

    public void checkBPartner() {
        if (log.isLoggable(Level.CONFIG)) {
            log.config("BPartner=" + this.m_C_BPartner_ID + ", Cur=" + this.m_C_Currency_ID);
        }
        if (this.m_C_BPartner_ID == 0 || this.m_C_Currency_ID == 0) {
            return;
        }
        Integer key = this.m_C_BPartner_ID;
        if (!this.m_bpartnerCheck.contains(key)) {
            new Thread(){

                @Override
                public void run() {
                    MPayment.setIsAllocated((Properties)Env.getCtx(), (int)Allocation.this.m_C_BPartner_ID, null);
                    MInvoice.setIsPaid((Properties)Env.getCtx(), (int)Allocation.this.m_C_BPartner_ID, null);
                }
            }.start();
            this.m_bpartnerCheck.add(key);
        }
    }

    public Vector<Vector<Object>> getPaymentData(boolean isMultiCurrency, Object date, IMiniTable paymentTable) {
        return this.getPaymentData(isMultiCurrency, (Timestamp)date, null);
    }

    public Vector<Vector<Object>> getPaymentData(boolean isMultiCurrency, Timestamp date, String trxName) {
        return MPayment.getUnAllocatedPaymentData((int)this.m_C_BPartner_ID, (int)this.m_C_Currency_ID, (boolean)isMultiCurrency, (Timestamp)date, (int)this.m_AD_Org_ID, (String)trxName);
    }

    public Vector<String> getPaymentColumnNames(boolean isMultiCurrency) {
        Vector<String> columnNames = new Vector<String>();
        columnNames.add(Msg.getMsg((Properties)Env.getCtx(), (String)"Select"));
        columnNames.add(Msg.translate((Properties)Env.getCtx(), (String)"Date"));
        columnNames.add(Util.cleanAmp((String)Msg.translate((Properties)Env.getCtx(), (String)"DocumentNo")));
        if (isMultiCurrency) {
            columnNames.add(Msg.getMsg((Properties)Env.getCtx(), (String)"TrxCurrency"));
            columnNames.add(Msg.translate((Properties)Env.getCtx(), (String)"Amount"));
        }
        columnNames.add(Msg.getMsg((Properties)Env.getCtx(), (String)"ConvertedAmount"));
        columnNames.add(Msg.getMsg((Properties)Env.getCtx(), (String)"OpenAmt"));
        columnNames.add(Msg.getMsg((Properties)Env.getCtx(), (String)"AppliedAmt"));
        return columnNames;
    }

    public void setPaymentColumnClass(IMiniTable paymentTable, boolean isMultiCurrency) {
        int i = 0;
        paymentTable.setColumnClass(i++, Boolean.class, false);
        paymentTable.setColumnClass(i++, Timestamp.class, true);
        paymentTable.setColumnClass(i++, String.class, true);
        if (isMultiCurrency) {
            paymentTable.setColumnClass(i++, String.class, true);
            paymentTable.setColumnClass(i++, BigDecimal.class, true);
        }
        paymentTable.setColumnClass(i++, BigDecimal.class, true);
        paymentTable.setColumnClass(i++, BigDecimal.class, true);
        paymentTable.setColumnClass(i++, BigDecimal.class, false);
        this.i_payment = isMultiCurrency ? 7 : 5;
        paymentTable.autoSize();
    }

    public Vector<Vector<Object>> getInvoiceData(boolean isMultiCurrency, Object date, IMiniTable invoiceTable) {
        return this.getInvoiceData(isMultiCurrency, (Timestamp)date, null);
    }

    public Vector<Vector<Object>> getInvoiceData(boolean isMultiCurrency, Timestamp date, String trxName) {
        return MInvoice.getUnpaidInvoiceData((boolean)isMultiCurrency, (Timestamp)date, (int)this.m_AD_Org_ID, (int)this.m_C_Currency_ID, (int)this.m_C_BPartner_ID, (String)trxName);
    }

    public Vector<String> getInvoiceColumnNames(boolean isMultiCurrency) {
        Vector<String> columnNames = new Vector<String>();
        columnNames.add(Msg.getMsg((Properties)Env.getCtx(), (String)"Select"));
        columnNames.add(Msg.translate((Properties)Env.getCtx(), (String)"Date"));
        columnNames.add(Util.cleanAmp((String)Msg.translate((Properties)Env.getCtx(), (String)"DocumentNo")));
        if (isMultiCurrency) {
            columnNames.add(Msg.getMsg((Properties)Env.getCtx(), (String)"TrxCurrency"));
            columnNames.add(Msg.translate((Properties)Env.getCtx(), (String)"Amount"));
        }
        columnNames.add(Msg.getMsg((Properties)Env.getCtx(), (String)"ConvertedAmount"));
        columnNames.add(Msg.getMsg((Properties)Env.getCtx(), (String)"OpenAmt"));
        columnNames.add(Msg.getMsg((Properties)Env.getCtx(), (String)"Discount"));
        columnNames.add(Msg.getMsg((Properties)Env.getCtx(), (String)"WriteOff"));
        columnNames.add(Msg.getMsg((Properties)Env.getCtx(), (String)"AppliedAmt"));
        columnNames.add(Msg.getMsg((Properties)Env.getCtx(), (String)"OverUnderAmt"));
        return columnNames;
    }

    public void setInvoiceColumnClass(IMiniTable invoiceTable, boolean isMultiCurrency) {
        int i = 0;
        invoiceTable.setColumnClass(i++, Boolean.class, false);
        invoiceTable.setColumnClass(i++, Timestamp.class, true);
        invoiceTable.setColumnClass(i++, String.class, true);
        if (isMultiCurrency) {
            invoiceTable.setColumnClass(i++, String.class, true);
            invoiceTable.setColumnClass(i++, BigDecimal.class, true);
        }
        invoiceTable.setColumnClass(i++, BigDecimal.class, true);
        invoiceTable.setColumnClass(i++, BigDecimal.class, true);
        invoiceTable.setColumnClass(i++, BigDecimal.class, false);
        invoiceTable.setColumnClass(i++, BigDecimal.class, false);
        invoiceTable.setColumnClass(i++, BigDecimal.class, false);
        invoiceTable.setColumnClass(i++, BigDecimal.class, true);
        invoiceTable.autoSize();
    }

    protected void prepareForCalculate(boolean isMultiCurrency) {
        this.i_open = isMultiCurrency ? 6 : 4;
        this.i_discount = isMultiCurrency ? 7 : 5;
        this.i_writeOff = isMultiCurrency ? 8 : 6;
        this.i_applied = isMultiCurrency ? 9 : 7;
        this.i_overUnder = isMultiCurrency ? 10 : 8;
    }

    public String writeOff(int row, int col, boolean isInvoice, IMiniTable payment, IMiniTable invoice, boolean isAutoWriteOff) {
        String msg = "";
        if (this.m_calculating) {
            return msg;
        }
        this.m_calculating = true;
        if (log.isLoggable(Level.CONFIG)) {
            log.config("Row=" + row + ", Col=" + col + ", InvoiceTable=" + isInvoice);
        }
        if (!isInvoice) {
            BigDecimal open = (BigDecimal)payment.getValueAt(row, this.i_open);
            BigDecimal applied = (BigDecimal)payment.getValueAt(row, this.i_payment);
            if (col == 0) {
                if (((Boolean)payment.getValueAt(row, 0)).booleanValue()) {
                    applied = open;
                    if (this.totalDiff.abs().compareTo(applied.abs()) < 0 && this.totalDiff.signum() == -applied.signum()) {
                        applied = this.totalDiff.negate();
                    }
                } else {
                    applied = Env.ZERO;
                }
            }
            if (col == this.i_payment) {
                if (!MSysConfig.getBooleanValue((String)"ALLOW_APPLY_PAYMENT_TO_CREDITMEMO", (boolean)false, (int)Env.getAD_Client_ID((Properties)Env.getCtx())) && open.signum() > 0 && applied.signum() == -open.signum()) {
                    applied = applied.negate();
                }
                if (!MSysConfig.getBooleanValue((String)"ALLOW_OVER_APPLIED_PAYMENT", (boolean)false, (int)Env.getAD_Client_ID((Properties)Env.getCtx())) && open.abs().compareTo(applied.abs()) < 0) {
                    applied = open;
                }
            }
            payment.setValueAt(applied, row, this.i_payment);
        } else {
            boolean selected = (Boolean)invoice.getValueAt(row, 0);
            BigDecimal open = (BigDecimal)invoice.getValueAt(row, this.i_open);
            BigDecimal discount = (BigDecimal)invoice.getValueAt(row, this.i_discount);
            BigDecimal applied = (BigDecimal)invoice.getValueAt(row, this.i_applied);
            BigDecimal writeOff = (BigDecimal)invoice.getValueAt(row, this.i_writeOff);
            BigDecimal overUnder = (BigDecimal)invoice.getValueAt(row, this.i_overUnder);
            int openSign = open.signum();
            if (col == 0) {
                if (selected) {
                    applied = open;
                    applied = applied.subtract(discount);
                    writeOff = Env.ZERO;
                    overUnder = Env.ZERO;
                    this.totalDiff = Env.ZERO;
                    if (this.totalDiff.abs().compareTo(applied.abs()) < 0 && this.totalDiff.signum() == applied.signum()) {
                        applied = this.totalDiff;
                    }
                    if (isAutoWriteOff) {
                        writeOff = open.subtract(applied.add(discount));
                    } else {
                        overUnder = open.subtract(applied.add(discount));
                    }
                } else {
                    writeOff = Env.ZERO;
                    applied = Env.ZERO;
                    overUnder = Env.ZERO;
                }
            }
            if (selected && col != 0) {
                if (discount.signum() == -openSign) {
                    discount = discount.negate();
                }
                if (writeOff.signum() == -openSign) {
                    writeOff = writeOff.negate();
                }
                if (applied.signum() == -openSign) {
                    applied = applied.negate();
                }
                if (discount.abs().compareTo(open.abs()) > 0) {
                    discount = open;
                }
                if (writeOff.abs().compareTo(open.abs()) > 0) {
                    writeOff = open;
                }
                BigDecimal newTotal = discount.add(writeOff).add(applied).add(overUnder);
                BigDecimal difference = newTotal.subtract(open);
                BigDecimal diffWOD = writeOff.add(discount).subtract(open);
                if (diffWOD.signum() == open.signum()) {
                    if (col == this.i_discount) {
                        writeOff = writeOff.subtract(diffWOD);
                    } else {
                        discount = discount.subtract(diffWOD);
                    }
                    difference = difference.subtract(diffWOD);
                }
                if (col == this.i_applied) {
                    overUnder = overUnder.subtract(difference);
                } else {
                    applied = applied.subtract(difference);
                }
            }
            if (isAutoWriteOff && writeOff.doubleValue() / open.doubleValue() > 0.3) {
                msg = "AllocationWriteOffWarn";
            }
            invoice.setValueAt(discount, row, this.i_discount);
            invoice.setValueAt(applied, row, this.i_applied);
            invoice.setValueAt(writeOff, row, this.i_writeOff);
            invoice.setValueAt(overUnder, row, this.i_overUnder);
        }
        this.m_calculating = false;
        return msg;
    }

    public void calculate(IMiniTable paymentTable, IMiniTable invoiceTable, boolean isMultiCurrency) {
        this.allocDate = null;
        this.prepareForCalculate(isMultiCurrency);
        this.calculatePayment(paymentTable, isMultiCurrency);
        this.calculateInvoice(invoiceTable, isMultiCurrency);
        this.calculateDifference();
    }

    public String calculatePayment(IMiniTable payment, boolean isMultiCurrency) {
        if (log.isLoggable(Level.CONFIG)) {
            log.config("");
        }
        this.totalPay = Env.ZERO;
        int rows = payment.getRowCount();
        this.m_noPayments = 0;
        int i = 0;
        while (i < rows) {
            if (((Boolean)payment.getValueAt(i, 0)).booleanValue()) {
                Timestamp ts = (Timestamp)payment.getValueAt(i, 1);
                if (!isMultiCurrency) {
                    this.allocDate = TimeUtil.max((Timestamp)this.allocDate, (Timestamp)ts);
                }
                BigDecimal bd = (BigDecimal)payment.getValueAt(i, this.i_payment);
                this.totalPay = this.totalPay.add(bd);
                ++this.m_noPayments;
                if (log.isLoggable(Level.FINE)) {
                    log.fine("Payment_" + i + " = " + bd + " - Total=" + this.totalPay);
                }
            }
            ++i;
        }
        return this.getPaymentInfoText();
    }

    public String getPaymentInfoText() {
        return String.valueOf(String.valueOf(this.m_noPayments)) + " - " + Msg.getMsg((Properties)Env.getCtx(), (String)"Sum") + "  " + this.format.format(this.totalPay) + " ";
    }

    public String calculateInvoice(IMiniTable invoice, boolean isMultiCurrency) {
        this.totalInv = Env.ZERO;
        int rows = invoice.getRowCount();
        this.m_noInvoices = 0;
        int i = 0;
        while (i < rows) {
            if (((Boolean)invoice.getValueAt(i, 0)).booleanValue()) {
                Timestamp ts = (Timestamp)invoice.getValueAt(i, 1);
                if (!isMultiCurrency) {
                    this.allocDate = TimeUtil.max((Timestamp)this.allocDate, (Timestamp)ts);
                }
                BigDecimal bd = (BigDecimal)invoice.getValueAt(i, this.i_applied);
                this.totalInv = this.totalInv.add(bd);
                ++this.m_noInvoices;
                if (log.isLoggable(Level.FINE)) {
                    log.fine("Invoice_" + i + " = " + bd + " - Total=" + this.totalPay);
                }
            }
            ++i;
        }
        return this.getInvoiceInfoText();
    }

    public String getInvoiceInfoText() {
        return String.valueOf(String.valueOf(this.m_noInvoices)) + " - " + Msg.getMsg((Properties)Env.getCtx(), (String)"Sum") + "  " + this.format.format(this.totalInv) + " ";
    }

    public MAllocationHdr saveData(int m_WindowNo, Timestamp dateTrx, IMiniTable payment, IMiniTable invoice, String trxName) {
        int C_Invoice_ID;
        KeyNamePair pp;
        if (this.m_noInvoices + this.m_noPayments == 0) {
            return null;
        }
        int AD_Client_ID = Env.getContextAsInt((Properties)Env.getCtx(), (int)m_WindowNo, (String)"AD_Client_ID");
        int AD_Org_ID = Env.getContextAsInt((Properties)Env.getCtx(), (int)m_WindowNo, (String)"AD_Org_ID");
        int C_BPartner_ID = this.m_C_BPartner_ID;
        int C_Order_ID = 0;
        int C_CashLine_ID = 0;
        int C_Currency_ID = this.m_C_Currency_ID;
        if (AD_Org_ID == 0) {
            throw new AdempiereException("@Org0NotAllowed@");
        }
        if (log.isLoggable(Level.CONFIG)) {
            log.config("Client=" + AD_Client_ID + ", Org=" + AD_Org_ID + ", BPartner=" + C_BPartner_ID + ", Date=" + dateTrx);
        }
        int pRows = payment.getRowCount();
        ArrayList<Integer> paymentList = new ArrayList<Integer>(pRows);
        ArrayList<BigDecimal> amountList = new ArrayList<BigDecimal>(pRows);
        BigDecimal paymentAppliedAmt = Env.ZERO;
        int i = 0;
        while (i < pRows) {
            if (((Boolean)payment.getValueAt(i, 0)).booleanValue()) {
                KeyNamePair pp2 = (KeyNamePair)payment.getValueAt(i, 2);
                int C_Payment_ID = pp2.getKey();
                paymentList.add(C_Payment_ID);
                BigDecimal PaymentAmt = (BigDecimal)payment.getValueAt(i, this.i_payment);
                amountList.add(PaymentAmt);
                paymentAppliedAmt = paymentAppliedAmt.add(PaymentAmt);
                if (log.isLoggable(Level.FINE)) {
                    log.fine("C_Payment_ID=" + C_Payment_ID + " - PaymentAmt=" + PaymentAmt);
                }
            }
            ++i;
        }
        if (log.isLoggable(Level.CONFIG)) {
            log.config("Number of Payments=" + paymentList.size() + " - Total=" + paymentAppliedAmt);
        }
        int iRows = invoice.getRowCount();
        MAllocationHdr alloc = new MAllocationHdr(Env.getCtx(), true, dateTrx, C_Currency_ID, Env.getContext((Properties)Env.getCtx(), (String)"#AD_User_Name"), trxName);
        alloc.setAD_Org_ID(AD_Org_ID);
        alloc.setC_DocType_ID(this.m_C_DocType_ID);
        alloc.setDescription(alloc.getDescriptionForManualAllocation(this.m_C_BPartner_ID, trxName));
        alloc.saveEx();
        BigDecimal unmatchedApplied = Env.ZERO;
        int i2 = 0;
        while (i2 < iRows) {
            if (((Boolean)invoice.getValueAt(i2, 0)).booleanValue()) {
                pp = (KeyNamePair)invoice.getValueAt(i2, 2);
                C_Invoice_ID = pp.getKey();
                BigDecimal AppliedAmt = (BigDecimal)invoice.getValueAt(i2, this.i_applied);
                BigDecimal DiscountAmt = (BigDecimal)invoice.getValueAt(i2, this.i_discount);
                BigDecimal WriteOffAmt = (BigDecimal)invoice.getValueAt(i2, this.i_writeOff);
                BigDecimal OverUnderAmt = ((BigDecimal)invoice.getValueAt(i2, this.i_open)).subtract(AppliedAmt).subtract(DiscountAmt).subtract(WriteOffAmt);
                if (log.isLoggable(Level.CONFIG)) {
                    log.config("Invoice #" + i2 + " - AppliedAmt=" + AppliedAmt);
                }
                int j = 0;
                while (j < paymentList.size() && AppliedAmt.signum() != 0) {
                    int C_Payment_ID = (Integer)paymentList.get(j);
                    BigDecimal PaymentAmt = (BigDecimal)amountList.get(j);
                    if (PaymentAmt.signum() == AppliedAmt.signum()) {
                        BigDecimal amount;
                        if (log.isLoggable(Level.CONFIG)) {
                            log.config(".. with payment #" + j + ", Amt=" + PaymentAmt);
                        }
                        if ((amount = AppliedAmt).abs().compareTo(PaymentAmt.abs()) > 0) {
                            amount = PaymentAmt;
                        }
                        MAllocationLine aLine = new MAllocationLine(alloc, amount, DiscountAmt, WriteOffAmt, OverUnderAmt);
                        aLine.setDocInfo(C_BPartner_ID, C_Order_ID, C_Invoice_ID);
                        aLine.setPaymentInfo(C_Payment_ID, C_CashLine_ID);
                        aLine.saveEx();
                        DiscountAmt = Env.ZERO;
                        WriteOffAmt = Env.ZERO;
                        AppliedAmt = AppliedAmt.subtract(amount);
                        PaymentAmt = PaymentAmt.subtract(amount);
                        if (log.isLoggable(Level.FINE)) {
                            log.fine("Allocation Amount=" + amount + " - Remaining  Applied=" + AppliedAmt + ", Payment=" + PaymentAmt);
                        }
                        amountList.set(j, PaymentAmt);
                    }
                    ++j;
                }
                if (AppliedAmt.signum() != 0 || DiscountAmt.signum() != 0 || WriteOffAmt.signum() != 0) {
                    int C_Payment_ID = 0;
                    MAllocationLine aLine = new MAllocationLine(alloc, AppliedAmt, DiscountAmt, WriteOffAmt, OverUnderAmt);
                    aLine.setDocInfo(C_BPartner_ID, C_Order_ID, C_Invoice_ID);
                    aLine.setPaymentInfo(C_Payment_ID, C_CashLine_ID);
                    aLine.saveEx();
                    if (log.isLoggable(Level.FINE)) {
                        log.fine("Allocation Amount=" + AppliedAmt);
                    }
                    unmatchedApplied = unmatchedApplied.add(AppliedAmt);
                }
            }
            ++i2;
        }
        i2 = 0;
        while (i2 < paymentList.size()) {
            BigDecimal payAmt = (BigDecimal)amountList.get(i2);
            if (payAmt.signum() != 0) {
                int C_Payment_ID = (Integer)paymentList.get(i2);
                if (log.isLoggable(Level.FINE)) {
                    log.fine("Payment=" + C_Payment_ID + ", Amount=" + payAmt);
                }
                MAllocationLine aLine = new MAllocationLine(alloc, payAmt, Env.ZERO, Env.ZERO, Env.ZERO);
                aLine.setDocInfo(C_BPartner_ID, 0, 0);
                aLine.setPaymentInfo(C_Payment_ID, 0);
                aLine.saveEx();
                unmatchedApplied = unmatchedApplied.subtract(payAmt);
            }
            ++i2;
        }
        if (this.m_C_Charge_ID > 0 && unmatchedApplied.compareTo(Env.ZERO) != 0) {
            BigDecimal chargeAmt = this.totalDiff;
            MAllocationLine aLine = new MAllocationLine(alloc, chargeAmt.negate(), Env.ZERO, Env.ZERO, Env.ZERO);
            aLine.setC_Charge_ID(this.m_C_Charge_ID);
            aLine.setC_BPartner_ID(this.m_C_BPartner_ID);
            if (!aLine.save(trxName)) {
                StringBuilder msg = new StringBuilder("Allocation Line not saved - Charge=").append(this.m_C_Charge_ID);
                throw new AdempiereException(msg.toString());
            }
            unmatchedApplied = unmatchedApplied.add(chargeAmt);
        }
        if (unmatchedApplied.signum() != 0) {
            throw new AdempiereException("Allocation not balanced -- out by " + unmatchedApplied);
        }
        if (alloc.get_ID() != 0) {
            if (!alloc.processIt("CO")) {
                throw new AdempiereException("Cannot complete allocation: " + alloc.getProcessMsg());
            }
            alloc.saveEx();
        }
        i = 0;
        while (i < iRows) {
            if (((Boolean)invoice.getValueAt(i, 0)).booleanValue()) {
                String sql = "SELECT invoiceOpen(C_Invoice_ID, 0) FROM C_Invoice WHERE C_Invoice_ID=?";
                pp = (KeyNamePair)invoice.getValueAt(i, 2);
                C_Invoice_ID = pp.getKey();
                BigDecimal open = DB.getSQLValueBD((String)trxName, (String)sql, (int)C_Invoice_ID);
                if (open != null && open.signum() == 0) {
                    sql = "UPDATE C_Invoice SET IsPaid='Y' WHERE C_Invoice_ID=" + C_Invoice_ID;
                    int no = DB.executeUpdate((String)sql, (String)trxName);
                    if (log.isLoggable(Level.CONFIG)) {
                        log.config("Invoice #" + i + " is paid - updated=" + no);
                    }
                } else if (log.isLoggable(Level.CONFIG)) {
                    log.config("Invoice #" + i + " is not paid - " + open);
                }
            }
            ++i;
        }
        i = 0;
        while (i < paymentList.size()) {
            int C_Payment_ID = (Integer)paymentList.get(i);
            MPayment pay = new MPayment(Env.getCtx(), C_Payment_ID, trxName);
            if (pay.testAllocation()) {
                pay.saveEx();
            }
            if (log.isLoggable(Level.CONFIG)) {
                log.config("Payment #" + i + (pay.isAllocated() ? " not" : " is") + " fully allocated");
            }
            ++i;
        }
        paymentList.clear();
        amountList.clear();
        return alloc;
    }

    public int getC_BPartner_ID() {
        return this.m_C_BPartner_ID;
    }

    public void setC_BPartner_ID(int C_BPartner_ID) {
        this.m_C_BPartner_ID = C_BPartner_ID;
    }

    public int getC_Currency_ID() {
        return this.m_C_Currency_ID;
    }

    public void setC_Currency_ID(int C_Currency_ID) {
        this.m_C_Currency_ID = C_Currency_ID;
    }

    public int getC_DocType_ID() {
        return this.m_C_DocType_ID;
    }

    public void setC_DocType_ID(int C_DocType_ID) {
        this.m_C_DocType_ID = C_DocType_ID;
    }

    public int getC_Charge_ID() {
        return this.m_C_Charge_ID;
    }

    public void setC_Charge_ID(int C_Charge_ID) {
        this.m_C_Charge_ID = C_Charge_ID;
    }

    public int getAD_Org_ID() {
        return this.m_AD_Org_ID;
    }

    public void setAD_Org_ID(int AD_Org_ID) {
        this.m_AD_Org_ID = AD_Org_ID;
    }

    public int getSelectedInvoiceCount() {
        return this.m_noInvoices;
    }

    public int getSelectedPaymentCount() {
        return this.m_noPayments;
    }

    public BigDecimal getInvoiceAppliedTotal() {
        return this.totalInv;
    }

    public BigDecimal getPaymentAppliedTotal() {
        return this.totalPay;
    }

    public boolean isOkToAllocate() {
        return this.totalDiff.signum() == 0 || this.getC_Charge_ID() > 0;
    }

    public BigDecimal getTotalDifference() {
        return this.totalDiff;
    }

    public void calculateDifference() {
        this.totalDiff = this.totalPay.subtract(this.totalInv);
    }
}

