/*
 * Decompiled with CFR 0.152.
 */
package org.idempiere.zk.billboard.chart;

import java.awt.Color;
import java.awt.Font;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import org.adempiere.apps.graph.GraphColumn;
import org.adempiere.webui.apps.AEnv;
import org.adempiere.webui.apps.graph.model.GoalModel;
import org.adempiere.webui.apps.graph.model.IndicatorModel;
import org.adempiere.webui.component.ZkCssHelper;
import org.compiere.model.MColorSchema;
import org.compiere.model.MGoal;
import org.compiere.model.MQuery;
import org.idempiere.zk.billboard.Billboard;
import org.zkoss.json.JSONObject;
import org.zkoss.zk.ui.event.Event;
import org.zkoss.zk.ui.event.EventListener;
import org.zkoss.zul.CategoryModel;
import org.zkoss.zul.ChartModel;
import org.zkoss.zul.DialModel;
import org.zkoss.zul.DialModelRange;
import org.zkoss.zul.DialModelScale;
import org.zkoss.zul.SimpleCategoryModel;
import org.zkoss.zul.SimplePieModel;

public class PerformanceGraphBuilder {
    public Billboard createIndicatorChart(IndicatorModel model) {
        Billboard billboard = new Billboard();
        billboard.setType("gauge");
        DialModel dialModel = this.createDialModel(model);
        this.buildDialRendererOptions(billboard, dialModel);
        billboard.setModel((ChartModel)dialModel);
        return billboard;
    }

    private void buildDialRendererOptions(Billboard billboard, DialModel dialModel) {
        DialModelScale dialScale = dialModel.getScale(0);
        billboard.addRendererOptions("min", (Object)0);
        billboard.addRendererOptions("max", (Object)dialScale.getScaleUpperBound());
        ArrayList<Double> intervals = new ArrayList<Double>();
        ArrayList<String> intervalColors = new ArrayList<String>();
        int i = 0;
        while (i < dialScale.rangeSize()) {
            DialModelRange dialRange = dialScale.getRange(i);
            double upperBound = dialRange.getUpperBound();
            intervals.add(upperBound);
            intervalColors.add(dialRange.getRangeColor());
            ++i;
        }
        ArrayList<Double> ticks = new ArrayList<Double>(intervals);
        ticks.add(0, 0.0);
        billboard.addRendererOptions("ticks", (Object)ticks.toArray(new Double[0]));
        billboard.addRendererOptions("intervals", (Object)intervals.toArray(new Double[0]));
        billboard.addRendererOptions("intervalColors", (Object)intervalColors.toArray(new String[0]));
        billboard.addRendererOptions("tickColor", (Object)dialScale.getTickColor());
        billboard.addRendererOptions("background", (Object)dialModel.getFrameBgColor());
    }

    private DialModel createDialModel(IndicatorModel model) {
        int[] rangeBounds;
        DialModel dialModel = new DialModel();
        MColorSchema colorSchema = model.goalModel.getColorSchema();
        int upperBound = 0;
        int[] nArray = rangeBounds = new int[]{colorSchema.getMark1Percent(), colorSchema.getMark2Percent(), colorSchema.getMark3Percent(), colorSchema.getMark4Percent()};
        int n = rangeBounds.length;
        int n2 = 0;
        while (n2 < n) {
            int rangeBound = nArray[n2];
            if (rangeBound > upperBound) {
                if (rangeBound == 9999) {
                    upperBound = (int)Math.floor((double)upperBound * 1.5);
                    break;
                }
                upperBound = rangeBound;
            }
            ++n2;
        }
        DialModelScale dialScale = dialModel.newScale(0.0, (double)upperBound, 180.0, -180.0, (double)(colorSchema.getMark2Percent() - colorSchema.getMark1Percent()), 5);
        int rangeLo = 0;
        int[] nArray2 = rangeBounds;
        int n3 = rangeBounds.length;
        int n4 = 0;
        while (n4 < n3) {
            int rangeHi = nArray2[n4];
            if (rangeHi == 9999) {
                rangeHi = (int)Math.floor((double)rangeLo * 1.5);
            }
            if (rangeLo < rangeHi) {
                dialScale.newRange((double)rangeLo, (double)rangeHi, "#" + ZkCssHelper.createHexColorString((Color)colorSchema.getColor(rangeHi)), 0.5, 0.5);
                rangeLo = rangeHi;
            }
            ++n4;
        }
        dialModel.setFrameBgColor("#" + ZkCssHelper.createHexColorString((Color)model.dialBackground));
        dialScale.setTickFont(new Font("SansSerif", 1, 8));
        dialScale.setValueFont(new Font("SansSerif", 1, 8));
        dialModel.setFrameFgColor("#000000");
        dialScale.setTickColor("#" + ZkCssHelper.createHexColorString((Color)model.tickColor));
        dialScale.setValue((double)model.goalModel.getPercent());
        return dialModel;
    }

    public Billboard createPerformanceChart(GoalModel goalModel, int chartWidth, int chartHeight) {
        if ("BC".equals(goalModel.chartType)) {
            return this.createBarChart(goalModel, chartWidth, chartHeight);
        }
        if ("PC".equals(goalModel.chartType)) {
            return this.createPieChart(goalModel, chartWidth, chartHeight);
        }
        if ("AC".equals(goalModel.chartType)) {
            return this.createAreaChart(goalModel, chartWidth, chartHeight);
        }
        if ("LC".equals(goalModel.chartType)) {
            return this.createLineChart(goalModel, chartWidth, chartHeight);
        }
        if ("RC".equals(goalModel.chartType)) {
            return this.createDonutChart(goalModel, chartWidth, chartHeight);
        }
        if ("WC".equals(goalModel.chartType)) {
            return this.createWaterfallChart(goalModel, chartWidth, chartHeight);
        }
        throw new IllegalArgumentException("unknown chart type=" + goalModel.chartType);
    }

    private Billboard createWaterfallChart(GoalModel goalModel, int chartWidth, int chartHeight) {
        Billboard billboard = new Billboard();
        billboard.setType("waterfall");
        CategoryModel chartModel = this.createWaterfallModel(goalModel);
        billboard.setModel((ChartModel)chartModel);
        billboard.setStyle("width: " + chartWidth + "px" + "; height: " + chartHeight + "px");
        billboard.addEventListener("onDataClick", (EventListener)new ZoomListener(goalModel, chartModel.getCategories().toArray(new Comparable[0])));
        if (goalModel.showTitle) {
            billboard.setTitle(goalModel.goal.getMeasure().getName());
        }
        billboard.setTickAxisLabel(goalModel.xAxisLabel);
        billboard.setValueAxisLabel(goalModel.yAxisLabel);
        billboard.setLegend(false, false);
        this.buildRendererOptions(billboard, goalModel);
        return billboard;
    }

    private Billboard createDonutChart(GoalModel goalModel, int chartWidth, int chartHeight) {
        Billboard billboard = new Billboard();
        billboard.setType("donut");
        SimplePieModel chartModel = new SimplePieModel();
        List list = goalModel.columnList;
        int i = 0;
        while (i < list.size()) {
            chartModel.setValue((Comparable)((Object)((GraphColumn)list.get(i)).getLabel()), (Number)((GraphColumn)list.get(i)).getValue());
            ++i;
        }
        billboard.setModel((ChartModel)chartModel);
        billboard.setStyle("width: " + chartWidth + "px" + "; height: " + chartHeight + "px");
        billboard.setLegend(true, true);
        billboard.addEventListener("onDataClick", (EventListener)new ZoomListener(goalModel, chartModel.getCategories().toArray(new Comparable[0])));
        if (goalModel.showTitle) {
            billboard.setTitle(goalModel.goal.getMeasure().getName());
        }
        return billboard;
    }

    private Billboard createLineChart(GoalModel goalModel, int chartWidth, int chartHeight) {
        Billboard billboard = new Billboard();
        billboard.setType("line");
        CategoryModel chartModel = this.createCategoryModel(goalModel, true);
        billboard.setModel((ChartModel)chartModel);
        billboard.setStyle("width: " + chartWidth + "px" + "; height: " + chartHeight + "px");
        billboard.addEventListener("onDataClick", (EventListener)new ZoomListener(goalModel, chartModel.getCategories().toArray(new Comparable[0])));
        if (goalModel.showTitle) {
            billboard.setTitle(goalModel.goal.getMeasure().getName());
        }
        billboard.setTickAxisLabel(goalModel.xAxisLabel);
        billboard.setValueAxisLabel(goalModel.yAxisLabel);
        billboard.setLegend(false, false);
        this.buildRendererOptions(billboard, goalModel);
        return billboard;
    }

    private Billboard createAreaChart(GoalModel goalModel, int chartWidth, int chartHeight) {
        Billboard billboard = new Billboard();
        billboard.setType("area");
        CategoryModel chartModel = this.createCategoryModel(goalModel, true);
        billboard.setModel((ChartModel)chartModel);
        billboard.setStyle("width: " + chartWidth + "px" + "; height: " + chartHeight + "px");
        billboard.addEventListener("onDataClick", (EventListener)new ZoomListener(goalModel, chartModel.getCategories().toArray(new Comparable[0])));
        billboard.setLegend(false, false);
        if (goalModel.showTitle) {
            billboard.setTitle(goalModel.goal.getMeasure().getName());
        }
        billboard.setTickAxisLabel(goalModel.xAxisLabel);
        billboard.setValueAxisLabel(goalModel.yAxisLabel);
        this.buildRendererOptions(billboard, goalModel);
        return billboard;
    }

    private Billboard createPieChart(GoalModel goalModel, int chartWidth, int chartHeight) {
        Billboard billboard = new Billboard();
        billboard.setType("pie");
        SimplePieModel chartModel = new SimplePieModel();
        List list = goalModel.columnList;
        int i = 0;
        while (i < list.size()) {
            chartModel.setValue((Comparable)((Object)((GraphColumn)list.get(i)).getLabel()), (Number)((GraphColumn)list.get(i)).getValue());
            ++i;
        }
        billboard.setModel((ChartModel)chartModel);
        billboard.setStyle("width: " + chartWidth + "px" + "; height: " + chartHeight + "px");
        billboard.addEventListener("onDataClick", (EventListener)new ZoomListener(goalModel, chartModel.getCategories().toArray(new Comparable[0])));
        billboard.setLegend(true, true);
        if (goalModel.showTitle) {
            billboard.setTitle(goalModel.goal.getMeasure().getName());
        }
        return billboard;
    }

    private Billboard createBarChart(GoalModel goalModel, int chartWidth, int chartHeight) {
        Billboard billboard = new Billboard();
        billboard.setRenderdefer(500);
        billboard.setType("bar");
        CategoryModel chartModel = this.createCategoryModel(goalModel, true);
        billboard.setModel((ChartModel)chartModel);
        billboard.setStyle("width: " + chartWidth + "px" + "; height: " + chartHeight + "px");
        billboard.addEventListener("onDataClick", (EventListener)new ZoomListener(goalModel, chartModel.getCategories().toArray(new Comparable[0])));
        if (goalModel.showTitle) {
            billboard.setTitle(goalModel.goal.getMeasure().getName());
        }
        billboard.setTickAxisLabel(goalModel.xAxisLabel);
        billboard.setValueAxisLabel(goalModel.yAxisLabel);
        billboard.setLegend(false, false);
        this.buildRendererOptions(billboard, goalModel);
        return billboard;
    }

    private CategoryModel createCategoryModel(GoalModel goalModel, boolean linear) {
        SimpleCategoryModel chartModel = new SimpleCategoryModel();
        List list = goalModel.columnList;
        int i = 0;
        while (i < list.size()) {
            String series = goalModel.xAxisLabel;
            if (!linear && ((GraphColumn)list.get(i)).getDate() != null) {
                Calendar cal = Calendar.getInstance();
                cal.setTime(((GraphColumn)list.get(i)).getDate());
                series = Integer.toString(cal.get(1));
            }
            chartModel.setValue((Comparable)((Object)series), (Comparable)((Object)((GraphColumn)list.get(i)).getLabel()), (Number)((GraphColumn)list.get(i)).getValue());
            ++i;
        }
        return chartModel;
    }

    private CategoryModel createWaterfallModel(GoalModel goalModel) {
        return this.createCategoryModel(goalModel, true);
    }

    private void buildRendererOptions(Billboard billboard, GoalModel goalModel) {
        int[] rangeBounds;
        ArrayList<Double> intervals = new ArrayList<Double>();
        ArrayList<String> intervalColors = new ArrayList<String>();
        MColorSchema colorSchema = goalModel.goal.getColorSchema();
        int upperBound = 0;
        int[] nArray = rangeBounds = new int[]{colorSchema.getMark1Percent(), colorSchema.getMark2Percent(), colorSchema.getMark3Percent(), colorSchema.getMark4Percent()};
        int n = rangeBounds.length;
        int n2 = 0;
        while (n2 < n) {
            int rangeBound = nArray[n2];
            if (rangeBound > upperBound) {
                if (rangeBound == 9999) {
                    upperBound = (int)Math.floor((double)upperBound * 1.5);
                    break;
                }
                upperBound = rangeBound;
            }
            ++n2;
        }
        int rangeLo = 0;
        int[] nArray2 = rangeBounds;
        int n3 = rangeBounds.length;
        n = 0;
        while (n < n3) {
            int rangeHi = nArray2[n];
            if (rangeHi == 9999) {
                rangeHi = (int)Math.floor((double)rangeLo * 1.5);
            }
            if (rangeLo < rangeHi) {
                intervals.add(Double.valueOf(rangeHi));
                intervalColors.add("#" + ZkCssHelper.createHexColorString((Color)colorSchema.getColor(rangeHi)));
                rangeLo = rangeHi;
            }
            ++n;
        }
        billboard.addRendererOptions("intervals", (Object)intervals.toArray(new Double[0]));
        billboard.addRendererOptions("intervalColors", (Object)intervalColors.toArray(new String[0]));
    }

    private static class ZoomListener
    implements EventListener<Event> {
        private GoalModel goalModel;
        private Comparable<?>[] categories;

        private ZoomListener(GoalModel goalModel, Comparable<?>[] comparables) {
            this.goalModel = goalModel;
            this.categories = comparables;
        }

        public void onEvent(Event event) throws Exception {
            JSONObject json = (JSONObject)event.getData();
            Number pointIndex = (Number)json.get((Object)"pointIndex");
            if (pointIndex == null) {
                pointIndex = 0;
            }
            Comparable<?> categoryLabel = this.categories[pointIndex.intValue()];
            List list = this.goalModel.columnList;
            int i = 0;
            while (i < list.size()) {
                if (((GraphColumn)list.get(i)).getLabel().equals(categoryLabel)) {
                    this.zoom(this.goalModel.goal, (GraphColumn)list.get(i));
                    return;
                }
                ++i;
            }
        }

        private void zoom(MGoal goal, GraphColumn graphColumn) {
            MQuery query = graphColumn.getMQuery(goal);
            if (query != null) {
                AEnv.zoom((MQuery)query);
            }
        }
    }
}

