/*
 * Decompiled with CFR 0.152.
 */
package org.idempiere.zk.billboard.chart;

import java.util.Calendar;
import java.util.Date;
import java.util.Map;
import java.util.Properties;
import org.adempiere.webui.apps.AEnv;
import org.adempiere.webui.apps.graph.IChartRendererService;
import org.adempiere.webui.apps.graph.model.GoalModel;
import org.adempiere.webui.apps.graph.model.IndicatorModel;
import org.adempiere.webui.component.Label;
import org.compiere.model.MQuery;
import org.compiere.model.MSysConfig;
import org.compiere.util.Msg;
import org.idempiere.zk.billboard.Billboard;
import org.idempiere.zk.billboard.chart.ChartBuilder;
import org.idempiere.zk.billboard.chart.PerformanceGraphBuilder;
import org.zkoss.json.JSONObject;
import org.zkoss.zk.au.AuResponse;
import org.zkoss.zk.au.out.AuScript;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.Executions;
import org.zkoss.zk.ui.event.Event;
import org.zkoss.zk.ui.event.EventListener;
import org.zkoss.zk.ui.util.Clients;
import org.zkoss.zul.CategoryModel;
import org.zkoss.zul.ChartModel;
import org.zkoss.zul.Div;
import org.zkoss.zul.PieModel;

@org.osgi.service.component.annotations.Component(name="org.idempiere.zk.billboard.chart.ChartRendererServiceImpl", immediate=true, service={IChartRendererService.class}, property={"service.ranking:Integer=0"})
public class ChartRendererServiceImpl
implements IChartRendererService {
    public boolean renderPerformanceIndicator(Component parent, int chartWidth, int chartHeight, IndicatorModel model) {
        PerformanceGraphBuilder builder = new PerformanceGraphBuilder();
        Billboard billboard = builder.createIndicatorChart(model);
        billboard.setStyle("width: " + chartWidth + "px;height: " + chartHeight + "px;");
        parent.appendChild((Component)billboard);
        return true;
    }

    public boolean renderPerformanceGraph(Component parent, int chartWidth, int chartHeight, GoalModel goalModel) {
        PerformanceGraphBuilder builder = new PerformanceGraphBuilder();
        Billboard billboard = builder.createPerformanceChart(goalModel, chartWidth, chartHeight);
        parent.appendChild((Component)billboard);
        return true;
    }

    public boolean renderChart(Component parent, int width, int height, org.adempiere.webui.apps.graph.model.ChartModel chartModel, boolean showTitle) {
        ChartBuilder builder = new ChartBuilder(chartModel.chart);
        Billboard billboard = builder.createChart();
        billboard.setStyle("width: " + width + "px;" + " height: " + height + "px;");
        if (!showTitle) {
            billboard.setTitle("");
        }
        this.updateUI(parent, chartModel, builder, billboard, width, height);
        return true;
    }

    private void updateUI(Component parent, org.adempiere.webui.apps.graph.model.ChartModel chartModel, ChartBuilder builder, Billboard billboard, int width, int height) {
        Date minDate = builder.getMinDate();
        Date maxDate = builder.getMaxDate();
        if (chartModel.chart.isTimeSeries() && minDate != null && maxDate != null) {
            Date startDate;
            billboard.setTimeSeries(true);
            int noOfPeriod = 0;
            if (width < MSysConfig.getIntValue((String)"CHART_MIN_WIDTH_3_PERIOD", (int)230, (int)chartModel.chart.getAD_Client_ID())) {
                noOfPeriod = 3;
            } else if (width < MSysConfig.getIntValue((String)"CHART_MIN_WIDTH_6_PERIOD", (int)320, (int)chartModel.chart.getAD_Client_ID())) {
                noOfPeriod = 6;
            }
            Calendar c = Calendar.getInstance();
            c.setTime(maxDate);
            String timeUnit = chartModel.chart.getTimeUnit();
            if (chartModel.chart.getTimeScope() == 1) {
                if (timeUnit.equals("W")) {
                    timeUnit = "D";
                } else if (timeUnit.equals("M")) {
                    timeUnit = "W";
                } else if (timeUnit.equals("Q")) {
                    timeUnit = "M";
                } else if (timeUnit.equals("Y")) {
                    timeUnit = "Q";
                }
            }
            if (timeUnit.equals("D")) {
                billboard.setTimeSeriesInterval("1 days");
                billboard.setTimeSeriesFormat("%D");
                if (noOfPeriod != 0) {
                    c.add(5, -1 * (noOfPeriod - 1));
                }
            } else if (timeUnit.equals("W")) {
                billboard.setTimeSeriesInterval("1 weeks");
                billboard.setTimeSeriesFormat("%D");
                if (noOfPeriod != 0) {
                    c.add(3, -1 * (noOfPeriod - 1));
                }
            } else if (timeUnit.equals("M")) {
                billboard.setTimeSeriesInterval("1 months");
                billboard.setTimeSeriesFormat("%Y-%m");
                if (noOfPeriod != 0) {
                    c.add(2, -1 * (noOfPeriod - 1));
                }
            } else if (timeUnit.equals("Q")) {
                billboard.setTimeSeriesInterval("3 months");
                billboard.setTimeSeriesFormat("%Y-%m");
                if (noOfPeriod != 0) {
                    c.add(2, -1 * (noOfPeriod - 1) * 3);
                }
            } else if (timeUnit.equals("Y")) {
                billboard.setTimeSeriesInterval("1 years");
                billboard.setTimeSeriesFormat("%Y");
                if (noOfPeriod != 0) {
                    c.add(1, -1 * (noOfPeriod - 1));
                }
            }
            if (noOfPeriod != 0 && minDate.before(startDate = c.getTime())) {
                minDate = startDate;
            }
        }
        parent.getChildren().clear();
        parent.appendChild((Component)billboard);
        Label label = new Label(Msg.translate((Properties)chartModel.chart.getCtx(), (String)"NoDataAvailable"));
        Div labelDiv = new Div();
        labelDiv.setStyle("padding: 10px;");
        labelDiv.appendChild((Component)label);
        Div div = new Div();
        div.appendChild((Component)labelDiv);
        parent.appendChild((Component)div);
        div.setVisible(false);
        if (Executions.getCurrent() != null) {
            String script = "(function() {let parent = jq('#" + parent.getUuid() + "');";
            script = String.valueOf(script) + "let billboard = parent.children().first(); ";
            script = String.valueOf(script) + "let div = parent.children().eq(1); ";
            script = String.valueOf(script) + "if (billboard.children().length == 0) {";
            script = String.valueOf(script) + "div.show(); ";
            script = String.valueOf(script) + "billboard.hide(); ";
            script = String.valueOf(script) + "parent.height(div.css('height')); }";
            script = String.valueOf(script) + "else {";
            script = String.valueOf(script) + "div.hide(); ";
            script = String.valueOf(script) + "billboard.show(); ";
            script = String.valueOf(script) + "}})();";
            Clients.response((AuResponse)new AuScript(script));
        }
        ZoomListener listener = new ZoomListener(builder.getQueries(), billboard.getModel());
        billboard.addEventListener("onDataClick", (EventListener)listener);
    }

    private static class ZoomListener
    implements EventListener<Event> {
        private Map<String, MQuery> queries;
        private ChartModel model;

        private ZoomListener(Map<String, MQuery> queries, ChartModel model) {
            this.queries = queries;
            this.model = model;
        }

        public void onEvent(Event event) throws Exception {
            JSONObject json = (JSONObject)event.getData();
            Number seriesIndex = (Number)json.get((Object)"seriesIndex");
            Number pointIndex = (Number)json.get((Object)"pointIndex");
            if (pointIndex == null) {
                pointIndex = 0;
            }
            MQuery query = null;
            if (this.model instanceof PieModel) {
                PieModel pieModel = (PieModel)this.model;
                Comparable category = pieModel.getCategory(pointIndex.intValue());
                if (category != null) {
                    query = this.queries.get(category.toString());
                }
            } else if (this.model instanceof CategoryModel) {
                CategoryModel categoryModel = (CategoryModel)this.model;
                Comparable series = categoryModel.getSeries(seriesIndex.intValue());
                Comparable category = categoryModel.getCategory(pointIndex.intValue());
                query = this.queries.get(String.valueOf(series.toString()) + "__" + category.toString());
            }
            if (query != null) {
                AEnv.zoom(query);
            }
        }
    }
}

