/*
 * Decompiled with CFR 0.152.
 */
package org.idempiere.server.cluster.callable;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.RandomAccessFile;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.concurrent.Callable;
import java.util.logging.Level;
import org.compiere.util.CLogFile;
import org.idempiere.server.cluster.callable.LogFileCallable;

public class ReadLogCallable
extends LogFileCallable
implements Callable<byte[]>,
Serializable {
    private static final long serialVersionUID = 33969865104073117L;
    private String fileName;
    private int blockNo;

    public ReadLogCallable(String fileName) {
        this(fileName, 0);
    }

    public ReadLogCallable(String fileName, int blockNo) {
        this.fileName = fileName;
        this.blockNo = blockNo;
    }

    /*
     * Loose catch block
     */
    @Override
    public byte[] call() throws Exception {
        File file;
        CLogFile fileHandler = CLogFile.get((boolean)false, null, (boolean)false);
        if (fileHandler != null && fileHandler.getFileName().equals(this.fileName)) {
            fileHandler.flush();
        }
        if (!this.isAccessible(file = new File(this.fileName))) {
            return null;
        }
        if (file.length() == 0L) {
            return new byte[0];
        }
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try {
                byte[] byArray;
                FileChannel channel;
                RandomAccessFile raf;
                block24: {
                    block23: {
                        raf = new RandomAccessFile(file, "r");
                        channel = raf.getChannel();
                        if (this.blockNo > 0) {
                            channel.position(this.blockNo * 0x500000);
                        }
                        ByteBuffer buffer = ByteBuffer.allocate(1024);
                        ByteArrayOutputStream baos = new ByteArrayOutputStream(2048);
                        int bytesRead = 0;
                        int totalRead = 0;
                        while ((bytesRead = channel.read(buffer)) > 0) {
                            if ((totalRead += bytesRead) > 0x500000) {
                                int diff = totalRead - 0x500000;
                                bytesRead -= diff;
                                totalRead = 0x500000;
                            }
                            baos.write(buffer.array(), 0, bytesRead);
                            buffer.clear();
                            if (totalRead == 0x500000) break;
                        }
                        byArray = baos.toByteArray();
                        if (channel == null) break block23;
                        channel.close();
                    }
                    if (raf == null) break block24;
                    raf.close();
                }
                return byArray;
                {
                    catch (Throwable throwable2) {
                        try {
                            if (channel != null) {
                                channel.close();
                            }
                            throw throwable2;
                        }
                        catch (Throwable throwable3) {
                            if (throwable == null) {
                                throwable = throwable3;
                            } else if (throwable != throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            if (raf != null) {
                                raf.close();
                            }
                            throw throwable;
                        }
                    }
                }
            }
            catch (Throwable throwable4) {
                if (throwable == null) {
                    throwable = throwable4;
                } else if (throwable != throwable4) {
                    throwable.addSuppressed(throwable4);
                }
                throw throwable;
            }
        }
        catch (Exception ex) {
            this.log.log(Level.SEVERE, "stream" + ex);
            return null;
        }
    }
}

