/*
 * Decompiled with CFR 0.152.
 */
package org.idempiere.server.cluster.callable;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.logging.Level;
import org.compiere.Adempiere;
import org.compiere.util.CLogFile;
import org.compiere.util.CLogger;

public abstract class LogFileCallable {
    protected static final int BLOCK_SIZE = 0x500000;
    protected static final String s_dirAccessFileName = "dirAccess.txt";
    protected transient CLogger log = CLogger.getCLogger(this.getClass());

    protected ArrayList<File> getDirAcessList() {
        ArrayList<File> dirAccessList = new ArrayList<File>();
        CLogFile fileHandler = CLogFile.get((boolean)true, null, (boolean)false);
        File logDir = fileHandler.getLogDirectory();
        dirAccessList.add(logDir);
        String dirAccessPathName = String.valueOf(Adempiere.getAdempiereHome()) + File.separator + s_dirAccessFileName;
        File dirAccessFile = new File(dirAccessPathName);
        if (dirAccessFile.exists()) {
            try {
                Throwable throwable = null;
                Object var7_9 = null;
                try (BufferedReader br2 = new BufferedReader(new FileReader(dirAccessFile));){
                    String pathName;
                    while ((pathName = br2.readLine()) != null) {
                        File pathDir = new File(pathName);
                        if (!pathDir.exists() || dirAccessList.contains(pathDir)) continue;
                        dirAccessList.add(pathDir);
                    }
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (Exception e) {
                this.log.log(Level.SEVERE, String.valueOf(dirAccessPathName) + " - " + e.toString());
            }
        }
        return dirAccessList;
    }

    protected boolean isAccessible(File file) throws IOException {
        if (!file.exists() || !file.canRead()) {
            return false;
        }
        boolean found = false;
        ArrayList<File> dirAccessList = this.getDirAcessList();
        for (File dir : dirAccessList) {
            if (!file.getCanonicalPath().startsWith(dir.getAbsolutePath())) continue;
            found = true;
            break;
        }
        if (!found) {
            this.log.warning("Couldn't find file in directories that allowed to access");
            return false;
        }
        return true;
    }
}

