/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.server;

import com.sun.management.OperatingSystemMXBean;
import java.io.Serializable;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import java.lang.management.RuntimeMXBean;
import java.lang.management.ThreadMXBean;
import java.net.InetAddress;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.logging.Level;
import org.compiere.Adempiere;
import org.compiere.db.AdempiereDatabase;
import org.compiere.db.CConnection;
import org.compiere.model.MSession;
import org.compiere.server.LogFileInfo;
import org.compiere.server.TrxInfo;
import org.compiere.util.CLogMgt;
import org.compiere.util.CMemoryUsage;
import org.compiere.util.Ini;
import org.idempiere.distributed.IClusterMember;
import org.idempiere.distributed.IClusterService;
import org.idempiere.server.cluster.ClusterServerMgr;
import org.idempiere.server.cluster.callable.GetSystemInfoCallable;

public class SystemInfo
implements Serializable {
    private static final long serialVersionUID = -4451616690416295597L;
    private String propertyFileName;
    private String idempereHome;
    private String operatingSystem;
    private String javaVM;
    private String databaseDescription;
    private String databaseConnectionURL;
    private String databaseStatus;
    private String memoryUsage;
    private String heapMemoryUsage;
    private String runtimeName;
    private long runtimeUpTime;
    private int threadCount;
    private int peakThreadCount;
    private int daemonThreadCount;
    private long totalStartedThreadCount;
    private TrxInfo[] trxInfos;
    private Level logLevel;
    private String currentLogFile;
    private LogFileInfo[] logFileInfos;
    private long garbageCollectionTime;
    private long garbageCollectionCount;
    private int availableProcessors;
    private double averageSystemLoad;
    private int sessionCount;
    private InetAddress address;

    private SystemInfo() {
    }

    public String getPropertyFileName() {
        return this.propertyFileName;
    }

    public String getIDempiereHome() {
        return this.idempereHome;
    }

    public String getOperatingSystem() {
        return this.operatingSystem;
    }

    public String getJavaVM() {
        return this.javaVM;
    }

    public String getDatabaseDescription() {
        return this.databaseDescription;
    }

    public String getDatabaseConnectionURL() {
        return this.databaseConnectionURL;
    }

    public String getDatabaseStatus() {
        return this.databaseStatus;
    }

    public String getMemoryUsage() {
        return this.memoryUsage;
    }

    public String getHeapMemoryUsage() {
        return this.heapMemoryUsage;
    }

    public String getRuntimeName() {
        return this.runtimeName;
    }

    public long getRuntimeUpTime() {
        return this.runtimeUpTime;
    }

    public int getThreadCount() {
        return this.threadCount;
    }

    public int getPeakThreadCount() {
        return this.peakThreadCount;
    }

    public int getDaemonThreadCount() {
        return this.daemonThreadCount;
    }

    public long getTotalStartedThreadCount() {
        return this.totalStartedThreadCount;
    }

    public TrxInfo[] getTrxInfos() {
        return this.trxInfos;
    }

    public Level getLogLevel() {
        return this.logLevel;
    }

    public String getCurrentLogFile() {
        return this.currentLogFile;
    }

    public LogFileInfo[] getLogFileInfos() {
        return this.logFileInfos;
    }

    public long getGarbageCollectionTime() {
        return this.garbageCollectionTime;
    }

    public static SystemInfo getLocalSystemInfo() {
        String vm;
        SystemInfo si = new SystemInfo();
        si.propertyFileName = Ini.getPropertyFileName();
        si.idempereHome = Adempiere.getAdempiereHome();
        java.lang.management.OperatingSystemMXBean os = ManagementFactory.getOperatingSystemMXBean();
        String osInfo = String.valueOf(os.getName()) + " " + os.getVersion();
        si.operatingSystem = osInfo = String.valueOf(osInfo) + " (" + os.getArch() + ")";
        si.availableProcessors = os.getAvailableProcessors();
        if (os instanceof OperatingSystemMXBean) {
            OperatingSystemMXBean extInfo = (OperatingSystemMXBean)os;
            si.averageSystemLoad = extInfo.getSystemCpuLoad() * 100.0;
        } else {
            si.averageSystemLoad = os.getSystemLoadAverage() / (double)si.availableProcessors * 100.0;
        }
        si.javaVM = vm = String.valueOf(System.getProperty("java.vm.name")) + " " + System.getProperty("java.vm.version");
        CConnection cc = CConnection.get();
        AdempiereDatabase db = cc.getDatabase();
        si.databaseDescription = db.getDescription();
        si.databaseConnectionURL = cc.getConnectionURL();
        si.databaseStatus = cc.getDatabase().getStatus();
        MemoryMXBean memory = ManagementFactory.getMemoryMXBean();
        si.memoryUsage = new CMemoryUsage(memory.getNonHeapMemoryUsage()).toString();
        si.heapMemoryUsage = new CMemoryUsage(memory.getHeapMemoryUsage()).toString();
        RuntimeMXBean rt = ManagementFactory.getRuntimeMXBean();
        si.runtimeName = rt.getName();
        si.runtimeUpTime = rt.getUptime();
        ThreadMXBean th = ManagementFactory.getThreadMXBean();
        si.threadCount = th.getThreadCount();
        si.peakThreadCount = th.getPeakThreadCount();
        si.daemonThreadCount = th.getDaemonThreadCount();
        si.totalStartedThreadCount = th.getTotalStartedThreadCount();
        si.trxInfos = TrxInfo.getOpenTransactions();
        si.logLevel = CLogMgt.getLevel();
        si.currentLogFile = LogFileInfo.getCurrentLogFile();
        si.logFileInfos = LogFileInfo.getLogFileInfos();
        si.garbageCollectionTime = ManagementFactory.getGarbageCollectorMXBeans().stream().mapToLong(mxBean -> mxBean.getCollectionTime()).sum();
        si.garbageCollectionCount = ManagementFactory.getGarbageCollectorMXBeans().stream().mapToLong(mxBean -> mxBean.getCollectionCount()).sum();
        si.sessionCount = MSession.getCachedSessionCount();
        return si;
    }

    public long getGarbageCollectionCount() {
        return this.garbageCollectionCount;
    }

    public int getAvailableProcessors() {
        return this.availableProcessors;
    }

    public double getAverageSystemLoad() {
        return this.averageSystemLoad;
    }

    public int getSessionCount() {
        return this.sessionCount;
    }

    public InetAddress getAddress() {
        return this.address;
    }

    public static SystemInfo getClusterNodeInfo(String nodeId) {
        SystemInfo si = null;
        IClusterMember member = ClusterServerMgr.getClusterMember(nodeId);
        if (member != null) {
            GetSystemInfoCallable callable = new GetSystemInfoCallable();
            Future future = ClusterServerMgr.getClusterService().execute((Callable)callable, member);
            if (future != null) {
                try {
                    si = (SystemInfo)future.get();
                    si.address = member.getAddress();
                }
                catch (InterruptedException | ExecutionException e) {
                    throw new RuntimeException(e);
                }
            }
        }
        return si;
    }

    public static int getClusterSessionCount(IClusterMember member) {
        GetSessionCountCallable callable;
        Future future;
        IClusterService service = ClusterServerMgr.getClusterService();
        if (service != null && (future = service.execute((Callable)(callable = new GetSessionCountCallable()), member)) != null) {
            try {
                return (Integer)future.get();
            }
            catch (InterruptedException | ExecutionException exception) {
                // empty catch block
            }
        }
        return 0;
    }

    private static class GetSessionCountCallable
    implements Callable<Integer>,
    Serializable {
        private static final long serialVersionUID = -7793108679625240698L;

        private GetSessionCountCallable() {
        }

        @Override
        public Integer call() throws Exception {
            return MSession.getCachedSessionCount();
        }
    }
}

