/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.server;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import org.adempiere.base.Core;
import org.adempiere.base.Service;
import org.adempiere.server.AdempiereServerActivator;
import org.adempiere.server.IServerFactory;
import org.adempiere.util.ServerContext;
import org.compiere.Adempiere;
import org.compiere.model.AdempiereProcessor;
import org.compiere.model.MScheduler;
import org.compiere.model.MSession;
import org.compiere.server.AdempiereServer;
import org.compiere.server.AdempiereServerGroup;
import org.compiere.server.IServerManager;
import org.compiere.server.ServerCount;
import org.compiere.server.ServerInstance;
import org.compiere.util.CLogger;
import org.compiere.util.Env;
import org.idempiere.distributed.ICacheService;
import org.idempiere.distributed.IClusterMember;
import org.idempiere.distributed.IClusterService;
import org.idempiere.server.cluster.ClusterServerMgr;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.BundleListener;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;

public class AdempiereServerMgr
implements ServiceTrackerCustomizer<IServerFactory<AdempiereServer, AdempiereProcessor>, IServerFactory<AdempiereServer, AdempiereProcessor>>,
BundleListener,
IServerManager {
    private static ServiceTracker<IServerFactory<AdempiereServer, AdempiereProcessor>, IServerFactory<AdempiereServer, AdempiereProcessor>> serviceTracker;
    private static AdempiereServerMgr m_serverMgr;
    protected static final CLogger log;
    private ArrayList<LocalServerController> m_servers = new ArrayList();
    private Properties m_ctx = Env.getCtx();
    private Timestamp m_start = new Timestamp(System.currentTimeMillis());
    private Set<String> processorClass;

    static {
        m_serverMgr = null;
        log = CLogger.getCLogger(AdempiereServerMgr.class);
    }

    public static synchronized AdempiereServerMgr get() {
        return AdempiereServerMgr.get(true);
    }

    public static synchronized AdempiereServerMgr get(boolean createNew) {
        if (m_serverMgr == null && createNew) {
            m_serverMgr = new AdempiereServerMgr();
            serviceTracker = new ServiceTracker(AdempiereServerActivator.getBundleContext(), IServerFactory.class.getName(), (ServiceTrackerCustomizer)m_serverMgr);
            serviceTracker.open();
            AdempiereServerActivator.getBundleContext().addBundleListener((BundleListener)m_serverMgr);
        }
        return m_serverMgr;
    }

    private AdempiereServerMgr() {
        this.startEnvironment();
        this.m_servers = new ArrayList();
        this.processorClass = new HashSet<String>();
    }

    private boolean startEnvironment() {
        Adempiere.startup((boolean)false);
        log.info("");
        MSession session = MSession.get((Properties)this.getCtx());
        session = session == null ? MSession.create((Properties)this.getCtx()) : new MSession(this.getCtx(), session.getAD_Session_ID(), null);
        session.setWebStoreSession(false);
        session.setWebSession("Server");
        session.saveEx();
        return true;
    }

    @Override
    public synchronized String reload() {
        block12: {
            Map<String, String> map;
            log.info("");
            if (this.stopAll() != null) {
                return "Failed to stop all servers";
            }
            String clusterId = this.getClusterMemberId();
            if (clusterId != null && (map = this.getServerOwnerMap()) != null) {
                ICacheService cacheService = Core.getCacheService();
                try {
                    String reloadLockKey = "cluster.server.owner.map.reload";
                    if (!cacheService.tryLock(map, (Object)reloadLockKey, 30L, TimeUnit.SECONDS)) break block12;
                    try {
                        ArrayList<String> toRemove = new ArrayList<String>();
                        for (Map.Entry<String, String> entry : map.entrySet()) {
                            if (!entry.getValue().equals(clusterId)) continue;
                            toRemove.add(entry.getKey());
                        }
                        for (String key : toRemove) {
                            map.remove(key);
                        }
                    }
                    finally {
                        cacheService.unLock(map, (Object)reloadLockKey);
                    }
                }
                catch (Exception e) {
                    return "Failed to lock cluster server owner map";
                }
            }
        }
        int noServers = 0;
        this.m_servers = new ArrayList();
        this.processorClass = new HashSet<String>();
        List serverFactoryList = Service.locator().list(IServerFactory.class).getServices();
        if (serverFactoryList != null && !serverFactoryList.isEmpty()) {
            for (IServerFactory factory : serverFactoryList) {
                this.createServers(factory);
            }
        }
        if (log.isLoggable(Level.FINE)) {
            log.fine("#" + noServers);
        }
        return this.startAll() == null ? null : "Failed to restart all servers";
    }

    private void createServers(IServerFactory<AdempiereServer, AdempiereProcessor> factory) {
        String name = factory.getProcessorClass().getName();
        if (!this.processorClass.contains(name)) {
            this.processorClass.add(name);
            AdempiereServer[] servers = factory.create(this.m_ctx);
            if (servers != null && servers.length > 0) {
                AdempiereServer[] adempiereServerArray = servers;
                int n = servers.length;
                int n2 = 0;
                while (n2 < n) {
                    block11: {
                        AdempiereServer server = adempiereServerArray[n2];
                        AdempiereProcessor model = server.getModel();
                        if (this.canRunHere(server, model)) {
                            block12: {
                                Map<String, String> map;
                                String clusterId = this.getClusterMemberId();
                                if (clusterId != null && (map = this.getServerOwnerMap()) != null) {
                                    ICacheService cacheService = Core.getCacheService();
                                    try {
                                        if (!cacheService.tryLock(map, (Object)server.getServerID(), 30L, TimeUnit.SECONDS)) break block11;
                                        try {
                                            String memberId = map.get(server.getServerID());
                                            if (memberId != null && !memberId.equals(clusterId)) break block11;
                                            if (memberId != null) break block12;
                                            map.put(server.getServerID(), clusterId);
                                        }
                                        finally {
                                            cacheService.unLock(map, (Object)server.getServerID());
                                        }
                                    }
                                    catch (Exception e) {
                                        break block11;
                                    }
                                }
                            }
                            this.m_servers.add(new LocalServerController(server));
                        }
                    }
                    ++n2;
                }
            }
        }
    }

    private boolean canRunHere(AdempiereServer server, AdempiereProcessor model) {
        return AdempiereServer.isOKtoRunOnIP(model);
    }

    @Override
    public String addScheduler(MScheduler scheduler) {
        String serverId = scheduler.getServerID();
        if (this.getServerInstance(serverId) != null) {
            return null;
        }
        List serverFactoryList = Service.locator().list(IServerFactory.class).getServices();
        if (serverFactoryList != null && !serverFactoryList.isEmpty()) {
            for (IServerFactory factory : serverFactoryList) {
                Object server;
                block10: {
                    Map<String, String> map;
                    if (!factory.getProcessorClass().getName().equals(scheduler.getClass().getName()) || (server = factory.create(this.m_ctx, scheduler)) == null || !this.canRunHere((AdempiereServer)server, (AdempiereProcessor)scheduler) || this.getServerInstance(scheduler.getServerID()) != null) continue;
                    String clusterId = this.getClusterMemberId();
                    if (clusterId != null && (map = this.getServerOwnerMap()) != null) {
                        ICacheService cacheService = Core.getCacheService();
                        try {
                            if (!cacheService.tryLock(map, (Object)((AdempiereServer)server).getServerID(), 30L, TimeUnit.SECONDS)) continue;
                            try {
                                String memberId = map.get(((AdempiereServer)server).getServerID());
                                if (memberId != null && !memberId.equals(clusterId)) continue;
                                if (memberId != null) break block10;
                                map.put(((AdempiereServer)server).getServerID(), clusterId);
                            }
                            finally {
                                cacheService.unLock(map, (Object)((AdempiereServer)server).getServerID());
                            }
                        }
                        catch (Exception e) {
                            continue;
                        }
                    }
                }
                this.m_servers.add(new LocalServerController((AdempiereServer)server, false));
                return this.start(serverId);
            }
        }
        return null;
    }

    @Override
    public synchronized String removeScheduler(MScheduler scheduler) {
        String error;
        String serverId = scheduler.getServerID();
        LocalServerController serverController = this.getLocalServerController(serverId);
        if (serverController == null) {
            return null;
        }
        if (serverController.isAlive() && (error = this.stop(serverId)) != null) {
            return error;
        }
        int i = 0;
        while (i < this.m_servers.size()) {
            serverController = this.m_servers.get(i);
            if (serverId.equals(serverController.server.getServerID())) {
                String ownerId;
                Map<String, String> map;
                this.m_servers.remove(i);
                String clusterId = this.getClusterMemberId();
                if (clusterId != null && (map = this.getServerOwnerMap()) != null && (ownerId = map.get(serverId)) != null && ownerId.equals(clusterId)) {
                    map.remove(serverId);
                }
                return null;
            }
            ++i;
        }
        return null;
    }

    public Properties getCtx() {
        return this.m_ctx;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public synchronized String startAll() {
        AdempiereServerMgr.log.info("");
        servers = this.getInActive();
        currentContext = ServerContext.getCurrentInstance();
        i = 0;
        while (i < servers.length) {
            block18: {
                block16: {
                    server = servers[i];
                    temp = null;
                    if (server.scheduleFuture == null || server.scheduleFuture.isDone()) break block16;
                    if (temp == null) ** GOTO lbl35
                    ServerContext.setCurrentInstance((Properties)currentContext);
                    break block18;
                }
                try {
                    try {
                        if (Env.getAD_Client_ID((Properties)currentContext) != server.getServer().getModel().getAD_Client_ID()) {
                            temp = new Properties(currentContext);
                            Env.setContext((Properties)temp, (String)"#AD_Client_ID", (int)server.getServer().getModel().getAD_Client_ID());
                            ServerContext.setCurrentInstance((Properties)temp);
                        }
                        server.getServer().recalculateSleepMS();
                        server.start();
                    }
                    catch (Exception e) {
                        AdempiereServerMgr.log.log(Level.SEVERE, "Server: " + server, (Throwable)e);
                        if (temp == null) ** GOTO lbl35
                        ServerContext.setCurrentInstance((Properties)currentContext);
                    }
                }
                catch (Throwable var7_10) {
                    if (temp != null) {
                        ServerContext.setCurrentInstance((Properties)currentContext);
                    }
                    throw var7_10;
                }
                if (temp != null) {
                    ServerContext.setCurrentInstance((Properties)currentContext);
                }
            }
            ++i;
        }
        noRunning = 0;
        noStopped = 0;
        i = 0;
        while (i < servers.length) {
            server = servers[i];
            try {
                if (server.scheduleFuture != null && !server.scheduleFuture.isDone()) {
                    if (AdempiereServerMgr.log.isLoggable(Level.INFO)) {
                        AdempiereServerMgr.log.info("Alive: " + server);
                    }
                    ++noRunning;
                } else {
                    AdempiereServerMgr.log.warning("Dead: " + server);
                    ++noStopped;
                }
            }
            catch (Exception e) {
                AdempiereServerMgr.log.log(Level.SEVERE, "(checking) - " + server, (Throwable)e);
                ++noStopped;
            }
            ++i;
        }
        if (AdempiereServerMgr.log.isLoggable(Level.FINE)) {
            AdempiereServerMgr.log.fine("Running=" + noRunning + ", Stopped=" + noStopped);
        }
        return noStopped == 0 ? null : "Failed to start all servers";
    }

    @Override
    public synchronized String start(String serverID) {
        LocalServerController server = this.getLocalServerController(serverID);
        if (server == null) {
            return "Server not found";
        }
        if (server.scheduleFuture != null && !server.scheduleFuture.isDone()) {
            return "Server is already running";
        }
        Properties currentContext = ServerContext.getCurrentInstance();
        Properties temp = null;
        try {
            try {
                if (Env.getAD_Client_ID((Properties)currentContext) != server.getServer().getModel().getAD_Client_ID()) {
                    temp = new Properties(currentContext);
                    Env.setContext((Properties)temp, (String)"#AD_Client_ID", (int)server.getServer().getModel().getAD_Client_ID());
                    ServerContext.setCurrentInstance((Properties)temp);
                }
                server.getServer().recalculateSleepMS();
                server.start();
            }
            catch (Exception e) {
                log.log(Level.SEVERE, "Server=" + serverID, (Throwable)e);
                String string = e.getMessage();
                if (temp != null) {
                    ServerContext.setCurrentInstance((Properties)currentContext);
                }
                return string;
            }
        }
        finally {
            if (temp != null) {
                ServerContext.setCurrentInstance((Properties)currentContext);
            }
        }
        if (log.isLoggable(Level.INFO)) {
            log.info(server.toString());
        }
        return server.scheduleFuture != null && !server.scheduleFuture.isDone() ? null : "Failed to start server";
    }

    @Override
    public synchronized String stopAll() {
        LocalServerController server;
        log.info("");
        LocalServerController[] servers = this.getActive();
        int i = 0;
        while (i < servers.length) {
            server = servers[i];
            try {
                if (server.scheduleFuture != null && !server.scheduleFuture.isDone()) {
                    server.scheduleFuture.cancel(true);
                }
            }
            catch (Exception e) {
                log.log(Level.SEVERE, "(interrupting) - " + server, (Throwable)e);
            }
            ++i;
        }
        Thread.yield();
        i = 0;
        while (i < servers.length) {
            server = servers[i];
            try {
                int maxWait = 10;
                while (server.scheduleFuture != null && !server.scheduleFuture.isDone()) {
                    if (maxWait-- == 0) {
                        log.severe("Wait timeout for interruped " + server);
                        break;
                    }
                    Thread.sleep(100L);
                }
            }
            catch (Exception e) {
                log.log(Level.SEVERE, "(waiting) - " + server, (Throwable)e);
            }
            ++i;
        }
        int noRunning = 0;
        int noStopped = 0;
        int i2 = 0;
        while (i2 < servers.length) {
            LocalServerController server2 = servers[i2];
            try {
                if (server2.scheduleFuture != null && !server2.scheduleFuture.isDone()) {
                    log.warning("Alive: " + server2);
                    ++noRunning;
                } else {
                    if (log.isLoggable(Level.INFO)) {
                        log.info("Stopped: " + server2);
                    }
                    ++noStopped;
                }
            }
            catch (Exception e) {
                log.log(Level.SEVERE, "(checking) - " + server2, (Throwable)e);
                ++noRunning;
            }
            ++i2;
        }
        if (log.isLoggable(Level.FINE)) {
            log.fine("Running=" + noRunning + ", Stopped=" + noStopped);
        }
        AdempiereServerGroup.get().dump();
        return noRunning == 0 ? null : "Failed to stop all servers";
    }

    @Override
    public synchronized String stop(String serverID) {
        LocalServerController server = this.getLocalServerController(serverID);
        if (server == null) {
            return "Server not found";
        }
        if (server.scheduleFuture == null || server.scheduleFuture.isDone()) {
            return "Server is already stop";
        }
        try {
            server.scheduleFuture.cancel(true);
            Thread.sleep(10L);
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "stop", (Throwable)e);
            return e.getMessage();
        }
        if (log.isLoggable(Level.INFO)) {
            log.info(server.toString());
        }
        return server.scheduleFuture == null || server.scheduleFuture.isDone() ? null : "Failed to stop server";
    }

    public synchronized void destroy() {
        log.info("");
        this.stopAll();
        this.m_servers.clear();
    }

    protected synchronized LocalServerController[] getActive() {
        ArrayList<LocalServerController> list = new ArrayList<LocalServerController>();
        int i = 0;
        while (i < this.m_servers.size()) {
            LocalServerController server = this.m_servers.get(i);
            if (server != null && server.scheduleFuture != null && !server.scheduleFuture.isDone()) {
                list.add(server);
            }
            ++i;
        }
        LocalServerController[] retValue = new LocalServerController[list.size()];
        list.toArray(retValue);
        return retValue;
    }

    protected synchronized LocalServerController[] getInActive() {
        ArrayList<LocalServerController> list = new ArrayList<LocalServerController>();
        int i = 0;
        while (i < this.m_servers.size()) {
            LocalServerController server = this.m_servers.get(i);
            if (server != null && (server.scheduleFuture == null || server.scheduleFuture.isDone())) {
                list.add(server);
            }
            ++i;
        }
        LocalServerController[] retValue = new LocalServerController[list.size()];
        list.toArray(retValue);
        return retValue;
    }

    private synchronized LocalServerController[] getLocalServerControllers() {
        LocalServerController[] retValue = new LocalServerController[this.m_servers.size()];
        this.m_servers.toArray(retValue);
        return retValue;
    }

    @Override
    public synchronized ServerInstance[] getServerInstances() {
        LocalServerController[] controllers;
        ArrayList<ServerInstance> responses = new ArrayList<ServerInstance>();
        LocalServerController[] localServerControllerArray = controllers = this.getLocalServerControllers();
        int n = controllers.length;
        int n2 = 0;
        while (n2 < n) {
            LocalServerController controller = localServerControllerArray[n2];
            if (controller.getServer() != null) {
                ServerInstance response = new ServerInstance(controller.getServer().getServerID(), controller.getServer().getModel(), controller.isAlive(), controller.isInterrupted(), controller.getServer().isSleeping(), controller.getServer().getStartTime(), controller.getServer().getStatistics(), controller.getServer().getServerInfo());
                responses.add(response);
            }
            ++n2;
        }
        return responses.toArray(new ServerInstance[0]);
    }

    public synchronized int getStatus(AdempiereProcessor processor) {
        return this.getServerStatus(processor.getServerID());
    }

    @Override
    public synchronized ServerInstance getServerInstance(String serverID) {
        if (serverID == null) {
            return null;
        }
        int i = 0;
        while (i < this.m_servers.size()) {
            LocalServerController server = this.m_servers.get(i);
            if (serverID.equals(server.server.getServerID())) {
                return new ServerInstance(server.getServer().getServerID(), server.getServer().getModel(), server.isAlive(), server.isInterrupted(), server.getServer().isSleeping(), server.getServer().getStartTime(), server.getServer().getStatistics(), server.getServer().getServerInfo());
            }
            ++i;
        }
        return null;
    }

    private synchronized LocalServerController getLocalServerController(String serverID) {
        if (serverID == null) {
            return null;
        }
        int i = 0;
        while (i < this.m_servers.size()) {
            LocalServerController server = this.m_servers.get(i);
            if (serverID.equals(server.server.getServerID())) {
                return server;
            }
            ++i;
        }
        return null;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("AdempiereServerMgr[");
        sb.append("Servers=").append(this.m_servers.size()).append(",ContextSize=").append(this.m_ctx.size()).append(",Started=").append(this.m_start).append("]");
        return sb.toString();
    }

    @Override
    public String getDescription() {
        return Adempiere.getVersion();
    }

    @Override
    public synchronized ServerCount getServerCount() {
        ServerCount serverCount = new ServerCount();
        int i = 0;
        while (i < this.m_servers.size()) {
            LocalServerController server = this.m_servers.get(i);
            if (server.scheduleFuture != null && !server.scheduleFuture.isDone()) {
                serverCount.addStarted(1);
            } else {
                serverCount.addStopped(1);
            }
            ++i;
        }
        return serverCount;
    }

    @Override
    public Timestamp getStartTime() {
        return this.m_start;
    }

    public synchronized IServerFactory<AdempiereServer, AdempiereProcessor> addingService(ServiceReference<IServerFactory<AdempiereServer, AdempiereProcessor>> reference) {
        IServerFactory factory = (IServerFactory)AdempiereServerActivator.getBundleContext().getService(reference);
        this.createServers(factory);
        this.startAll();
        return factory;
    }

    public void modifiedService(ServiceReference<IServerFactory<AdempiereServer, AdempiereProcessor>> reference, IServerFactory<AdempiereServer, AdempiereProcessor> service) {
    }

    public void removedService(ServiceReference<IServerFactory<AdempiereServer, AdempiereProcessor>> reference, IServerFactory<AdempiereServer, AdempiereProcessor> service) {
    }

    public void bundleChanged(BundleEvent event) {
        if (event.getType() == 4) {
            if (serviceTracker != null) {
                serviceTracker.close();
            }
        } else if (event.getType() == 2 && serviceTracker != null) {
            serviceTracker.open();
        }
    }

    public Boolean remove(String serverID) {
        LocalServerController server = this.getLocalServerController(serverID);
        if (server == null) {
            return false;
        }
        if (server.scheduleFuture != null && !server.scheduleFuture.isDone() && this.stop(serverID) != null) {
            return false;
        }
        int i = 0;
        while (i < this.m_servers.size()) {
            server = this.m_servers.get(i);
            if (serverID.equals(server.server.getServerID())) {
                this.m_servers.remove(i);
                return true;
            }
            ++i;
        }
        return false;
    }

    @Override
    public String runNow(String serverId) {
        LocalServerController serverInstance = this.getLocalServerController(serverId);
        if (serverInstance == null || serverInstance.getServer() == null) {
            return "Server " + serverId + " not found";
        }
        if (serverInstance.getServer().isSleeping()) {
            serverInstance.getServer().runNow();
        } else {
            int count = 0;
            while (!serverInstance.getServer().isSleeping() && count < 5) {
                ++count;
                try {
                    Thread.sleep(60000L);
                }
                catch (InterruptedException e) {
                    Thread.interrupted();
                }
            }
            if (serverInstance.getServer().isSleeping()) {
                serverInstance.getServer().runNow();
            } else {
                return "Timeout waiting for server process to be available for execution.";
            }
        }
        return null;
    }

    private String getClusterMemberId() {
        IClusterMember local;
        IClusterService service = ClusterServerMgr.getClusterService();
        if (service != null && (local = service.getLocalMember()) != null) {
            return local.getId();
        }
        return null;
    }

    private Map<String, String> getServerOwnerMap() {
        ICacheService service = Core.getCacheService();
        if (service != null) {
            return service.getMap("cluster.server.owner.map");
        }
        return null;
    }

    private class LocalServerController
    implements Runnable {
        protected AdempiereServer server;
        protected volatile ScheduledFuture<?> scheduleFuture;

        private LocalServerController(AdempiereServer server) {
            this(server, true);
        }

        private LocalServerController(AdempiereServer server, boolean start) {
            this.server = server;
            if (start) {
                this.start();
            }
        }

        public void start() {
            this.scheduleFuture = Adempiere.getThreadPoolExecutor().schedule(this, this.server.getInitialNap() * 1000L + this.server.getSleepMS(), TimeUnit.MILLISECONDS);
        }

        @Override
        public void run() {
            if (this.server.isSleeping()) {
                this.server.run();
                if (!this.isInterrupted() && this.server.getSleepMS() != 0L) {
                    this.scheduleFuture = Adempiere.getThreadPoolExecutor().schedule(this, this.server.getSleepMS(), TimeUnit.MILLISECONDS);
                }
            } else {
                this.scheduleFuture = Adempiere.getThreadPoolExecutor().schedule(this, 60000L, TimeUnit.MILLISECONDS);
            }
        }

        public AdempiereServer getServer() {
            return this.server;
        }

        public boolean isAlive() {
            return this.scheduleFuture != null && !this.scheduleFuture.isDone();
        }

        public boolean isInterrupted() {
            return this.scheduleFuture != null && this.scheduleFuture.isCancelled();
        }
    }
}

