/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.server;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.Statement;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Properties;
import java.util.logging.Level;
import org.compiere.acct.DocManager;
import org.compiere.model.AdempiereProcessor;
import org.compiere.model.MAcctProcessor;
import org.compiere.model.MAcctProcessorLog;
import org.compiere.model.MAcctSchema;
import org.compiere.model.MClient;
import org.compiere.model.MCost;
import org.compiere.model.MOrgInfo;
import org.compiere.model.MRole;
import org.compiere.model.MTable;
import org.compiere.model.MUser;
import org.compiere.server.AdempiereServer;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.TimeUtil;

public class AcctProcessor
extends AdempiereServer {
    protected MAcctProcessor m_model = null;
    protected StringBuffer m_summary = new StringBuffer();
    protected MClient m_client = null;
    protected MAcctSchema[] m_ass = null;

    public AcctProcessor(MAcctProcessor model) {
        super((AdempiereProcessor)model, 30);
        this.m_model = model;
        this.m_client = MClient.get((Properties)model.getCtx(), (int)model.getAD_Client_ID());
    }

    @Override
    protected void doWork() {
        MOrgInfo schedorg;
        this.m_summary = new StringBuffer();
        Env.setContext((Properties)this.getCtx(), (String)"#AD_Client_ID", (int)this.m_client.getAD_Client_ID());
        Env.setContext((Properties)this.getCtx(), (String)"#AD_Language", (String)this.m_client.getAD_Language());
        Env.setContext((Properties)this.getCtx(), (String)"#AD_Org_ID", (int)this.m_model.getAD_Org_ID());
        if (this.m_model.getAD_Org_ID() != 0 && (schedorg = MOrgInfo.get((Properties)this.getCtx(), (int)this.m_model.getAD_Org_ID(), null)).getM_Warehouse_ID() > 0) {
            Env.setContext((Properties)this.getCtx(), (String)"#M_Warehouse_ID", (int)schedorg.getM_Warehouse_ID());
        }
        Env.setContext((Properties)this.getCtx(), (String)"#AD_User_ID", (int)this.getAD_User_ID());
        Env.setContext((Properties)this.getCtx(), (String)"#SalesRep_ID", (int)this.getAD_User_ID());
        MUser scheduser = MUser.get((Properties)this.getCtx(), (int)this.getAD_User_ID());
        MRole[] schedroles = scheduser.getRoles(this.m_model.getAD_Org_ID());
        if (schedroles != null && schedroles.length > 0) {
            Env.setContext((Properties)this.getCtx(), (String)"#AD_Role_ID", (int)schedroles[0].getAD_Role_ID());
        }
        Timestamp ts = new Timestamp(System.currentTimeMillis());
        SimpleDateFormat dateFormat4Timestamp = new SimpleDateFormat("yyyy-MM-dd");
        Env.setContext((Properties)this.getCtx(), (String)"#Date", (String)(String.valueOf(dateFormat4Timestamp.format(ts)) + " 00:00:00"));
        this.m_ass = this.m_model.getC_AcctSchema_ID() == 0 ? MAcctSchema.getClientAcctSchema((Properties)this.getCtx(), (int)this.m_model.getAD_Client_ID()) : new MAcctSchema[]{new MAcctSchema(this.getCtx(), this.m_model.getC_AcctSchema_ID(), null)};
        this.postSession();
        MCost.create((MClient)this.m_client);
        int no = this.m_model.deleteLog();
        this.m_summary.append("Logs deleted=").append(no);
        MAcctProcessorLog pLog = new MAcctProcessorLog(this.m_model, this.m_summary.toString());
        pLog.setReference("#" + String.valueOf(this.p_runCount) + " - " + TimeUtil.formatElapsed((Timestamp)new Timestamp(this.p_startWork)));
        pLog.saveEx();
    }

    private int getAD_User_ID() {
        int AD_User_ID = this.m_model.getSupervisor_ID() > 0 ? this.m_model.getSupervisor_ID() : (this.m_model.getCreatedBy() > 0 ? this.m_model.getCreatedBy() : (this.m_model.getUpdatedBy() > 0 ? this.m_model.getUpdatedBy() : 100));
        return AD_User_ID;
    }

    private void postSession() {
        ArrayList<BigDecimal> listProcessedOn = new ArrayList<BigDecimal>();
        listProcessedOn.add(Env.ZERO);
        Timestamp ts = DB.getSQLValueTS(null, (String)"SELECT CURRENT_TIMESTAMP FROM DUAL", (Object[])new Object[0]);
        long ms = ts.getTime() - 2000L;
        ts = new Timestamp(ms);
        long mili = ts.getTime();
        BigDecimal value = new BigDecimal(Long.toString(mili));
        int[] documentsTableID = DocManager.getDocumentsTableID();
        String[] documentsTableName = DocManager.getDocumentsTableName();
        int i = 0;
        while (i < documentsTableID.length) {
            block29: {
                int AD_Table_ID = documentsTableID[i];
                String TableName = documentsTableName[i];
                if (this.m_model.getAD_Table_ID() == 0 || this.m_model.getAD_Table_ID() == AD_Table_ID) {
                    StringBuilder sql = new StringBuilder("SELECT DISTINCT ProcessedOn FROM ").append(TableName).append(" WHERE AD_Client_ID=? AND ProcessedOn<?").append(" AND Processed='Y' AND Posted IN ('N','d') AND IsActive='Y'");
                    CPreparedStatement pstmt = null;
                    ResultSet rs = null;
                    try {
                        try {
                            pstmt = DB.prepareStatement((String)sql.toString(), null);
                            pstmt.setInt(1, this.m_model.getAD_Client_ID());
                            pstmt.setBigDecimal(2, value);
                            rs = pstmt.executeQuery();
                            while (!Thread.currentThread().isInterrupted() && rs.next()) {
                                BigDecimal processedOn = rs.getBigDecimal(1);
                                if (listProcessedOn.contains(processedOn)) continue;
                                listProcessedOn.add(processedOn);
                            }
                        }
                        catch (Exception e) {
                            this.log.log(Level.SEVERE, sql.toString(), (Throwable)e);
                            DB.close(rs, (Statement)pstmt);
                            break block29;
                        }
                    }
                    catch (Throwable throwable) {
                        DB.close(rs, pstmt);
                        throw throwable;
                    }
                    DB.close((ResultSet)rs, (Statement)pstmt);
                }
            }
            ++i;
        }
        int[] count = new int[documentsTableID.length];
        int[] countError = new int[documentsTableID.length];
        int i2 = 0;
        while (i2 < count.length) {
            count[i2] = 0;
            countError[i2] = 0;
            ++i2;
        }
        Collections.sort(listProcessedOn);
        for (BigDecimal processedOn : listProcessedOn) {
            int i3 = 0;
            while (i3 < documentsTableID.length) {
                block31: {
                    int AD_Table_ID = documentsTableID[i3];
                    String TableName = documentsTableName[i3];
                    if (this.m_model.getAD_Table_ID() == 0 || this.m_model.getAD_Table_ID() == AD_Table_ID) {
                        StringBuilder sql = new StringBuilder("SELECT * FROM ").append(TableName).append(" WHERE AD_Client_ID=? AND (ProcessedOn");
                        if (processedOn.compareTo(Env.ZERO) != 0) {
                            sql.append("=?");
                        } else {
                            sql.append(" IS NULL OR ProcessedOn=0");
                        }
                        sql.append(") AND Processed='Y' AND Posted IN ('N','d') AND IsActive='Y'").append(" ORDER BY Created");
                        CPreparedStatement pstmt = null;
                        ResultSet rs = null;
                        try {
                            try {
                                pstmt = DB.prepareStatement((String)sql.toString(), null);
                                pstmt.setInt(1, this.m_model.getAD_Client_ID());
                                if (processedOn.compareTo(Env.ZERO) != 0) {
                                    pstmt.setBigDecimal(2, processedOn);
                                }
                                rs = pstmt.executeQuery();
                                while (!this.isInterrupted() && rs.next()) {
                                    boolean ok = true;
                                    try {
                                        String error = DocManager.postDocument((MAcctSchema[])this.m_ass, (int)AD_Table_ID, (ResultSet)rs, (boolean)false, (boolean)false, null);
                                        ok = error == null;
                                    }
                                    catch (Exception e) {
                                        this.log.log(Level.SEVERE, TableName, (Throwable)e);
                                        ok = false;
                                    }
                                    if (!ok) {
                                        int n = i3;
                                        countError[n] = countError[n] + 1;
                                        continue;
                                    }
                                    MTable table = MTable.get((Properties)Env.getCtx(), (int)AD_Table_ID);
                                    int Record_ID = rs.getInt(table.getKeyColumns()[0]);
                                    sql = new StringBuilder("SELECT COUNT(*) FROM ").append(table.getTableName());
                                    sql.append(" WHERE Posted='Y' AND ").append(table.getTableName()).append("_ID=").append(Record_ID);
                                    int no = DB.getSQLValue(null, (String)sql.toString());
                                    if (no <= 0) continue;
                                    int n = i3;
                                    count[n] = count[n] + 1;
                                }
                            }
                            catch (Exception e) {
                                this.log.log(Level.SEVERE, sql.toString(), (Throwable)e);
                                DB.close(rs, (Statement)pstmt);
                                rs = null;
                                pstmt = null;
                                break block31;
                            }
                        }
                        catch (Throwable throwable) {
                            DB.close(rs, pstmt);
                            rs = null;
                            pstmt = null;
                            throw throwable;
                        }
                        DB.close((ResultSet)rs, (Statement)pstmt);
                        rs = null;
                        pstmt = null;
                    }
                }
                ++i3;
            }
        }
        i = 0;
        while (i < documentsTableID.length) {
            String TableName = documentsTableName[i];
            if (count[i] > 0) {
                this.m_summary.append(TableName).append("=").append(count[i]);
                if (countError[i] > 0) {
                    this.m_summary.append("(Errors=").append(countError[i]).append(")");
                }
                this.m_summary.append(" - ");
                if (this.log.isLoggable(Level.FINER)) {
                    this.log.finer(String.valueOf(this.getName()) + ": " + this.m_summary.toString());
                }
            } else if (this.log.isLoggable(Level.FINER)) {
                this.log.finer(String.valueOf(this.getName()) + ": " + TableName + " - no work");
            }
            ++i;
        }
    }

    @Override
    public String getServerInfo() {
        return "#" + this.p_runCount + " - Last=" + this.m_summary.toString();
    }
}

