/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zsoup.parser;

import java.util.Iterator;
import java.util.List;
import org.zkoss.zsoup.helper.Validate;
import org.zkoss.zsoup.nodes.Comment;
import org.zkoss.zsoup.nodes.Document;
import org.zkoss.zsoup.nodes.DocumentType;
import org.zkoss.zsoup.nodes.Element;
import org.zkoss.zsoup.nodes.Node;
import org.zkoss.zsoup.nodes.TextNode;
import org.zkoss.zsoup.nodes.XmlDeclaration;
import org.zkoss.zsoup.parser.ParseErrorList;
import org.zkoss.zsoup.parser.Tag;
import org.zkoss.zsoup.parser.Token;
import org.zkoss.zsoup.parser.TreeBuilder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XmlTreeBuilder
extends TreeBuilder {
    @Override
    protected void initialiseParse(String input, String baseUri, ParseErrorList errors) {
        super.initialiseParse(input, baseUri, errors);
        this.stack.add(this.doc);
        this.doc.outputSettings().syntax(Document.OutputSettings.Syntax.xml);
    }

    @Override
    protected boolean process(Token token) {
        switch (token.type) {
            case StartTag: {
                this.insert(token.asStartTag());
                break;
            }
            case EndTag: {
                this.popStackToClose(token.asEndTag());
                break;
            }
            case Comment: {
                this.insert(token.asComment());
                break;
            }
            case Character: {
                this.insert(token.asCharacter());
                break;
            }
            case Doctype: {
                this.insert(token.asDoctype());
                break;
            }
            case EOF: {
                break;
            }
            default: {
                Validate.fail("Unexpected token type: " + (Object)((Object)token.type));
            }
        }
        return true;
    }

    private void insertNode(Node node) {
        this.currentElement().appendChild(node);
    }

    Element insert(Token.StartTag startTag) {
        Tag tag = Tag.valueOf(startTag.name());
        Element el = new Element(tag, this.baseUri, startTag.attributes);
        this.insertNode(el);
        if (startTag.isSelfClosing()) {
            this.tokeniser.acknowledgeSelfClosingFlag();
            if (!tag.isKnownTag()) {
                tag.setSelfClosing();
            }
        } else {
            this.stack.add(el);
        }
        return el;
    }

    void insert(Token.Comment commentToken) {
        String data;
        Comment comment;
        Node insert = comment = new Comment(commentToken.getData(), this.baseUri);
        if (commentToken.bogus && (data = comment.getData()).length() > 1 && (data.startsWith("!") || data.startsWith("?"))) {
            String declaration = data.substring(1);
            insert = new XmlDeclaration(declaration, comment.baseUri(), data.startsWith("!"));
        }
        this.insertNode(insert);
    }

    void insert(Token.Character characterToken) {
        TextNode node = new TextNode(characterToken.getData(), this.baseUri);
        this.insertNode(node);
    }

    void insert(Token.Doctype d) {
        DocumentType doctypeNode = new DocumentType(d.getName(), d.getPublicIdentifier(), d.getSystemIdentifier(), this.baseUri);
        this.insertNode(doctypeNode);
    }

    private void popStackToClose(Token.EndTag endTag) {
        Element next;
        String elName = endTag.name();
        Element firstFound = null;
        Iterator it = this.stack.descendingIterator();
        while (it.hasNext()) {
            next = (Element)it.next();
            if (!next.nodeName().equals(elName)) continue;
            firstFound = next;
            break;
        }
        if (firstFound == null) {
            return;
        }
        it = this.stack.descendingIterator();
        while (it.hasNext()) {
            next = (Element)it.next();
            if (next == firstFound) {
                it.remove();
                break;
            }
            it.remove();
        }
    }

    List<Node> parseFragment(String inputFragment, String baseUri, ParseErrorList errors) {
        this.initialiseParse(inputFragment, baseUri, errors);
        this.runParser();
        return this.doc.childNodes();
    }
}

