/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.export.oasis;

import net.sf.jasperreports.engine.JRPrintElement;
import net.sf.jasperreports.engine.JRPrintText;
import net.sf.jasperreports.engine.JRTextAlignment;
import net.sf.jasperreports.engine.export.JRExporterGridCell;
import net.sf.jasperreports.engine.export.oasis.BorderStyle;
import net.sf.jasperreports.engine.export.oasis.ParagraphStyle;
import net.sf.jasperreports.engine.export.oasis.WriterHelper;
import net.sf.jasperreports.engine.type.HorizontalTextAlignEnum;
import net.sf.jasperreports.engine.type.ModeEnum;
import net.sf.jasperreports.engine.type.RotationEnum;
import net.sf.jasperreports.engine.type.VerticalTextAlignEnum;
import net.sf.jasperreports.engine.util.JRColorUtil;

public class CellStyle
extends BorderStyle {
    private String backcolor;
    private final String horizontalAlignment;
    private final String verticalAlignment;
    private final boolean shrinkToFit;
    private final boolean wrapText;

    public CellStyle(WriterHelper styleWriter, JRExporterGridCell gridCell, boolean shrinkToFit, boolean wrapText) {
        super(styleWriter);
        JRTextAlignment alignment;
        JRPrintElement element = gridCell.getElement();
        if (element != null && element.getModeValue() == ModeEnum.OPAQUE) {
            this.backcolor = JRColorUtil.getColorHexa(element.getBackcolor());
        } else if (gridCell.getBackcolor() != null) {
            this.backcolor = JRColorUtil.getColorHexa(gridCell.getBackcolor());
        }
        RotationEnum rotation = element instanceof JRPrintText ? ((JRPrintText)element).getRotationValue() : RotationEnum.NONE;
        VerticalTextAlignEnum vAlign = VerticalTextAlignEnum.TOP;
        HorizontalTextAlignEnum hAlign = HorizontalTextAlignEnum.LEFT;
        JRTextAlignment jRTextAlignment = alignment = element instanceof JRTextAlignment ? (JRTextAlignment)((Object)element) : null;
        if (alignment != null) {
            vAlign = alignment.getVerticalTextAlign();
            hAlign = alignment.getHorizontalTextAlign();
        }
        this.horizontalAlignment = ParagraphStyle.getHorizontalAlignment(hAlign, vAlign, rotation);
        this.verticalAlignment = ParagraphStyle.getVerticalAlignment(hAlign, vAlign, rotation);
        this.shrinkToFit = shrinkToFit;
        this.wrapText = wrapText;
        this.setBox(gridCell.getBox());
    }

    @Override
    public String getId() {
        return this.backcolor + super.getId() + "|" + this.horizontalAlignment + "|" + this.verticalAlignment + "|" + this.shrinkToFit + "|" + this.wrapText;
    }

    @Override
    public void write(String cellStyleName) {
        this.styleWriter.write("<style:style style:name=\"");
        this.styleWriter.write(cellStyleName);
        this.styleWriter.write("\"");
        this.styleWriter.write(" style:family=\"table-cell\">\n");
        this.styleWriter.write(" <style:table-cell-properties");
        this.styleWriter.write(" style:shrink-to-fit=\"" + this.shrinkToFit + "\"");
        this.styleWriter.write(" fo:wrap-option=\"" + (!this.wrapText || this.shrinkToFit ? "no-" : "") + "wrap\"");
        if (this.backcolor != null) {
            this.styleWriter.write(" fo:background-color=\"#");
            this.styleWriter.write(this.backcolor);
            this.styleWriter.write("\"");
        }
        this.writeBorder(0);
        this.writeBorder(1);
        this.writeBorder(2);
        this.writeBorder(3);
        if (this.verticalAlignment != null) {
            this.styleWriter.write(" style:vertical-align=\"");
            this.styleWriter.write(this.verticalAlignment);
            this.styleWriter.write("\"");
        }
        this.styleWriter.write("/>\n");
        if (this.horizontalAlignment != null) {
            this.styleWriter.write(" <style:paragraph-properties");
            this.styleWriter.write(" fo:text-align=\"");
            this.styleWriter.write(this.horizontalAlignment);
            this.styleWriter.write("\"");
            this.styleWriter.write("/>\n");
        }
        this.styleWriter.write("</style:style>\n");
    }
}

