/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.design;

import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.util.Map;
import net.sf.jasperreports.compilers.DirectExpressionValueFilter;
import net.sf.jasperreports.compilers.JavaDirectExpressionValueFilter;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRPropertiesUtil;
import net.sf.jasperreports.engine.JasperReportsContext;
import net.sf.jasperreports.engine.design.JRAbstractCompiler;
import net.sf.jasperreports.engine.fill.JREvaluator;
import net.sf.jasperreports.engine.util.JRClassLoader;
import org.apache.commons.collections4.map.AbstractReferenceMap;
import org.apache.commons.collections4.map.ReferenceMap;

public abstract class JRAbstractJavaCompiler
extends JRAbstractCompiler {
    public static final String PROPERTY_EVALUATOR_CLASS_REFERENCE_FIX_ENABLED = "net.sf.jasperreports.evaluator.class.reference.fix.enabled";
    public static final String EXCEPTION_MESSAGE_KEY_EXPECTED_JAVA_LANGUAGE = "compilers.language.expected.java";
    public static final String EXCEPTION_MESSAGE_KEY_EXPRESSION_CLASS_NOT_LOADED = "compilers.expression.class.not.loaded";
    private static ThreadLocal<Class<?>> classFromBytesRef = new ThreadLocal();
    private static final Object CLASS_CACHE_NULL_KEY = new Object();
    private static Map<Object, Map<String, Class<?>>> classCache = new ReferenceMap(AbstractReferenceMap.ReferenceStrength.WEAK, AbstractReferenceMap.ReferenceStrength.SOFT);

    protected JRAbstractJavaCompiler(JasperReportsContext jasperReportsContext, boolean needsSourceFiles) {
        super(jasperReportsContext, needsSourceFiles);
    }

    @Override
    protected DirectExpressionValueFilter directValueFilter() {
        return JavaDirectExpressionValueFilter.instance();
    }

    @Override
    protected JREvaluator loadEvaluator(Serializable compileData, String className) throws JRException {
        JREvaluator evaluator = null;
        try {
            Class<?> clazz = JRAbstractJavaCompiler.getClassFromCache(className);
            if (clazz == null) {
                clazz = this.loadClass(className, (byte[])compileData);
                JRAbstractJavaCompiler.putClassInCache(className, clazz);
            }
            if (JRPropertiesUtil.getInstance(this.jasperReportsContext).getBooleanProperty(PROPERTY_EVALUATOR_CLASS_REFERENCE_FIX_ENABLED)) {
                classFromBytesRef.set(clazz);
            }
            evaluator = (JREvaluator)clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new JRException(EXCEPTION_MESSAGE_KEY_EXPRESSION_CLASS_NOT_LOADED, new Object[]{className}, e);
        }
        return evaluator;
    }

    protected Class<?> loadClass(String className, byte[] compileData) {
        return JRClassLoader.loadClassFromBytes(this.reportClassFilter, className, compileData);
    }

    protected static Object classCacheKey() {
        ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
        return contextClassLoader == null ? CLASS_CACHE_NULL_KEY : contextClassLoader;
    }

    protected static synchronized Class<?> getClassFromCache(String className) {
        Object key = JRAbstractJavaCompiler.classCacheKey();
        Map<String, Class<?>> contextMap = classCache.get(key);
        Class<?> cachedClass = null;
        if (contextMap != null) {
            cachedClass = contextMap.get(className);
        }
        return cachedClass;
    }

    protected static synchronized void putClassInCache(String className, Class<?> loadedClass) {
        Object key = JRAbstractJavaCompiler.classCacheKey();
        ReferenceMap contextMap = classCache.get(key);
        if (contextMap == null) {
            contextMap = new ReferenceMap(AbstractReferenceMap.ReferenceStrength.HARD, AbstractReferenceMap.ReferenceStrength.SOFT);
            classCache.put(key, (Map<String, Class<?>>)contextMap);
        }
        contextMap.put((String)className, loadedClass);
    }
}

