/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.base;

import java.io.IOException;
import java.io.ObjectInputStream;
import net.sf.jasperreports.engine.JRCloneable;
import net.sf.jasperreports.engine.JRExpression;
import net.sf.jasperreports.engine.JRExpressionCollector;
import net.sf.jasperreports.engine.JRGroup;
import net.sf.jasperreports.engine.JRHyperlinkHelper;
import net.sf.jasperreports.engine.JRHyperlinkParameter;
import net.sf.jasperreports.engine.JRImage;
import net.sf.jasperreports.engine.JRLineBox;
import net.sf.jasperreports.engine.JRPen;
import net.sf.jasperreports.engine.JRVisitor;
import net.sf.jasperreports.engine.base.JRBaseGraphicElement;
import net.sf.jasperreports.engine.base.JRBaseHyperlink;
import net.sf.jasperreports.engine.base.JRBaseObjectFactory;
import net.sf.jasperreports.engine.type.EvaluationTimeEnum;
import net.sf.jasperreports.engine.type.HorizontalAlignEnum;
import net.sf.jasperreports.engine.type.HorizontalImageAlignEnum;
import net.sf.jasperreports.engine.type.HyperlinkTargetEnum;
import net.sf.jasperreports.engine.type.HyperlinkTypeEnum;
import net.sf.jasperreports.engine.type.ModeEnum;
import net.sf.jasperreports.engine.type.OnErrorTypeEnum;
import net.sf.jasperreports.engine.type.RotationEnum;
import net.sf.jasperreports.engine.type.ScaleImageEnum;
import net.sf.jasperreports.engine.type.VerticalAlignEnum;
import net.sf.jasperreports.engine.type.VerticalImageAlignEnum;
import net.sf.jasperreports.engine.util.JRCloneUtils;

public class JRBaseImage
extends JRBaseGraphicElement
implements JRImage {
    private static final long serialVersionUID = 10200L;
    public static final String PROPERTY_LAZY = "isLazy";
    public static final String PROPERTY_ON_ERROR_TYPE = "onErrorType";
    public static final String PROPERTY_USING_CACHE = "isUsingCache";
    protected ScaleImageEnum scaleImageValue;
    protected RotationEnum rotation;
    protected HorizontalImageAlignEnum horizontalImageAlign;
    protected VerticalImageAlignEnum verticalImageAlign;
    protected Boolean isUsingCache;
    protected boolean isLazy;
    protected OnErrorTypeEnum onErrorTypeValue = OnErrorTypeEnum.ERROR;
    protected EvaluationTimeEnum evaluationTimeValue = EvaluationTimeEnum.NOW;
    protected String linkType;
    protected String linkTarget;
    private JRHyperlinkParameter[] hyperlinkParameters;
    protected JRLineBox lineBox;
    protected JRGroup evaluationGroup;
    protected JRExpression expression;
    protected JRExpression anchorNameExpression;
    protected JRExpression bookmarkLevelExpression;
    protected JRExpression hyperlinkReferenceExpression;
    protected JRExpression hyperlinkWhenExpression;
    protected JRExpression hyperlinkAnchorExpression;
    protected JRExpression hyperlinkPageExpression;
    private JRExpression hyperlinkTooltipExpression;
    protected int bookmarkLevel = 0;
    private int PSEUDO_SERIAL_VERSION_UID = 61100;
    private Byte horizontalAlignment;
    private Byte verticalAlignment;
    private HorizontalAlignEnum horizontalAlignmentValue;
    private VerticalAlignEnum verticalAlignmentValue;
    private byte hyperlinkType;
    private byte hyperlinkTarget;
    private Byte scaleImage;
    private byte onErrorType;
    private byte evaluationTime;

    protected JRBaseImage(JRImage image, JRBaseObjectFactory factory) {
        super(image, factory);
        this.scaleImageValue = image.getOwnScaleImageValue();
        this.rotation = image.getOwnRotation();
        this.horizontalImageAlign = image.getOwnHorizontalImageAlign();
        this.verticalImageAlign = image.getOwnVerticalImageAlign();
        this.isUsingCache = image.getUsingCache();
        this.isLazy = image.isLazy();
        this.onErrorTypeValue = image.getOnErrorTypeValue();
        this.evaluationTimeValue = image.getEvaluationTimeValue();
        this.linkType = image.getLinkType();
        this.linkTarget = image.getLinkTarget();
        this.hyperlinkParameters = JRBaseHyperlink.copyHyperlinkParameters(image, factory);
        this.lineBox = image.getLineBox().clone(this);
        this.evaluationGroup = factory.getGroup(image.getEvaluationGroup());
        this.expression = factory.getExpression(image.getExpression());
        this.anchorNameExpression = factory.getExpression(image.getAnchorNameExpression());
        this.bookmarkLevelExpression = factory.getExpression(image.getBookmarkLevelExpression());
        this.hyperlinkReferenceExpression = factory.getExpression(image.getHyperlinkReferenceExpression());
        this.hyperlinkWhenExpression = factory.getExpression(image.getHyperlinkWhenExpression());
        this.hyperlinkAnchorExpression = factory.getExpression(image.getHyperlinkAnchorExpression());
        this.hyperlinkPageExpression = factory.getExpression(image.getHyperlinkPageExpression());
        this.hyperlinkTooltipExpression = factory.getExpression(image.getHyperlinkTooltipExpression());
        this.bookmarkLevel = image.getBookmarkLevel();
    }

    @Override
    public ModeEnum getModeValue() {
        return this.getStyleResolver().getMode(this, ModeEnum.TRANSPARENT);
    }

    @Override
    public ScaleImageEnum getScaleImageValue() {
        return this.getStyleResolver().getScaleImageValue(this);
    }

    @Override
    public ScaleImageEnum getOwnScaleImageValue() {
        return this.scaleImageValue;
    }

    @Override
    public void setScaleImage(ScaleImageEnum scaleImageValue) {
        ScaleImageEnum old = this.scaleImageValue;
        this.scaleImageValue = scaleImageValue;
        this.getEventSupport().firePropertyChange("scaleImage", old, this.scaleImageValue);
    }

    @Override
    public RotationEnum getRotation() {
        return this.getStyleResolver().getRotation(this);
    }

    @Override
    public RotationEnum getOwnRotation() {
        return this.rotation;
    }

    @Override
    public void setRotation(RotationEnum rotation) {
        RotationEnum old = this.rotation;
        this.rotation = rotation;
        this.getEventSupport().firePropertyChange("rotation", old, this.rotation);
    }

    @Override
    public HorizontalImageAlignEnum getHorizontalImageAlign() {
        return this.getStyleResolver().getHorizontalImageAlign(this);
    }

    @Override
    public HorizontalImageAlignEnum getOwnHorizontalImageAlign() {
        return this.horizontalImageAlign;
    }

    @Override
    public void setHorizontalImageAlign(HorizontalImageAlignEnum horizontalImageAlign) {
        HorizontalImageAlignEnum old = this.horizontalImageAlign;
        this.horizontalImageAlign = horizontalImageAlign;
        this.getEventSupport().firePropertyChange("horizontalImageAlignment", old, this.horizontalImageAlign);
    }

    @Override
    public VerticalImageAlignEnum getVerticalImageAlign() {
        return this.getStyleResolver().getVerticalImageAlign(this);
    }

    @Override
    public VerticalImageAlignEnum getOwnVerticalImageAlign() {
        return this.verticalImageAlign;
    }

    @Override
    public void setVerticalImageAlign(VerticalImageAlignEnum verticalImageAlign) {
        VerticalImageAlignEnum old = this.verticalImageAlign;
        this.verticalImageAlign = verticalImageAlign;
        this.getEventSupport().firePropertyChange("verticalImageAlignment", old, this.verticalImageAlign);
    }

    @Override
    public Boolean getUsingCache() {
        return this.isUsingCache;
    }

    @Override
    public void setUsingCache(boolean isUsingCache) {
        this.setUsingCache((Boolean)isUsingCache);
    }

    @Override
    public void setUsingCache(Boolean isUsingCache) {
        Boolean old = this.isUsingCache;
        this.isUsingCache = isUsingCache;
        this.getEventSupport().firePropertyChange(PROPERTY_USING_CACHE, old, this.isUsingCache);
    }

    @Override
    public boolean isLazy() {
        return this.isLazy;
    }

    @Override
    public void setLazy(boolean isLazy) {
        boolean old = this.isLazy;
        this.isLazy = isLazy;
        this.getEventSupport().firePropertyChange(PROPERTY_LAZY, old, this.isLazy);
    }

    @Override
    public OnErrorTypeEnum getOnErrorTypeValue() {
        return this.onErrorTypeValue;
    }

    @Override
    public void setOnErrorType(OnErrorTypeEnum onErrorTypeValue) {
        OnErrorTypeEnum old = this.onErrorTypeValue;
        this.onErrorTypeValue = onErrorTypeValue;
        this.getEventSupport().firePropertyChange(PROPERTY_ON_ERROR_TYPE, old, this.onErrorTypeValue);
    }

    @Override
    public EvaluationTimeEnum getEvaluationTimeValue() {
        return this.evaluationTimeValue;
    }

    @Override
    public JRLineBox getLineBox() {
        return this.lineBox;
    }

    public byte getHyperlinkType() {
        return this.getHyperlinkTypeValue().getValue();
    }

    @Override
    public HyperlinkTypeEnum getHyperlinkTypeValue() {
        return JRHyperlinkHelper.getHyperlinkTypeValue(this);
    }

    @Override
    public byte getHyperlinkTarget() {
        return JRHyperlinkHelper.getHyperlinkTarget(this);
    }

    @Override
    public JRGroup getEvaluationGroup() {
        return this.evaluationGroup;
    }

    @Override
    public JRExpression getExpression() {
        return this.expression;
    }

    @Override
    public JRExpression getAnchorNameExpression() {
        return this.anchorNameExpression;
    }

    @Override
    public JRExpression getBookmarkLevelExpression() {
        return this.bookmarkLevelExpression;
    }

    @Override
    public JRExpression getHyperlinkReferenceExpression() {
        return this.hyperlinkReferenceExpression;
    }

    @Override
    public JRExpression getHyperlinkWhenExpression() {
        return this.hyperlinkWhenExpression;
    }

    @Override
    public JRExpression getHyperlinkAnchorExpression() {
        return this.hyperlinkAnchorExpression;
    }

    @Override
    public JRExpression getHyperlinkPageExpression() {
        return this.hyperlinkPageExpression;
    }

    @Override
    public void collectExpressions(JRExpressionCollector collector) {
        collector.collect(this);
    }

    @Override
    public void visit(JRVisitor visitor) {
        visitor.visitImage(this);
    }

    @Override
    public int getBookmarkLevel() {
        return this.bookmarkLevel;
    }

    @Override
    public Float getDefaultLineWidth() {
        return JRPen.LINE_WIDTH_0;
    }

    @Override
    public String getLinkType() {
        return this.linkType;
    }

    @Override
    public String getLinkTarget() {
        return this.linkTarget;
    }

    @Override
    public JRHyperlinkParameter[] getHyperlinkParameters() {
        return this.hyperlinkParameters;
    }

    @Override
    public JRExpression getHyperlinkTooltipExpression() {
        return this.hyperlinkTooltipExpression;
    }

    @Override
    public Object clone() {
        JRBaseImage clone = (JRBaseImage)super.clone();
        clone.lineBox = this.lineBox.clone(clone);
        clone.hyperlinkParameters = (JRHyperlinkParameter[])JRCloneUtils.cloneArray((JRCloneable[])this.hyperlinkParameters);
        clone.expression = JRCloneUtils.nullSafeClone(this.expression);
        clone.anchorNameExpression = JRCloneUtils.nullSafeClone(this.anchorNameExpression);
        clone.bookmarkLevelExpression = JRCloneUtils.nullSafeClone(this.bookmarkLevelExpression);
        clone.hyperlinkReferenceExpression = JRCloneUtils.nullSafeClone(this.hyperlinkReferenceExpression);
        clone.hyperlinkWhenExpression = JRCloneUtils.nullSafeClone(this.hyperlinkWhenExpression);
        clone.hyperlinkAnchorExpression = JRCloneUtils.nullSafeClone(this.hyperlinkAnchorExpression);
        clone.hyperlinkPageExpression = JRCloneUtils.nullSafeClone(this.hyperlinkPageExpression);
        clone.hyperlinkTooltipExpression = JRCloneUtils.nullSafeClone(this.hyperlinkTooltipExpression);
        return clone;
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        if (this.PSEUDO_SERIAL_VERSION_UID < 30702) {
            this.horizontalAlignmentValue = HorizontalAlignEnum.getByValue(this.horizontalAlignment);
            this.verticalAlignmentValue = VerticalAlignEnum.getByValue(this.verticalAlignment);
            this.scaleImageValue = ScaleImageEnum.getByValue(this.scaleImage);
            this.onErrorTypeValue = OnErrorTypeEnum.getByValue(this.onErrorType);
            this.evaluationTimeValue = EvaluationTimeEnum.getByValue(this.evaluationTime);
            this.horizontalAlignment = null;
            this.verticalAlignment = null;
            this.scaleImage = null;
        }
        if (this.linkType == null) {
            this.linkType = JRHyperlinkHelper.getLinkType(HyperlinkTypeEnum.getByValue(this.hyperlinkType));
        }
        if (this.linkTarget == null) {
            this.linkTarget = JRHyperlinkHelper.getLinkTarget(HyperlinkTargetEnum.getByValue(this.hyperlinkTarget));
        }
        if (this.PSEUDO_SERIAL_VERSION_UID < 60002) {
            this.horizontalImageAlign = HorizontalAlignEnum.getHorizontalImageAlignEnum(this.horizontalAlignmentValue);
            this.verticalImageAlign = VerticalAlignEnum.getVerticalImageAlignEnum(this.verticalAlignmentValue);
            this.horizontalAlignmentValue = null;
            this.verticalAlignmentValue = null;
        }
    }
}

