/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.components.map;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import net.sf.jasperreports.components.map.Marker;
import net.sf.jasperreports.components.map.MarkerProperty;
import net.sf.jasperreports.engine.design.events.JRChangeEventsSupport;
import net.sf.jasperreports.engine.design.events.JRPropertyChangeSupport;
import net.sf.jasperreports.engine.util.JRCloneUtils;

public class StandardMarker
implements Marker,
JRChangeEventsSupport,
Serializable {
    private static final long serialVersionUID = 10200L;
    public static final String PROPERTY_MARKER_PROPERTIES = "markerProperties";
    private transient JRPropertyChangeSupport eventSupport;
    private List<MarkerProperty> properties = new ArrayList<MarkerProperty>();

    public StandardMarker() {
    }

    public StandardMarker(List<MarkerProperty> properties) {
        this.properties = properties;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public JRPropertyChangeSupport getEventSupport() {
        StandardMarker standardMarker = this;
        synchronized (standardMarker) {
            if (this.eventSupport == null) {
                this.eventSupport = new JRPropertyChangeSupport(this);
            }
        }
        return this.eventSupport;
    }

    @Override
    public Object clone() {
        try {
            StandardMarker clone = (StandardMarker)super.clone();
            clone.properties = JRCloneUtils.cloneList(this.properties);
            return clone;
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public List<MarkerProperty> getProperties() {
        return this.properties;
    }

    public void addMarkerProperty(MarkerProperty property) {
        this.properties.add(property);
        this.getEventSupport().fireCollectionElementAddedEvent(PROPERTY_MARKER_PROPERTIES, property, this.properties.size() - 1);
    }

    public void removeMarkerProperty(MarkerProperty property) {
        int idx = this.properties.indexOf(property);
        if (idx >= 0) {
            this.properties.remove(idx);
            this.getEventSupport().fireCollectionElementRemovedEvent(PROPERTY_MARKER_PROPERTIES, property, idx);
        }
    }
}

