/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.utils;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.security.DigestInputStream;
import java.security.MessageDigest;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.codec.binary.Hex;

public class DigestOfFile {
    private MessageDigest digestAgent;

    public DigestOfFile(String algorithm) throws Exception {
        this.digestAgent = MessageDigest.getInstance(algorithm);
    }

    /*
     * Loose catch block
     */
    public synchronized byte[] digestAsByteArray(File file) throws Exception {
        this.digestAgent.reset();
        Throwable throwable = null;
        Object var3_4 = null;
        try {
            byte[] byArray;
            DigestInputStream dis;
            BufferedInputStream is;
            block17: {
                block16: {
                    byte[] digest;
                    is = new BufferedInputStream(new FileInputStream(file));
                    dis = new DigestInputStream(is, this.digestAgent);
                    while (dis.read() != -1) {
                    }
                    byArray = digest = this.digestAgent.digest();
                    if (dis == null) break block16;
                    dis.close();
                }
                if (is == null) break block17;
                ((InputStream)is).close();
            }
            return byArray;
            {
                catch (Throwable throwable2) {
                    try {
                        if (dis != null) {
                            dis.close();
                        }
                        throw throwable2;
                    }
                    catch (Throwable throwable3) {
                        if (throwable == null) {
                            throwable = throwable3;
                        } else if (throwable != throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        if (is != null) {
                            ((InputStream)is).close();
                        }
                        throw throwable;
                    }
                }
            }
        }
        catch (Throwable throwable4) {
            if (throwable == null) {
                throwable = throwable4;
            } else if (throwable != throwable4) {
                throwable.addSuppressed(throwable4);
            }
            throw throwable;
        }
    }

    public synchronized byte[] digestAsByteArray(byte[] input) throws Exception {
        this.digestAgent.reset();
        byte[] digest = this.digestAgent.digest(input);
        return digest;
    }

    public synchronized String digestAsBase64(File file) throws Exception {
        byte[] digest = this.digestAsByteArray(file);
        Base64 encoder = new Base64();
        String digestAsBase64 = new String(encoder.encode(digest), "ASCII");
        return digestAsBase64;
    }

    public synchronized String digestAsBase64(byte[] input) throws Exception {
        byte[] digest = this.digestAsByteArray(input);
        Base64 encoder = new Base64();
        String digestAsBase64 = new String(encoder.encode(digest), "ASCII");
        return digestAsBase64;
    }

    public synchronized String digestAsHex(File file) throws Exception {
        byte[] digest = this.digestAsByteArray(file);
        return Hex.encodeHexString((byte[])digest);
    }

    public synchronized String digestAsHex(byte[] input) throws Exception {
        byte[] digest = this.digestAsByteArray(input);
        return Hex.encodeHexString((byte[])digest);
    }

    public static void main(String[] args) {
        try {
            DigestOfFile md5DigestAgent = new DigestOfFile("MD5");
            int argIndex = 0;
            while (argIndex < args.length) {
                String base64Digest = md5DigestAgent.digestAsBase64(new File(args[argIndex]));
                System.out.println("Base64 MD5 of " + args[argIndex] + " = [" + base64Digest + "]");
                ++argIndex;
            }
        }
        catch (Exception e) {
            e.printStackTrace(System.out);
        }
    }

    public static boolean md5HashCompare(File file1, File file2) {
        try {
            DigestOfFile md5DigestAgent = new DigestOfFile("MD5");
            String hashFile1 = md5DigestAgent.digestAsHex(file1);
            String hashFile2 = md5DigestAgent.digestAsHex(file2);
            return hashFile1.equals(hashFile2);
        }
        catch (Exception e) {
            return false;
        }
    }

    public static String getMD5Hash(File file) {
        try {
            DigestOfFile md5DigestAgent = new DigestOfFile("MD5");
            String hash = md5DigestAgent.digestAsHex(file);
            return hash;
        }
        catch (Exception e) {
            return null;
        }
    }

    public static String getMD5Hash(byte[] input) {
        try {
            DigestOfFile md5DigestAgent = new DigestOfFile("MD5");
            String hash = md5DigestAgent.digestAsHex(input);
            return hash;
        }
        catch (Exception e) {
            return null;
        }
    }
}

