/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.report.jasper;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.util.logging.Level;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.util.CLogger;
import org.compiere.util.Language;
import org.compiere.util.Util;
import org.compiere.utils.DigestOfFile;

public class WebResourceLoader {
    private static final CLogger log = CLogger.getCLogger(WebResourceLoader.class);
    private String destinationFolder;

    public WebResourceLoader(String destinationFolder) {
        this.destinationFolder = destinationFolder;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private File downloadFile(String reportFilePath) {
        File downloadedFile;
        File reportFile;
        block11: {
            String tmpLocalFilePath;
            block10: {
                reportFile = null;
                downloadedFile = null;
                if (log.isLoggable(Level.INFO)) {
                    log.info(" report deployed to " + reportFilePath);
                }
                try {
                    String[] tmps = reportFilePath.split("/");
                    String fileName = tmps[tmps.length - 1];
                    String localFilePath = String.valueOf(this.destinationFolder) + fileName;
                    tmpLocalFilePath = String.valueOf(this.destinationFolder) + "TMP_" + fileName;
                    reportFile = new File(localFilePath);
                    if (!reportFile.exists()) return this.getRemoteFile(reportFilePath, localFilePath);
                    String remoteMD5Hash = this.getRemoteMD5(reportFilePath);
                    if (Util.isEmpty((String)remoteMD5Hash, (boolean)true)) break block10;
                    String localMD5hash = DigestOfFile.getMD5Hash(reportFile);
                    if (log.isLoggable(Level.INFO)) {
                        log.info("MD5 for local file is " + localMD5hash);
                    }
                    if (localMD5hash.equals(remoteMD5Hash.trim())) {
                        if (!log.isLoggable(Level.INFO)) return reportFile;
                        log.info("MD5 match: local report file is up-to-date");
                        return reportFile;
                    }
                    if (log.isLoggable(Level.INFO)) {
                        log.info("MD5 is different, download and replace");
                    }
                    if ((downloadedFile = this.getRemoteFile(reportFilePath, tmpLocalFilePath)) == null) return null;
                    Path to = reportFile.toPath();
                    Path from = downloadedFile.toPath();
                    Files.copy(from, to, StandardCopyOption.REPLACE_EXISTING);
                    Files.delete(from);
                    return to.toFile();
                }
                catch (Exception e) {
                    throw new AdempiereException("Unknown exception: " + e.getLocalizedMessage());
                }
            }
            downloadedFile = this.getRemoteFile(reportFilePath, tmpLocalFilePath);
            if (downloadedFile != null) break block11;
            return null;
        }
        if (DigestOfFile.md5HashCompare(reportFile, downloadedFile)) {
            if (!log.isLoggable(Level.INFO)) return reportFile;
            log.info("MD5 match: local report file is up-to-date");
            return reportFile;
        }
        if (log.isLoggable(Level.INFO)) {
            log.info("MD5 is different, replace with downloaded file");
        }
        Path to = reportFile.toPath();
        Path from = downloadedFile.toPath();
        Files.copy(from, to, StandardCopyOption.REPLACE_EXISTING);
        Files.delete(from);
        return to.toFile();
    }

    public File getReportFile(String reportFilePath) {
        return this.downloadFile(reportFilePath);
    }

    public File getResourceBundle(String reportPath, String bundleName, Language currLang) {
        String remoteDir = reportPath.substring(0, reportPath.lastIndexOf("/"));
        String resname = String.valueOf(bundleName) + "_" + currLang.getLocale().getLanguage() + "_" + currLang.getLocale().getCountry() + ".properties";
        try {
            File resFile = this.downloadFile(String.valueOf(remoteDir) + "/" + resname);
            if (resFile == null) {
                resname = String.valueOf(bundleName) + "_" + currLang.getLocale().getLanguage() + ".properties";
                resFile = this.downloadFile(String.valueOf(remoteDir) + "/" + resname);
                if (resFile == null) {
                    resname = String.valueOf(bundleName) + ".properties";
                    resFile = this.downloadFile(String.valueOf(remoteDir) + "/" + resname);
                }
            }
            return resFile;
        }
        catch (Exception e) {
            if (log.isLoggable(Level.CONFIG)) {
                log.log(Level.CONFIG, e.getMessage(), (Throwable)e);
            }
            return null;
        }
    }

    private String getRemoteMD5(String reportLocation) {
        try {
            String md5url = String.valueOf(reportLocation) + ".md5";
            URL reportURL = new URL(md5url);
            Throwable throwable = null;
            Object var5_7 = null;
            try (InputStream in = reportURL.openStream();){
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                byte[] buf = new byte[1024];
                int s = 0;
                while ((s = in.read(buf, 0, 1024)) > 0) {
                    baos.write(buf, 0, s);
                }
                String hash = new String(baos.toByteArray());
                int posSpace = hash.indexOf(" ");
                if (posSpace > 0) {
                    hash = hash.substring(0, posSpace);
                }
                return hash;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            if (log.isLoggable(Level.CONFIG)) {
                log.log(Level.CONFIG, "MD5 not available for " + reportLocation, (Throwable)e);
            }
            return null;
        }
    }

    private File getRemoteFile(String reportLocation, String localPath) {
        try {
            URL reportURL = new URL(reportLocation);
            Throwable throwable = null;
            Object var5_7 = null;
            try (InputStream in = reportURL.openStream();){
                File downloadedFile = new File(localPath);
                if (downloadedFile.exists()) {
                    downloadedFile.delete();
                }
                Throwable throwable2 = null;
                Object var9_13 = null;
                try (FileOutputStream fout = new FileOutputStream(downloadedFile);){
                    byte[] buf = new byte[1024];
                    int s = 0;
                    while ((s = in.read(buf, 0, 1024)) > 0) {
                        fout.write(buf, 0, s);
                    }
                    fout.flush();
                }
                catch (Throwable throwable3) {
                    if (throwable2 == null) {
                        throwable2 = throwable3;
                    } else if (throwable2 != throwable3) {
                        throwable2.addSuppressed(throwable3);
                    }
                    throw throwable2;
                }
                return downloadedFile;
            }
            catch (Throwable throwable4) {
                if (throwable == null) {
                    throwable = throwable4;
                } else if (throwable != throwable4) {
                    throwable.addSuppressed(throwable4);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            throw new AdempiereException(e.getMessage(), (Throwable)e);
        }
    }

    public static boolean isWebResourcePath(String path) {
        return path.startsWith("http://") || path.startsWith("https://");
    }
}

