/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.report.jasper;

import java.io.File;
import java.io.FilenameFilter;
import java.net.URI;
import java.net.URISyntaxException;
import org.compiere.util.CLogger;
import org.compiere.util.Language;

public class FileResourceLoader {
    private static final CLogger log = CLogger.getCLogger(FileResourceLoader.class);
    private static final String FILE_PATH_PREFIX = "file:/";

    public File getReportFile(String reportPath) {
        File reportFile = null;
        try {
            reportFile = new File(new URI(reportPath));
        }
        catch (URISyntaxException e) {
            log.warning(e.getLocalizedMessage());
            reportFile = null;
        }
        return reportFile;
    }

    public File getResourceBundle(String resourcePath, String bundleName, Language currLang) {
        String resname = String.valueOf(bundleName) + "_" + currLang.getLocale().getLanguage() + "_" + currLang.getLocale().getCountry() + ".properties";
        File resFile = new File(resourcePath, resname);
        if (!(resFile.exists() || (resFile = new File(resourcePath, resname = String.valueOf(bundleName) + "_" + currLang.getLocale().getLanguage() + ".properties")).exists() || (resFile = new File(resourcePath, resname = String.valueOf(bundleName) + ".properties")).exists())) {
            resFile = null;
        }
        return resFile;
    }

    public File[] getSubreports(File reportFile, File reportDir) {
        return reportDir.listFiles(new FileFilter(reportFile, reportDir));
    }

    public static boolean isFileResourcePath(String path) {
        return path != null && path.startsWith(FILE_PATH_PREFIX);
    }

    private static class FileFilter
    implements FilenameFilter {
        private File directory;
        private File reportFile;

        public FileFilter(File reportFile, File directory) {
            this.reportFile = reportFile;
            this.directory = directory;
        }

        @Override
        public boolean accept(File file, String name) {
            String lower;
            return file.equals(this.directory) && !name.equals(this.reportFile.getName()) && ((lower = name.toLowerCase()).endsWith(".jasper") || lower.endsWith(".jrxml"));
        }
    }
}

