/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.report.jasper;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.logging.Level;
import org.compiere.util.CLogger;
import org.compiere.util.Language;
import org.compiere.utils.DigestOfFile;

public class ClassResourceLoader {
    private static final CLogger log = CLogger.getCLogger(ClassResourceLoader.class);
    private String destinationFolder;
    private String resourcePath;
    private static final String RESOURCE_PATH_PREFIX = "resource:";

    public ClassResourceLoader(String destinationFolder) {
        this.destinationFolder = destinationFolder;
    }

    public Object getResource(String path) {
        String resourceName;
        boolean empty = true;
        URL url = null;
        Serializable reportFile = null;
        String string = resourceName = path.startsWith(RESOURCE_PATH_PREFIX) ? path.substring(RESOURCE_PATH_PREFIX.length()).trim() : path.trim();
        if (resourceName.endsWith(".jrxml")) {
            String localResourceName = this.toLocalName(resourceName);
            String localAbsolutePathName = String.valueOf(this.destinationFolder) + localResourceName;
            reportFile = new File(localAbsolutePathName);
            String localPathName = localAbsolutePathName.substring(0, localAbsolutePathName.lastIndexOf(System.getProperty("file.separator")) + 1);
            Path localAbsolutePath = Path.of(localPathName, new String[0]);
            try {
                if (!Files.exists(localAbsolutePath, new LinkOption[0])) {
                    Files.createDirectory(localAbsolutePath, new FileAttribute[0]);
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            String localFileName = localAbsolutePathName.substring(localAbsolutePathName.lastIndexOf(System.getProperty("file.separator")) + 1);
            String extension = localFileName.substring(localFileName.lastIndexOf("."));
            Serializable tmpOutputFile = null;
            url = this.getClass().getClassLoader().getResource(resourceName);
            if (url != null) {
                block39: {
                    try {
                        Throwable throwable = null;
                        Object var14_18 = null;
                        try (InputStream inputStream = url.openStream();){
                            if (inputStream == null) break block39;
                            if (!((File)reportFile).exists()) {
                                ((File)reportFile).createNewFile();
                                tmpOutputFile = reportFile;
                            } else {
                                tmpOutputFile = File.createTempFile(localFileName.substring(0, localFileName.lastIndexOf(".")), extension, localAbsolutePath.toFile());
                            }
                            Throwable throwable2 = null;
                            Object var17_24 = null;
                            try (FileOutputStream out = new FileOutputStream((File)tmpOutputFile);){
                                if (out != null) {
                                    int len;
                                    byte[] buf = new byte[1024];
                                    while ((len = inputStream.read(buf)) > 0) {
                                        empty = false;
                                        ((OutputStream)out).write(buf, 0, len);
                                    }
                                }
                            }
                            catch (Throwable throwable3) {
                                if (throwable2 == null) {
                                    throwable2 = throwable3;
                                } else if (throwable2 != throwable3) {
                                    throwable2.addSuppressed(throwable3);
                                }
                                throw throwable2;
                            }
                        }
                        catch (Throwable throwable4) {
                            if (throwable == null) {
                                throwable = throwable4;
                            } else if (throwable != throwable4) {
                                throwable.addSuppressed(throwable4);
                            }
                            throw throwable;
                        }
                    }
                    catch (Exception e) {
                        log.log(Level.SEVERE, e.getMessage(), (Throwable)e);
                        empty = true;
                    }
                }
                if (!empty && tmpOutputFile != reportFile) {
                    if (!DigestOfFile.md5HashCompare((File)reportFile, tmpOutputFile)) {
                        Path to = ((File)reportFile).toPath();
                        Path from = ((File)tmpOutputFile).toPath();
                        try {
                            Files.copy(from, to, StandardCopyOption.REPLACE_EXISTING);
                        }
                        catch (IOException e) {
                            log.log(Level.SEVERE, e.getMessage(), (Throwable)e);
                            return null;
                        }
                    }
                    try {
                        Files.delete(((File)tmpOutputFile).toPath());
                    }
                    catch (IOException iOException) {}
                }
            }
        } else {
            url = this.getClass().getClassLoader().getResource(resourceName);
            boolean bl = empty = url == null;
        }
        if (empty) {
            return null;
        }
        if (url != null) {
            this.resourcePath = url.toString();
            if (this.resourcePath != null && this.resourcePath.lastIndexOf("/") > 0) {
                this.resourcePath = this.resourcePath.substring(0, this.resourcePath.lastIndexOf("/") + 1);
            }
        }
        return reportFile != null ? reportFile : url;
    }

    private String toLocalName(String name) {
        String localName = name;
        if (localName.startsWith("/")) {
            localName = localName.substring(1);
        }
        if (localName.lastIndexOf("/") > 0) {
            String path = localName.substring(0, localName.lastIndexOf("/"));
            localName = localName.substring(localName.lastIndexOf("/") + 1);
            path = path.replace('/', '_');
            localName = String.valueOf(path) + System.getProperty("file.separator") + localName;
        }
        return localName;
    }

    public URL getResourceBundle(String bundleName, Language currLang) {
        String resourceName = String.valueOf(bundleName) + "_" + currLang.getLocale().getLanguage() + "_" + currLang.getLocale().getCountry() + ".properties";
        URL resourceURL = null;
        try {
            resourceURL = (URL)this.getResource(resourceName);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (resourceURL == null) {
            resourceName = String.valueOf(bundleName) + "_" + currLang.getLocale().getLanguage() + ".properties";
            try {
                resourceURL = (URL)this.getResource(resourceName);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (resourceURL == null) {
                resourceName = String.valueOf(bundleName) + ".properties";
                try {
                    resourceURL = (URL)this.getResource(resourceName);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        return resourceURL;
    }

    public File[] getSubreports(String path) {
        return new File[0];
    }

    public String getRelatedResourcesPath() {
        return this.resourcePath;
    }

    public static boolean isClassResourcePath(String path) {
        return path != null && path.startsWith(RESOURCE_PATH_PREFIX);
    }
}

