/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.report.jasper;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Enumeration;
import java.util.logging.Level;
import org.adempiere.report.jasper.Activator;
import org.compiere.util.CLogger;
import org.compiere.util.Language;
import org.compiere.utils.DigestOfFile;

public class BundleResourceLoader {
    private static final CLogger log = CLogger.getCLogger(BundleResourceLoader.class);
    private String destinationFolder;
    private String resourcePath;
    private static final String BUNDLE_PATH_PREFIX = "bundle:";

    public BundleResourceLoader(String destinationFolder) {
        this.destinationFolder = destinationFolder;
    }

    public Object getResource(String path) {
        String resourceName = path.startsWith(BUNDLE_PATH_PREFIX) ? path.substring(BUNDLE_PATH_PREFIX.length()).trim() : path.trim();
        Serializable reportFile = null;
        boolean empty = true;
        String parentPath = "/";
        String bundleFileName = resourceName;
        if (resourceName.lastIndexOf("/") > 0) {
            parentPath = "/" + resourceName.substring(0, resourceName.lastIndexOf("/"));
            bundleFileName = resourceName.substring(resourceName.lastIndexOf("/") + 1);
        }
        URL url = null;
        Enumeration entries = Activator.getBundleContext().getBundle().findEntries(parentPath, bundleFileName, false);
        if (entries != null && entries.hasMoreElements()) {
            url = (URL)entries.nextElement();
        }
        if (url != null) {
            if (resourceName.endsWith(".jrxml")) {
                Serializable tmpOutputFile;
                block41: {
                    tmpOutputFile = null;
                    try {
                        Throwable throwable = null;
                        Object var11_14 = null;
                        try (InputStream inputStream = url.openStream();){
                            if (inputStream == null) break block41;
                            String localResourceName = this.toLocalName(resourceName);
                            String localAbsoluteFileName = String.valueOf(this.destinationFolder) + localResourceName;
                            String localAbsolutePathName = localAbsoluteFileName.substring(0, localAbsoluteFileName.lastIndexOf(System.getProperty("file.separator")) + 1);
                            Path localPath = Path.of(localAbsolutePathName, new String[0]);
                            try {
                                if (!Files.exists(localPath, new LinkOption[0])) {
                                    Files.createDirectory(localPath, new FileAttribute[0]);
                                }
                            }
                            catch (IOException e) {
                                throw new RuntimeException(e);
                            }
                            String localFileName = localAbsoluteFileName.substring(localAbsoluteFileName.lastIndexOf(System.getProperty("file.separator")) + 1);
                            String extension = localFileName.substring(localFileName.lastIndexOf("."));
                            reportFile = new File(localAbsoluteFileName);
                            if (!((File)reportFile).exists()) {
                                ((File)reportFile).createNewFile();
                                tmpOutputFile = reportFile;
                            } else {
                                tmpOutputFile = File.createTempFile(localFileName.substring(0, localFileName.lastIndexOf(".")), extension, localPath.toFile());
                            }
                            Throwable throwable2 = null;
                            Object var20_27 = null;
                            try (FileOutputStream out = new FileOutputStream((File)tmpOutputFile);){
                                if (out != null) {
                                    int len;
                                    byte[] buf = new byte[1024];
                                    while ((len = inputStream.read(buf)) > 0) {
                                        empty = false;
                                        ((OutputStream)out).write(buf, 0, len);
                                    }
                                }
                            }
                            catch (Throwable throwable3) {
                                if (throwable2 == null) {
                                    throwable2 = throwable3;
                                } else if (throwable2 != throwable3) {
                                    throwable2.addSuppressed(throwable3);
                                }
                                throw throwable2;
                            }
                        }
                        catch (Throwable throwable4) {
                            if (throwable == null) {
                                throwable = throwable4;
                            } else if (throwable != throwable4) {
                                throwable.addSuppressed(throwable4);
                            }
                            throw throwable;
                        }
                    }
                    catch (Exception e) {
                        log.log(Level.SEVERE, e.getMessage(), (Throwable)e);
                        empty = true;
                    }
                }
                if (!empty && tmpOutputFile != reportFile) {
                    if (!DigestOfFile.md5HashCompare((File)reportFile, tmpOutputFile)) {
                        Path to = ((File)reportFile).toPath();
                        Path from = tmpOutputFile.toPath();
                        try {
                            Files.copy(from, to, StandardCopyOption.REPLACE_EXISTING);
                        }
                        catch (IOException e) {
                            log.log(Level.SEVERE, e.getMessage(), (Throwable)e);
                            return null;
                        }
                    }
                    try {
                        Files.delete(tmpOutputFile.toPath());
                    }
                    catch (IOException iOException) {}
                }
            } else {
                empty = false;
            }
        }
        if (empty) {
            return null;
        }
        if (url != null) {
            this.resourcePath = url.toString();
            if (this.resourcePath != null && this.resourcePath.lastIndexOf("/") > 0) {
                this.resourcePath = this.resourcePath.substring(0, this.resourcePath.lastIndexOf("/") + 1);
            }
        }
        return reportFile != null ? reportFile : url;
    }

    private String toLocalName(String name) {
        String localName = name;
        if (localName.startsWith("/")) {
            localName = localName.substring(1);
        }
        if (localName.lastIndexOf("/") > 0) {
            String path = localName.substring(0, localName.lastIndexOf("/"));
            localName = localName.substring(localName.lastIndexOf("/") + 1);
            path = path.replace('/', '_');
            localName = String.valueOf(path) + System.getProperty("file.separator") + localName;
        }
        return localName;
    }

    public URL getResourceBundle(String bundleName, Language currLang) {
        String resname = String.valueOf(bundleName) + "_" + currLang.getLocale().getLanguage() + "_" + currLang.getLocale().getCountry() + ".properties";
        URL resourceURL = null;
        try {
            resourceURL = (URL)this.getResource(resname);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (resourceURL == null) {
            resname = String.valueOf(bundleName) + "_" + currLang.getLocale().getLanguage() + ".properties";
            try {
                resourceURL = (URL)this.getResource(resname);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (resourceURL == null) {
                resname = String.valueOf(bundleName) + ".properties";
                try {
                    resourceURL = (URL)this.getResource(resname);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        return resourceURL;
    }

    public File[] getSubreports(String path) {
        return new File[0];
    }

    public String getRelatedResourcesPath() {
        return this.resourcePath;
    }

    public static boolean isBundleResourcePath(String path) {
        return path != null && path.startsWith(BUNDLE_PATH_PREFIX);
    }
}

