/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zk.ui.sys;

import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public class DigestUtilsHelper {
    private static final char[] DIGITS_LOWER = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
    private static final char[] DIGITS_UPPER = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};

    public static String md5Hex(String data) {
        return DigestUtilsHelper.encodeHexString(DigestUtilsHelper.md5(data));
    }

    public static String md5Hex(InputStream data) throws IOException {
        return DigestUtilsHelper.encodeHexString(DigestUtilsHelper.md5(data));
    }

    public static byte[] md5(String data) {
        return DigestUtilsHelper.md5(DigestUtilsHelper.getBytesUtf8(data));
    }

    public static byte[] md5(byte[] data) {
        return DigestUtilsHelper.getMd5Digest().digest(data);
    }

    public static byte[] md5(InputStream data) throws IOException {
        int v;
        MessageDigest md = DigestUtilsHelper.getMd5Digest();
        byte[] buf = new byte[4096];
        while ((v = data.read(buf)) >= 0) {
            if (v <= 0) continue;
            md.update(buf, 0, v);
        }
        return md.digest();
    }

    public static MessageDigest getMd5Digest() {
        return DigestUtilsHelper.getDigest("MD5");
    }

    public static MessageDigest getDigest(String algorithm) {
        try {
            return MessageDigest.getInstance(algorithm);
        }
        catch (NoSuchAlgorithmException var2) {
            throw new IllegalArgumentException(var2);
        }
    }

    public static byte[] getBytesUtf8(String string) {
        try {
            return string == null ? null : string.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return null;
        }
    }

    public static String encodeHexString(byte[] data) {
        return new String(DigestUtilsHelper.encodeHex(data));
    }

    public static char[] encodeHex(byte[] data) {
        return DigestUtilsHelper.encodeHex(data, true);
    }

    public static char[] encodeHex(byte[] data, boolean toLowerCase) {
        return DigestUtilsHelper.encodeHex(data, toLowerCase ? DIGITS_LOWER : DIGITS_UPPER);
    }

    protected static char[] encodeHex(byte[] data, char[] toDigits) {
        int l = data.length;
        char[] out = new char[l << 1];
        int j = 0;
        for (int i = 0; i < l; ++i) {
            out[j++] = toDigits[(0xF0 & data[i]) >>> 4];
            out[j++] = toDigits[0xF & data[i]];
        }
        return out;
    }

    public static byte[] decodeHexString(String data) throws IllegalArgumentException {
        return DigestUtilsHelper.decodeHex(data.toCharArray());
    }

    public static byte[] decodeHex(char[] data) throws IllegalArgumentException {
        int len = data.length;
        if ((len & 1) != 0) {
            throw new IllegalArgumentException("Odd number of characters.");
        }
        byte[] out = new byte[len >> 1];
        int i = 0;
        int j = 0;
        while (j < len) {
            int f = DigestUtilsHelper.toDigit(data[j], j) << 4;
            f |= DigestUtilsHelper.toDigit(data[++j], j);
            ++j;
            out[i] = (byte)(f & 0xFF);
            ++i;
        }
        return out;
    }

    protected static int toDigit(char ch, int index) throws IllegalArgumentException {
        int digit = Character.digit(ch, 16);
        if (digit == -1) {
            throw new IllegalArgumentException("Illegal hexadecimal character " + ch + " at index " + index);
        }
        return digit;
    }
}

