/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zk.ui.sys;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.net.URL;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.zkoss.idom.Attribute;
import org.zkoss.idom.Document;
import org.zkoss.idom.Element;
import org.zkoss.idom.Item;
import org.zkoss.idom.input.SAXBuilder;
import org.zkoss.idom.util.IDOMs;
import org.zkoss.lang.Classes;
import org.zkoss.lang.Generics;
import org.zkoss.lang.Library;
import org.zkoss.lang.Strings;
import org.zkoss.mesg.MCommon;
import org.zkoss.util.Cache;
import org.zkoss.util.IllegalSyntaxException;
import org.zkoss.util.Pair;
import org.zkoss.util.resource.Locator;
import org.zkoss.util.resource.XMLResourcesLocator;
import org.zkoss.web.fn.ThemeFns;
import org.zkoss.web.theme.ThemeRegistry;
import org.zkoss.web.theme.ThemeResolver;
import org.zkoss.xel.ExpressionFactory;
import org.zkoss.xml.Locators;
import org.zkoss.zk.au.AuDecoder;
import org.zkoss.zk.au.AuWriter;
import org.zkoss.zk.au.AuWriters;
import org.zkoss.zk.device.Devices;
import org.zkoss.zk.scripting.Interpreters;
import org.zkoss.zk.ui.UiException;
import org.zkoss.zk.ui.WebApp;
import org.zkoss.zk.ui.impl.Utils;
import org.zkoss.zk.ui.metainfo.DefinitionLoaders;
import org.zkoss.zk.ui.sys.ComponentsCtrl;
import org.zkoss.zk.ui.sys.DesktopCacheProvider;
import org.zkoss.zk.ui.sys.DiskFileItemFactory;
import org.zkoss.zk.ui.sys.FailoverManager;
import org.zkoss.zk.ui.sys.IdGenerator;
import org.zkoss.zk.ui.sys.Registry;
import org.zkoss.zk.ui.sys.SessionCache;
import org.zkoss.zk.ui.sys.UiEngine;
import org.zkoss.zk.ui.sys.UiFactory;
import org.zkoss.zk.ui.sys.WebAppFactory;
import org.zkoss.zk.ui.util.CharsetFinder;
import org.zkoss.zk.ui.util.Configuration;
import org.zkoss.zk.ui.util.DataHandlerInfo;
import org.zkoss.zk.ui.util.ThemeProvider;
import org.zkoss.zk.ui.util.ThemeURIHandler;

public class ConfigParser {
    private static final Logger log = LoggerFactory.getLogger(ConfigParser.class);
    private static final int MAX_VERSION_SEGMENT = 4;
    private static volatile int[] _zkver;
    private static volatile List<org.zkoss.zk.ui.util.ConfigParser> _parsers;
    private static final Map<Integer, Boolean> _syscfgLoadedConfigs;
    private static boolean _syscfgLoaded;
    private int _richletnm;
    private static final int POSITIVE_ONLY = 2;
    private static final int NON_NEGATIVE = 1;
    private static final int ANY_VALUE = 0;

    public static boolean checkVersion(URL url, Document doc) throws Exception {
        return ConfigParser.checkVersion(url, doc, false);
    }

    public static boolean checkVersion(URL url, Document doc, boolean zk5required) throws Exception {
        Class cls;
        Field fld;
        String uidInClass;
        String uid;
        String clsnm;
        String s;
        Element el = doc.getRootElement().getElement("version");
        if (el == null) {
            return true;
        }
        if (_zkver == null) {
            _zkver = org.zkoss.util.Utils.parseVersion((String)"9.6.3");
        }
        if ((s = el.getElementValue("zk-version", true)) != null) {
            int[] reqzkver = org.zkoss.util.Utils.parseVersion((String)s);
            if (org.zkoss.util.Utils.compareVersion((int[])_zkver, (int[])reqzkver) < 0) {
                log.info("Ignore " + url + "\nCause: ZK version must be " + s + " or later, not " + "9.6.3");
                return false;
            }
            if (zk5required && reqzkver.length > 0 && reqzkver[0] < 5) {
                log.info("Ingore " + url + "\nCause: version " + s + " not supported");
                return false;
            }
        }
        if ((clsnm = el.getElementValue("version-class", true)) == null) {
            return true;
        }
        if (clsnm.length() == 0) {
            log.warn("Ignored: empty version-class, " + el.getLocator());
        }
        if (!(uid = IDOMs.getRequiredElementValue((Element)el, (String)"version-uid")).equals(uidInClass = (String)(fld = (cls = Classes.forNameByThread((String)clsnm)).getField("UID")).get(null))) {
            log.info("Ignore " + url + "\nCause: version not matched; expected=" + uidInClass + ", xml=" + uid);
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void parseConfigXml(Configuration config) {
        Class<ConfigParser> clazz = ConfigParser.class;
        synchronized (ConfigParser.class) {
            boolean syscfgLoaded = _syscfgLoaded;
            _syscfgLoaded = true;
            boolean syscfgLoadedConfig = config != null ? _syscfgLoadedConfigs.put(new Integer(System.identityHashCode(config)), Boolean.TRUE) != null : syscfgLoaded;
            // ** MonitorExit[var4_2] (shouldn't be in output)
            if (!syscfgLoaded) {
                log.info("Loading system default");
            } else if (config == null) {
                return;
            }
            try {
                XMLResourcesLocator locator = Utils.getXMLResourcesLocator();
                List xmls = locator.getDependentXMLResources("metainfo/zk/config.xml", "config-name", "depends");
                Registry reg = Registry.getInstance();
                for (XMLResourcesLocator.Resource res : xmls) {
                    if (log.isDebugEnabled()) {
                        log.debug("Loading " + res.url);
                    }
                    try {
                        block23: {
                            if (!ConfigParser.checkVersion(res.url, res.document)) continue;
                            try {
                                String path = res.url.toExternalForm();
                                int end = path.lastIndexOf(47);
                                if (end < 0) break block23;
                                try (InputStream inputStream = null;){
                                    path = path.substring(0, end + 1) + Strings.toString((byte[])Registry.PREFS_0);
                                    inputStream = new URL(path).openStream();
                                    if (inputStream != null) {
                                        Properties props = new Properties();
                                        props.load(inputStream);
                                        for (Map.Entry<Object, Object> me : props.entrySet()) {
                                            reg.addKeys((String)me.getKey(), (String)me.getValue());
                                        }
                                    }
                                }
                            }
                            catch (Exception path) {
                                // empty catch block
                            }
                        }
                        Element el = res.document.getRootElement();
                        if (!syscfgLoaded) {
                            ConfigParser.parseSubZScriptConfig(el);
                            ConfigParser.parseSubDeviceConfig(el);
                        }
                        if (!syscfgLoadedConfig) {
                            ConfigParser.parseSubSystemConfig(config, el);
                            ConfigParser.parseSubClientConfig(config, el);
                        }
                        if (!syscfgLoaded) {
                            ConfigParser.parseProperties(el);
                            ConfigParser.parseLangConfigs((Locator)locator, el);
                        }
                        if (config == null) continue;
                        ConfigParser.parseListeners(config, el);
                        ConfigParser.parsePreferences(config, el);
                        if (config.getBinderInitAttribute() != null || !"zkbind".equals(el.getElement("config-name").getText())) continue;
                        ConfigParser.parseBinderConfig(config, el);
                    }
                    catch (Exception ex) {
                        throw UiException.Aide.wrap((Throwable)ex, "Failed to load " + res.url);
                        return;
                    }
                }
            }
            catch (IOException ex) {
                throw UiException.Aide.wrap(ex);
            }
        }
    }

    private static void parseSubZScriptConfig(Element root) {
        for (Element el : root.getElements("zscript-config")) {
            Interpreters.add(el);
        }
    }

    private static void parseSubDeviceConfig(Element root) {
        for (Element el : root.getElements("device-config")) {
            Devices.add(el);
        }
    }

    private static void parseSubSystemConfig(Configuration config, Element root) throws Exception {
        for (Element el : root.getElements("system-config")) {
            if (config != null) {
                ConfigParser.parseSystemConfig(config, el);
                continue;
            }
            Class cls = ConfigParser.parseClass(el, "au-writer-class", AuWriter.class);
            if (cls != null) {
                AuWriters.setImplementationClass(cls);
            }
            if ((cls = ConfigParser.parseClass(el, "config-parser-class", org.zkoss.zk.ui.util.ConfigParser.class)) == null) continue;
            if (_parsers == null) {
                _parsers = new LinkedList<org.zkoss.zk.ui.util.ConfigParser>();
            }
            _parsers.add((org.zkoss.zk.ui.util.ConfigParser)cls.newInstance());
        }
    }

    private static void parseSubClientConfig(Configuration config, Element root) throws Exception {
        for (Element el : root.getElements("client-config")) {
            if (config == null) continue;
            ConfigParser.parseClientConfig(config, el);
        }
    }

    private static void parseListeners(Configuration config, Element root) throws Exception {
        for (Element el : root.getElements("listener")) {
            ConfigParser.parseListener(config, el);
        }
    }

    private static void parseListener(Configuration config, Element el) {
        try {
            config.addListener(ConfigParser.parseClass(el, "listener-class", null, true));
        }
        catch (Exception ex) {
            log.error("Unable to load a listener, " + el.getLocator(), (Throwable)ex);
        }
    }

    public void parse(URL url, Configuration config, Locator locator) throws Exception {
        if (url == null || config == null) {
            throw new IllegalArgumentException("null");
        }
        log.info("Parsing " + url);
        this.parse(new SAXBuilder(true, false, true).build(url).getRootElement(), config, locator);
    }

    public void parse(InputStream is, Configuration config, Locator locator) throws Exception {
        if (is == null || config == null) {
            throw new IllegalArgumentException("null");
        }
        this.parse(new SAXBuilder(true, false, true).build(is).getRootElement(), config, locator);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void parse(Element root, Configuration config, Locator locator) throws Exception {
        block9: for (Element el : root.getElements()) {
            Class cls;
            String elnm = el.getName();
            if ("config-name".equals(elnm) || "depends".equals(elnm)) continue;
            if ("listener".equals(elnm)) {
                ConfigParser.parseListener(config, el);
                continue;
            }
            if ("richlet".equals(elnm)) {
                String clsnm = IDOMs.getRequiredElementValue((Element)el, (String)"richlet-class");
                Map params = IDOMs.parseParams((Element)el, (String)"init-param", (String)"param-name", (String)"param-value");
                String path = el.getElementValue("richlet-url", true);
                if (path != null) {
                    int cnt;
                    ConfigParser configParser = this;
                    synchronized (configParser) {
                        ++this._richletnm;
                    }
                    String name = "z_obs_" + Integer.toHexString(cnt);
                    try {
                        config.addRichlet(name, clsnm, (Map<String, String>)params);
                        config.addRichletMapping(name, path);
                    }
                    catch (Throwable ex) {
                        log.error("Illegal richlet definition at " + el.getLocator(), ex);
                    }
                    continue;
                }
                String nm = IDOMs.getRequiredElementValue((Element)el, (String)"richlet-name");
                try {
                    config.addRichlet(nm, clsnm, (Map<String, String>)params);
                }
                catch (Throwable ex) {
                    log.error("Illegal richlet definition at " + el.getLocator(), ex);
                }
                continue;
            }
            if ("richlet-mapping".equals(elnm)) {
                String nm = IDOMs.getRequiredElementValue((Element)el, (String)"richlet-name");
                String path = IDOMs.getRequiredElementValue((Element)el, (String)"url-pattern");
                try {
                    config.addRichletMapping(nm, path);
                }
                catch (Throwable ex) {
                    log.error("Illegal richlet mapping at " + el.getLocator(), ex);
                }
                continue;
            }
            if ("desktop-config".equals(elnm)) {
                ConfigParser.parseDesktopConfig(config, el);
                ConfigParser.parseClientConfig(config, el);
                continue;
            }
            if ("client-config".equals(elnm)) {
                ConfigParser.parseClientConfig(config, el);
                continue;
            }
            if ("session-config".equals(elnm)) {
                String s;
                Integer v = ConfigParser.parseInteger(el, "session-timeout", 0);
                if (v != null) {
                    config.setSessionMaxInactiveInterval(v);
                }
                if ((v = ConfigParser.parseInteger(el, "max-desktops-per-session", 0)) != null) {
                    config.setSessionMaxDesktops(v);
                }
                if ((v = ConfigParser.parseInteger(el, "max-requests-per-session", 0)) != null) {
                    config.setSessionMaxRequests(v);
                }
                if ((v = ConfigParser.parseInteger(el, "max-pushes-per-session", 0)) != null) {
                    config.setSessionMaxPushes(v);
                }
                if ((s = el.getElementValue("timer-keep-alive", true)) != null) {
                    config.setTimerKeepAlive("true".equals(s));
                }
                ConfigParser.parseTimeoutURI(config, el);
                continue;
            }
            if ("language-config".equals(elnm)) {
                ConfigParser.parseLangConfig(locator, el);
                continue;
            }
            if ("language-mapping".equals(elnm)) {
                DefinitionLoaders.addExtension(IDOMs.getRequiredElementValue((Element)el, (String)"extension"), IDOMs.getRequiredElementValue((Element)el, (String)"language-name"));
                continue;
            }
            if ("system-config".equals(elnm)) {
                ConfigParser.parseSystemConfig(config, el);
                continue;
            }
            if ("xel-config".equals(elnm)) {
                cls = ConfigParser.parseClass(el, "evaluator-class", ExpressionFactory.class);
                if (cls == null) continue;
                config.setExpressionFactoryClass(cls);
                continue;
            }
            if ("zscript-config".equals(elnm)) {
                Interpreters.add(el);
                continue;
            }
            if ("device-config".equals(elnm)) {
                Devices.add(el);
                ConfigParser.parseTimeoutURI(config, el);
                continue;
            }
            if ("log".equals(elnm)) {
                log.warn("Ingored. Use the library property called org.zkoss.util.logging.config.file instead");
                continue;
            }
            if ("error-page".equals(elnm)) {
                cls = ConfigParser.parseClass(el, "exception-type", Throwable.class, true);
                String loc = IDOMs.getRequiredElementValue((Element)el, (String)"location");
                String deviceType = el.getElementValue("device-type", true);
                if (deviceType == null) {
                    deviceType = "ajax";
                } else if (deviceType.length() == 0) {
                    log.error("device-type not specified at " + el.getLocator());
                }
                config.addErrorPage(deviceType, cls, loc);
                continue;
            }
            if ("preference".equals(elnm)) {
                ConfigParser.parsePreference(config, el);
                continue;
            }
            if ("library-property".equals(elnm)) {
                ConfigParser.parseLibProperty(el);
                continue;
            }
            if ("system-property".equals(elnm)) {
                ConfigParser.parseSysProperty(el);
                continue;
            }
            if (_parsers != null) {
                for (org.zkoss.zk.ui.util.ConfigParser parser : _parsers) {
                    if (!parser.parse(config, el)) continue;
                    continue block9;
                }
            }
            log.error("Unknown element: " + elnm + ", at " + el.getLocator());
        }
    }

    private static void parseProperties(Element root) {
        Iterator it = root.getElements("library-property").iterator();
        while (it.hasNext()) {
            ConfigParser.parseLibProperty((Element)it.next());
        }
        it = root.getElements("system-property").iterator();
        while (it.hasNext()) {
            ConfigParser.parseSysProperty((Element)it.next());
        }
    }

    public static void parseLibProperty(Element el) {
        String nm = IDOMs.getRequiredElementValue((Element)el, (String)"name");
        Element valueElmn = el.getElement("value");
        Element appendableElmn = el.getElement("appendable");
        boolean appendable = appendableElmn != null ? "true".equals(appendableElmn.getText(true)) : false;
        Element listElmn = el.getElement("list");
        if (valueElmn != null && listElmn != null) {
            throw new IllegalSyntaxException("You should not use <value> and <list> in <library-property> at the same time");
        }
        if (listElmn != null) {
            List valElements = listElmn.getElements("value");
            if (valElements == null || valElements.isEmpty()) {
                throw new IllegalSyntaxException(MCommon.XML_ELEMENT_REQUIRED, new Object[]{"value", el.getLocator()});
            }
            LinkedList<String> values = new LinkedList<String>();
            for (Element valElmn : valElements) {
                String val = valElmn.getText(true);
                if (!(val != null & val.length() != 0)) continue;
                values.add(val);
            }
            if (appendable) {
                Library.addProperties((String)nm, values);
            } else {
                Library.setProperties((String)nm, values);
            }
        } else if (valueElmn != null) {
            String val = valueElmn.getText(true);
            if (appendable) {
                Library.addProperty((String)nm, (String)val);
            } else {
                Library.setProperty((String)nm, (String)val);
            }
        } else {
            throw new IllegalSyntaxException(MCommon.XML_ELEMENT_REQUIRED, new Object[]{"<value> or <list>", el.getLocator()});
        }
    }

    private static void parseSysProperty(Element el) {
        String nm = IDOMs.getRequiredElementValue((Element)el, (String)"name");
        String val = IDOMs.getRequiredElementValue((Element)el, (String)"value");
        System.setProperty(nm, val);
    }

    private static void parsePreferences(Configuration config, Element root) {
        Iterator it = root.getElements("preference").iterator();
        while (it.hasNext()) {
            ConfigParser.parsePreference(config, (Element)it.next());
        }
    }

    private static void parsePreference(Configuration config, Element el) {
        String nm = IDOMs.getRequiredElementValue((Element)el, (String)"name");
        String val = IDOMs.getRequiredElementValue((Element)el, (String)"value");
        config.setPreference(nm, val);
    }

    private static void parseTimeoutURI(Configuration config, Element conf) throws Exception {
        String deviceType = conf.getElementValue("device-type", true);
        String s = conf.getElementValue("timeout-uri", true);
        if (s != null) {
            config.setTimeoutURI(deviceType, s, 0);
        }
        if ((s = conf.getElementValue("timeout-message", true)) != null) {
            config.setTimeoutMessage(deviceType, s);
        }
        if ((s = conf.getElementValue("automatic-timeout", true)) != null) {
            config.setAutomaticTimeout(deviceType, !"false".equals(s));
        }
    }

    private static void parseDesktopConfig(Configuration config, Element conf) throws Exception {
        String s;
        Integer v;
        String uri;
        for (Element el : conf.getElements("theme-uri")) {
            uri = el.getText(true);
            if (uri.length() == 0) continue;
            config.addThemeURI(uri);
        }
        for (Element el : conf.getElements("disable-theme-uri")) {
            uri = el.getText(true);
            if (uri.length() == 0) continue;
            config.addDisabledThemeURI(uri);
        }
        Class cls = null;
        if (!config.isCustomThemeProvider() && (cls = ConfigParser.parseClass(conf, "theme-provider-class", ThemeProvider.class)) != null) {
            if (!cls.getName().startsWith("org.zkoss.")) {
                config.setCustomThemeProvider(true);
            }
            if (log.isDebugEnabled()) {
                log.debug("ThemeProvider: " + cls.getName());
            }
            config.setThemeProvider((ThemeProvider)cls.newInstance());
        }
        if (!config.isCustomThemeRegistry() && (cls = ConfigParser.parseClass(conf, "theme-registry-class", ThemeRegistry.class)) != null) {
            if (!cls.getName().startsWith("org.zkoss.")) {
                config.setCustomThemeRegistry(true);
            }
            if (log.isDebugEnabled()) {
                log.debug("ThemeRegistry: " + cls.getName());
            }
            ThemeFns.setThemeRegistry((ThemeRegistry)((ThemeRegistry)cls.newInstance()));
        }
        if (!config.isCustomThemeResolver() && (cls = ConfigParser.parseClass(conf, "theme-resolver-class", ThemeResolver.class)) != null) {
            if (!cls.getName().startsWith("org.zkoss.")) {
                config.setCustomThemeResolver(true);
            }
            if (log.isDebugEnabled()) {
                log.debug("ThemeResolver: " + cls.getName());
            }
            ThemeFns.setThemeResolver((ThemeResolver)((ThemeResolver)cls.newInstance()));
        }
        if ((cls = ConfigParser.parseClass(conf, "theme-uri-handler-class", ThemeURIHandler.class)) != null) {
            if (log.isDebugEnabled()) {
                log.debug("ThemeURIHandler: " + cls.getName());
            }
            config.addThemeURIHandler((ThemeURIHandler)cls.newInstance());
        }
        if ((v = ConfigParser.parseInteger(conf, "desktop-timeout", 0)) != null) {
            config.setDesktopMaxInactiveInterval(v);
        }
        if ((v = ConfigParser.parseInteger(conf, "file-check-period", 2)) != null) {
            Library.setProperty((String)"org.zkoss.util.resource.checkPeriod", (String)v.toString());
        }
        if ((v = ConfigParser.parseInteger(conf, "extendlet-check-period", 2)) != null) {
            Library.setProperty((String)"org.zkoss.util.resource.extendlet.checkPeriod", (String)v.toString());
        }
        if ((s = conf.getElementValue("repeat-uuid", true)) != null) {
            config.setRepeatUuid(!"false".equals(s));
        }
    }

    private static void parseSystemConfig(Configuration config, Element el) throws Exception {
        Integer v;
        String s = el.getElementValue("disable-event-thread", true);
        if (s != null) {
            boolean enable = "false".equals(s);
            if (!enable) {
                log.info("The event processing thread is disabled");
            }
            config.enableEventThread(enable);
        }
        if ((s = el.getElementValue("disable-zscript", true)) != null) {
            config.enableZScript(!"true".equals(s));
        }
        if ((v = ConfigParser.parseInteger(el, "max-spare-threads", 0)) != null) {
            config.setMaxSpareThreads(v);
        }
        if ((v = ConfigParser.parseInteger(el, "max-suspended-threads", 0)) != null) {
            config.setMaxSuspendedThreads(v);
        }
        if ((v = ConfigParser.parseInteger(el, "event-time-warning", 0)) != null) {
            config.setEventTimeWarning(v);
        }
        if ((v = ConfigParser.parseInteger(el, "max-upload-size", 0)) != null) {
            config.setMaxUploadSize(v);
        }
        if ((v = ConfigParser.parseInteger(el, "file-size-threshold", 0)) != null) {
            config.setFileSizeThreshold(v);
        }
        if ((v = ConfigParser.parseInteger(el, "max-process-time", 2)) != null) {
            config.setMaxProcessTime(v);
        }
        if ((s = el.getElementValue("upload-charset", true)) != null) {
            config.setUploadCharset(s);
        }
        if ((s = el.getElementValue("response-charset", true)) != null) {
            config.setResponseCharset(s);
        }
        if ((s = el.getElementValue("crawlable", true)) != null) {
            config.setCrawlable(!"false".equals(s));
        }
        if ((s = el.getElementValue("file-repository", true)) != null) {
            config.setFileRepository(s);
        }
        for (Element elinner : el.getElements("label-location")) {
            String path = elinner.getText(true);
            if (Strings.isEmpty((String)path)) continue;
            config.addLabelLocation(path);
        }
        Class cls = ConfigParser.parseClass(el, "upload-charset-finder-class", CharsetFinder.class);
        if (cls != null) {
            config.setUploadCharsetFinder((CharsetFinder)cls.newInstance());
        }
        if ((cls = ConfigParser.parseClass(el, "cache-provider-class", DesktopCacheProvider.class)) != null) {
            config.setDesktopCacheProviderClass(cls);
        }
        if ((cls = ConfigParser.parseClass(el, "ui-factory-class", UiFactory.class)) != null) {
            config.setUiFactoryClass(cls);
        }
        if ((cls = ConfigParser.parseClass(el, "failover-manager-class", FailoverManager.class)) != null) {
            config.setFailoverManagerClass(cls);
        }
        if ((cls = ConfigParser.parseClass(el, "engine-class", UiEngine.class)) != null) {
            config.setUiEngineClass(cls);
        }
        if ((cls = ConfigParser.parseClass(el, "id-generator-class", IdGenerator.class)) != null) {
            config.setIdGeneratorClass(cls);
        }
        if ((cls = ConfigParser.parseClass(el, "session-cache-class", SessionCache.class)) != null) {
            config.setSessionCacheClass(cls);
        }
        if ((cls = ConfigParser.parseClass(el, "file-item-factory-class", DiskFileItemFactory.class)) != null) {
            config.setFileItemFactoryClass(cls);
        }
        if ((cls = ConfigParser.parseClass(el, "au-decoder-class", AuDecoder.class)) != null) {
            config.setAuDecoderClass(cls);
        }
        if ((cls = ConfigParser.parseClass(el, "web-app-class", WebApp.class)) != null) {
            config.setWebAppClass(cls);
        }
        if ((cls = ConfigParser.parseClass(el, "web-app-factory-class", WebAppFactory.class)) != null) {
            config.setWebAppFactoryClass(cls);
        }
        if ((cls = ConfigParser.parseClass(el, "method-cache-class", Cache.class)) != null) {
            ComponentsCtrl.setEventMethodCache((Cache)cls.newInstance());
        }
        if ((cls = ConfigParser.parseClass(el, "au-writer-class", AuWriter.class)) != null) {
            AuWriters.setImplementationClass(cls);
        }
    }

    private static void parseClientConfig(Configuration config, Element conf) {
        String s;
        Integer v = ConfigParser.parseInteger(conf, "processing-prompt-delay", 2);
        if (v != null) {
            config.setProcessingPromptDelay(v);
        }
        if ((v = ConfigParser.parseInteger(conf, "tooltip-delay", 2)) != null) {
            config.setTooltipDelay(v);
        }
        if ((v = ConfigParser.parseInteger(conf, "auto-resend-timeout", 2)) != null) {
            config.setAutoResendTimeout(v);
        }
        if ((s = conf.getElementValue("keep-across-visits", true)) != null) {
            config.setKeepDesktopAcrossVisits(!"false".equals(s));
        }
        if ((s = conf.getElementValue("debug-js", true)) != null) {
            config.setDebugJS(!"false".equals(s));
        }
        if ((s = conf.getElementValue("enable-source-map", true)) != null) {
            config.enableSourceMap(!"false".equals(s));
        }
        if ((s = conf.getElementValue("init-crash-script", true)) != null) {
            config.setInitCrashScript(s);
        }
        if ((v = ConfigParser.parseInteger(conf, "init-crash-timeout", 1)) != null) {
            config.setInitCrashTimeout(v);
        }
        if ((s = conf.getElementValue("enable-history-state", true)) != null) {
            config.enableHistoryState(Boolean.parseBoolean(s));
        }
        Iterator it = conf.getElements("package").iterator();
        while (it.hasNext()) {
            config.addClientPackage(IDOMs.getRequiredElementValue((Element)((Element)it.next()), (String)"package-name"));
        }
        for (Element el : conf.getElements("data-handler")) {
            String dataName = IDOMs.getRequiredElementValue((Element)el, (String)"name");
            List elements = el.getElements("script");
            LinkedList<Pair<String, String>> scripts = null;
            if (!elements.isEmpty()) {
                scripts = new LinkedList<Pair<String, String>>();
                for (Element e : elements) {
                    scripts.add(new Pair((Object)e.getAttribute("src"), (Object)e.getText(true)));
                }
            }
            if (scripts == null) {
                throw new IllegalSyntaxException(MCommon.XML_ELEMENT_REQUIRED, new Object[]{"script", el.getLocator()});
            }
            boolean override = Boolean.parseBoolean(el.getElementValue("override", true));
            elements = el.getElements("link");
            LinkedList<Map<String, String>> links = null;
            if (!elements.isEmpty()) {
                links = new LinkedList<Map<String, String>>();
                for (Element e : elements) {
                    List attrs = e.getAttributeItems();
                    if (attrs == null || attrs.isEmpty()) continue;
                    LinkedHashMap<String, String> attrMap = new LinkedHashMap<String, String>();
                    for (Attribute a : attrs) {
                        attrMap.put(a.getName(), a.getValue());
                    }
                    links.add(attrMap);
                }
            }
            config.addDataHandler(new DataHandlerInfo(dataName, scripts, override, links));
        }
        for (Element el : conf.getElements("error-reload")) {
            String deviceType = el.getElementValue("device-type", true);
            String connType = el.getElementValue("connection-type", true);
            v = ConfigParser.parseInteger(el, "error-code", 1);
            if (v == null) {
                throw new UiException(ConfigParser.message("error-code is required", (Item)el));
            }
            String uri = IDOMs.getRequiredElementValue((Element)el, (String)"reload-uri");
            if ("false".equals(uri)) {
                uri = null;
            }
            config.setClientErrorReload(deviceType, v, uri, connType);
        }
    }

    private static String message(String message, Item el) {
        return Locators.format((String)message, (org.zkoss.xml.Locator)(el != null ? el.getLocator() : null));
    }

    private static void parseLangConfigs(Locator locator, Element root) {
        Iterator it = root.getElements("language-config").iterator();
        while (it.hasNext()) {
            ConfigParser.parseLangConfig(locator, (Element)it.next());
        }
    }

    private static void parseLangConfig(Locator locator, Element conf) {
        URL url;
        String path;
        for (Element el : conf.getElements("addon-uri")) {
            path = el.getText(true);
            url = locator.getResource(path);
            if (url == null) {
                log.error("File not found: " + path + ", at " + el.getLocator());
                continue;
            }
            DefinitionLoaders.addAddon(locator, url);
        }
        for (Element el : conf.getElements("language-uri")) {
            path = el.getText(true);
            url = locator.getResource(path);
            if (url == null) {
                log.error("File not found: " + path + ", at " + el.getLocator());
                continue;
            }
            DefinitionLoaders.addLanguage(locator, url);
        }
    }

    private static <T> Class<T> parseClass(Element el, String elnm, Class cls) {
        return ConfigParser.parseClass(el, elnm, cls, false);
    }

    private static <T> Class<T> parseClass(Element el, String elnm, Class<?> cls, boolean required) {
        String clsnm = el.getElementValue(elnm, true);
        if (clsnm != null && clsnm.length() != 0) {
            try {
                Class klass = Classes.forNameByThread((String)clsnm);
                if (cls != null && !cls.isAssignableFrom(klass)) {
                    String msg = ConfigParser.message(clsnm + " must implement " + cls.getName(), (Item)el);
                    if (required) {
                        throw new UiException(msg);
                    }
                    log.error(msg);
                    return null;
                }
                return Generics.cast((Class)klass);
            }
            catch (Throwable ex) {
                String msg = ex instanceof ClassNotFoundException ? clsnm + " not found" : "Unable to load " + clsnm;
                msg = ConfigParser.message(msg, (Item)el);
                if (required) {
                    throw new UiException(msg, ex);
                }
                log.error(msg);
                return null;
            }
        }
        if (required) {
            throw new UiException(ConfigParser.message(elnm + " required", (Item)el));
        }
        return null;
    }

    private static Integer parseInteger(Element el, String subnm, int flag) throws UiException {
        String val = el.getElementValue(subnm, true);
        if (val != null && val.length() > 0) {
            try {
                int v = Integer.parseInt(val);
                if (flag == 2 && v <= 0 || flag == 1 && v < 0) {
                    throw new UiException(ConfigParser.message("The " + subnm + " element must be a " + (flag == 2 ? "positive" : "non-negative") + " number, not " + val, (Item)el));
                }
                return new Integer(v);
            }
            catch (NumberFormatException ex) {
                throw new UiException(ConfigParser.message("The " + subnm + " element must be a number, not " + val, (Item)el));
            }
        }
        return null;
    }

    private static void parseBinderConfig(Configuration config, Element conf) {
        Element binderConf = conf.getElement("binder-config");
        if (binderConf != null) {
            config.setBinderInitAttribute(binderConf.getElement("binder-init-attribute").getText());
            List values = binderConf.getElement("binding-annotations").getElement("list").getElements();
            HashSet<String> annots = new HashSet<String>();
            for (Element val : values) {
                annots.add("@" + val.getText() + "(");
            }
            config.setBinderAnnotations(annots);
        }
    }

    static {
        _syscfgLoadedConfigs = new HashMap<Integer, Boolean>(4);
    }
}

