/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zk.ui.metainfo;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import org.zkoss.zk.ui.Page;
import org.zkoss.zk.xel.Evaluator;
import org.zkoss.zk.xel.ExValue;

class ArgumentInfo {
    private final Map<String, ExValue> _args;

    ArgumentInfo(Map<String, String> args) {
        if (args != null && !args.isEmpty()) {
            this._args = new LinkedHashMap<String, ExValue>();
            for (Map.Entry<String, String> me : args.entrySet()) {
                this._args.put(me.getKey(), new ExValue(me.getValue(), Object.class));
            }
        } else {
            this._args = null;
        }
    }

    Object newInstance(Class<?> cls, Evaluator eval, Page page) throws Exception {
        if (this._args != null) {
            Map<String, Object> args = this.resolveArguments(eval, page);
            try {
                return cls.getConstructor(Map.class).newInstance(args);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                try {
                    return cls.getConstructor(Object[].class).newInstance(new Object[]{ArgumentInfo.toArray(args)});
                }
                catch (NoSuchMethodException noSuchMethodException2) {
                    // empty catch block
                }
            }
        }
        return cls.newInstance();
    }

    Map<String, Object> resolveArguments(Evaluator eval, Page page) {
        if (this._args == null) {
            return Collections.emptyMap();
        }
        LinkedHashMap<String, Object> args = new LinkedHashMap<String, Object>();
        for (Map.Entry<String, ExValue> me : this._args.entrySet()) {
            args.put(me.getKey(), me.getValue().getValue(eval, page));
        }
        return args;
    }

    static Object[] toArray(Map<String, Object> args) {
        String nm;
        if (args.isEmpty()) {
            return new Object[0];
        }
        LinkedList<Object> lst = new LinkedList<Object>();
        int j = 0;
        while (args.containsKey(nm = "arg" + j)) {
            lst.add(args.remove(nm));
            ++j;
        }
        lst.addAll(args.values());
        return lst.toArray(new Object[lst.size()]);
    }
}

