/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zk.ui.impl;

import java.util.LinkedList;
import java.util.List;
import org.zkoss.zk.ui.IdSpace;
import org.zkoss.zk.ui.ext.Scope;
import org.zkoss.zk.ui.ext.ScopeListener;

public class ScopeListeners {
    private final Scope _owner;
    private List<ScopeListener> _listeners;

    public ScopeListeners(Scope owner) {
        this._owner = owner;
    }

    public boolean addScopeListener(ScopeListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("null");
        }
        if (this._listeners == null) {
            this._listeners = new LinkedList<ScopeListener>();
        } else if (this._listeners.contains(listener)) {
            return false;
        }
        this._listeners.add(listener);
        return true;
    }

    public boolean removeScopeListener(ScopeListener listener) {
        return this._listeners != null && this._listeners.remove(listener);
    }

    public List<ScopeListener> getListeners() {
        if (this._listeners == null) {
            this._listeners = new LinkedList<ScopeListener>();
        }
        return this._listeners;
    }

    public void notifyAdded(String name, Object value) {
        if (this._listeners != null) {
            for (ScopeListener l : this._listeners) {
                l.attributeAdded(this._owner, name, value);
            }
        }
    }

    public void notifyReplaced(String name, Object value) {
        if (this._listeners != null) {
            for (ScopeListener l : this._listeners) {
                l.attributeReplaced(this._owner, name, value);
            }
        }
    }

    public void notifyRemoved(String name) {
        if (this._listeners != null) {
            for (ScopeListener l : this._listeners) {
                l.attributeRemoved(this._owner, name);
            }
        }
    }

    public void notifyParentChanged(Scope newparent) {
        if (this._listeners != null) {
            for (ScopeListener l : this._listeners) {
                l.parentChanged(this._owner, newparent);
            }
        }
    }

    public void notifyIdSpaceChanged(IdSpace newIdSpace) {
        if (this._listeners != null) {
            for (ScopeListener l : this._listeners) {
                l.idSpaceChanged(this._owner, newIdSpace);
            }
        }
    }
}

