/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zk.ui.http;

import com.google.javascript.jscomp.CompilationLevel;
import com.google.javascript.jscomp.Compiler;
import com.google.javascript.jscomp.CompilerOptions;
import com.google.javascript.jscomp.SourceFile;
import com.google.javascript.jscomp.SourceMap;
import com.google.javascript.jscomp.WarningLevel;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.zkoss.lang.Strings;
import org.zkoss.util.Pair;

public class SourceMapManager
implements Serializable {
    static final Logger log = LoggerFactory.getLogger(SourceMapManager.class);
    private final String _name;
    private final String _sourceRoot;
    private final String _sourceMappingURL;
    private String _preScript = null;
    private String _postScript = null;
    private Map<Pair<String, String>, String> _jsContentMap;
    private Map<Pair<String, String>, String> _postJsContentMap;
    private Pair<String, String> _jsCursor = null;
    private static final SourceFile.Builder _builder = new SourceFile.Builder();

    public SourceMapManager(String name, String sourceRoot, String id) {
        this._name = name;
        this._sourceRoot = sourceRoot;
        this._sourceMappingURL = this._sourceRoot + "js/" + id + "/" + this._name + ".map";
        this._jsContentMap = new LinkedHashMap<Pair<String, String>, String>();
        this._postJsContentMap = new LinkedHashMap<Pair<String, String>, String>();
    }

    public void setPreScript(String preScript) {
        this._preScript = preScript;
    }

    public void setPostScript(String postScript) {
        this._postScript = postScript;
    }

    public void updateCursorRealPath(String realPath) {
        if (!this.isJsCursorValid()) {
            return;
        }
        if (this._jsCursor.getY() == null) {
            Pair newKey;
            String jsContent = this._jsContentMap.remove(this._jsCursor);
            this._jsCursor = newKey = new Pair((Object)((String)this._jsCursor.getX()), (Object)realPath.replace("/js/", "/js/src/"));
            this._jsContentMap.put((Pair<String, String>)newKey, jsContent);
        }
    }

    public void appendJsContent(String ... scripts) {
        if (!this.isJsCursorValid()) {
            return;
        }
        String jsContent = this._jsContentMap.get(this._jsCursor);
        if (jsContent == null) {
            jsContent = "";
        }
        for (String script : scripts) {
            jsContent = jsContent + script;
        }
        this._jsContentMap.put(this._jsCursor, jsContent);
    }

    public void startJsCursor(String jsPath) {
        this._jsCursor = new Pair((Object)jsPath, null);
    }

    public void clearJsCursor() {
        this._jsCursor = null;
    }

    public void closeJsCursor(ByteArrayOutputStream out) {
        String realPath = (String)this._jsCursor.getY();
        if (!Strings.isEmpty((String)realPath)) {
            String key = "$zk$" + realPath;
            String loadJsScript = "window['" + key + "']();delete window['" + key + "'];";
            byte[] bs = loadJsScript.getBytes();
            out.write(bs, 0, bs.length);
        }
        this.clearJsCursor();
    }

    public void appendPostScript(String ... scripts) {
        for (String script : scripts) {
            this._postScript = this._postScript + script;
        }
    }

    public void mergeWpd(SourceMapManager sourceMapManager, byte[] data) {
        String wpdFileName = sourceMapManager._name + ".wpd.src.js";
        String wpdPath = "/js/src/" + wpdFileName;
        String wpdFileContent = sourceMapManager._preScript + new String(data) + sourceMapManager._postScript;
        for (Map.Entry<Pair<String, String>, String> en : sourceMapManager._jsContentMap.entrySet()) {
            this._postJsContentMap.put(en.getKey(), en.getValue());
        }
        this._postJsContentMap.put((Pair<String, String>)new Pair((Object)wpdFileName, (Object)wpdPath), wpdFileContent);
    }

    public String generateFinalWpd(ConcurrentMap<String, String> sourceMapContentMap, String sourceMapKey, ConcurrentMap sourceCache, byte[] data) throws IOException {
        LinkedList<SourceFile> jsSourceFiles = new LinkedList<SourceFile>();
        this.handleSourceFiles(sourceCache, jsSourceFiles, this._jsContentMap);
        String wpdFileName = "js/src/" + this._name + ".wpd.src.js";
        String wpdFilePath = this._sourceRoot + wpdFileName;
        String wpdFileContent = this._preScript + new String(data) + this._postScript;
        SourceFile wpdSourceFile = _builder.buildFromCode(wpdFilePath, wpdFileContent);
        this.cacheJsSource(sourceCache, "/" + wpdFileName, wpdFileContent);
        jsSourceFiles.add(wpdSourceFile);
        this.handleSourceFiles(sourceCache, jsSourceFiles, this._postJsContentMap);
        Compiler compiler = new Compiler();
        CompilerOptions compilerOptions = new CompilerOptions();
        CompilationLevel.WHITESPACE_ONLY.setOptionsForCompilationLevel(compilerOptions);
        compilerOptions.setSourceMapDetailLevel(SourceMap.DetailLevel.ALL);
        compilerOptions.setSourceMapOutputPath(this._sourceMappingURL);
        compilerOptions.setStrictModeInput(false);
        WarningLevel.QUIET.setOptionsForWarningLevel(compilerOptions);
        compilerOptions.setEmitUseStrict(false);
        compilerOptions.sourceMapFormat = SourceMap.Format.V3;
        compiler.compile(Collections.emptyList(), jsSourceFiles, compilerOptions);
        String finalWpdContent = compiler.toSource();
        finalWpdContent = finalWpdContent + "//# sourceMappingURL=" + this._sourceMappingURL;
        StringBuilder sourceMapBuilder = new StringBuilder();
        compiler.getSourceMap().appendTo((Appendable)sourceMapBuilder, this._sourceMappingURL);
        sourceMapContentMap.putIfAbsent(sourceMapKey, sourceMapBuilder.toString());
        this._jsContentMap.clear();
        this._postJsContentMap.clear();
        return finalWpdContent;
    }

    private void handleSourceFiles(ConcurrentMap sourceCache, List<SourceFile> sourceFiles, Map<Pair<String, String>, String> jsContentMap) {
        for (Map.Entry<Pair<String, String>, String> en : jsContentMap.entrySet()) {
            String jsContent = en.getValue();
            Pair<String, String> jsKey = en.getKey();
            String jsRealPath = (String)jsKey.getY();
            if (!jsRealPath.contains("wpd.src.js")) {
                jsContent = "window['$zk$" + jsRealPath + "'] = function () {\n" + jsContent + "\n};";
            }
            this.cacheJsSource(sourceCache, jsRealPath.substring(jsRealPath.indexOf("/js/")), jsContent);
            if (jsRealPath.startsWith(File.separator)) {
                jsRealPath = this._sourceRoot + jsRealPath.substring(1);
            }
            SourceFile sourceFile = _builder.buildFromCode(jsRealPath, jsContent);
            sourceFiles.add(sourceFile);
        }
    }

    private boolean isJsCursorValid() {
        if (this._jsCursor == null) {
            log.debug("({}) invalid _jsCursor", (Object)this._name);
            return false;
        }
        return true;
    }

    private void cacheJsSource(ConcurrentMap<String, String> sourceCache, String key, String content) {
        sourceCache.putIfAbsent(key, content);
    }
}

