/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zk.ui.event.impl;

import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.zkoss.lang.Generics;
import org.zkoss.zk.ui.Desktop;
import org.zkoss.zk.ui.Execution;
import org.zkoss.zk.ui.Executions;
import org.zkoss.zk.ui.Session;
import org.zkoss.zk.ui.Sessions;
import org.zkoss.zk.ui.WebApp;
import org.zkoss.zk.ui.WebApps;
import org.zkoss.zk.ui.event.Event;
import org.zkoss.zk.ui.event.EventQueue;
import org.zkoss.zk.ui.event.impl.DesktopEventQueue;
import org.zkoss.zk.ui.event.impl.EventQueueProvider;
import org.zkoss.zk.ui.event.impl.ServerPushEventQueue;
import org.zkoss.zk.ui.ext.Scope;
import org.zkoss.zk.ui.impl.DesktopImpl;
import org.zkoss.zk.ui.impl.PollingServerPush;
import org.zkoss.zk.ui.sys.ExecutionCtrl;
import org.zkoss.zk.ui.util.Callback;

public class EventQueueProviderImpl
implements EventQueueProvider {
    private static final Logger log = LoggerFactory.getLogger(EventQueueProviderImpl.class);
    protected static final String ATTR_EVENT_QUEUES = "org.zkoss.zk.ui.event.eventQueues";

    @Override
    public <T extends Event> EventQueue<T> lookup(String name, String scope, boolean autoCreate) {
        boolean bAppScope = "application".equals(scope);
        boolean bSessionScope = "session".equals(scope);
        if (bSessionScope && Sessions.getCurrent() == null) {
            throw new IllegalStateException("Current session is not available");
        }
        if (bAppScope || bSessionScope) {
            return this.lookup0(name, bAppScope ? WebApps.getCurrent() : Sessions.getCurrent(), autoCreate);
        }
        if ("desktop".equals(scope)) {
            Execution exec = Executions.getCurrent();
            if (exec == null) {
                throw new IllegalStateException("Not in an execution");
            }
            Desktop desktop = exec.getDesktop();
            HashMap eqs = Generics.cast((Map)((Map)desktop.getAttribute(ATTR_EVENT_QUEUES)));
            if (eqs == null) {
                eqs = new HashMap(4);
                desktop.setAttribute(ATTR_EVENT_QUEUES, eqs);
            }
            DesktopEventQueue eq = (DesktopEventQueue)eqs.get(name);
            if (autoCreate && eq == null) {
                eq = new DesktopEventQueue();
                eqs.put(name, eq);
            }
            if (log.isDebugEnabled()) {
                log.debug("Lookup event queue: name [{}], scope [{}], autoCreate [{}]", new Object[]{name, scope, autoCreate});
            }
            return eq;
        }
        throw new UnsupportedOperationException("Unknown scope: " + scope);
    }

    @Override
    public <T extends Event> EventQueue<T> lookup(String name, Session sess, boolean autoCreate) {
        return this.lookup0(name, sess, autoCreate);
    }

    @Override
    public <T extends Event> EventQueue<T> lookup(String name, WebApp wapp, boolean autoCreate) {
        return this.lookup0(name, wapp, autoCreate);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T extends Event> EventQueue<T> lookup0(String name, Scope ctxscope, boolean autoCreate) {
        ServerPushEventQueue eq;
        HashMap eqs;
        Scope scope = ctxscope;
        synchronized (scope) {
            eqs = Generics.cast((Map)((Map)ctxscope.getAttribute(ATTR_EVENT_QUEUES)));
            if (eqs == null) {
                eqs = new HashMap(4);
                ctxscope.setAttribute(ATTR_EVENT_QUEUES, eqs);
            }
        }
        HashMap hashMap = eqs;
        synchronized (hashMap) {
            eq = (ServerPushEventQueue)eqs.get(name);
            if (autoCreate && eq == null) {
                eq = new ServerPushEventQueue();
                eqs.put(name, eq);
            }
        }
        if (log.isDebugEnabled()) {
            log.debug("Lookup event queue: name [{}], scope [{}], autoCreate [{}]", new Object[]{name, ctxscope, autoCreate});
        }
        return eq;
    }

    @Override
    public boolean remove(String name, String scope) {
        Execution exec = Executions.getCurrent();
        if (exec == null) {
            throw new IllegalStateException("Not in an execution");
        }
        if ("desktop".equals(scope)) {
            return this.remove0(name, exec.getDesktop());
        }
        if ("application".equals(scope)) {
            return this.remove0(name, exec.getDesktop().getWebApp());
        }
        if ("session".equals(scope)) {
            return this.remove0(name, exec.getSession());
        }
        return false;
    }

    @Override
    public boolean remove(String name, Session sess) {
        return this.remove0(name, sess);
    }

    @Override
    public boolean remove(String name, WebApp wapp) {
        return this.remove0(name, wapp);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean remove0(String name, Scope ctxscope) {
        Map eqs;
        Scope scope = ctxscope;
        synchronized (scope) {
            eqs = Generics.cast((Map)((Map)ctxscope.getAttribute(ATTR_EVENT_QUEUES)));
        }
        if (eqs != null) {
            EventQueue eq;
            Map map = eqs;
            synchronized (map) {
                eq = (EventQueue)eqs.remove(name);
            }
            if (eq != null) {
                DesktopImpl desktopImpl;
                Execution execution = Executions.getCurrent();
                DesktopImpl desktopImpl2 = desktopImpl = execution != null ? (DesktopImpl)execution.getDesktop() : null;
                if (execution == null || WebApps.getCurrent().getServletContext().getMajorVersion() < 3 || desktopImpl != null && desktopImpl.isServerPushEnabled() && desktopImpl.getServerPush() instanceof PollingServerPush) {
                    eq.close();
                } else {
                    final EventQueue callbackEq = eq;
                    ((ExecutionCtrl)((Object)execution)).addOnDeactivate(new Callback<Object>(){

                        @Override
                        public void call(Object data) {
                            callbackEq.close();
                        }
                    });
                }
                if (log.isDebugEnabled()) {
                    log.debug("Remove the event queue: name [{}], scope [{}]", (Object)name, (Object)ctxscope);
                }
                return true;
            }
        }
        if (log.isDebugEnabled()) {
            log.debug("Fail to remove the event queue: name [{}], scope [{}]", (Object)name, (Object)ctxscope);
        }
        return false;
    }
}

