/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.idom;

import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.regex.Pattern;
import org.w3c.dom.Attr;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.TypeInfo;
import org.zkoss.idom.Attributable;
import org.zkoss.idom.Attribute;
import org.zkoss.idom.Binary;
import org.zkoss.idom.CData;
import org.zkoss.idom.DOMException;
import org.zkoss.idom.Document;
import org.zkoss.idom.Group;
import org.zkoss.idom.Item;
import org.zkoss.idom.Namespace;
import org.zkoss.idom.Namespaceable;
import org.zkoss.idom.Text;
import org.zkoss.idom.Verifier;
import org.zkoss.idom.impl.AbstractGroup;
import org.zkoss.idom.impl.AbstractTextual;
import org.zkoss.idom.impl.FacadeNodeList;
import org.zkoss.lang.Generics;
import org.zkoss.util.NotableLinkedList;

public class Element
extends AbstractGroup
implements Attributable,
Namespaceable,
org.w3c.dom.Element {
    protected Namespace _ns;
    protected String _lname;
    protected List<Attribute> _attrs = null;
    protected Map<String, Namespace> _addNamespaces = null;

    public Element(String nsURI, String tname) {
        int kp = tname.indexOf(58);
        String prefix = kp >= 0 ? tname.substring(0, kp) : "";
        String lname = kp >= 0 ? tname.substring(kp + 1) : tname;
        this.setNamespace(prefix, nsURI);
        this.setLocalName(lname);
    }

    public Element(Namespace ns, String lname) {
        this.setNamespace(ns);
        this.setLocalName(lname);
    }

    public Element(String lname) {
        this(Namespace.NO_NAMESPACE, lname);
    }

    protected Element() {
        this._ns = Namespace.NO_NAMESPACE;
    }

    public final boolean isRootElement() {
        return this.getParent() instanceof Document;
    }

    public final Namespace getNamespace(String prefix) {
        Namespace ns;
        if (prefix == null) {
            prefix = "";
        }
        if ((ns = Namespace.getSpecial(prefix)) != null) {
            return ns;
        }
        ns = this.getNamespace();
        if (ns != null && prefix.equals(ns.getPrefix())) {
            return ns;
        }
        if (this._addNamespaces != null && (ns = this._addNamespaces.get(prefix)) != null) {
            return ns;
        }
        if (this.getParent() instanceof Element) {
            return ((Element)this.getParent()).getNamespace(prefix);
        }
        return prefix.length() > 0 ? null : Namespace.NO_NAMESPACE;
    }

    public final Collection<Namespace> getDeclaredNamespaces() {
        if (this._addNamespaces != null) {
            return this._addNamespaces.values();
        }
        return Collections.emptyList();
    }

    public final boolean addDeclaredNamespace(Namespace ns) {
        if (this._addNamespaces == null) {
            this._addNamespaces = new LinkedHashMap<String, Namespace>(4);
        } else {
            Namespace old = this._addNamespaces.get(ns.getPrefix());
            if (old != null) {
                if (!old.equals(ns)) {
                    throw new DOMException(14, "Add a conflict namespace: " + ns + ", while " + old + " already exists");
                }
                return false;
            }
        }
        this._addNamespaces.put(ns.getPrefix(), ns);
        return true;
    }

    public final Object getContent() {
        for (Object o : this._children) {
            if (o instanceof Text) {
                return ((Text)o).getText();
            }
            if (o instanceof Binary) {
                return ((Binary)o).getValue();
            }
            if (!(o instanceof CData)) continue;
            return ((CData)o).getText();
        }
        return null;
    }

    public final Object setContent(Object obj) {
        Object[] ary;
        if (obj instanceof Item) {
            this.getChildren().add((Item)obj);
            return null;
        }
        if (obj instanceof Collection) {
            Collection c = (Collection)obj;
            Iterator it = c.iterator();
            if (it.hasNext() && it.next() instanceof Item) {
                Collection ci = Generics.cast(c);
                this.getChildren().addAll(ci);
                return null;
            }
        } else if (obj instanceof Object[] && (ary = (Object[])obj).length > 0 && ary[0] instanceof Item) {
            for (int j = 0; j < ary.length; ++j) {
                this.getChildren().add((Item)ary[j]);
            }
            return null;
        }
        Object ret = null;
        boolean retFound = false;
        boolean bStr = obj instanceof String;
        Iterator it = this._children.iterator();
        while (it.hasNext()) {
            Object o = it.next();
            if (o instanceof Text) {
                if (!retFound) {
                    retFound = true;
                    ret = ((Text)o).getText();
                }
                if (!bStr || obj == null) {
                    it.remove();
                    continue;
                }
                ((Text)o).setText((String)obj);
                obj = null;
                continue;
            }
            if (o instanceof Binary) {
                if (!retFound) {
                    retFound = true;
                    ret = ((Binary)o).getValue();
                }
                if (bStr || obj == null) {
                    it.remove();
                    continue;
                }
                ((Binary)o).setValue(obj);
                obj = null;
                continue;
            }
            if (!(o instanceof CData)) continue;
            if (!retFound) {
                retFound = true;
                ret = ((CData)o).getText();
            }
            it.remove();
        }
        if (obj != null) {
            this._children.add(0, bStr ? new Text((String)obj) : new Binary(obj));
        }
        return ret;
    }

    public final Object getContent(String path) {
        Element e = this;
        int j = 0;
        while (true) {
            int k;
            String tname;
            String string = tname = (k = path.indexOf(47, j)) >= 0 ? path.substring(j, k) : path.substring(j);
            if (tname.length() > 0 && (e = e.getElement(tname)) == null) {
                return null;
            }
            if (k < 0) {
                return e.getContent();
            }
            j = k + 1;
        }
    }

    public final boolean hasContent(String path) {
        Element e = this;
        int j = 0;
        while (true) {
            int k;
            String tname;
            String string = tname = (k = path.indexOf(47, j)) >= 0 ? path.substring(j, k) : path.substring(j);
            if (tname.length() > 0 && (e = e.getElement(tname)) == null) {
                return false;
            }
            if (k < 0) {
                return true;
            }
            j = k + 1;
        }
    }

    public final Object setContent(String path, Object obj) {
        Element e = this;
        int j = 0;
        while (true) {
            int k;
            String tname;
            String string = tname = (k = path.indexOf(47, j)) >= 0 ? path.substring(j, k) : path.substring(j);
            if (tname.length() > 0) {
                Element e2 = e.getElement(tname);
                if (e2 == null) {
                    e2 = new Element(e.getNamespace().getURI(), tname);
                    e.getChildren().add(e2);
                }
                e = e2;
            }
            if (k < 0) {
                return e.setContent(obj);
            }
            j = k + 1;
        }
    }

    public final Object removeContent(String path) {
        Element e = this;
        int j = 0;
        while (true) {
            int k;
            String tname;
            String string = tname = (k = path.indexOf(47, j)) >= 0 ? path.substring(j, k) : path.substring(j);
            if (tname.length() > 0 && (e = e.getElement(tname)) == null) {
                return null;
            }
            if (k < 0) {
                Object ret = e.setContent(null);
                Group group = e;
                while (group != this && group.getChildren().size() == 0) {
                    Group parent = group.getParent();
                    group.detach();
                    group = parent;
                }
                return ret;
            }
            j = k + 1;
        }
    }

    private static final String getTextOfChild(Object o) {
        if (!(o instanceof AbstractTextual)) {
            return "";
        }
        AbstractTextual t = (AbstractTextual)o;
        return t.isPartOfParentText() ? t.getText() : "";
    }

    @Override
    public final void setNamespace(Namespace ns) {
        Namespace old;
        if (ns == null) {
            if (this._ns != null && this._ns.getPrefix().length() == 0) {
                return;
            }
            ns = this.getNamespace("");
            if (ns == null) {
                ns = Namespace.NO_NAMESPACE;
            }
        }
        if ((old = this.getNamespace(ns.getPrefix())) != null && old.equals(ns)) {
            ns = old;
        }
        this._ns = ns;
    }

    public final void setNamespace(String prefix, String nsURI) {
        Namespace ns;
        if (nsURI == null) {
            nsURI = "";
        }
        if ((ns = this.getNamespace(prefix)) != null && ns.getURI().equals(nsURI)) {
            this.setNamespace(ns);
            return;
        }
        this.setNamespace(new Namespace(prefix, nsURI));
    }

    @Override
    public final Namespace getNamespace() {
        return this._ns;
    }

    @Override
    public final String getTagName() {
        return this._ns.tagNameOf(this._lname);
    }

    @Override
    public final void setTagName(String tname) {
        int kp = tname.indexOf(58);
        String prefix = kp >= 0 ? tname.substring(0, kp) : "";
        String lname = kp >= 0 ? tname.substring(kp + 1) : tname;
        this.setPrefix(prefix);
        this.setLocalName(lname);
    }

    @Override
    public final String getLocalName() {
        return this._lname;
    }

    @Override
    public final void setLocalName(String lname) {
        Verifier.checkElementName(lname, this.getLocator());
        this._lname = lname;
    }

    @Override
    public final String getName() {
        return this.getTagName();
    }

    @Override
    public final void setName(String tname) {
        this.setTagName(tname);
    }

    @Override
    public final String getText() {
        if (this._children.size() == 1) {
            return Element.getTextOfChild(this._children.get(0));
        }
        StringBuffer sb = new StringBuffer(256);
        Iterator it = this._children.iterator();
        while (it.hasNext()) {
            sb.append(Element.getTextOfChild(it.next()));
        }
        return sb.toString();
    }

    public final String getText(boolean trim) {
        String t = this.getText();
        return trim && t != null ? t.trim() : t;
    }

    @Override
    public final List<Attribute> getAttributeItems() {
        if (this._attrs == null) {
            this._attrs = this.newAttrArray();
        }
        return this._attrs;
    }

    protected List<Attribute> newAttrArray() {
        return new AttrArray();
    }

    @Override
    public final int getAttributeIndex(int indexFrom, String namespace, String name, int mode) {
        if (this._attrs == null || indexFrom < 0 || indexFrom >= this._attrs.size()) {
            return -1;
        }
        Pattern ptn = (mode & 1) != 0 ? Pattern.compile(name) : null;
        ListIterator<Attribute> it = this._attrs.listIterator(indexFrom);
        int j = indexFrom;
        while (it.hasNext()) {
            if (Element.match((Attribute)it.next(), namespace, name, ptn, mode)) {
                return j;
            }
            ++j;
        }
        return -1;
    }

    @Override
    public final int getAttributeIndex(int indexFrom, String tname) {
        return this.getAttributeIndex(indexFrom, null, tname, 4);
    }

    @Override
    public final Attribute getAttributeItem(String namespace, String name, int mode) {
        int j = this.getAttributeIndex(0, namespace, name, mode);
        return j >= 0 ? this._attrs.get(j) : null;
    }

    @Override
    public final Attribute getAttributeItem(String tname) {
        int j = this.getAttributeIndex(0, tname);
        return j >= 0 ? this._attrs.get(j) : null;
    }

    @Override
    public final List<Attribute> getAttributes(String namespace, String name, int mode) {
        if (this._attrs == null) {
            return Collections.emptyList();
        }
        Pattern ptn = (mode & 1) != 0 ? Pattern.compile(name) : null;
        LinkedList<Attribute> list = new LinkedList<Attribute>();
        for (Attribute attr : this._attrs) {
            if (!Element.match(attr, namespace, name, ptn, mode)) continue;
            list.add(attr);
        }
        return list;
    }

    @Override
    public final Attribute setAttribute(Attribute attr) {
        int j = this.getAttributeIndex(0, attr.getTagName());
        if (j >= 0) {
            return this.getAttributeItems().set(j, attr);
        }
        this.getAttributeItems().add(attr);
        return null;
    }

    @Override
    public final String getAttributeValue(String namespace, String name, int mode) {
        Attribute attr = this.getAttributeItem(namespace, name, mode);
        return attr != null ? attr.getValue() : null;
    }

    @Override
    public final String getAttributeValue(String tname) {
        Attribute attr = this.getAttributeItem(tname);
        return attr != null ? attr.getValue() : null;
    }

    @Override
    public final Attribute setAttributeValue(String tname, String value) {
        Attribute attr = this.getAttributeItem(tname);
        if (attr != null) {
            attr.setValue(value);
        } else {
            this.getAttributeItems().add(new Attribute(tname, value));
        }
        return attr;
    }

    @Override
    public Object clone() {
        Element elem = (Element)super.clone();
        if (this._addNamespaces != null) {
            elem._addNamespaces = new LinkedHashMap<String, Namespace>(this._addNamespaces);
        }
        if (this._attrs != null) {
            elem._attrs = elem.newAttrArray();
            for (Attribute attr : this._attrs) {
                elem._attrs.add((Attribute)attr.clone());
            }
        }
        return elem;
    }

    @Override
    public final short getNodeType() {
        return 1;
    }

    @Override
    public final String getNodeValue() {
        return null;
    }

    @Override
    public final NamedNodeMap getAttributes() {
        return new AttrMap();
    }

    @Override
    public final boolean hasAttributes() {
        return this._attrs != null && !this._attrs.isEmpty();
    }

    @Override
    public final String getNamespaceURI() {
        return this._ns.getURI();
    }

    @Override
    public final String getPrefix() {
        return this._ns.getPrefix();
    }

    @Override
    public final void setPrefix(String prefix) {
        this.setNamespace(prefix, this._ns.getURI());
    }

    @Override
    public final NodeList getElementsByTagName(String tname) {
        return new FacadeNodeList(this.getElements(null, tname, 260));
    }

    @Override
    public final NodeList getElementsByTagNameNS(String nsURI, String lname) {
        return new FacadeNodeList(this.getElements(nsURI, lname, 256));
    }

    @Override
    public final Attr getAttributeNode(String tname) {
        return this.getAttributeItem(tname);
    }

    @Override
    public final Attr getAttributeNodeNS(String nsURI, String lname) {
        return this.getAttributeItem(nsURI, lname, 0);
    }

    @Override
    public final String getAttribute(String tname) {
        String val = this.getAttributeValue(tname);
        return val != null ? val : "";
    }

    @Override
    public final String getAttributeNS(String nsURI, String lname) {
        Attribute attr = this.getAttributeItem(nsURI, lname, 0);
        return attr != null ? attr.getValue() : "";
    }

    @Override
    public final void setAttribute(String tname, String value) {
        this.setAttributeValue(tname, value);
    }

    @Override
    public final void setAttributeNS(String nsURI, String tname, String value) {
        int kp = tname.indexOf(58);
        String prefix = kp >= 0 ? tname.substring(0, kp) : "";
        String lname = kp >= 0 ? tname.substring(kp + 1) : tname;
        Attribute attr = this.getAttributeItem(nsURI, lname, 0);
        if (attr != null) {
            attr.setPrefix(prefix);
            attr.setValue(value);
        } else {
            this.getAttributeItems().add(new Attribute(nsURI, tname, value));
        }
    }

    @Override
    public final Attr setAttributeNode(Attr newAttr) {
        return this.setAttribute((Attribute)newAttr);
    }

    @Override
    public final Attr setAttributeNodeNS(Attr newAttr) {
        Attribute attr = (Attribute)newAttr;
        int j = this.getAttributeIndex(0, attr.getNamespace().getURI(), attr.getLocalName(), 0);
        if (j >= 0) {
            return this.getAttributeItems().set(j, (Attribute)newAttr);
        }
        this.getAttributeItems().add((Attribute)newAttr);
        return null;
    }

    @Override
    public final void removeAttribute(String tname) {
        int j = this.getAttributeIndex(0, tname);
        if (j >= 0) {
            this._attrs.remove(j);
        }
    }

    @Override
    public final void removeAttributeNS(String nsURI, String lname) {
        int j = this.getAttributeIndex(0, nsURI, lname, 0);
        if (j >= 0) {
            this._attrs.remove(j);
        }
    }

    @Override
    public final Attr removeAttributeNode(Attr oldAttr) {
        Attribute attr = (Attribute)oldAttr;
        int j = this.getAttributeIndex(0, attr.getTagName());
        if (j >= 0) {
            return this._attrs.remove(j);
        }
        throw new DOMException(8, this.getLocator());
    }

    @Override
    public final boolean hasAttribute(String tname) {
        return this.getAttributeIndex(0, tname) >= 0;
    }

    @Override
    public final boolean hasAttributeNS(String nsURI, String lname) {
        return this.getAttributeIndex(0, nsURI, lname, 0) >= 0;
    }

    public final String toString() {
        StringBuffer sb = new StringBuffer(64).append("[Element: <").append(this.getTagName());
        String uri = this.getNamespace().getURI();
        if (uri.length() != 0) {
            sb.append(" [").append(uri).append(']');
        }
        if (this._attrs != null) {
            for (Attribute attr : this._attrs) {
                sb.append(' ').append(attr.getTagName()).append("=\"").append(attr.getValue()).append('\"');
            }
        }
        return sb.append("/>]").toString();
    }

    @Override
    public TypeInfo getSchemaTypeInfo() {
        throw new UnsupportedOperationException("DOM Level 3");
    }

    @Override
    public void setIdAttribute(String name, boolean isId) throws DOMException {
    }

    @Override
    public void setIdAttributeNS(String namespaceURI, String localName, boolean isId) throws DOMException {
    }

    @Override
    public void setIdAttributeNode(Attr idAttr, boolean isId) throws DOMException {
    }

    protected class AttrMap
    implements NamedNodeMap {
        protected AttrMap() {
        }

        @Override
        public final int getLength() {
            return Element.this._attrs != null ? Element.this._attrs.size() : 0;
        }

        @Override
        public final Node item(int index) {
            return index < 0 || index >= this.getLength() ? null : (Node)Element.this._attrs.get(index);
        }

        @Override
        public final Node getNamedItem(String tname) {
            return Element.this.getAttributeItem(tname);
        }

        @Override
        public final Node getNamedItemNS(String nsURI, String lname) {
            return Element.this.getAttributeItem(nsURI, lname, 0);
        }

        @Override
        public final Node removeNamedItem(String tname) {
            int j = Element.this.getAttributeIndex(0, tname);
            return j >= 0 ? (Node)Element.this._attrs.remove(j) : null;
        }

        @Override
        public final Node removeNamedItemNS(String nsURI, String lname) {
            int j = Element.this.getAttributeIndex(0, nsURI, lname, 0);
            return j >= 0 ? (Node)Element.this._attrs.remove(j) : null;
        }

        @Override
        public final Node setNamedItem(Node node) {
            return Element.this.setAttributeNode((Attr)node);
        }

        @Override
        public final Node setNamedItemNS(Node node) {
            return Element.this.setAttributeNodeNS((Attr)node);
        }
    }

    protected class AttrArray
    extends NotableLinkedList<Attribute> {
        protected AttrArray() {
        }

        @Override
        protected void onAdd(Attribute newElement, Attribute followingElement) {
            this.checkAdd(newElement, followingElement, false);
        }

        @Override
        protected void onSet(Attribute newElement, Attribute replaced) {
            assert (replaced != null);
            this.checkAdd(newElement, replaced, true);
        }

        private void checkAdd(Attribute newItem, Attribute other, boolean replace) {
            if (newItem.getOwner() != null) {
                throw new DOMException(3, "Attribute, " + newItem.toString() + ", owned by other; detach or clone it", Element.this.getLocator());
            }
            int j = Element.this.getAttributeIndex(0, newItem.getTagName());
            if (!(j < 0 || replace && this.get(j) == other)) {
                throw new DOMException(3, "Attribute name, " + newItem.getTagName() + ", is conflicts with existent one (" + j + ')', Element.this.getLocator());
            }
            try {
                if (replace) {
                    this.onRemove(other);
                }
                newItem.setOwner(Element.this);
            }
            catch (RuntimeException ex) {
                Attribute attrRep;
                if (replace && (attrRep = other).getOwner() == null) {
                    attrRep.setOwner(Element.this);
                }
                throw ex;
            }
        }

        @Override
        protected void onRemove(Attribute item) {
            item.setOwner(null);
        }
    }
}

