/*
 * Decompiled with CFR 0.152.
 */
package jpiere.plugin.groupware.window;

import java.math.BigDecimal;
import java.sql.Timestamp;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import jpiere.plugin.groupware.form.TeamMemberPopup;
import jpiere.plugin.groupware.model.I_ToDo;
import jpiere.plugin.groupware.model.I_ToDoReminder;
import jpiere.plugin.groupware.model.MToDoReminder;
import jpiere.plugin.groupware.model.MToDoTeamReminder;
import jpiere.plugin.groupware.util.GroupwareToDoUtil;
import jpiere.plugin.groupware.window.PersonalToDoListWindow;
import jpiere.plugin.groupware.window.PersonalToDoReminderListWindow;
import jpiere.plugin.groupware.window.ToDoPopupWindow;
import org.adempiere.util.Callback;
import org.adempiere.webui.ClientInfo;
import org.adempiere.webui.apps.AEnv;
import org.adempiere.webui.component.Borderlayout;
import org.adempiere.webui.component.Button;
import org.adempiere.webui.component.ConfirmPanel;
import org.adempiere.webui.component.Grid;
import org.adempiere.webui.component.GridFactory;
import org.adempiere.webui.component.Label;
import org.adempiere.webui.component.Row;
import org.adempiere.webui.component.Rows;
import org.adempiere.webui.component.Timebox;
import org.adempiere.webui.component.Window;
import org.adempiere.webui.editor.WDateEditor;
import org.adempiere.webui.editor.WDatetimeEditor;
import org.adempiere.webui.editor.WEditor;
import org.adempiere.webui.editor.WNumberEditor;
import org.adempiere.webui.editor.WSearchEditor;
import org.adempiere.webui.editor.WStringEditor;
import org.adempiere.webui.editor.WTableDirEditor;
import org.adempiere.webui.editor.WTimeEditor;
import org.adempiere.webui.editor.WUrlEditor;
import org.adempiere.webui.editor.WYesNoEditor;
import org.adempiere.webui.event.ValueChangeEvent;
import org.adempiere.webui.event.ValueChangeListener;
import org.adempiere.webui.session.SessionManager;
import org.adempiere.webui.theme.ThemeManager;
import org.adempiere.webui.util.ZKUpdateUtil;
import org.adempiere.webui.window.Dialog;
import org.compiere.model.GridField;
import org.compiere.model.GridFieldVO;
import org.compiere.model.Lookup;
import org.compiere.model.MColumn;
import org.compiere.model.MLookup;
import org.compiere.model.MLookupFactory;
import org.compiere.model.MTable;
import org.compiere.model.PO;
import org.compiere.util.CLogger;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.compiere.util.Util;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.HtmlBasedComponent;
import org.zkoss.zk.ui.WrongValueException;
import org.zkoss.zk.ui.event.Event;
import org.zkoss.zk.ui.event.EventListener;
import org.zkoss.zul.Caption;
import org.zkoss.zul.Center;
import org.zkoss.zul.Div;
import org.zkoss.zul.Groupbox;
import org.zkoss.zul.Hlayout;
import org.zkoss.zul.North;
import org.zkoss.zul.South;

public class ReminderPopupWindow
extends Window
implements EventListener<Event>,
ValueChangeListener {
    private static final CLogger log = CLogger.getCLogger(ReminderPopupWindow.class);
    private Properties ctx = null;
    private ToDoPopupWindow p_TodoPopupWindow = null;
    private PersonalToDoListWindow p_PersonalTodoListWindow = null;
    private I_ToDo p_iToDo = null;
    private I_ToDoReminder i_Reminder = null;
    private int p_Reminder_ID = 0;
    private boolean p_IsPersonalToDo = false;
    private boolean p_IsNewRecord = true;
    private boolean p_IsUpdatable = false;
    private boolean p_haveParentTeamToDoReminder = false;
    private boolean p_IsUpdatebale_IsConfirmed = false;
    private boolean p_IsUpdatebale_Comments = false;
    private boolean p_IsUpdatebale_StatisticsInfo = false;
    private boolean p_IsDirty = false;
    private int p_Login_User_ID = 0;
    private int p_Add_Hours = 5;
    private int p_Add_Mins = 15;
    private North north;
    private Center center;
    private ConfirmPanel confirmPanel;
    private static final String BUTTON_NAME_ZOOM_PERSONALTODO_REMINDER = "ZOOM_P";
    private static final String BUTTON_NAME_ZOOM_TEAMTODO_REMINDER = "ZOOM_T";
    private static final String BUTTON_NAME_UNDO = "REDO";
    private static final String BUTTON_NAME_SAVE = "SAVE";
    private static final String BUTTON_NAME_DELETE = "DELETE";
    private static final String BUTTON_NAME_ADD_HOURS = "ADD_HOURS";
    private static final String BUTTON_NAME_ADD_MINS = "ADD_MINS";
    private static final String BUTTON_NAME_SHOW_TEAM_MEMBER = "SHOW_TEAM_MEMBER";
    private static final String BUTTON_NAME_SHOW_TEAM_TODO_REMINDER = "SHOW_TEAM_TODO_REMINDER";
    private Map<String, Label> map_Label = new HashMap<String, Label>();
    private Map<String, WEditor> map_Editor = new HashMap<String, WEditor>();
    private Button zoomPersonalToDoReminderBtn = null;
    private Button zoomTeamToDoReminderBtn = null;
    private Button undoBtn = null;
    private Button saveBtn = null;
    private Button deleteBtn = null;
    private Button addHoursBtn = null;
    private Button addMinsBtn = null;
    private Button showTeamMemberBtn = null;
    private Button showTeamToDoReminderBtn = null;
    private boolean mobile = false;

    public ReminderPopupWindow(PersonalToDoListWindow PersonalTodoListWindow, I_ToDo i_ToDo, int reminder_ID) {
        this.ctx = Env.getCtx();
        this.mobile = ClientInfo.isMobile();
        this.p_Login_User_ID = Env.getAD_User_ID((Properties)this.ctx);
        this.p_PersonalTodoListWindow = PersonalTodoListWindow;
        this.p_TodoPopupWindow = PersonalTodoListWindow.getToDoPopupWindow();
        this.init(i_ToDo, reminder_ID);
    }

    public ReminderPopupWindow(ToDoPopupWindow todoPopupWindow, I_ToDo i_ToDo, int reminder_ID) {
        this.ctx = Env.getCtx();
        this.mobile = ClientInfo.isMobile();
        this.p_Login_User_ID = Env.getAD_User_ID((Properties)this.ctx);
        this.p_TodoPopupWindow = todoPopupWindow;
        this.init(i_ToDo, reminder_ID);
    }

    private void init(I_ToDo i_ToDo, int reminder_ID) {
        String name;
        this.setSclass("popup-dialog request-dialog");
        this.setBorder("normal");
        this.setShadow(true);
        this.setClosable(true);
        this.setSizable(true);
        this.p_iToDo = i_ToDo;
        this.p_Reminder_ID = reminder_ID;
        this.p_IsNewRecord = reminder_ID == 0;
        if (i_ToDo.get_TableName().equals("JP_ToDo")) {
            this.p_IsPersonalToDo = true;
            this.i_Reminder = new MToDoReminder(this.ctx, reminder_ID, null);
            if (reminder_ID == 0) {
                this.i_Reminder.setAD_Org_ID(i_ToDo.getAD_Org_ID());
                this.i_Reminder.setJP_ToDo_ID(i_ToDo.get_ID());
                this.i_Reminder.setJP_ToDo_ReminderType("M");
            }
            name = GroupwareToDoUtil.trimName(this.p_iToDo.getName());
            this.setTitle("[" + Msg.getElement((Properties)this.ctx, (String)"JP_ToDo_Reminder_ID") + "] " + name);
        } else {
            this.p_IsPersonalToDo = false;
            this.i_Reminder = new MToDoTeamReminder(this.ctx, reminder_ID, null);
            if (reminder_ID == 0) {
                this.i_Reminder.setAD_Org_ID(i_ToDo.getAD_Org_ID());
                this.i_Reminder.setJP_ToDo_Team_ID(i_ToDo.get_ID());
                this.i_Reminder.setJP_ToDo_ReminderType("M");
            }
            name = GroupwareToDoUtil.trimName(this.p_iToDo.getName());
            this.setTitle("[" + Msg.getElement((Properties)this.ctx, (String)"JP_ToDo_Team_Reminder_ID") + "] " + name);
        }
        this.updateControlParameter();
        this.createLabelMap();
        this.createEditorMap();
        this.updateEditorStatus();
        this.updateEditorValue();
        Borderlayout borderlayout = new Borderlayout();
        this.appendChild((Component)borderlayout);
        ZKUpdateUtil.setHflex((HtmlBasedComponent)borderlayout, (String)"1");
        ZKUpdateUtil.setVflex((HtmlBasedComponent)borderlayout, (String)"1");
        this.north = new North();
        this.north = this.updateNorth();
        borderlayout.appendChild((Component)this.north);
        this.center = new Center();
        ZKUpdateUtil.setVflex((HtmlBasedComponent)this.center, (String)"max");
        this.center.setSclass("dialog-content");
        this.center.setAutoscroll(true);
        this.center = this.updateCenter();
        borderlayout.appendChild((Component)this.center);
        if (this.p_IsNewRecord) {
            this.p_IsNewRecord = true;
            South southPane = new South();
            southPane.setSclass("dialog-footer");
            borderlayout.appendChild((Component)southPane);
            this.confirmPanel = new ConfirmPanel(true);
            this.confirmPanel.addActionListener((EventListener)this);
            southPane.appendChild((Component)this.confirmPanel);
        }
        if (this.mobile) {
            ZKUpdateUtil.setWindowWidthX((HtmlBasedComponent)this, (int)SessionManager.getAppDesktop().getClientInfo().desktopWidth);
            ZKUpdateUtil.setWindowHeightX((HtmlBasedComponent)this, (int)SessionManager.getAppDesktop().getClientInfo().desktopHeight);
        } else {
            ZKUpdateUtil.setWindowWidthX((HtmlBasedComponent)this, (int)480);
            ZKUpdateUtil.setWindowHeightX((HtmlBasedComponent)this, (int)480);
        }
    }

    private void updateControlParameter() {
        if (this.p_IsNewRecord) {
            this.p_IsUpdatable = true;
            this.p_IsUpdatebale_Comments = true;
            this.p_haveParentTeamToDoReminder = false;
        } else {
            this.p_haveParentTeamToDoReminder = this.i_Reminder.get_TableName().equals("JP_ToDo_Reminder") ? this.i_Reminder.getJP_ToDo_Team_Reminder_ID() != 0 : false;
            this.p_IsUpdatable = this.i_Reminder.isSentReminderJP() || this.i_Reminder.isProcessed() || !this.i_Reminder.isActive() || this.p_haveParentTeamToDoReminder ? false : (this.p_iToDo.getAD_User_ID() == this.p_Login_User_ID ? true : this.i_Reminder.getCreatedBy() == this.p_Login_User_ID);
            this.p_IsUpdatebale_Comments = this.p_iToDo.getAD_User_ID() == this.p_Login_User_ID || this.i_Reminder.getCreatedBy() == this.p_Login_User_ID;
        }
        this.p_IsUpdatebale_StatisticsInfo = this.p_iToDo.getAD_User_ID() == this.p_Login_User_ID;
        this.p_IsUpdatebale_IsConfirmed = this.p_iToDo.getAD_User_ID() != this.p_Login_User_ID ? false : !this.i_Reminder.isConfirmed();
    }

    private void createLabelMap() {
        this.map_Label.put("JP_ToDo_ReminderType", new Label(Msg.getElement((Properties)this.ctx, (String)"JP_ToDo_ReminderType")));
        this.map_Label.put("JP_ToDo_RemindDate", new Label(Msg.getElement((Properties)this.ctx, (String)"JP_ToDo_RemindTime")));
        this.map_Label.put("JP_ToDo_RemindTime", new Label(Msg.getElement((Properties)this.ctx, (String)"JP_ToDo_RemindTime")));
        this.map_Label.put("JP_MailFrequency", new Label(Msg.getElement((Properties)this.ctx, (String)"JP_MailFrequency")));
        this.map_Label.put("BroadcastFrequency", new Label(Msg.getElement((Properties)this.ctx, (String)"BroadcastFrequency")));
        this.map_Label.put("Description", new Label(Msg.getElement((Properties)this.ctx, (String)"Description")));
        this.map_Label.put("URL", new Label(Msg.getElement((Properties)this.ctx, (String)"URL")));
        this.map_Label.put("IsSentReminderJP", new Label(Msg.getElement((Properties)this.ctx, (String)"IsSentReminderJP")));
        this.map_Label.put("IsConfirmed", new Label(Msg.getElement((Properties)this.ctx, (String)"IsConfirmed")));
        this.map_Label.put("JP_Confirmed", new Label(Msg.getElement((Properties)this.ctx, (String)"JP_Confirmed")));
        if (this.p_IsPersonalToDo) {
            this.map_Label.put("Comments", new Label(Msg.getElement((Properties)this.ctx, (String)"Comments")));
            this.map_Label.put("IsConfirmed", new Label(Msg.getElement((Properties)this.ctx, (String)"IsConfirmed")));
            this.map_Label.put("JP_Statistics_YesNo", new Label(Msg.getElement((Properties)this.ctx, (String)"JP_Statistics_YesNo")));
            this.map_Label.put("JP_Statistics_Choice", new Label(Msg.getElement((Properties)this.ctx, (String)"JP_Statistics_Choice")));
            this.map_Label.put("JP_Statistics_DateAndTime", new Label(Msg.getElement((Properties)this.ctx, (String)"JP_Statistics_DateAndTime")));
            this.map_Label.put("JP_Statistics_Number", new Label(Msg.getElement((Properties)this.ctx, (String)"JP_Statistics_Number")));
        } else {
            this.map_Label.put("JP_ToDo_RemindTarget", new Label(Msg.getElement((Properties)this.ctx, (String)"JP_ToDo_RemindTarget")));
            this.map_Label.put("JP_Mandatory_Statistics_Info", new Label(Msg.getElement((Properties)this.ctx, (String)"JP_Mandatory_Statistics_Info")));
            this.map_Label.put("JP_Team_ID", new Label(Msg.getElement((Properties)this.ctx, (String)"JP_Team_ID")));
        }
    }

    private void createEditorMap() {
        MLookup lookup_JP_ToDo_ReminderType = MLookupFactory.get((Properties)Env.getCtx(), (int)0, (int)0, (int)MColumn.getColumn_ID((String)"JP_ToDo_Reminder", (String)"JP_ToDo_ReminderType"), (int)17);
        WTableDirEditor editor_JP_ToDo_ReminderType = new WTableDirEditor("JP_ToDo_ReminderType", true, this.p_haveParentTeamToDoReminder ? true : !this.p_IsUpdatable, true, (Lookup)lookup_JP_ToDo_ReminderType);
        editor_JP_ToDo_ReminderType.addValueChangeListener((ValueChangeListener)this);
        ZKUpdateUtil.setHflex((HtmlBasedComponent)editor_JP_ToDo_ReminderType.getComponent(), (String)"true");
        this.map_Editor.put("JP_ToDo_ReminderType", (WEditor)editor_JP_ToDo_ReminderType);
        WDateEditor editor_JP_ToDo_RemindDate = new WDateEditor("JP_ToDo_RemindDate", false, this.p_haveParentTeamToDoReminder ? true : !this.p_IsUpdatable, true, null);
        editor_JP_ToDo_RemindDate.addValueChangeListener((ValueChangeListener)this);
        ZKUpdateUtil.setHflex((HtmlBasedComponent)editor_JP_ToDo_RemindDate.getComponent(), (String)"true");
        this.map_Editor.put("JP_ToDo_RemindDate", (WEditor)editor_JP_ToDo_RemindDate);
        WTimeEditor editor_JP_ToDo_RemindTime = new WTimeEditor("JP_ToDo_RemindTime", false, this.p_haveParentTeamToDoReminder ? true : !this.p_IsUpdatable, true, null);
        editor_JP_ToDo_RemindTime.addValueChangeListener((ValueChangeListener)this);
        ZKUpdateUtil.setHflex((HtmlBasedComponent)editor_JP_ToDo_RemindTime.getComponent(), (String)"true");
        Timebox reminderTimebox = editor_JP_ToDo_RemindTime.getComponent();
        reminderTimebox.setFormat("HH:mm");
        this.map_Editor.put("JP_ToDo_RemindTime", (WEditor)editor_JP_ToDo_RemindTime);
        MLookup lookup_MailFrequency = MLookupFactory.get((Properties)Env.getCtx(), (int)0, (int)0, (int)MColumn.getColumn_ID((String)"JP_ToDo_Reminder", (String)"JP_MailFrequency"), (int)17);
        WTableDirEditor editor_MailFrequency = new WTableDirEditor("JP_MailFrequency", true, this.p_haveParentTeamToDoReminder ? true : !this.p_IsUpdatable, true, (Lookup)lookup_MailFrequency);
        editor_MailFrequency.addValueChangeListener((ValueChangeListener)this);
        ZKUpdateUtil.setHflex((HtmlBasedComponent)editor_MailFrequency.getComponent(), (String)"true");
        this.map_Editor.put("JP_MailFrequency", (WEditor)editor_MailFrequency);
        MLookup lookup_BroadcastFrequency = MLookupFactory.get((Properties)Env.getCtx(), (int)0, (int)0, (int)MColumn.getColumn_ID((String)"JP_ToDo_Reminder", (String)"BroadcastFrequency"), (int)17);
        WTableDirEditor editor_BroadcastFrequency = new WTableDirEditor("BroadcastFrequency", true, this.p_haveParentTeamToDoReminder ? true : !this.p_IsUpdatable, true, (Lookup)lookup_BroadcastFrequency);
        editor_BroadcastFrequency.addValueChangeListener((ValueChangeListener)this);
        ZKUpdateUtil.setHflex((HtmlBasedComponent)editor_BroadcastFrequency.getComponent(), (String)"true");
        this.map_Editor.put("BroadcastFrequency", (WEditor)editor_BroadcastFrequency);
        WStringEditor editor_Description = new WStringEditor("Description", true, this.p_haveParentTeamToDoReminder ? true : !this.p_IsUpdatable, true, 30, 30, "", null);
        editor_Description.addValueChangeListener((ValueChangeListener)this);
        ZKUpdateUtil.setHflex((HtmlBasedComponent)editor_Description.getComponent(), (String)"true");
        editor_Description.getComponent().setRows(5);
        this.map_Editor.put("Description", (WEditor)editor_Description);
        GridFieldVO gridFieldVO = GridFieldVO.createParameter((Properties)this.ctx, (int)0, (int)0, (int)0, (int)0, (String)"URL", (String)"URL", (int)40, (int)0, (boolean)false, (boolean)false, null);
        WUrlEditor editor_URL = new WUrlEditor(new GridField(gridFieldVO));
        editor_URL.addValueChangeListener((ValueChangeListener)this);
        ZKUpdateUtil.setHflex((HtmlBasedComponent)editor_URL.getComponent(), (String)"true");
        this.map_Editor.put("URL", (WEditor)editor_URL);
        WYesNoEditor editor_IsSentReminderJP = new WYesNoEditor("IsSentReminderJP", Msg.getElement((Properties)this.ctx, (String)"IsSentReminderJP"), null, true, true, true);
        editor_IsSentReminderJP.addValueChangeListener((ValueChangeListener)this);
        this.map_Editor.put("IsSentReminderJP", (WEditor)editor_IsSentReminderJP);
        WYesNoEditor editor_IsConfirmed = new WYesNoEditor("IsConfirmed", Msg.getElement((Properties)this.ctx, (String)"IsConfirmed"), null, true, this.p_IsUpdatebale_IsConfirmed, true);
        editor_IsConfirmed.addValueChangeListener((ValueChangeListener)this);
        this.map_Editor.put("IsConfirmed", (WEditor)editor_IsConfirmed);
        WDatetimeEditor editor_JP_Confirmed = new WDatetimeEditor("JP_Confirmed", false, this.p_haveParentTeamToDoReminder ? true : true, true, null);
        editor_JP_Confirmed.addValueChangeListener((ValueChangeListener)this);
        ZKUpdateUtil.setHflex((HtmlBasedComponent)editor_JP_Confirmed.getComponent(), (String)"true");
        this.map_Editor.put("JP_Confirmed", (WEditor)editor_JP_Confirmed);
        if (this.p_IsPersonalToDo) {
            WStringEditor editor_Comments = new WStringEditor("Comments", true, !this.p_IsUpdatable, true, 30, 30, "", null);
            editor_Comments.addValueChangeListener((ValueChangeListener)this);
            ZKUpdateUtil.setHflex((HtmlBasedComponent)editor_Comments.getComponent(), (String)"true");
            editor_Comments.getComponent().setRows(3);
            this.map_Editor.put("Comments", (WEditor)editor_Comments);
            MLookup lookup_JP_Statistics_YesNo = MLookupFactory.get((Properties)Env.getCtx(), (int)0, (int)0, (int)MColumn.getColumn_ID((String)"JP_ToDo_Reminder", (String)"JP_Statistics_YesNo"), (int)17);
            WTableDirEditor editor_JP_Statistics_YesNo = new WTableDirEditor((Lookup)lookup_JP_Statistics_YesNo, Msg.getElement((Properties)this.ctx, (String)"JP_Statistics_YesNo"), null, false, !this.p_IsUpdatable, true);
            editor_JP_Statistics_YesNo.addValueChangeListener((ValueChangeListener)this);
            ZKUpdateUtil.setHflex((HtmlBasedComponent)editor_JP_Statistics_YesNo.getComponent(), (String)"true");
            this.map_Editor.put("JP_Statistics_YesNo", (WEditor)editor_JP_Statistics_YesNo);
            MLookup lookup_JP_Statistics_Choice = MLookupFactory.get((Properties)Env.getCtx(), (int)0, (int)0, (int)MColumn.getColumn_ID((String)"JP_ToDo_Reminder", (String)"JP_Statistics_Choice"), (int)17);
            WTableDirEditor editor_JP_Statistics_Choice = new WTableDirEditor((Lookup)lookup_JP_Statistics_Choice, Msg.getElement((Properties)this.ctx, (String)"JP_Statistics_Choice"), null, false, !this.p_IsUpdatable, true);
            editor_JP_Statistics_Choice.addValueChangeListener((ValueChangeListener)this);
            ZKUpdateUtil.setHflex((HtmlBasedComponent)editor_JP_Statistics_Choice.getComponent(), (String)"true");
            this.map_Editor.put("JP_Statistics_Choice", (WEditor)editor_JP_Statistics_Choice);
            WDatetimeEditor editor_JP_Statistics_DateAndTime = new WDatetimeEditor(Msg.getElement((Properties)this.ctx, (String)"JP_Statistics_DateAndTime"), null, false, !this.p_IsUpdatable, true);
            editor_JP_Statistics_DateAndTime.addValueChangeListener((ValueChangeListener)this);
            ZKUpdateUtil.setHflex((HtmlBasedComponent)editor_JP_Statistics_DateAndTime.getComponent(), (String)"true");
            this.map_Editor.put("JP_Statistics_DateAndTime", (WEditor)editor_JP_Statistics_DateAndTime);
            WNumberEditor editor_JP_Statistics_Number = new WNumberEditor("JP_Statistics_Number", false, !this.p_IsUpdatable, true, 22, Msg.getElement((Properties)this.ctx, (String)"JP_Statistics_Number"));
            editor_JP_Statistics_Number.addValueChangeListener((ValueChangeListener)this);
            ZKUpdateUtil.setHflex((HtmlBasedComponent)editor_JP_Statistics_Number.getComponent(), (String)"true");
            this.map_Editor.put("JP_Statistics_Number", (WEditor)editor_JP_Statistics_Number);
        } else {
            MLookup lookup_JP_ToDo_ReminderTarget = MLookupFactory.get((Properties)Env.getCtx(), (int)0, (int)0, (int)MColumn.getColumn_ID((String)"JP_ToDo_Team_Reminder", (String)"JP_ToDo_RemindTarget"), (int)17);
            WTableDirEditor editor_JP_ToDo_RemindTarget = new WTableDirEditor("JP_ToDo_RemindTarget", true, this.p_haveParentTeamToDoReminder ? true : !this.p_IsUpdatable, true, (Lookup)lookup_JP_ToDo_ReminderTarget);
            editor_JP_ToDo_RemindTarget.addValueChangeListener((ValueChangeListener)this);
            ZKUpdateUtil.setHflex((HtmlBasedComponent)editor_JP_ToDo_RemindTarget.getComponent(), (String)"true");
            this.map_Editor.put("JP_ToDo_RemindTarget", (WEditor)editor_JP_ToDo_RemindTarget);
            String validationCode = "JP_Team.AD_User_ID IS NULL OR JP_Team.AD_User_ID=" + Env.getAD_User_ID((Properties)this.ctx);
            MLookup lookup_JP_Team_ID = MLookupFactory.get((Properties)Env.getCtx(), (int)0, (int)0, (int)MColumn.getColumn_ID((String)"JP_ToDo_Team_Reminder", (String)"JP_Team_ID"), (int)30);
            lookup_JP_Team_ID.getLookupInfo().ValidationCode = validationCode;
            WSearchEditor editor_JP_Team_ID = new WSearchEditor((Lookup)lookup_JP_Team_ID, Msg.getElement((Properties)this.ctx, (String)"JP_Team_ID"), null, false, !this.p_IsUpdatable, true);
            editor_JP_Team_ID.addValueChangeListener((ValueChangeListener)this);
            ZKUpdateUtil.setHflex((HtmlBasedComponent)editor_JP_Team_ID.getComponent(), (String)"true");
            this.map_Editor.put("JP_Team_ID", (WEditor)editor_JP_Team_ID);
            MLookup lookup_JP_Mandatory_Statistics_Info = MLookupFactory.get((Properties)Env.getCtx(), (int)0, (int)0, (int)MColumn.getColumn_ID((String)"JP_ToDo_Team", (String)"JP_Mandatory_Statistics_Info"), (int)17);
            WTableDirEditor editor_JP_Mandatory_Statistics_Info = new WTableDirEditor("JP_Mandatory_Statistics_Info", true, !this.p_IsUpdatable, true, (Lookup)lookup_JP_Mandatory_Statistics_Info);
            editor_JP_Mandatory_Statistics_Info.addValueChangeListener((ValueChangeListener)this);
            ZKUpdateUtil.setHflex((HtmlBasedComponent)editor_JP_Mandatory_Statistics_Info.getComponent(), (String)"true");
            this.map_Editor.put("JP_Mandatory_Statistics_Info", (WEditor)editor_JP_Mandatory_Statistics_Info);
        }
    }

    private void updateEditorStatus() {
        if (this.p_IsNewRecord) {
            this.map_Editor.get("JP_ToDo_ReminderType").setReadWrite(true);
        } else {
            this.map_Editor.get("JP_ToDo_ReminderType").setReadWrite(false);
        }
        this.map_Editor.get("JP_ToDo_RemindDate").setReadWrite(this.p_IsUpdatable);
        this.map_Editor.get("JP_ToDo_RemindTime").setReadWrite(this.p_IsUpdatable);
        this.map_Editor.get("BroadcastFrequency").setReadWrite(this.p_IsUpdatable);
        this.map_Editor.get("JP_MailFrequency").setReadWrite(this.p_IsUpdatable);
        this.map_Editor.get("Description").setReadWrite(this.p_IsUpdatable);
        this.map_Editor.get("URL").setReadWrite(this.p_IsUpdatable);
        this.map_Editor.get("IsSentReminderJP").setReadWrite(false);
        if (this.p_IsPersonalToDo) {
            this.map_Editor.get("Comments").setReadWrite(this.p_IsUpdatebale_Comments);
            this.map_Editor.get("JP_Confirmed").setReadWrite(false);
            this.map_Editor.get("JP_Statistics_YesNo").setReadWrite(this.p_IsUpdatebale_StatisticsInfo);
            this.map_Editor.get("JP_Statistics_Choice").setReadWrite(this.p_IsUpdatebale_StatisticsInfo);
            this.map_Editor.get("JP_Statistics_DateAndTime").setReadWrite(this.p_IsUpdatebale_StatisticsInfo);
            this.map_Editor.get("JP_Statistics_Number").setReadWrite(this.p_IsUpdatebale_StatisticsInfo);
        } else {
            this.map_Editor.get("JP_ToDo_RemindTarget").setReadWrite(this.p_IsUpdatable);
            this.map_Editor.get("JP_Team_ID").setReadWrite(this.p_IsUpdatable);
        }
        if (this.i_Reminder.isConfirmed()) {
            this.map_Editor.get("IsConfirmed").setReadWrite(false);
        } else {
            this.map_Editor.get("IsConfirmed").setReadWrite(this.p_IsUpdatebale_IsConfirmed);
        }
    }

    private void updateEditorValue() {
        if (this.p_IsNewRecord) {
            this.map_Editor.get("JP_ToDo_ReminderType").setValue((Object)this.i_Reminder.getJP_ToDo_ReminderType());
            this.map_Editor.get("JP_ToDo_RemindDate").removeValuechangeListener((ValueChangeListener)this);
            this.map_Editor.get("JP_ToDo_RemindDate").setValue((Object)Timestamp.valueOf(LocalDateTime.of(LocalDate.now(), LocalTime.MIN)));
            this.map_Editor.get("JP_ToDo_RemindDate").addValueChangeListener((ValueChangeListener)this);
            this.map_Editor.get("JP_ToDo_RemindTime").removeValuechangeListener((ValueChangeListener)this);
            this.map_Editor.get("JP_ToDo_RemindTime").setValue((Object)Timestamp.valueOf(LocalDateTime.of(LocalDate.now(), LocalTime.now())));
            this.map_Editor.get("JP_ToDo_RemindTime").addValueChangeListener((ValueChangeListener)this);
            this.map_Editor.get("IsSentReminderJP").setValue((Object)"N");
            this.map_Editor.get("JP_MailFrequency").setValue((Object)"J");
            this.map_Editor.get("BroadcastFrequency").setValue((Object)"J");
            if (this.p_IsPersonalToDo) {
                this.map_Editor.get("IsConfirmed").setValue((Object)"N");
                this.map_Editor.get("JP_Confirmed").setValue(null);
            } else {
                this.map_Editor.get("JP_ToDo_RemindTarget").setValue((Object)"AL");
                this.map_Editor.get("JP_Team_ID").setValue(null);
            }
        } else {
            this.map_Editor.get("JP_ToDo_ReminderType").setValue((Object)this.i_Reminder.getJP_ToDo_ReminderType());
            this.map_Editor.get("JP_ToDo_RemindDate").removeValuechangeListener((ValueChangeListener)this);
            this.map_Editor.get("JP_ToDo_RemindDate").setValue((Object)this.i_Reminder.getJP_ToDo_RemindTime());
            this.map_Editor.get("JP_ToDo_RemindDate").addValueChangeListener((ValueChangeListener)this);
            this.map_Editor.get("JP_ToDo_RemindTime").removeValuechangeListener((ValueChangeListener)this);
            this.map_Editor.get("JP_ToDo_RemindTime").setValue((Object)this.i_Reminder.getJP_ToDo_RemindTime());
            this.map_Editor.get("JP_ToDo_RemindTime").addValueChangeListener((ValueChangeListener)this);
            this.map_Editor.get("Description").setValue((Object)this.i_Reminder.getDescription());
            this.map_Editor.get("URL").setValue((Object)this.i_Reminder.getURL());
            this.map_Editor.get("IsSentReminderJP").setValue((Object)this.i_Reminder.isSentReminderJP());
            this.map_Editor.get("JP_MailFrequency").setValue((Object)this.i_Reminder.getJP_MailFrequency());
            this.map_Editor.get("BroadcastFrequency").setValue((Object)this.i_Reminder.getBroadcastFrequency());
            if (this.p_IsPersonalToDo) {
                this.map_Editor.get("Comments").setValue((Object)this.i_Reminder.getComments());
                this.map_Editor.get("JP_Statistics_YesNo").setValue((Object)this.i_Reminder.getJP_Statistics_YesNo());
                this.map_Editor.get("JP_Statistics_Choice").setValue((Object)this.i_Reminder.getJP_Statistics_Choice());
                this.map_Editor.get("JP_Statistics_DateAndTime").removeValuechangeListener((ValueChangeListener)this);
                this.map_Editor.get("JP_Statistics_DateAndTime").setValue((Object)this.i_Reminder.getJP_Statistics_DateAndTime());
                this.map_Editor.get("JP_Statistics_DateAndTime").addValueChangeListener((ValueChangeListener)this);
                this.map_Editor.get("JP_Statistics_Number").setValue((Object)this.i_Reminder.getJP_Statistics_Number());
                this.map_Editor.get("IsConfirmed").setValue((Object)this.i_Reminder.isConfirmed());
                this.map_Editor.get("JP_Confirmed").setValue((Object)this.i_Reminder.getJP_Confirmed());
            } else {
                this.map_Editor.get("JP_ToDo_RemindTarget").setValue((Object)this.i_Reminder.getJP_ToDo_RemindTarget());
                this.map_Editor.get("JP_Team_ID").setValue(this.i_Reminder.getJP_Team_ID() == 0 ? null : Integer.valueOf(this.i_Reminder.getJP_Team_ID()));
                this.map_Editor.get("JP_Mandatory_Statistics_Info").setValue((Object)this.i_Reminder.getJP_Mandatory_Statistics_Info());
            }
        }
    }

    private North updateNorth() {
        if (this.north.getFirstChild() != null) {
            this.north.getFirstChild().detach();
        }
        if (this.p_IsNewRecord) {
            return this.north;
        }
        Hlayout hlyaout = new Hlayout();
        hlyaout.setStyle("margin:2px 2px 2px 2px; padding:2px 2px 2px 2px;");
        this.north.appendChild((Component)hlyaout);
        if (this.p_IsPersonalToDo) {
            if (this.zoomPersonalToDoReminderBtn == null) {
                this.zoomPersonalToDoReminderBtn = new Button();
                if (ThemeManager.isUseFontIconForImage()) {
                    this.zoomPersonalToDoReminderBtn.setIconSclass("z-icon-Zoom");
                } else {
                    this.zoomPersonalToDoReminderBtn.setImage(ThemeManager.getThemeResource((String)"images/Zoom16.png"));
                }
                this.zoomPersonalToDoReminderBtn.setClass("btn-small");
                this.zoomPersonalToDoReminderBtn.setName(BUTTON_NAME_ZOOM_PERSONALTODO_REMINDER);
                this.zoomPersonalToDoReminderBtn.setTooltiptext(Msg.getMsg((Properties)this.ctx, (String)"JP_Zoom_To_PersonalToDoReminder"));
                this.zoomPersonalToDoReminderBtn.addEventListener("onClick", (EventListener)this);
            }
            hlyaout.appendChild((Component)this.zoomPersonalToDoReminderBtn);
        }
        if (this.zoomTeamToDoReminderBtn == null) {
            this.zoomTeamToDoReminderBtn = new Button();
            if (ThemeManager.isUseFontIconForImage()) {
                this.zoomTeamToDoReminderBtn.setIconSclass("z-icon-ZoomAcross");
            } else {
                this.zoomTeamToDoReminderBtn.setImage(ThemeManager.getThemeResource((String)"images/ZoomAcross16.png"));
            }
            this.zoomTeamToDoReminderBtn.setClass("btn-small");
            this.zoomTeamToDoReminderBtn.setName(BUTTON_NAME_ZOOM_TEAMTODO_REMINDER);
            this.zoomTeamToDoReminderBtn.setTooltiptext(Msg.getMsg((Properties)this.ctx, (String)"JP_Zoom_To_TeamToDoReminder"));
            this.zoomTeamToDoReminderBtn.addEventListener("onClick", (EventListener)this);
        }
        if (this.p_IsPersonalToDo) {
            if (this.i_Reminder.getJP_ToDo_Team_Reminder_ID() == 0) {
                this.zoomTeamToDoReminderBtn.setEnabled(false);
            } else {
                this.zoomTeamToDoReminderBtn.setEnabled(true);
            }
        } else {
            this.zoomTeamToDoReminderBtn.setEnabled(true);
        }
        hlyaout.appendChild((Component)this.zoomTeamToDoReminderBtn);
        hlyaout.appendChild((Component)GroupwareToDoUtil.getDividingLine());
        if (this.undoBtn == null) {
            this.undoBtn = new Button();
            if (ThemeManager.isUseFontIconForImage()) {
                this.undoBtn.setIconSclass("z-icon-Ignore");
            } else {
                this.undoBtn.setImage(ThemeManager.getThemeResource((String)"images/Undo16.png"));
            }
            this.undoBtn.setClass("btn-small");
            this.undoBtn.setName(BUTTON_NAME_UNDO);
            this.undoBtn.setTooltiptext(Msg.getMsg((Properties)this.ctx, (String)"Ignore"));
            this.undoBtn.addEventListener("onClick", (EventListener)this);
        }
        if (this.p_IsDirty) {
            this.undoBtn.setEnabled(true);
        } else {
            this.undoBtn.setEnabled(false);
        }
        hlyaout.appendChild((Component)this.undoBtn);
        if (this.saveBtn == null) {
            this.saveBtn = new Button();
            if (ThemeManager.isUseFontIconForImage()) {
                this.saveBtn.setIconSclass("z-icon-Save");
            } else {
                this.saveBtn.setImage(ThemeManager.getThemeResource((String)"images/Save16.png"));
            }
            this.saveBtn.setClass("btn-small");
            this.saveBtn.setName(BUTTON_NAME_SAVE);
            this.saveBtn.setTooltiptext(Msg.getMsg((Properties)this.ctx, (String)"Save"));
            this.saveBtn.addEventListener("onClick", (EventListener)this);
        }
        if (this.p_IsDirty) {
            this.saveBtn.setEnabled(true);
        } else {
            this.saveBtn.setEnabled(false);
        }
        hlyaout.appendChild((Component)this.saveBtn);
        hlyaout.appendChild((Component)GroupwareToDoUtil.getDividingLine());
        if (this.deleteBtn == null) {
            this.deleteBtn = new Button();
            if (ThemeManager.isUseFontIconForImage()) {
                this.deleteBtn.setIconSclass("z-icon-Delete");
            } else {
                this.deleteBtn.setImage(ThemeManager.getThemeResource((String)"images/Delete16.png"));
            }
            this.deleteBtn.setClass("btn-small");
            this.deleteBtn.setName(BUTTON_NAME_DELETE);
            this.deleteBtn.setTooltiptext(Msg.getMsg((Properties)this.ctx, (String)"Delete"));
            this.deleteBtn.addEventListener("onClick", (EventListener)this);
        }
        if (this.i_Reminder.isProcessed()) {
            this.deleteBtn.setEnabled(false);
        } else {
            this.deleteBtn.setEnabled(this.p_IsUpdatable);
        }
        hlyaout.appendChild((Component)this.deleteBtn);
        return this.north;
    }

    private Center updateCenter() {
        if (this.center.getFirstChild() != null) {
            this.center.getFirstChild().detach();
        }
        if (this.addHoursBtn == null) {
            this.addHoursBtn = new Button();
            this.addHoursBtn.setClass("btn-small");
            this.addHoursBtn.setName(BUTTON_NAME_ADD_HOURS);
            this.addHoursBtn.setLabel("+" + this.p_Add_Hours + Msg.getMsg((Properties)this.ctx, (String)"JP_Hours"));
            this.addHoursBtn.setVisible(this.p_haveParentTeamToDoReminder ? false : this.p_IsUpdatable);
            this.addHoursBtn.addEventListener("onClick", (EventListener)this);
            ZKUpdateUtil.setWidth((HtmlBasedComponent)this.addHoursBtn, (String)"100%");
        }
        if (this.addMinsBtn == null) {
            this.addMinsBtn = new Button();
            this.addMinsBtn.setClass("btn-small");
            this.addMinsBtn.setName(BUTTON_NAME_ADD_MINS);
            this.addMinsBtn.setLabel("+" + this.p_Add_Mins + Msg.getMsg((Properties)this.ctx, (String)"JP_Mins"));
            this.addMinsBtn.setVisible(this.p_haveParentTeamToDoReminder ? false : this.p_IsUpdatable);
            this.addMinsBtn.addEventListener("onClick", (EventListener)this);
            ZKUpdateUtil.setWidth((HtmlBasedComponent)this.addMinsBtn, (String)"100%");
        }
        if (this.showTeamMemberBtn == null) {
            this.showTeamMemberBtn = new Button();
            if (ThemeManager.isUseFontIconForImage()) {
                this.showTeamMemberBtn.setIconSclass("z-icon-BPartner");
            } else {
                this.showTeamMemberBtn.setImage(ThemeManager.getThemeResource((String)"images/BPartner16.png"));
            }
            this.showTeamMemberBtn.setClass("btn-small");
            this.showTeamMemberBtn.setStyle("float:right;");
            this.showTeamMemberBtn.setName(BUTTON_NAME_SHOW_TEAM_MEMBER);
            this.showTeamMemberBtn.setLabel(Msg.getElement((Properties)this.ctx, (String)"JP_Team_ID"));
            this.showTeamMemberBtn.setVisible(true);
            this.showTeamMemberBtn.addEventListener("onClick", (EventListener)this);
            ZKUpdateUtil.setHflex((HtmlBasedComponent)this.showTeamMemberBtn, (String)"max");
        }
        if (this.showTeamToDoReminderBtn == null) {
            this.showTeamToDoReminderBtn = new Button();
            if (ThemeManager.isUseFontIconForImage()) {
                this.showTeamToDoReminderBtn.setIconSclass("z-icon-Report");
            } else {
                this.showTeamToDoReminderBtn.setImage(ThemeManager.getThemeResource((String)"images/Report16.png"));
            }
            this.showTeamToDoReminderBtn.setName(BUTTON_NAME_SHOW_TEAM_TODO_REMINDER);
            this.showTeamToDoReminderBtn.setLabel(Msg.getMsg((Properties)this.ctx, (String)"JP_ToDo_PersonalToDoReminderList"));
            this.showTeamToDoReminderBtn.setVisible(true);
            this.showTeamToDoReminderBtn.addEventListener("onClick", (EventListener)this);
            ZKUpdateUtil.setWidth((HtmlBasedComponent)this.showTeamToDoReminderBtn, (String)"100%");
        }
        Div centerContent = new Div();
        this.center.appendChild((Component)centerContent);
        ZKUpdateUtil.setHeight((HtmlBasedComponent)centerContent, (String)"100%");
        Grid grid = GridFactory.newGridLayout();
        ZKUpdateUtil.setHeight((HtmlBasedComponent)grid, (String)"100%");
        ZKUpdateUtil.setHflex((HtmlBasedComponent)grid, (String)"1");
        centerContent.appendChild((Component)grid);
        Rows rows = grid.newRows();
        Row row = null;
        if (!this.p_IsPersonalToDo) {
            row = rows.newRow();
            rows.appendChild((Component)row);
            row.appendCellChild((Component)GroupwareToDoUtil.createLabelDiv(this.map_Label.get("JP_ToDo_RemindTarget"), true), 2);
            row.appendCellChild(this.map_Editor.get("JP_ToDo_RemindTarget").getComponent(), 4);
            row = rows.newRow();
            rows.appendChild((Component)row);
            row.appendCellChild((Component)this.showTeamMemberBtn, 2);
            row.appendCellChild(this.map_Editor.get("JP_Team_ID").getComponent(), 4);
        }
        row = rows.newRow();
        rows.appendChild((Component)row);
        row.appendCellChild((Component)GroupwareToDoUtil.createLabelDiv(this.map_Label.get("JP_ToDo_ReminderType"), true), 2);
        row.appendCellChild(this.map_Editor.get("JP_ToDo_ReminderType").getComponent(), 4);
        row = rows.newRow();
        row.appendCellChild((Component)GroupwareToDoUtil.createLabelDiv(this.map_Label.get("JP_ToDo_RemindDate"), true), 2);
        row.appendCellChild(this.map_Editor.get("JP_ToDo_RemindDate").getComponent(), 2);
        row = rows.newRow();
        row.appendCellChild((Component)new Label(""), 2);
        row.appendCellChild(this.map_Editor.get("JP_ToDo_RemindTime").getComponent(), 2);
        row.appendCellChild((Component)this.addHoursBtn, 1);
        row.appendCellChild((Component)this.addMinsBtn, 1);
        if ("B".equals(this.i_Reminder.getJP_ToDo_ReminderType())) {
            row = rows.newRow();
            rows.appendChild((Component)row);
            row.appendCellChild((Component)GroupwareToDoUtil.createLabelDiv(this.map_Label.get("BroadcastFrequency"), true), 2);
            row.appendCellChild(this.map_Editor.get("BroadcastFrequency").getComponent(), 4);
        } else if ("M".equals(this.i_Reminder.getJP_ToDo_ReminderType())) {
            row = rows.newRow();
            rows.appendChild((Component)row);
            row.appendCellChild((Component)GroupwareToDoUtil.createLabelDiv(this.map_Label.get("JP_MailFrequency"), true), 2);
            row.appendCellChild(this.map_Editor.get("JP_MailFrequency").getComponent(), 4);
        }
        row = rows.newRow();
        row.appendCellChild((Component)GroupwareToDoUtil.createLabelDiv(this.map_Label.get("Description"), true), 2);
        row.appendCellChild(this.map_Editor.get("Description").getComponent(), 4);
        row = rows.newRow();
        row.appendCellChild((Component)GroupwareToDoUtil.createLabelDiv(this.map_Label.get("URL"), false), 2);
        row.appendCellChild(this.map_Editor.get("URL").getComponent(), 4);
        if (this.p_IsPersonalToDo) {
            row = rows.newRow();
            row.appendCellChild((Component)GroupwareToDoUtil.createLabelDiv(this.map_Label.get("Comments"), false), 2);
            row.appendCellChild(this.map_Editor.get("Comments").getComponent(), 4);
        }
        if (!this.p_IsNewRecord) {
            row = rows.newRow();
            row.appendCellChild((Component)new Label(), 2);
            row.appendCellChild(this.map_Editor.get("IsSentReminderJP").getComponent(), 2);
            if (this.p_IsPersonalToDo) {
                row.appendCellChild(this.map_Editor.get("IsConfirmed").getComponent(), 2);
                row = rows.newRow();
                row.appendCellChild((Component)GroupwareToDoUtil.createLabelDiv(this.map_Label.get("JP_Confirmed"), false), 2);
                row.appendCellChild(this.map_Editor.get("JP_Confirmed").getComponent(), 4);
            }
        }
        if (!this.p_IsPersonalToDo && !this.p_IsNewRecord) {
            row = rows.newRow();
            row.appendCellChild((Component)this.showTeamToDoReminderBtn, 6);
        }
        if (this.p_IsPersonalToDo && this.p_Reminder_ID == 0) {
            return this.center;
        }
        if (this.p_IsPersonalToDo && this.p_Reminder_ID > 0) {
            MToDoReminder reminder = new MToDoReminder(this.ctx, this.p_Reminder_ID, null);
            if (reminder.getJP_ToDo_Team_Reminder_ID() == 0) {
                return this.center;
            }
            MToDoTeamReminder teamReminder = new MToDoTeamReminder(this.ctx, reminder.getJP_ToDo_Team_Reminder_ID(), null);
            if ("NO".equals(teamReminder.getJP_Mandatory_Statistics_Info())) {
                return this.center;
            }
        }
        row = rows.newRow();
        Groupbox statisticsInfo_GroupBox = new Groupbox();
        statisticsInfo_GroupBox.setOpen(true);
        row.appendCellChild((Component)statisticsInfo_GroupBox, 6);
        String caption = Msg.getMsg((Properties)Env.getCtx(), (String)"JP_StatisticsInfo");
        statisticsInfo_GroupBox.appendChild((Component)new Caption(caption));
        Grid statisticsInfo_Grid = GridFactory.newGridLayout();
        statisticsInfo_Grid.setStyle("background-color: #E9F0FF");
        statisticsInfo_Grid.setStyle("border: none");
        statisticsInfo_GroupBox.appendChild((Component)statisticsInfo_Grid);
        Rows statisticsInfo_rows = statisticsInfo_Grid.newRows();
        if (this.p_IsPersonalToDo) {
            String JP_Mandatory_Statistics_Info = null;
            if (this.i_Reminder.getJP_ToDo_Team_Reminder_ID() > 0) {
                JP_Mandatory_Statistics_Info = new MToDoTeamReminder(this.ctx, this.i_Reminder.getJP_ToDo_Team_Reminder_ID(), null).getJP_Mandatory_Statistics_Info();
            }
            if ("YN".equals(JP_Mandatory_Statistics_Info)) {
                row = statisticsInfo_rows.newRow();
                row.appendCellChild((Component)GroupwareToDoUtil.createLabelDiv(this.map_Label.get("JP_Statistics_YesNo"), true), 2);
                row.appendCellChild(this.map_Editor.get("JP_Statistics_YesNo").getComponent(), 4);
                this.map_Editor.get("JP_Statistics_YesNo").dynamicDisplay();
            }
            if ("CC".equals(JP_Mandatory_Statistics_Info)) {
                row = statisticsInfo_rows.newRow();
                row.appendCellChild((Component)GroupwareToDoUtil.createLabelDiv(this.map_Label.get("JP_Statistics_Choice"), true), 2);
                row.appendCellChild(this.map_Editor.get("JP_Statistics_Choice").getComponent(), 4);
                this.map_Editor.get("JP_Statistics_Choice").dynamicDisplay();
            }
            if ("DT".equals(JP_Mandatory_Statistics_Info)) {
                row = statisticsInfo_rows.newRow();
                row.appendCellChild((Component)GroupwareToDoUtil.createLabelDiv(this.map_Label.get("JP_Statistics_DateAndTime"), true), 2);
                row.appendCellChild(this.map_Editor.get("JP_Statistics_DateAndTime").getComponent(), 4);
            }
            if ("NM".equals(JP_Mandatory_Statistics_Info)) {
                row = statisticsInfo_rows.newRow();
                row.appendCellChild((Component)GroupwareToDoUtil.createLabelDiv(this.map_Label.get("JP_Statistics_Number"), true), 2);
                row.appendCellChild(this.map_Editor.get("JP_Statistics_Number").getComponent(), 4);
            }
        } else {
            row = statisticsInfo_rows.newRow();
            row.appendCellChild((Component)GroupwareToDoUtil.createLabelDiv(this.map_Label.get("JP_Mandatory_Statistics_Info"), false), 3);
            row.appendCellChild(this.map_Editor.get("JP_Mandatory_Statistics_Info").getComponent(), 3);
        }
        return this.center;
    }

    public void onEvent(Event event) throws Exception {
        Component comp = event.getTarget();
        if (comp instanceof Button) {
            Button btn = (Button)comp;
            String btnName = btn.getName();
            if (this.p_IsNewRecord) {
                if (btn == this.confirmPanel.getButton("Ok")) {
                    if (this.saveReminder()) {
                        this.onClose();
                        return;
                    }
                } else if (btn == this.confirmPanel.getButton("Cancel")) {
                    this.onClose();
                    return;
                }
            }
            if (BUTTON_NAME_SAVE.equals(btnName)) {
                this.saveReminder();
            } else if (BUTTON_NAME_DELETE.equals(btnName)) {
                if (this.deleteReminder()) {
                    this.onClose();
                }
            } else if (BUTTON_NAME_UNDO.equals(btnName)) {
                this.p_IsDirty = false;
                this.updateEditorValue();
                this.updateNorth();
                this.updateCenter();
            } else if (BUTTON_NAME_ADD_HOURS.equals(btnName) || BUTTON_NAME_ADD_MINS.equals(btnName)) {
                this.p_IsDirty = true;
                this.updateNorth();
                WDateEditor editor_RemindDate = (WDateEditor)this.map_Editor.get("JP_ToDo_RemindDate");
                Timestamp ts_RemindDate = editor_RemindDate.getValue();
                if (ts_RemindDate == null) {
                    String msg = String.valueOf(Msg.getMsg((Properties)Env.getCtx(), (String)"FillMandatory")) + Msg.getElement((Properties)Env.getCtx(), (String)"JP_ToDo_RemindTime");
                    throw new WrongValueException((Component)editor_RemindDate.getComponent(), msg);
                }
                WTimeEditor editor_RemindTime = (WTimeEditor)this.map_Editor.get("JP_ToDo_RemindTime");
                Timestamp ts_RemindTime = (Timestamp)editor_RemindTime.getValue();
                LocalTime local_RemindTime = null;
                if (ts_RemindTime == null) {
                    local_RemindTime = LocalTime.MIN;
                } else {
                    local_RemindTime = ts_RemindTime.toLocalDateTime().toLocalTime();
                    if (BUTTON_NAME_ADD_HOURS.equals(btnName)) {
                        local_RemindTime = local_RemindTime.plusHours(this.p_Add_Hours);
                    } else if (BUTTON_NAME_ADD_MINS.equals(btnName)) {
                        local_RemindTime = local_RemindTime.plusMinutes(this.p_Add_Mins);
                    }
                }
                ts_RemindTime = Timestamp.valueOf(LocalDateTime.of(ts_RemindDate.toLocalDateTime().toLocalDate(), local_RemindTime));
                editor_RemindDate.setValue((Object)ts_RemindTime);
                editor_RemindTime.setValue((Object)ts_RemindTime);
                editor_RemindTime.getComponent().focus();
            } else if (BUTTON_NAME_ZOOM_PERSONALTODO_REMINDER.equals(btnName)) {
                AEnv.zoom((int)MTable.getTable_ID((String)"JP_ToDo_Reminder"), (int)this.p_Reminder_ID);
                if (this.p_PersonalTodoListWindow != null) {
                    this.p_PersonalTodoListWindow.hideBusyMask();
                    this.p_PersonalTodoListWindow.dispose();
                }
                if (this.p_TodoPopupWindow != null) {
                    this.p_TodoPopupWindow.hideBusyMask();
                    this.p_TodoPopupWindow.dispose();
                }
                this.detach();
            } else if (BUTTON_NAME_ZOOM_TEAMTODO_REMINDER.equals(btnName)) {
                if (this.p_IsPersonalToDo) {
                    AEnv.zoom((int)MTable.getTable_ID((String)"JP_ToDo_Team_Reminder"), (int)this.i_Reminder.getJP_ToDo_Team_Reminder_ID());
                } else {
                    AEnv.zoom((int)MTable.getTable_ID((String)"JP_ToDo_Team_Reminder"), (int)this.p_Reminder_ID);
                }
                if (this.p_PersonalTodoListWindow != null) {
                    this.p_PersonalTodoListWindow.hideBusyMask();
                    this.p_PersonalTodoListWindow.dispose();
                }
                if (this.p_TodoPopupWindow != null) {
                    this.p_TodoPopupWindow.hideBusyMask();
                    this.p_TodoPopupWindow.dispose();
                }
                this.detach();
            } else if (BUTTON_NAME_SHOW_TEAM_MEMBER.equals(btnName)) {
                TeamMemberPopup teampMemberPopup = new TeamMemberPopup(this, this.getJP_Team_ID());
                teampMemberPopup.setPage(this.showTeamMemberBtn.getPage());
                teampMemberPopup.open((Component)this.showTeamMemberBtn, "start_before");
            } else if (BUTTON_NAME_SHOW_TEAM_TODO_REMINDER.equals(btnName)) {
                PersonalToDoReminderListWindow personalToDoReminderListWindow = new PersonalToDoReminderListWindow(this, (MToDoTeamReminder)this.i_Reminder);
                personalToDoReminderListWindow.setVisible(true);
                personalToDoReminderListWindow.setStyle("border: 2px");
                personalToDoReminderListWindow.setClosable(true);
                AEnv.showWindow((Window)personalToDoReminderListWindow);
            }
        }
    }

    private boolean saveReminder() {
        if (!this.p_IsNewRecord) {
            PO db_Reminder = null;
            db_Reminder = this.p_IsPersonalToDo ? new MToDoReminder(this.ctx, this.p_Reminder_ID, null) : new MToDoTeamReminder(this.ctx, this.p_Reminder_ID, null);
            if (this.i_Reminder.getUpdated().compareTo(db_Reminder.getUpdated()) != 0) {
                Dialog.info((int)0, (String)"JP_ToDo_CurrentToDoModified");
                this.i_Reminder.setAD_Org_ID(db_Reminder.getAD_Org_ID());
                this.i_Reminder.setJP_ToDo_ReminderType(db_Reminder.getJP_ToDo_ReminderType());
                this.i_Reminder.setJP_ToDo_RemindTime(db_Reminder.getJP_ToDo_RemindTime());
                this.i_Reminder.setDescription(db_Reminder.getDescription());
                this.i_Reminder.setURL(db_Reminder.getURL());
                this.i_Reminder.setIsActive(db_Reminder.isActive());
                this.i_Reminder.setIsSentReminderJP(db_Reminder.isSentReminderJP());
                this.i_Reminder.setProcessed(db_Reminder.isProcessed());
                this.i_Reminder.setUpdated(db_Reminder.getUpdated());
                this.i_Reminder.setBroadcastFrequency(db_Reminder.getBroadcastFrequency());
                this.i_Reminder.setJP_MailFrequency(db_Reminder.getJP_MailFrequency());
                if (this.p_IsPersonalToDo) {
                    this.i_Reminder.setIsConfirmed(db_Reminder.isConfirmed());
                    this.i_Reminder.setJP_Confirmed(db_Reminder.getJP_Confirmed());
                    this.i_Reminder.setComments(db_Reminder.getComments());
                    this.i_Reminder.setJP_Statistics_Choice(db_Reminder.getJP_Statistics_Choice());
                    this.i_Reminder.setJP_Statistics_DateAndTime(db_Reminder.getJP_Statistics_DateAndTime());
                    this.i_Reminder.setJP_Statistics_Number(db_Reminder.getJP_Statistics_Number());
                    this.i_Reminder.setJP_Statistics_YesNo(db_Reminder.getJP_Statistics_YesNo());
                } else {
                    this.i_Reminder.setJP_ToDo_RemindTarget(db_Reminder.getJP_ToDo_RemindTarget());
                    this.i_Reminder.setJP_Team_ID(db_Reminder.getJP_Team_ID());
                    this.i_Reminder.setJP_Mandatory_Statistics_Info(db_Reminder.getJP_Mandatory_Statistics_Info());
                }
                this.p_IsDirty = false;
                this.updateControlParameter();
                this.updateEditorValue();
                this.updateEditorStatus();
                this.updateNorth();
                this.updateCenter();
                return true;
            }
        }
        WEditor editor = null;
        if (!this.p_IsPersonalToDo) {
            editor = this.map_Editor.get("JP_ToDo_RemindTarget");
            if (editor.getValue() == null || Util.isEmpty((String)editor.getValue().toString())) {
                String msg = String.valueOf(Msg.getMsg((Properties)Env.getCtx(), (String)"FillMandatory")) + Msg.getElement((Properties)Env.getCtx(), (String)"JP_ToDo_RemindTarget");
                throw new WrongValueException(editor.getComponent(), msg);
            }
            this.i_Reminder.setJP_ToDo_RemindTarget((String)editor.getValue());
            editor = this.map_Editor.get("JP_Team_ID");
            if (editor.getValue() == null || (Integer)editor.getValue() == 0) {
                this.i_Reminder.setJP_Team_ID(0);
            } else {
                this.i_Reminder.setJP_Team_ID((Integer)editor.getValue());
            }
        }
        if ((editor = this.map_Editor.get("JP_ToDo_ReminderType")).getValue() == null || Util.isEmpty((String)editor.getValue().toString())) {
            String msg = String.valueOf(Msg.getMsg((Properties)Env.getCtx(), (String)"FillMandatory")) + Msg.getElement((Properties)Env.getCtx(), (String)"JP_ToDo_ReminderType");
            throw new WrongValueException(editor.getComponent(), msg);
        }
        this.i_Reminder.setJP_ToDo_ReminderType((String)editor.getValue());
        editor = this.map_Editor.get("JP_ToDo_RemindTime");
        if (editor.getValue() == null) {
            String msg = String.valueOf(Msg.getMsg((Properties)Env.getCtx(), (String)"FillMandatory")) + Msg.getElement((Properties)Env.getCtx(), (String)"JP_ToDo_RemindTime");
            throw new WrongValueException(editor.getComponent(), msg);
        }
        this.i_Reminder.setJP_ToDo_RemindTime((Timestamp)editor.getValue());
        if ("M".equals(this.i_Reminder.getJP_ToDo_ReminderType())) {
            this.i_Reminder.setBroadcastFrequency(null);
        } else {
            editor = this.map_Editor.get("BroadcastFrequency");
            if (editor.getValue() == null || Util.isEmpty((String)editor.getValue().toString())) {
                String msg = String.valueOf(Msg.getMsg((Properties)Env.getCtx(), (String)"FillMandatory")) + Msg.getElement((Properties)Env.getCtx(), (String)"BroadcastFrequency");
                throw new WrongValueException(editor.getComponent(), msg);
            }
            this.i_Reminder.setBroadcastFrequency((String)editor.getValue());
        }
        if ("BroadcastFrequency".equals(this.i_Reminder.getJP_ToDo_ReminderType())) {
            this.i_Reminder.setJP_MailFrequency(null);
        } else {
            editor = this.map_Editor.get("JP_MailFrequency");
            if (editor.getValue() == null || Util.isEmpty((String)editor.getValue().toString())) {
                String msg = String.valueOf(Msg.getMsg((Properties)Env.getCtx(), (String)"FillMandatory")) + Msg.getElement((Properties)Env.getCtx(), (String)"JP_MailFrequency");
                throw new WrongValueException(editor.getComponent(), msg);
            }
            this.i_Reminder.setJP_MailFrequency((String)editor.getValue());
        }
        editor = this.map_Editor.get("Description");
        if (editor.getValue() == null || Util.isEmpty((String)editor.getValue().toString())) {
            String msg = String.valueOf(Msg.getMsg((Properties)Env.getCtx(), (String)"FillMandatory")) + Msg.getElement((Properties)Env.getCtx(), (String)"Description");
            throw new WrongValueException(editor.getComponent(), msg);
        }
        this.i_Reminder.setDescription((String)editor.getValue());
        editor = this.map_Editor.get("URL");
        if (editor.getValue() == null || Util.isEmpty((String)editor.getValue().toString())) {
            this.i_Reminder.setURL(null);
        } else {
            this.i_Reminder.setURL(editor.getValue().toString());
        }
        if (this.p_IsPersonalToDo) {
            editor = this.map_Editor.get("Comments");
            if (editor.getValue() == null || Util.isEmpty((String)editor.getValue().toString())) {
                this.i_Reminder.setComments(null);
            } else {
                this.i_Reminder.setComments((String)editor.getValue());
            }
            editor = this.map_Editor.get("IsConfirmed");
            this.i_Reminder.setIsConfirmed((Boolean)editor.getValue());
            editor = this.map_Editor.get("JP_Statistics_YesNo");
            if (editor.getValue() == null || Util.isEmpty((String)editor.getValue().toString())) {
                this.i_Reminder.setJP_Statistics_YesNo(null);
            } else {
                this.i_Reminder.setJP_Statistics_YesNo((String)editor.getValue());
            }
            editor = this.map_Editor.get("JP_Statistics_Choice");
            if (editor.getValue() == null || Util.isEmpty((String)editor.getValue().toString())) {
                this.i_Reminder.setJP_Statistics_Choice(null);
            } else {
                this.i_Reminder.setJP_Statistics_Choice((String)editor.getValue());
            }
            editor = this.map_Editor.get("JP_Statistics_DateAndTime");
            if (editor.getValue() == null || Util.isEmpty((String)editor.getValue().toString())) {
                this.i_Reminder.setJP_Statistics_DateAndTime(null);
            } else {
                this.i_Reminder.setJP_Statistics_DateAndTime((Timestamp)editor.getValue());
            }
            editor = this.map_Editor.get("JP_Statistics_Number");
            if (editor.getValue() == null || Util.isEmpty((String)editor.getValue().toString())) {
                this.i_Reminder.setJP_Statistics_Number(null);
            } else {
                this.i_Reminder.setJP_Statistics_Number((BigDecimal)editor.getValue());
            }
        } else {
            editor = this.map_Editor.get("JP_Mandatory_Statistics_Info");
            if (editor.getValue() == null || Util.isEmpty((String)editor.getValue().toString())) {
                this.i_Reminder.setJP_Mandatory_Statistics_Info("NO");
            } else {
                this.i_Reminder.setJP_Mandatory_Statistics_Info(editor.getValue().toString());
            }
        }
        String msg = this.i_Reminder.beforeSavePreCheck(true);
        if (!Util.isEmpty((String)msg)) {
            Dialog.error((int)0, (String)"Error", (String)msg);
            return false;
        }
        if (this.i_Reminder.save()) {
            if (log.isLoggable(Level.FINE)) {
                log.fine("JP_ToDo_ID=" + this.p_iToDo.get_ID());
            }
        } else {
            Dialog.error((int)0, (String)"SaveError", (String)Msg.getMsg((Properties)this.ctx, (String)"JP_UnexpectedError"));
            return false;
        }
        this.p_IsDirty = false;
        this.updateControlParameter();
        this.updateEditorValue();
        this.updateEditorStatus();
        this.updateNorth();
        this.updateCenter();
        return true;
    }

    private boolean deleteReminder() {
        return this.i_Reminder.delete(false);
    }

    private boolean sendReminder() {
        if (!this.i_Reminder.isSentReminderJP() && !this.i_Reminder.isProcessed()) {
            Timestamp now = Timestamp.valueOf(LocalDateTime.now());
            if (this.i_Reminder.get_ID() != 0 && this.i_Reminder.getJP_ToDo_RemindTime().compareTo(now) <= 0) {
                if (this.p_IsPersonalToDo) {
                    MToDoReminder todoReminder = (MToDoReminder)this.i_Reminder;
                    if ("M".equals(todoReminder.getJP_ToDo_ReminderType())) {
                        int AD_UserMail_ID = todoReminder.sendMailRemainder();
                        if (AD_UserMail_ID > 0) {
                            todoReminder.setAD_UserMail_ID(AD_UserMail_ID);
                            todoReminder.setIsSentReminderJP(true);
                            todoReminder.saveEx();
                            Dialog.info((int)0, (String)"SendMail", (String)this.i_Reminder.getRemindMsg());
                        } else {
                            Dialog.error((int)0, (String)"Error", (String)this.i_Reminder.getRemindMsg());
                        }
                    } else if ("B".equals(todoReminder.getJP_ToDo_ReminderType())) {
                        int AD_BroadcastMessage_ID = todoReminder.sendMessageRemainder();
                        if (AD_BroadcastMessage_ID > 0) {
                            todoReminder.setAD_BroadcastMessage_ID(AD_BroadcastMessage_ID);
                            todoReminder.setIsSentReminderJP(true);
                            if ("J".equals(todoReminder.getBroadcastFrequency())) {
                                todoReminder.setProcessed(true);
                            }
                            todoReminder.saveEx();
                            Dialog.info((int)0, (String)"MessageSent", (String)this.i_Reminder.getRemindMsg());
                        } else {
                            Dialog.error((int)0, (String)"Error", (String)this.i_Reminder.getRemindMsg());
                        }
                    }
                } else {
                    MToDoTeamReminder todoReminder = (MToDoTeamReminder)this.i_Reminder;
                    if (todoReminder.createPersonalToDoRemainder()) {
                        Dialog.info((int)0, (String)"JP_CreatePersonalToDoReminder", (String)this.i_Reminder.getRemindMsg());
                    } else {
                        Dialog.error((int)0, (String)"Error", (String)this.i_Reminder.getRemindMsg());
                    }
                }
            }
        }
        return true;
    }

    public void onClose() {
        if (this.p_IsDirty) {
            Dialog.ask((int)0, (String)"SaveChanges?", (Callback)new Callback<Boolean>(){

                public void onCallback(Boolean result) {
                    if (result.booleanValue() && !ReminderPopupWindow.this.saveReminder()) {
                        return;
                    }
                    ReminderPopupWindow.this.sendReminder();
                    if (ReminderPopupWindow.this.p_TodoPopupWindow != null) {
                        ReminderPopupWindow.this.p_TodoPopupWindow.hideBusyMask();
                    } else {
                        ReminderPopupWindow.this.p_PersonalTodoListWindow.hideBusyMask();
                    }
                    ReminderPopupWindow.this.detach();
                }
            });
        } else {
            int loginUser = Env.getAD_User_ID((Properties)this.ctx);
            if (this.p_iToDo.getAD_User_ID() == loginUser || this.i_Reminder.getCreatedBy() == loginUser) {
                this.sendReminder();
            }
            if (this.p_TodoPopupWindow != null) {
                this.p_TodoPopupWindow.hideBusyMask();
            }
            if (this.p_PersonalTodoListWindow != null) {
                this.p_PersonalTodoListWindow.hideBusyMask();
            }
            super.onClose();
        }
    }

    public void valueChange(ValueChangeEvent evt) {
        String name = evt.getPropertyName();
        Object value = evt.getNewValue();
        if ("JP_ToDo_ReminderType".equals(name)) {
            this.i_Reminder.setJP_ToDo_ReminderType(value.toString());
            this.updateCenter();
        } else if ("JP_ToDo_RemindDate".equals(name) || "JP_ToDo_RemindDate".equals(name)) {
            WDateEditor editor_RemindDate = (WDateEditor)this.map_Editor.get("JP_ToDo_RemindDate");
            Timestamp ts_RemindDate = editor_RemindDate.getValue();
            if (ts_RemindDate == null) {
                String msg = String.valueOf(Msg.getMsg((Properties)Env.getCtx(), (String)"FillMandatory")) + Msg.getElement((Properties)Env.getCtx(), (String)"JP_ToDo_RemindTime");
                throw new WrongValueException((Component)editor_RemindDate.getComponent(), msg);
            }
            WTimeEditor editor_RemindTime = (WTimeEditor)this.map_Editor.get("JP_ToDo_RemindTime");
            Timestamp ts_RemindTime = (Timestamp)editor_RemindTime.getValue();
            if (ts_RemindTime == null) {
                String msg = String.valueOf(Msg.getMsg((Properties)Env.getCtx(), (String)"FillMandatory")) + Msg.getElement((Properties)Env.getCtx(), (String)"JP_ToDo_RemindTime");
                throw new WrongValueException((Component)editor_RemindDate.getComponent(), msg);
            }
            ts_RemindTime = Timestamp.valueOf(LocalDateTime.of(ts_RemindDate.toLocalDateTime().toLocalDate(), ts_RemindTime.toLocalDateTime().toLocalTime()));
            editor_RemindDate.setValue((Object)ts_RemindTime);
            editor_RemindTime.setValue((Object)ts_RemindTime);
        } else if ("URL".equals(name)) {
            this.map_Editor.get("URL").setValue((Object)value.toString());
        }
        this.p_IsDirty = true;
        this.updateNorth();
    }

    public int getJP_Team_ID() {
        Object value = this.map_Editor.get("JP_Team_ID").getValue();
        return value == null ? 0 : (Integer)value;
    }

    public ToDoPopupWindow getToDoPopupWindow() {
        return this.p_TodoPopupWindow;
    }
}

