/*
 * Decompiled with CFR 0.152.
 */
package jpiere.plugin.groupware.window;

import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Properties;
import jpiere.plugin.groupware.form.ReminderMenuPopup;
import jpiere.plugin.groupware.model.I_ToDo;
import jpiere.plugin.groupware.model.MToDo;
import jpiere.plugin.groupware.model.MToDoTeam;
import jpiere.plugin.groupware.window.PersonalToDoListModel;
import jpiere.plugin.groupware.window.PersonalToDoListRowRenderer;
import jpiere.plugin.groupware.window.PersonalToDoModel;
import jpiere.plugin.groupware.window.ToDoPopupWindow;
import org.adempiere.webui.ClientInfo;
import org.adempiere.webui.apps.AEnv;
import org.adempiere.webui.component.Borderlayout;
import org.adempiere.webui.component.Button;
import org.adempiere.webui.component.Grid;
import org.adempiere.webui.component.GridFactory;
import org.adempiere.webui.component.Label;
import org.adempiere.webui.component.Mask;
import org.adempiere.webui.component.Row;
import org.adempiere.webui.component.Rows;
import org.adempiere.webui.component.Window;
import org.adempiere.webui.event.ActionEvent;
import org.adempiere.webui.event.ActionListener;
import org.adempiere.webui.event.WTableModelEvent;
import org.adempiere.webui.event.WTableModelListener;
import org.adempiere.webui.factory.ButtonFactory;
import org.adempiere.webui.session.SessionManager;
import org.adempiere.webui.theme.ThemeManager;
import org.adempiere.webui.util.ZKUpdateUtil;
import org.compiere.model.MColumn;
import org.compiere.model.MLookupFactory;
import org.compiere.model.MTable;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Language;
import org.compiere.util.Msg;
import org.zkoss.zk.au.AuResponse;
import org.zkoss.zk.au.out.AuScript;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.HtmlBasedComponent;
import org.zkoss.zk.ui.event.Event;
import org.zkoss.zk.ui.event.EventListener;
import org.zkoss.zk.ui.util.Clients;
import org.zkoss.zul.Center;
import org.zkoss.zul.Column;
import org.zkoss.zul.Columns;
import org.zkoss.zul.Div;
import org.zkoss.zul.ListModel;
import org.zkoss.zul.North;
import org.zkoss.zul.Radio;
import org.zkoss.zul.Radiogroup;
import org.zkoss.zul.RowRenderer;
import org.zkoss.zul.South;
import org.zkoss.zul.ext.Sortable;

public class PersonalToDoListWindow
extends Window
implements EventListener<Event>,
WTableModelListener,
ActionListener,
Sortable<Object> {
    protected CLogger log = CLogger.getCLogger(((Object)((Object)this)).getClass());
    private Properties ctx = Env.getCtx();
    private Borderlayout layout = null;
    private ToDoPopupWindow todoPopupWindow = null;
    private MToDoTeam m_TeamToDo = null;
    private static final String BUTTON_NAME_ZOOM_PERSONALTODO = "ZOOM_P";
    private Button zoomPersonalToDoBtn = null;
    private boolean mobile = ClientInfo.isMobile();
    private static final long serialVersionUID = 304878472233552113L;
    private int JP_ToDO_ID = 0;
    private Mask mask = null;

    public PersonalToDoListWindow(ToDoPopupWindow todoPopupWindow, MToDoTeam todoTeam) throws Exception {
        this.todoPopupWindow = todoPopupWindow;
        this.m_TeamToDo = todoTeam;
        this.addEventListener("onWindowContainerSelectionChanged", this);
        this.addEventListener("onClose", this);
        this.setTitle(String.valueOf(Msg.getMsg((Properties)this.ctx, (String)"JP_ToDo_PersonalToDoList")) + " : " + this.m_TeamToDo.getName());
        this.setAttribute("mode", "highlighted");
        this.setBorder("normal");
        this.setClosable(true);
        this.setSizable(true);
        int height = 0;
        int width = 0;
        if (this.mobile) {
            height = SessionManager.getAppDesktop().getClientInfo().desktopHeight;
            width = SessionManager.getAppDesktop().getClientInfo().desktopWidth;
        } else {
            height = SessionManager.getAppDesktop().getClientInfo().desktopHeight * 80 / 100;
            width = SessionManager.getAppDesktop().getClientInfo().desktopWidth * 80 / 100;
        }
        ZKUpdateUtil.setWidth((HtmlBasedComponent)this, (String)(String.valueOf(width) + "px"));
        ZKUpdateUtil.setHeight((HtmlBasedComponent)this, (String)(String.valueOf(height) + "px"));
        this.setContentStyle("overflow: auto");
        this.layout = new Borderlayout();
        this.appendChild((Component)this.layout);
        North noth = new North();
        this.layout.appendChild((Component)noth);
        Center center = new Center();
        this.layout.appendChild((Component)center);
        StringBuilder sqlSELECT = new StringBuilder("SELECT ");
        StringBuilder sqlFROM = new StringBuilder(" FROM JP_ToDo ");
        StringBuilder sqlWHERE = new StringBuilder(" WHERE JP_ToDo.JP_ToDo_Team_ID = ? ");
        StringBuilder sqlOrder = new StringBuilder(" ORDER BY JP_ToDo.AD_User_ID");
        sqlSELECT.append(" JP_ToDo.JP_ToDo_ID");
        String eSql = MLookupFactory.getLookup_TableDirEmbed((Language)Env.getLanguage((Properties)this.ctx), (String)"AD_User_ID", (String)"JP_ToDo");
        sqlSELECT.append(", (").append(eSql).append(") AS User");
        sqlSELECT.append(", JP_ToDo.Comments");
        MColumn m_Column = MColumn.get((Properties)this.ctx, (String)"JP_ToDo", (String)"JP_ToDo_Status");
        int AD_Reference_Value_ID = m_Column.getAD_Reference_Value_ID();
        if (Env.isBaseLanguage((Language)Env.getLanguage((Properties)this.ctx), (String)"AD_Ref_List")) {
            sqlSELECT.append(", AD_Ref_List.Name AS JP_ToDo_Status ");
            sqlFROM.append(" LEFT OUTER JOIN  AD_Ref_List ON (JP_ToDo.JP_ToDo_Status = AD_Ref_List.Value AND AD_Ref_List.AD_Reference_ID = ?) ");
        } else {
            sqlSELECT.append(", AD_Ref_List_Trl.Name AS JP_ToDo_Status ");
            sqlFROM.append(" LEFT OUTER JOIN AD_Ref_List ON (JP_ToDo.JP_ToDo_Status = AD_Ref_List.Value AND AD_Ref_List.AD_Reference_ID = ?) ");
            sqlFROM.append(" LEFT OUTER JOIN AD_Ref_List_Trl ON (AD_Ref_List.AD_Ref_List_ID = AD_Ref_List_Trl.AD_Ref_List_ID AND AD_Ref_List_Trl.AD_Language = ?) ");
        }
        sqlSELECT.append(", JP_ToDo.JP_Statistics_YesNo AS JP_Statistics_YesNo ");
        sqlSELECT.append(", JP_ToDo.JP_Statistics_Choice AS JP_Statistics_Choice ");
        sqlSELECT.append(", JP_ToDo.JP_Statistics_DateAndTime AS JP_Statistics_DateAndTime ");
        sqlSELECT.append(", JP_ToDo.JP_Statistics_Number AS JP_Statistics_Number ");
        StringBuilder sql = sqlSELECT.append((CharSequence)sqlFROM).append((CharSequence)sqlWHERE).append((CharSequence)sqlOrder);
        ArrayList<PersonalToDoModel> list = new ArrayList<PersonalToDoModel>();
        CPreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            pstmt = DB.prepareStatement((String)sql.toString(), null);
            pstmt.setInt(1, AD_Reference_Value_ID);
            if (Env.isBaseLanguage((Language)Env.getLanguage((Properties)this.ctx), (String)"AD_Ref_List")) {
                pstmt.setInt(2, this.m_TeamToDo.get_ID());
            } else {
                pstmt.setString(2, Env.getAD_Language((Properties)this.ctx));
                pstmt.setInt(3, this.m_TeamToDo.get_ID());
            }
            rs = pstmt.executeQuery();
            PersonalToDoModel todo = null;
            while (rs.next()) {
                todo = new PersonalToDoModel();
                todo.JP_ToDo_ID = rs.getInt(1);
                todo.user = rs.getString(2);
                todo.comments = rs.getString(3);
                todo.status = rs.getString(4);
                todo.JP_Statistics_YesNo = rs.getString(5);
                todo.JP_Statistics_Choice = rs.getString(6);
                todo.JP_Statistics_DateAndTime = rs.getTimestamp(7);
                todo.JP_Statistics_Number = rs.getBigDecimal(8);
                list.add(todo);
            }
        }
        catch (Throwable throwable) {
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
            throw throwable;
        }
        DB.close((ResultSet)rs, (Statement)pstmt);
        rs = null;
        pstmt = null;
        if (list.size() == 0) {
            center.appendChild((Component)new Label(Msg.getMsg((Properties)this.ctx, (String)"not.found")));
            return;
        }
        org.zkoss.zul.Grid grid = new org.zkoss.zul.Grid();
        ZKUpdateUtil.setVflex((org.zkoss.zul.Grid)grid, (boolean)true);
        grid.setMold("paging");
        grid.setPageSize(20);
        grid.setPagingPosition("bottom");
        center.appendChild((Component)grid);
        Columns columns = new Columns();
        columns.setSizable(true);
        grid.appendChild((Component)columns);
        Column column = new Column();
        columns.appendChild((Component)column);
        column.setLabel("");
        column.setWidth("22px");
        Radiogroup radioGroup = new Radiogroup();
        column.appendChild((Component)radioGroup);
        column = new Column();
        columns.appendChild((Component)column);
        column.setLabel("");
        column.setWidth("30px");
        column = new Column();
        columns.appendChild((Component)column);
        column.setLabel(Msg.getElement((Properties)this.ctx, (String)"AD_User_ID"));
        ZKUpdateUtil.setHflex((HtmlBasedComponent)column, (String)"min");
        column = new Column();
        columns.appendChild((Component)column);
        column.setLabel(Msg.getElement((Properties)this.ctx, (String)"JP_ToDo_Status"));
        ZKUpdateUtil.setHflex((HtmlBasedComponent)column, (String)"min");
        if (!"NO".equals(this.m_TeamToDo.getJP_Mandatory_Statistics_Info())) {
            column = new Column();
            columns.appendChild((Component)column);
            column.setLabel(Msg.getElement((Properties)this.ctx, (String)"JP_Mandatory_Statistics_Info"));
            ZKUpdateUtil.setHflex((HtmlBasedComponent)column, (String)"min");
        }
        column = new Column();
        columns.appendChild((Component)column);
        column.setLabel(Msg.getElement((Properties)this.ctx, (String)"Comments"));
        PersonalToDoListModel listModel = new PersonalToDoListModel(list);
        grid.setModel((ListModel)listModel);
        PersonalToDoListRowRenderer rowRenderer = new PersonalToDoListRowRenderer(this, radioGroup);
        grid.setRowRenderer((RowRenderer)rowRenderer);
        South south = new South();
        this.layout.appendChild((Component)south);
        Grid southContent = GridFactory.newGridLayout();
        south.appendChild((Component)southContent);
        if (!this.mobile) {
            columns = new Columns();
            southContent.appendChild((Component)columns);
            int i = 0;
            while (i < 6) {
                columns.appendChild((Component)new Column());
                ++i;
            }
        }
        Rows southContentRows = new Rows();
        southContent.appendChild((Component)southContentRows);
        Row row1 = new Row();
        southContentRows.appendChild((Component)row1);
        this.zoomPersonalToDoBtn = ButtonFactory.createButton((String)Msg.getMsg((Properties)Env.getCtx(), (String)"Zoom"), null, (String)"");
        if (ThemeManager.isUseFontIconForImage()) {
            this.zoomPersonalToDoBtn.setIconSclass("z-icon-Zoom");
        } else {
            this.zoomPersonalToDoBtn.setImage(ThemeManager.getThemeResource((String)"images/Zoom24.png"));
        }
        this.zoomPersonalToDoBtn.setName(BUTTON_NAME_ZOOM_PERSONALTODO);
        this.zoomPersonalToDoBtn.setTooltiptext(Msg.getMsg((Properties)this.ctx, (String)"JP_Zoom_To_PersonalToDo"));
        this.zoomPersonalToDoBtn.addEventListener("onClick", (EventListener)this);
        this.zoomPersonalToDoBtn.setDisabled(true);
        ZKUpdateUtil.setHflex((HtmlBasedComponent)this.zoomPersonalToDoBtn, (String)"1");
        row1.appendChild((Component)this.zoomPersonalToDoBtn);
    }

    public MToDoTeam getMToDoTeam() {
        return this.m_TeamToDo;
    }

    public void tableChanged(WTableModelEvent event) {
    }

    public void setJP_ToDo_ID(int JP_ToDo_ID) {
        this.JP_ToDO_ID = JP_ToDo_ID;
        if (JP_ToDo_ID == 0) {
            this.zoomPersonalToDoBtn.setDisabled(true);
        } else {
            this.zoomPersonalToDoBtn.setDisabled(false);
        }
    }

    public void onEvent(Event event) throws Exception {
        Component comp = event.getTarget();
        if (event.getName().equals("onClose")) {
            this.dispose();
        } else if ("onCheck".equals(event.getName())) {
            if (comp instanceof Radio) {
                this.setJP_ToDo_ID((Integer)comp.getAttribute("JP_ToDo_ID"));
            }
        } else if ("onClick".equals(event.getName()) && comp instanceof Button) {
            Button btn = (Button)comp;
            if (btn.getName().equals(BUTTON_NAME_ZOOM_PERSONALTODO)) {
                AEnv.zoom((int)MTable.getTable_ID((String)"JP_ToDo"), (int)this.JP_ToDO_ID);
                this.dispose();
                this.todoPopupWindow.detach();
            } else if (btn.getName().equals("REMINDER")) {
                int JP_ToDo_ID = Integer.parseInt(btn.getAttribute("JP_ToDo_ID").toString());
                ReminderMenuPopup reminderMenuPopup = new ReminderMenuPopup(this, (I_ToDo)new MToDo(Env.getCtx(), JP_ToDo_ID, null));
                reminderMenuPopup.setPage(btn.getPage());
                reminderMenuPopup.open((Component)btn, "end_before");
            }
        }
    }

    public void showBusyMask(Window window) {
        this.appendChild((Component)this.getMask());
        StringBuilder script = new StringBuilder("var w=zk.Widget.$('#");
        script.append(this.getUuid()).append("');");
        if (window != null) {
            script.append("var d=zk.Widget.$('#").append(window.getUuid()).append("');w.busy=d;");
        } else {
            script.append("w.busy=true;");
        }
        Clients.response((AuResponse)new AuScript(script.toString()));
    }

    private Div getMask() {
        if (this.mask == null) {
            this.mask = new Mask();
        }
        return this.mask;
    }

    public void hideBusyMask() {
        if (this.mask != null && this.mask.getParent() != null) {
            this.mask.detach();
            StringBuilder script = new StringBuilder("var w=zk.Widget.$('#");
            script.append(this.getUuid()).append("');if(w) w.busy=false;");
            Clients.response((AuResponse)new AuScript(script.toString()));
        }
    }

    public void dispose() {
        this.detach();
    }

    public void actionPerformed(ActionEvent event) {
    }

    public void sort(Comparator<Object> cmpr, boolean ascending) {
    }

    public String getSortDirection(Comparator<Object> cmpr) {
        return null;
    }

    public ToDoPopupWindow getToDoPopupWindow() {
        return this.todoPopupWindow;
    }
}

