/*
 * Decompiled with CFR 0.152.
 */
package jpiere.plugin.groupware.model;

import java.sql.ResultSet;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Properties;
import jpiere.plugin.groupware.model.I_ToDoReminder;
import jpiere.plugin.groupware.model.MGroupwareUser;
import jpiere.plugin.groupware.model.MToDo;
import jpiere.plugin.groupware.model.MToDoReminderLog;
import jpiere.plugin.groupware.model.MToDoTeamReminder;
import jpiere.plugin.groupware.model.X_JP_ToDo_Reminder;
import org.adempiere.model.MBroadcastMessage;
import org.adempiere.webui.apps.AEnv;
import org.compiere.model.MClient;
import org.compiere.model.MMessage;
import org.compiere.model.MUser;
import org.compiere.model.MUserMail;
import org.compiere.model.PO;
import org.compiere.model.Query;
import org.compiere.model.X_C_NonBusinessDay;
import org.compiere.util.DB;
import org.compiere.util.DisplayType;
import org.compiere.util.EMail;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.compiere.util.Trx;
import org.compiere.util.Util;
import org.idempiere.broadcast.BroadcastMsgUtil;

public class MToDoReminder
extends X_JP_ToDo_Reminder
implements I_ToDoReminder {
    public static final String COLUMNNAME_JP_ToDo_RemindDate = "JP_ToDo_RemindDate";
    private MToDo parent = null;
    protected String m_RemindMsg = null;
    private boolean isProcessingReminder = false;

    public MToDoReminder(Properties ctx, int JP_ToDo_Reminder_ID, String trxName) {
        super(ctx, JP_ToDo_Reminder_ID, trxName);
    }

    public MToDoReminder(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public void setProcessingReminder(boolean isProcessingReminder) {
        this.isProcessingReminder = isProcessingReminder;
    }

    protected boolean beforeSave(boolean newRecord) {
        String msg = this.beforeSavePreCheck(newRecord);
        if (!Util.isEmpty((String)msg)) {
            this.log.saveError("Error", msg);
            return false;
        }
        if (newRecord) {
            this.setIsConfirmed(false);
            this.setJP_Confirmed(null);
        }
        if (!newRecord && this.is_ValueChanged("IsConfirmed") && this.isConfirmed() && this.getJP_Confirmed() == null) {
            this.setJP_Confirmed(Timestamp.valueOf(LocalDateTime.now()));
        }
        if (newRecord || this.is_ValueChanged("JP_ToDo_RemindTime") && !this.isSentReminderJP()) {
            if ("M".equals(this.getJP_ToDo_ReminderType())) {
                this.setJP_SendMailNextTime(this.getJP_ToDo_RemindTime());
            } else {
                this.setJP_SendMailNextTime(null);
            }
        }
        return true;
    }

    @Override
    public String beforeSavePreCheck(boolean newRecord) {
        MToDoTeamReminder teamToDoReminder;
        int loginUser;
        if (!newRecord && !this.isProcessingReminder && (loginUser = Env.getAD_User_ID((Properties)this.getCtx())) != this.getParent().getAD_User_ID() && loginUser != this.getParent().getCreatedBy() && loginUser != this.getCreatedBy()) {
            MMessage msg = MMessage.get((Properties)this.getCtx(), (String)"AccessCannotUpdate");
            return String.valueOf(msg.get_Translation("MsgText")) + " - " + msg.get_Translation("MsgTip");
        }
        if (this.getJP_ToDo_Team_Reminder_ID() != 0 && this.isConfirmed() && !"NO".equals((teamToDoReminder = new MToDoTeamReminder(this.getCtx(), this.getJP_ToDo_Team_Reminder_ID(), this.get_TrxName())).getJP_Mandatory_Statistics_Info())) {
            if ("YN".equals(teamToDoReminder.getJP_Mandatory_Statistics_Info())) {
                if (Util.isEmpty((String)this.getJP_Statistics_YesNo())) {
                    String msg = Msg.getElement((Properties)this.getCtx(), (String)"JP_Mandatory_Statistics_Info");
                    Object[] objs = new Object[]{Msg.getElement((Properties)Env.getCtx(), (String)"JP_Statistics_YesNo")};
                    return String.valueOf(msg) + " : " + Msg.getMsg((Properties)Env.getCtx(), (String)"JP_Mandatory", (Object[])objs);
                }
            } else if ("CC".equals(teamToDoReminder.getJP_Mandatory_Statistics_Info())) {
                if (Util.isEmpty((String)this.getJP_Statistics_Choice())) {
                    String msg = Msg.getElement((Properties)this.getCtx(), (String)"JP_Mandatory_Statistics_Info");
                    Object[] objs = new Object[]{Msg.getElement((Properties)Env.getCtx(), (String)"JP_Statistics_Choice")};
                    return String.valueOf(msg) + " : " + Msg.getMsg((Properties)Env.getCtx(), (String)"JP_Mandatory", (Object[])objs);
                }
            } else if ("DT".equals(teamToDoReminder.getJP_Mandatory_Statistics_Info())) {
                if (this.getJP_Statistics_DateAndTime() == null) {
                    String msg = Msg.getElement((Properties)this.getCtx(), (String)"JP_Mandatory_Statistics_Info");
                    Object[] objs = new Object[]{Msg.getElement((Properties)Env.getCtx(), (String)"JP_Statistics_DateAndTime")};
                    return String.valueOf(msg) + " : " + Msg.getMsg((Properties)Env.getCtx(), (String)"JP_Mandatory", (Object[])objs);
                }
            } else if ("NM".equals(teamToDoReminder.getJP_Mandatory_Statistics_Info()) && this.get_Value("JP_Statistics_Number") == null) {
                String msg = Msg.getElement((Properties)this.getCtx(), (String)"JP_Mandatory_Statistics_Info");
                Object[] objs = new Object[]{Msg.getElement((Properties)Env.getCtx(), (String)"JP_Statistics_Number")};
                return String.valueOf(msg) + " : " + Msg.getMsg((Properties)Env.getCtx(), (String)"JP_Mandatory", (Object[])objs);
            }
        }
        return null;
    }

    protected boolean beforeDelete() {
        String msg = this.beforeDeletePreCheck();
        if (!Util.isEmpty((String)msg)) {
            this.log.saveError("Error", msg);
            return false;
        }
        return true;
    }

    @Override
    public String beforeDeletePreCheck() {
        int loginUser = Env.getAD_User_ID((Properties)this.getCtx());
        if (loginUser != this.getParent().getAD_User_ID() && loginUser != this.getParent().getCreatedBy() && loginUser != this.getCreatedBy()) {
            MMessage msg = MMessage.get((Properties)this.getCtx(), (String)"AccessCannotUpdate");
            return String.valueOf(msg.get_Translation("MsgText")) + " - " + msg.get_Translation("MsgTip");
        }
        return null;
    }

    private MToDo getParent() {
        if (this.parent == null) {
            this.parent = new MToDo(this.getCtx(), this.getJP_ToDo_ID(), this.get_TrxName());
        }
        return this.parent;
    }

    public int sendMailRemainder() {
        MClient client = MClient.get((Properties)this.getCtx(), (int)this.getAD_Client_ID());
        MToDo todo = new MToDo(this.getCtx(), this.getJP_ToDo_ID(), this.get_TrxName());
        MUser to = new MUser(this.getCtx(), todo.getAD_User_ID(), this.get_TrxName());
        String subject = String.valueOf(Msg.getElement((Properties)this.getCtx(), (String)"JP_ToDo_Reminder_ID")) + " : " + todo.getName();
        StringBuilder message = new StringBuilder(todo.getName()).append(System.lineSeparator());
        try {
            if (!Util.isEmpty((String)AEnv.getApplicationUrl())) {
                message.append(AEnv.getZoomUrlTableID((PO)todo)).append(System.lineSeparator()).append(System.lineSeparator());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        SimpleDateFormat sdfV = DisplayType.getDateFormat();
        if ("S".equals(todo.getJP_ToDo_Type())) {
            Date startDate = new Date(todo.getJP_ToDo_ScheduledStartDate().getTime());
            String string_StartDate = sdfV.format(startDate);
            if (todo.isStartDateAllDayJP()) {
                message.append(Msg.getElement((Properties)this.getCtx(), (String)"JP_ToDo_ScheduledStartDate")).append(" : ").append(string_StartDate);
                message.append(System.lineSeparator());
            } else {
                message.append(Msg.getElement((Properties)this.getCtx(), (String)"JP_ToDo_ScheduledStartTime")).append(" : ").append(string_StartDate);
                String string_StartTime = todo.getJP_ToDo_ScheduledStartTime().toLocalDateTime().toLocalTime().toString();
                message.append(" ").append(string_StartTime).append(System.lineSeparator());
            }
        }
        if ("S".equals(todo.getJP_ToDo_Type()) || "T".equals(todo.getJP_ToDo_Type())) {
            Date endDate = new Date(todo.getJP_ToDo_ScheduledEndDate().getTime());
            String string_EndDate = sdfV.format(endDate);
            if (todo.isEndDateAllDayJP()) {
                message.append(Msg.getElement((Properties)this.getCtx(), (String)"JP_ToDo_ScheduledEndDate")).append(" : ").append(string_EndDate);
                message.append(System.lineSeparator());
            } else {
                message.append(Msg.getElement((Properties)this.getCtx(), (String)"JP_ToDo_ScheduledEndTime")).append(" : ").append(string_EndDate);
                String string_EndTime = todo.getJP_ToDo_ScheduledEndTime().toLocalDateTime().toLocalTime().toString();
                message.append(" ").append(string_EndTime).append(System.lineSeparator());
            }
        }
        if (!"M".equals(todo.getJP_ToDo_Type())) {
            message.append(System.lineSeparator());
        }
        if (!Util.isEmpty((String)this.getURL())) {
            message.append(String.valueOf(Msg.getElement((Properties)this.getCtx(), (String)"URL")) + " ").append(this.getURL());
            message.append(System.lineSeparator());
            message.append(System.lineSeparator());
        }
        message.append(this.getDescription()).append(System.lineSeparator()).append(System.lineSeparator());
        try {
            String reminderURL = String.valueOf(Msg.getElement((Properties)this.getCtx(), (String)"JP_ToDo_Reminder_ID")) + " : " + AEnv.getZoomUrlTableID((PO)this);
            message.append(reminderURL).append(System.lineSeparator());
        }
        catch (Exception reminderURL) {
            // empty catch block
        }
        EMail email = client.createEMail(to.getEMail(), subject, message.toString(), false);
        boolean isOK = "OK".equals(email.send());
        if (isOK) {
            this.setIsSentReminderJP(true);
        } else {
            this.m_RemindMsg = Msg.getMsg((Properties)this.getCtx(), (String)"RequestActionEMailError");
        }
        MUserMail userMail = new MUserMail(this.getCtx(), 0, this.get_TrxName());
        userMail.setMessageID("JP_ToDo_ID = " + todo.getJP_ToDo_ID() + " - " + "JP_ToDo_Reminder_ID" + " = " + this.getJP_ToDo_Reminder_ID());
        userMail.setAD_User_ID(todo.getAD_User_ID());
        userMail.setEMailFrom(client.getRequestEMail());
        userMail.setRecipientTo(to.getEMail());
        userMail.setSubject(isOK ? "" : String.valueOf(this.m_RemindMsg) + " > " + subject);
        userMail.setMailText(message.toString());
        userMail.setIsDelivered(isOK ? "Y" : "N");
        userMail.save(this.get_TrxName());
        this.setAD_UserMail_ID(userMail.getAD_UserMail_ID());
        this.isProcessingReminder = true;
        if (isOK) {
            this.updateSendMailNextTime();
        }
        this.saveEx(this.get_TrxName());
        this.isProcessingReminder = false;
        MToDoReminderLog reminderlog = new MToDoReminderLog(this.getCtx(), 0, this.get_TrxName());
        reminderlog.setJP_ToDo_Reminder_ID(this.getJP_ToDo_Reminder_ID());
        if (!isOK) {
            reminderlog.setIsError(true);
            reminderlog.setDescription(this.m_RemindMsg);
        } else {
            reminderlog.setAD_UserMail_ID(userMail.getAD_UserMail_ID());
            reminderlog.setIsError(false);
        }
        if (reminderlog.save(this.get_TrxName()) && this.get_TrxName() != null) {
            Trx.get((String)this.get_TrxName(), (boolean)true).commit();
        }
        if (isOK) {
            return userMail.getAD_UserMail_ID();
        }
        return 0;
    }

    private void updateSendMailNextTime() {
        if (!"M".equals(this.getJP_ToDo_ReminderType())) {
            return;
        }
        if ("J".equals(this.getJP_MailFrequency())) {
            this.setProcessed(true);
            return;
        }
        LocalDate date = LocalDate.now();
        LocalTime time = this.getJP_ToDo_RemindTime().toLocalDateTime().toLocalTime();
        Timestamp JP_SendMailNextTime = this.nextDay(date, time);
        if ("A".equals(this.getJP_MailFrequency())) {
            if (this.isConfirmed()) {
                this.setProcessed(true);
            } else {
                this.setJP_SendMailNextTime(JP_SendMailNextTime);
            }
        } else if ("C".equals(this.getJP_MailFrequency())) {
            if ("CO".equals(this.getParent().getJP_ToDo_Status())) {
                this.setProcessed(true);
            } else {
                this.setJP_SendMailNextTime(JP_SendMailNextTime);
            }
        } else if ("E".equals(this.getJP_MailFrequency())) {
            Timestamp scheduledEndTime = this.getParent().getJP_ToDo_ScheduledEndTime();
            if (scheduledEndTime == null) {
                this.setJP_SendMailNextTime(JP_SendMailNextTime);
            } else if (scheduledEndTime.compareTo(JP_SendMailNextTime) >= 0) {
                this.setJP_SendMailNextTime(JP_SendMailNextTime);
            } else {
                this.setProcessed(true);
            }
        } else if ("O".equals(this.getJP_MailFrequency())) {
            Timestamp scheduledEndTime = this.getParent().getJP_ToDo_ScheduledEndTime();
            if (this.isConfirmed()) {
                this.setProcessed(true);
            } else if (scheduledEndTime == null) {
                this.setJP_SendMailNextTime(JP_SendMailNextTime);
            } else if (scheduledEndTime.compareTo(JP_SendMailNextTime) >= 0) {
                this.setJP_SendMailNextTime(JP_SendMailNextTime);
            } else {
                this.setProcessed(true);
            }
        } else if ("M".equals(this.getJP_MailFrequency())) {
            Timestamp scheduledEndTime = this.getParent().getJP_ToDo_ScheduledEndTime();
            if ("CO".equals(this.getParent().getJP_ToDo_Status())) {
                this.setProcessed(true);
            } else if (scheduledEndTime == null) {
                this.setJP_SendMailNextTime(JP_SendMailNextTime);
            } else if (scheduledEndTime.compareTo(JP_SendMailNextTime) >= 0) {
                this.setJP_SendMailNextTime(JP_SendMailNextTime);
            } else {
                this.setProcessed(true);
            }
        }
    }

    private Timestamp nextDay(LocalDate localDate, LocalTime localTime) {
        boolean isNonBusinessDay = true;
        while (isNonBusinessDay) {
            localDate = localDate.plusDays(1L);
            isNonBusinessDay = this.checkNonBusinessDay(localDate);
        }
        return Timestamp.valueOf(LocalDateTime.of(localDate, localTime));
    }

    private boolean checkNonBusinessDay(LocalDate localDate) {
        MGroupwareUser m_GroupwareUser = MGroupwareUser.get(this.getCtx(), this.getParent().getAD_User_ID());
        if (m_GroupwareUser == null) {
            return false;
        }
        StringBuilder whereClause = null;
        StringBuilder orderClause = null;
        ArrayList<Comparable<Integer>> list_parameters = new ArrayList<Comparable<Integer>>();
        Object[] parameters = null;
        LocalDateTime toDayMin = LocalDateTime.of(localDate, LocalTime.MIN);
        LocalDateTime toDayMax = LocalDateTime.of(localDate, LocalTime.MAX);
        whereClause = new StringBuilder(" AD_Client_ID=? ");
        list_parameters.add(Integer.valueOf(Env.getAD_Client_ID((Properties)this.getCtx())));
        whereClause = whereClause.append(" AND C_Calendar_ID = ? ");
        list_parameters.add(Integer.valueOf(m_GroupwareUser.getJP_NonBusinessDayCalendar_ID()));
        whereClause = whereClause.append(" AND Date1 <= ? AND Date1 >= ? AND IsActive='Y' ");
        list_parameters.add(Timestamp.valueOf(toDayMax));
        list_parameters.add(Timestamp.valueOf(toDayMin));
        if (m_GroupwareUser.getC_Country_ID() == 0) {
            whereClause = whereClause.append(" AND C_Country_ID IS NULL ");
        } else {
            whereClause = whereClause.append(" AND ( C_Country_ID IS NULL OR C_Country_ID = ? ) ");
            list_parameters.add(Integer.valueOf(m_GroupwareUser.getC_Country_ID()));
        }
        parameters = list_parameters.toArray(new Object[list_parameters.size()]);
        orderClause = new StringBuilder("Date1");
        List list_NonBusinessDays = new Query(Env.getCtx(), "C_NonBusinessDay", whereClause.toString(), null).setParameters(parameters).setOrderBy(orderClause.toString()).list();
        boolean isNonBusinessDay = false;
        for (X_C_NonBusinessDay nonBusinessDay : list_NonBusinessDays) {
            if (nonBusinessDay.getDate1().toLocalDateTime().toLocalDate().compareTo(localDate) != 0) continue;
            isNonBusinessDay = true;
            break;
        }
        return isNonBusinessDay;
    }

    public int sendMessageRemainder() {
        int AD_BroadcastMessage_ID = 0;
        MBroadcastMessage bm = new MBroadcastMessage(this.getCtx(), AD_BroadcastMessage_ID, this.get_TrxName());
        bm.setAD_Org_ID(this.getAD_Org_ID());
        bm.setBroadcastType("IL");
        bm.setTarget("U");
        bm.setAD_User_ID(this.getParent().getAD_User_ID());
        int login_User_ID = Env.getAD_User_ID((Properties)this.getCtx());
        this.getParent();
        if (this.parent.getAD_User_ID() == login_User_ID) {
            bm.setBroadcastType("L");
        } else {
            bm.setBroadcastType("IL");
        }
        if (Util.isEmpty((String)this.getBroadcastFrequency())) {
            bm.setBroadcastFrequency("A");
        } else if ("A".equals(this.getBroadcastFrequency())) {
            bm.setBroadcastFrequency("A");
        } else if ("C".equals(this.getBroadcastFrequency())) {
            bm.setBroadcastFrequency("E");
            bm.setExpiration(Timestamp.valueOf("9999-12-31 00:00:00"));
        } else if ("E".equals(this.getBroadcastFrequency())) {
            bm.setBroadcastFrequency("E");
            bm.setExpiration(this.parent.getJP_ToDo_ScheduledEndTime() == null ? Timestamp.valueOf("9999-12-31 00:00:00") : this.parent.getJP_ToDo_ScheduledEndTime());
        } else if ("J".equals(this.getBroadcastFrequency())) {
            bm.setBroadcastFrequency("J");
        } else if ("M".equals(this.getBroadcastFrequency())) {
            bm.setBroadcastFrequency("E");
            bm.setExpiration(this.parent.getJP_ToDo_ScheduledEndTime() == null ? Timestamp.valueOf("9999-12-31 00:00:00") : this.parent.getJP_ToDo_ScheduledEndTime());
        } else if ("O".equals(this.getBroadcastFrequency())) {
            bm.setBroadcastFrequency("O");
            bm.setExpiration(this.parent.getJP_ToDo_ScheduledEndTime() == null ? Timestamp.valueOf("9999-12-31 00:00:00") : this.parent.getJP_ToDo_ScheduledEndTime());
        }
        SimpleDateFormat sdfV = DisplayType.getDateFormat();
        StringBuilder message = new StringBuilder();
        String p_Start = "<p class=\"z-label\">";
        String p_Start_Description = "<p class=\"z-label\" style=\"text-align:left;\">";
        String p_End = "</p>";
        String br = "<BR />";
        message.append("<h4>").append(this.parent.getName()).append(p_End).append("</h4>");
        if ("S".equals(this.parent.getJP_ToDo_Type())) {
            Date startDate = new Date(this.parent.getJP_ToDo_ScheduledStartDate().getTime());
            String string_StartDate = sdfV.format(startDate);
            if (this.parent.isStartDateAllDayJP()) {
                message.append(p_Start).append(Msg.getElement((Properties)this.getCtx(), (String)"JP_ToDo_ScheduledStartDate")).append(" : ").append(string_StartDate);
            } else {
                message.append(p_Start).append(Msg.getElement((Properties)this.getCtx(), (String)"JP_ToDo_ScheduledStartTime")).append(" : ").append(string_StartDate);
                String string_StartTime = this.parent.getJP_ToDo_ScheduledStartTime().toLocalDateTime().toLocalTime().toString();
                message.append(" ").append(string_StartTime);
            }
            message.append(p_End);
        }
        if ("S".equals(this.parent.getJP_ToDo_Type()) || "T".equals(this.parent.getJP_ToDo_Type())) {
            Date endDate = new Date(this.parent.getJP_ToDo_ScheduledEndDate().getTime());
            String string_EndDate = sdfV.format(endDate);
            if (this.parent.isEndDateAllDayJP()) {
                message.append(p_Start).append(Msg.getElement((Properties)this.getCtx(), (String)"JP_ToDo_ScheduledEndDate")).append(" : ").append(string_EndDate);
            } else {
                message.append(p_Start).append(Msg.getElement((Properties)this.getCtx(), (String)"JP_ToDo_ScheduledEndTime")).append(" : ").append(string_EndDate);
                String string_EndTime = this.parent.getJP_ToDo_ScheduledEndTime().toLocalDateTime().toLocalTime().toString();
                message.append(" ").append(string_EndTime);
            }
            message.append(p_End);
        }
        if (!Util.isEmpty((String)this.getURL())) {
            message.append(p_Start).append(String.valueOf(Msg.getElement((Properties)this.getCtx(), (String)"URL")) + " ").append("<a href=\"").append(this.getURL()).append("\"  target=\"_blank\">").append(this.getURL()).append("</a>").append(p_End);
        }
        if (!"M".equals(this.parent.getJP_ToDo_Type())) {
            message.append(br);
        }
        message.append(p_Start_Description).append(this.getDescription()).append(p_End);
        bm.setBroadcastMessage(message.toString());
        if (bm.save(this.get_TrxName())) {
            if (this.get_TrxName() != null) {
                Trx.get((String)this.get_TrxName(), (boolean)true).commit();
            }
            BroadcastMsgUtil.publishBroadcastMessage((int)bm.getAD_BroadcastMessage_ID(), (String)this.get_TrxName());
        } else {
            this.m_RemindMsg = String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"SaveError")) + Msg.getElement((Properties)this.getCtx(), (String)"AD_BroadcastMessage_ID");
            AD_BroadcastMessage_ID = -1;
        }
        AD_BroadcastMessage_ID = bm.getAD_BroadcastMessage_ID();
        if (AD_BroadcastMessage_ID > 0) {
            this.setAD_BroadcastMessage_ID(AD_BroadcastMessage_ID);
            this.setIsSentReminderJP(true);
            this.setProcessingReminder(true);
            this.saveEx(this.get_TrxName());
            this.setProcessingReminder(false);
        }
        MToDoReminderLog reminderlog = new MToDoReminderLog(this.getCtx(), 0, this.get_TrxName());
        reminderlog.setJP_ToDo_Reminder_ID(this.getJP_ToDo_Reminder_ID());
        if (AD_BroadcastMessage_ID <= 0) {
            reminderlog.setIsError(true);
            reminderlog.setDescription(this.m_RemindMsg);
        } else {
            reminderlog.setAD_BroadcastMessage_ID(AD_BroadcastMessage_ID);
            reminderlog.setIsError(false);
        }
        if (reminderlog.save(this.get_TrxName()) && this.get_TrxName() != null) {
            Trx.get((String)this.get_TrxName(), (boolean)true).commit();
        }
        return AD_BroadcastMessage_ID;
    }

    @Override
    public void setJP_Mandatory_Statistics_Info(String JP_Mandatory_Statistics_Info) {
    }

    @Override
    public String getJP_Mandatory_Statistics_Info() {
        return null;
    }

    @Override
    public void setUpdated(Timestamp updated) {
        this.set_ValueNoCheck("Updated", updated);
    }

    @Override
    public int getJP_ToDo_Team_ID() {
        return 0;
    }

    @Override
    public void setJP_ToDo_Team_ID(int JP_ToDo_Team_ID) {
    }

    @Override
    public String getRemindMsg() {
        return this.m_RemindMsg;
    }

    public static MToDoReminder getFromBroadcastMessage(Properties ctx, int AD_BroadcastMessage_ID, String trxName) {
        StringBuilder whereClauseFinal = new StringBuilder("AD_BroadcastMessage_ID=? ");
        String orderClause = "";
        MToDoReminder reminder = (MToDoReminder)new Query(ctx, "JP_ToDo_Reminder", whereClauseFinal.toString(), trxName).setParameters(new Object[]{AD_BroadcastMessage_ID}).setOrderBy(orderClause).first();
        return reminder;
    }

    @Override
    public void setJP_ToDo_RemindTarget(String JP_ToDo_RemindTarget) {
    }

    @Override
    public String getJP_ToDo_RemindTarget() {
        return null;
    }

    public boolean stopBroadcastMessage() {
        if (this.getAD_BroadcastMessage_ID() > 0) {
            MBroadcastMessage mbMessage = new MBroadcastMessage(Env.getCtx(), this.getAD_BroadcastMessage_ID(), this.get_TrxName());
            if (!mbMessage.isExpired() && mbMessage.isPublished()) {
                String sql = "UPDATE AD_Note SET Processed='Y' WHERE AD_BroadcastMessage_ID = ?";
                DB.executeUpdateEx((String)sql, (Object[])new Object[]{this.getAD_BroadcastMessage_ID()}, null);
                mbMessage.setProcessed(true);
                mbMessage.setExpired(true);
                mbMessage.saveEx();
            }
        } else {
            return false;
        }
        return true;
    }

    public boolean processedReminder() {
        this.stopBroadcastMessage();
        this.setProcessed(true);
        this.saveEx(this.get_TrxName());
        return true;
    }

    public boolean reprocessReminder() {
        if (!this.isProcessed()) {
            return false;
        }
        if ("C".equals(this.getBroadcastFrequency()) || "A".equals(this.getBroadcastFrequency()) && !this.isConfirmed()) {
            int AD_BroadcastMessage_ID = this.sendMessageRemainder();
            this.setAD_BroadcastMessage_ID(AD_BroadcastMessage_ID);
            this.setProcessed(false);
            this.saveEx(this.get_TrxName());
            return true;
        }
        if ("M".equals(this.getBroadcastFrequency()) || "E".equals(this.getBroadcastFrequency()) || "O".equals(this.getBroadcastFrequency()) && !this.isConfirmed()) {
            if (this.getParent().getJP_ToDo_ScheduledEndTime() == null || this.getParent().getJP_ToDo_ScheduledEndTime().compareTo(Timestamp.valueOf(LocalDateTime.now())) > 0) {
                int AD_BroadcastMessage_ID = this.sendMessageRemainder();
                this.setAD_BroadcastMessage_ID(AD_BroadcastMessage_ID);
                this.setProcessed(false);
                this.saveEx(this.get_TrxName());
                return true;
            }
        } else if ("J".equals(this.getBroadcastFrequency())) {
            if (!this.isSentReminderJP()) {
                this.setProcessed(false);
                this.saveEx(this.get_TrxName());
                return true;
            }
        } else {
            if ("C".equals(this.getJP_MailFrequency()) || "A".equals(this.getJP_MailFrequency()) && !this.isConfirmed()) {
                this.setProcessed(false);
                this.saveEx(this.get_TrxName());
                return true;
            }
            if ("M".equals(this.getJP_MailFrequency()) || "E".equals(this.getJP_MailFrequency()) || "O".equals(this.getJP_MailFrequency()) && !this.isConfirmed()) {
                if (this.getParent().getJP_ToDo_ScheduledEndTime() == null || this.getParent().getJP_ToDo_ScheduledEndTime().compareTo(Timestamp.valueOf(LocalDateTime.now())) > 0) {
                    this.setProcessed(false);
                    this.saveEx(this.get_TrxName());
                    return true;
                }
            } else if ("J".equals(this.getJP_MailFrequency()) && !this.isSentReminderJP()) {
                this.setProcessed(false);
                this.saveEx(this.get_TrxName());
                return true;
            }
        }
        return false;
    }

    @Override
    public int getJP_Team_ID() {
        return 0;
    }

    @Override
    public void setJP_Team_ID(int JP_Team_ID) {
    }
}

