/*
 * Decompiled with CFR 0.152.
 */
package jpiere.plugin.groupware.model;

import java.sql.ResultSet;
import java.sql.Timestamp;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import jpiere.plugin.groupware.model.I_ToDo;
import jpiere.plugin.groupware.model.MToDoCategory;
import jpiere.plugin.groupware.model.MToDoReminder;
import jpiere.plugin.groupware.model.MToDoTeam;
import jpiere.plugin.groupware.model.X_JP_ToDo;
import org.compiere.model.MMessage;
import org.compiere.model.Query;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.compiere.util.Util;

public class MToDo
extends X_JP_ToDo
implements I_ToDo {
    protected MToDoReminder[] m_ToDoReminders = null;

    public MToDo(Properties ctx, int JP_ToDo_Team_ID, String trxName) {
        super(ctx, JP_ToDo_Team_ID, trxName);
    }

    public MToDo(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    protected boolean beforeSave(boolean newRecord) {
        String msg = this.beforeSavePreCheck(newRecord);
        if (!Util.isEmpty((String)msg)) {
            this.log.saveError("Error", msg);
            return false;
        }
        return true;
    }

    @Override
    public String beforeSavePreCheck(boolean newRecord) {
        int loginUser;
        if (!newRecord && (loginUser = Env.getAD_User_ID((Properties)this.getCtx())) != this.getAD_User_ID() && loginUser != this.getCreatedBy()) {
            MMessage msg = MMessage.get((Properties)this.getCtx(), (String)"AccessCannotUpdate");
            return String.valueOf(msg.get_Translation("MsgText")) + " - " + msg.get_Translation("MsgTip");
        }
        if (Util.isEmpty((String)this.getJP_ToDo_Type())) {
            Object[] objs = new Object[]{Msg.getElement((Properties)Env.getCtx(), (String)"JP_ToDo_Type")};
            return Msg.getMsg((Properties)Env.getCtx(), (String)"JP_Mandatory", (Object[])objs);
        }
        if (this.getJP_ToDo_Category_ID() != 0 && (newRecord || this.is_ValueChanged("JP_ToDo_Category_ID")) && MToDoCategory.get(this.getCtx(), this.getJP_ToDo_Category_ID()).getAD_User_ID() != 0 && MToDoCategory.get(this.getCtx(), this.getJP_ToDo_Category_ID()).getAD_User_ID() != this.getAD_User_ID()) {
            return Msg.getMsg((Properties)this.getCtx(), (String)"JP_OtherUserToDoCategory");
        }
        if (newRecord || this.is_ValueChanged("JP_ToDo_Type") || this.is_ValueChanged("IsStartDateAllDayJP") || this.is_ValueChanged("IsEndDateAllDayJP") || this.is_ValueChanged("JP_ToDo_ScheduledStartDate") || this.is_ValueChanged("JP_ToDo_ScheduledEndDate") || this.is_ValueChanged("JP_ToDo_ScheduledStartTime") || this.is_ValueChanged("JP_ToDo_ScheduledEndTime")) {
            if ("S".equals(this.getJP_ToDo_Type())) {
                if (this.getJP_ToDo_ScheduledStartDate() == null) {
                    Object[] objs = new Object[]{Msg.getElement((Properties)Env.getCtx(), (String)"JP_ToDo_ScheduledStartDate")};
                    return Msg.getMsg((Properties)Env.getCtx(), (String)"JP_Mandatory", (Object[])objs);
                }
                LocalDate localStartDate = this.getJP_ToDo_ScheduledStartDate().toLocalDateTime().toLocalDate();
                LocalTime localStartTime = null;
                if (this.isStartDateAllDayJP()) {
                    localStartTime = LocalTime.MIN;
                } else {
                    if (this.getJP_ToDo_ScheduledStartTime() == null) {
                        Object[] objs = new Object[]{Msg.getElement((Properties)Env.getCtx(), (String)"JP_ToDo_ScheduledStartTime")};
                        return Msg.getMsg((Properties)Env.getCtx(), (String)"JP_Mandatory", (Object[])objs);
                    }
                    localStartTime = this.getJP_ToDo_ScheduledStartTime().toLocalDateTime().toLocalTime();
                }
                this.setJP_ToDo_ScheduledStartTime(Timestamp.valueOf(LocalDateTime.of(localStartDate, localStartTime)));
                this.setJP_ToDo_ScheduledStartDate(this.getJP_ToDo_ScheduledStartTime());
            }
            if ("T".equals(this.getJP_ToDo_Type()) || "S".equals(this.getJP_ToDo_Type())) {
                if (this.getJP_ToDo_ScheduledEndDate() == null) {
                    Object[] objs = new Object[]{Msg.getElement((Properties)Env.getCtx(), (String)"JP_ToDo_ScheduledEndDate")};
                    return Msg.getMsg((Properties)Env.getCtx(), (String)"JP_Mandatory", (Object[])objs);
                }
                LocalDate localEndDate = this.getJP_ToDo_ScheduledEndDate().toLocalDateTime().toLocalDate();
                LocalTime localEndTime = null;
                if (this.isEndDateAllDayJP()) {
                    localEndTime = LocalTime.MIN;
                } else {
                    if (this.getJP_ToDo_ScheduledEndTime() == null) {
                        Object[] objs = new Object[]{Msg.getElement((Properties)Env.getCtx(), (String)"JP_ToDo_ScheduledEndTime")};
                        return Msg.getMsg((Properties)Env.getCtx(), (String)"JP_Mandatory", (Object[])objs);
                    }
                    localEndTime = this.getJP_ToDo_ScheduledEndTime().toLocalDateTime().toLocalTime();
                }
                this.setJP_ToDo_ScheduledEndTime(Timestamp.valueOf(LocalDateTime.of(localEndDate, localEndTime)));
                this.setJP_ToDo_ScheduledEndDate(this.getJP_ToDo_ScheduledEndTime());
                if ("S".equals(this.getJP_ToDo_Type())) {
                    if (this.getJP_ToDo_ScheduledStartTime().after(this.getJP_ToDo_ScheduledEndTime())) {
                        return String.valueOf(Msg.getElement((Properties)this.getCtx(), (String)"JP_ToDo_ScheduledStartTime")) + " > " + Msg.getElement((Properties)this.getCtx(), (String)"JP_ToDo_ScheduledEndTime");
                    }
                } else if ("T".equals(this.getJP_ToDo_Type())) {
                    this.setJP_ToDo_ScheduledStartDate(this.getJP_ToDo_ScheduledEndDate());
                    this.setJP_ToDo_ScheduledStartTime(this.getJP_ToDo_ScheduledEndTime());
                }
            } else if ("M".equals(this.getJP_ToDo_Type())) {
                this.setJP_ToDo_ScheduledStartDate(null);
                this.setJP_ToDo_ScheduledStartTime(null);
                this.setJP_ToDo_ScheduledEndDate(null);
                this.setJP_ToDo_ScheduledEndTime(null);
            }
        }
        if (newRecord || this.is_ValueChanged("JP_ToDo_Status")) {
            if (Util.isEmpty((String)this.getJP_ToDo_Status())) {
                this.setJP_ToDo_Status("NY");
            }
            if ("NY".equals(this.getJP_ToDo_Status())) {
                this.setJP_ToDo_StartTime(null);
                this.setJP_ToDo_EndTime(null);
                this.setProcessed(false);
            } else if ("WP".equals(this.getJP_ToDo_Status())) {
                if (this.getJP_ToDo_StartTime() == null) {
                    this.setJP_ToDo_StartTime(new Timestamp(System.currentTimeMillis()));
                }
                this.setJP_ToDo_EndTime(null);
                this.setProcessed(false);
            } else if ("CO".equals(this.getJP_ToDo_Status())) {
                MToDoTeam teamToDo;
                if (this.getJP_ToDo_StartTime() == null) {
                    this.setJP_ToDo_StartTime(new Timestamp(System.currentTimeMillis()));
                }
                this.setJP_ToDo_EndTime(new Timestamp(System.currentTimeMillis()));
                this.setProcessed(true);
                if (this.getJP_ToDo_Team_ID() != 0 && !"NO".equals((teamToDo = new MToDoTeam(this.getCtx(), this.getJP_ToDo_Team_ID(), this.get_TrxName())).getJP_Mandatory_Statistics_Info())) {
                    String msg;
                    if ("YN".equals(teamToDo.getJP_Mandatory_Statistics_Info())) {
                        if (Util.isEmpty((String)this.getJP_Statistics_YesNo())) {
                            msg = Msg.getElement((Properties)this.getCtx(), (String)"JP_Mandatory_Statistics_Info");
                            Object[] objs = new Object[]{Msg.getElement((Properties)Env.getCtx(), (String)"JP_Statistics_YesNo")};
                            return String.valueOf(msg) + " : " + Msg.getMsg((Properties)Env.getCtx(), (String)"JP_Mandatory", (Object[])objs);
                        }
                    } else if ("CC".equals(teamToDo.getJP_Mandatory_Statistics_Info())) {
                        if (Util.isEmpty((String)this.getJP_Statistics_Choice())) {
                            msg = Msg.getElement((Properties)this.getCtx(), (String)"JP_Mandatory_Statistics_Info");
                            Object[] objs = new Object[]{Msg.getElement((Properties)Env.getCtx(), (String)"JP_Statistics_Choice")};
                            return String.valueOf(msg) + " : " + Msg.getMsg((Properties)Env.getCtx(), (String)"JP_Mandatory", (Object[])objs);
                        }
                    } else if ("DT".equals(teamToDo.getJP_Mandatory_Statistics_Info())) {
                        if (this.getJP_Statistics_DateAndTime() == null) {
                            msg = Msg.getElement((Properties)this.getCtx(), (String)"JP_Mandatory_Statistics_Info");
                            Object[] objs = new Object[]{Msg.getElement((Properties)Env.getCtx(), (String)"JP_Statistics_DateAndTime")};
                            return String.valueOf(msg) + " : " + Msg.getMsg((Properties)Env.getCtx(), (String)"JP_Mandatory", (Object[])objs);
                        }
                    } else if ("NM".equals(teamToDo.getJP_Mandatory_Statistics_Info()) && this.get_Value("JP_Statistics_Number") == null) {
                        msg = Msg.getElement((Properties)this.getCtx(), (String)"JP_Mandatory_Statistics_Info");
                        Object[] objs = new Object[]{Msg.getElement((Properties)Env.getCtx(), (String)"JP_Statistics_Number")};
                        return String.valueOf(msg) + " : " + Msg.getMsg((Properties)Env.getCtx(), (String)"JP_Mandatory", (Object[])objs);
                    }
                }
            }
        }
        return null;
    }

    protected boolean afterSave(boolean newRecord, boolean success) {
        if (success && !newRecord && this.is_ValueChanged("JP_ToDo_Status")) {
            if ("CO".equals(this.getJP_ToDo_Status())) {
                this.processedReminders();
            } else if ("CO".equals(this.get_ValueOld("JP_ToDo_Status"))) {
                this.reprocessReminders();
            }
        } else if (success && !newRecord && this.is_ValueChanged("Processed")) {
            if (this.isProcessed()) {
                this.processedReminders();
            } else {
                this.reprocessReminders();
            }
        }
        if (success && !newRecord && this.is_ValueChanged("IsActive")) {
            if (this.isActive()) {
                this.reactiveReminders();
            } else {
                this.inactiveReminders();
            }
        }
        return true;
    }

    public boolean reactiveReminders() {
        MToDoReminder[] reminders = this.getReminders(true);
        int i = 0;
        while (i < reminders.length) {
            reminders[i].setIsActive(true);
            if ("B".equals(reminders[i].getJP_ToDo_ReminderType())) {
                int AD_BroadcastMessage_ID = reminders[i].sendMessageRemainder();
                reminders[i].setAD_BroadcastMessage_ID(AD_BroadcastMessage_ID);
                reminders[i].setIsSentReminderJP(true);
            }
            reminders[i].saveEx();
            ++i;
        }
        return true;
    }

    public boolean inactiveReminders() {
        MToDoReminder[] reminders = this.getReminders(true);
        int i = 0;
        while (i < reminders.length) {
            reminders[i].setIsActive(false);
            reminders[i].stopBroadcastMessage();
            reminders[i].saveEx();
            ++i;
        }
        return true;
    }

    public boolean processedReminders() {
        MToDoReminder[] reminders = this.getReminders(true);
        int i = 0;
        while (i < reminders.length) {
            reminders[i].processedReminder();
            ++i;
        }
        return true;
    }

    public boolean reprocessReminders() {
        MToDoReminder[] reminders = this.getReminders(true);
        int i = 0;
        while (i < reminders.length) {
            reminders[i].reprocessReminder();
            ++i;
        }
        return true;
    }

    protected boolean beforeDelete() {
        String msg = this.beforeDeletePreCheck();
        if (!Util.isEmpty((String)msg)) {
            this.log.saveError("Error", msg);
            return false;
        }
        return true;
    }

    @Override
    public String beforeDeletePreCheck() {
        int loginUser = Env.getAD_User_ID((Properties)this.getCtx());
        if (loginUser != this.getAD_User_ID() && loginUser != this.getCreatedBy()) {
            MMessage msg = MMessage.get((Properties)this.getCtx(), (String)"AccessCannotUpdate");
            return String.valueOf(msg.get_Translation("MsgText")) + " - " + msg.get_Translation("MsgTip");
        }
        return null;
    }

    public MToDoReminder[] getReminders() {
        return this.getReminders(false);
    }

    public MToDoReminder[] getReminders(boolean requery) {
        if (this.m_ToDoReminders != null && this.m_ToDoReminders.length >= 0 && !requery) {
            return this.m_ToDoReminders;
        }
        StringBuilder whereClauseFinal = new StringBuilder("JP_ToDo_ID=? AND IsActive = 'Y'");
        List list = new Query(this.getCtx(), "JP_ToDo_Reminder", whereClauseFinal.toString(), this.get_TrxName()).setParameters(new Object[]{this.get_ID()}).list();
        this.m_ToDoReminders = list.toArray(new MToDoReminder[list.size()]);
        return this.m_ToDoReminders;
    }

    public static ArrayList<MToDo> getRelatedToDos(Properties ctx, MToDo m_ToDo, ArrayList<MToDo> list_ToDo, Timestamp time, boolean isIncludingIndirectRelationships, String trxName) {
        if (list_ToDo == null) {
            list_ToDo = new ArrayList();
        }
        StringBuilder whereClauseFinal = null;
        String orderClause = "JP_ToDo_ScheduledStartTime";
        List list = null;
        if (m_ToDo.getJP_Processing1().equals("N")) {
            whereClauseFinal = new StringBuilder(" JP_ToDo_Related_ID = ? AND JP_ToDo_ID <> ? ");
            if (time == null) {
                list = new Query(ctx, "JP_ToDo", whereClauseFinal.toString(), trxName).setParameters(new Object[]{m_ToDo.getJP_ToDo_Related_ID(), m_ToDo.getJP_ToDo_ID()}).setOrderBy(orderClause).list();
            } else {
                whereClauseFinal = whereClauseFinal.append(" AND JP_ToDo_ScheduledStartTime >= ?");
                list = new Query(ctx, "JP_ToDo", whereClauseFinal.toString(), trxName).setParameters(new Object[]{m_ToDo.getJP_ToDo_Related_ID(), m_ToDo.getJP_ToDo_ID(), time}).setOrderBy(orderClause).list();
            }
        } else {
            whereClauseFinal = new StringBuilder(" (JP_ToDo_Related_ID = ? OR JP_ToDo_Related_ID = ?) AND JP_ToDo_ID <> ? ");
            if (time == null) {
                list = new Query(ctx, "JP_ToDo", whereClauseFinal.toString(), trxName).setParameters(new Object[]{m_ToDo.getJP_ToDo_Related_ID(), m_ToDo.getJP_ToDo_ID(), m_ToDo.getJP_ToDo_ID()}).setOrderBy(orderClause).list();
            } else {
                whereClauseFinal = whereClauseFinal.append(" AND JP_ToDo_ScheduledStartTime >= ?");
                list = new Query(ctx, "JP_ToDo", whereClauseFinal.toString(), trxName).setParameters(new Object[]{m_ToDo.getJP_ToDo_Related_ID(), m_ToDo.getJP_ToDo_ID(), m_ToDo.getJP_ToDo_ID(), time}).setOrderBy(orderClause).list();
            }
        }
        boolean isContained = false;
        for (MToDo todo : list) {
            isContained = false;
            for (MToDo td : list_ToDo) {
                if (todo.getJP_ToDo_ID() != td.getJP_ToDo_ID()) continue;
                isContained = true;
            }
            if (isContained) continue;
            list_ToDo.add(todo);
            if (!isIncludingIndirectRelationships || !todo.getJP_Processing1().equals("Y")) continue;
            list_ToDo = MToDo.getRelatedToDos(ctx, todo, list_ToDo, time, true, trxName);
        }
        return list_ToDo;
    }

    @Override
    public int getParent_Team_ToDo_ID() {
        return this.getJP_ToDo_Team_ID();
    }

    @Override
    public void setJP_Mandatory_Statistics_Info(String JP_Mandatory_Statistics_Info) {
    }

    @Override
    public String getJP_Mandatory_Statistics_Info() {
        return null;
    }

    @Override
    public void setJP_Team_ID(int JP_Team_ID) {
    }

    @Override
    public int getJP_Team_ID() {
        return 0;
    }

    @Override
    public void setUpdated(Timestamp updated) {
        this.set_ValueNoCheck("Updated", updated);
    }

    @Override
    public boolean isCreatedToDoRepeatedly() {
        return this.getJP_Processing1().equals("Y");
    }

    @Override
    public void setisCreatedToDoRepeatedly(boolean Processed) {
        this.setJP_Processing1(Processed ? "Y" : "N");
    }

    @Override
    public int getRelated_ToDo_ID() {
        return this.getJP_ToDo_Related_ID();
    }
}

