/*
 * Decompiled with CFR 0.152.
 */
package jpiere.plugin.groupware.form;

import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Properties;
import jpiere.plugin.groupware.form.ReminderMenuListModel;
import jpiere.plugin.groupware.form.ReminderMenuRowRenderer;
import jpiere.plugin.groupware.model.I_ToDo;
import jpiere.plugin.groupware.model.I_ToDoReminder;
import jpiere.plugin.groupware.model.MToDoReminder;
import jpiere.plugin.groupware.model.MToDoTeamReminder;
import jpiere.plugin.groupware.window.PersonalToDoListWindow;
import jpiere.plugin.groupware.window.ReminderPopupWindow;
import jpiere.plugin.groupware.window.ToDoPopupWindow;
import org.adempiere.webui.ClientInfo;
import org.adempiere.webui.LayoutUtils;
import org.adempiere.webui.component.Borderlayout;
import org.adempiere.webui.component.Button;
import org.adempiere.webui.factory.ButtonFactory;
import org.adempiere.webui.theme.ThemeManager;
import org.adempiere.webui.util.ZKUpdateUtil;
import org.compiere.model.PO;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.HtmlBasedComponent;
import org.zkoss.zk.ui.event.Event;
import org.zkoss.zk.ui.event.EventListener;
import org.zkoss.zul.Center;
import org.zkoss.zul.Column;
import org.zkoss.zul.Columns;
import org.zkoss.zul.Grid;
import org.zkoss.zul.ListModel;
import org.zkoss.zul.North;
import org.zkoss.zul.Popup;
import org.zkoss.zul.RowRenderer;
import org.zkoss.zul.Window;

public class ReminderMenuPopup
extends Popup
implements EventListener<Event> {
    private Properties ctx = Env.getCtx();
    private Button createNewBtn = null;
    public static final String BUTTON_NEW_REMINDER = "NEW_REMINDER";
    public static final String BUTTON_UPDATE_REMINDER = "UPDATE_REMINDER";
    public static final String I_REMINDER = "I_ToDoReminder";
    private ToDoPopupWindow p_TodoPopupWindow = null;
    private PersonalToDoListWindow p_PersonalTodoListWindow = null;
    private I_ToDo p_iToDo;

    public ReminderMenuPopup(PersonalToDoListWindow PersonalTodoListWindow, I_ToDo p_iToDo) throws Exception {
        this.p_PersonalTodoListWindow = PersonalTodoListWindow;
        this.p_iToDo = p_iToDo;
        this.init();
    }

    public ReminderMenuPopup(ToDoPopupWindow todoPopupWindow, I_ToDo p_iToDo) throws Exception {
        this.p_TodoPopupWindow = todoPopupWindow;
        this.p_iToDo = p_iToDo;
        this.init();
    }

    private void init() throws Exception {
        PO model;
        ResultSet rs;
        CPreparedStatement pstmt;
        StringBuilder sql;
        ZKUpdateUtil.setVflex((HtmlBasedComponent)this, (String)"min");
        ZKUpdateUtil.setHflex((HtmlBasedComponent)this, (String)"min");
        Borderlayout popupContent = new Borderlayout();
        ZKUpdateUtil.setVflex((HtmlBasedComponent)popupContent, (String)"min");
        ZKUpdateUtil.setHflex((HtmlBasedComponent)popupContent, (String)"min");
        this.appendChild((Component)popupContent);
        North north = new North();
        ZKUpdateUtil.setVflex((HtmlBasedComponent)north, (String)"min");
        ZKUpdateUtil.setHflex((HtmlBasedComponent)north, (String)"min");
        this.createNewBtn = ButtonFactory.createButton((String)Msg.getMsg((Properties)this.ctx, (String)"JP_ToDo_Reminder_Create"), null, (String)"");
        if (ThemeManager.isUseFontIconForImage()) {
            this.createNewBtn.setIconSclass("z-icon-New");
        } else {
            this.createNewBtn.setImage(ThemeManager.getThemeResource((String)"images/New16.png"));
        }
        this.createNewBtn.setName(BUTTON_NEW_REMINDER);
        this.createNewBtn.addEventListener("onClick", (EventListener)this);
        north.appendChild((Component)this.createNewBtn);
        popupContent.appendChild((Component)north);
        ArrayList<I_ToDoReminder> list = new ArrayList<I_ToDoReminder>();
        if ("JP_ToDo".equals(this.p_iToDo.get_TableName())) {
            sql = new StringBuilder("SELECT * FROM JP_ToDo_Reminder WHERE JP_ToDo_ID=? ORDER BY JP_ToDo_RemindTime ASC");
            pstmt = null;
            rs = null;
            try {
                pstmt = DB.prepareStatement((String)sql.toString(), null);
                pstmt.setInt(1, this.p_iToDo.get_ID());
                rs = pstmt.executeQuery();
                while (rs.next()) {
                    model = new MToDoReminder(Env.getCtx(), rs, null);
                    list.add((I_ToDoReminder)model);
                }
            }
            catch (Throwable throwable) {
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
            DB.close((ResultSet)rs, (Statement)pstmt);
            rs = null;
            pstmt = null;
        } else {
            sql = new StringBuilder("SELECT * FROM JP_ToDo_Team_Reminder WHERE JP_ToDo_Team_ID=? ORDER BY JP_ToDo_RemindTime ASC");
            pstmt = null;
            rs = null;
            try {
                pstmt = DB.prepareStatement((String)sql.toString(), null);
                pstmt.setInt(1, this.p_iToDo.get_ID());
                rs = pstmt.executeQuery();
                while (rs.next()) {
                    model = new MToDoTeamReminder(Env.getCtx(), rs, null);
                    list.add((I_ToDoReminder)model);
                }
            }
            catch (Throwable throwable) {
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
            DB.close((ResultSet)rs, (Statement)pstmt);
            rs = null;
            pstmt = null;
        }
        if (list.size() == 0) {
            return;
        }
        Center center = new Center();
        ZKUpdateUtil.setVflex((HtmlBasedComponent)center, (String)"min");
        ZKUpdateUtil.setHflex((HtmlBasedComponent)center, (String)"min");
        popupContent.appendChild((Component)center);
        Grid grid = new Grid();
        ZKUpdateUtil.setVflex((HtmlBasedComponent)grid, (String)"min");
        ZKUpdateUtil.setHflex((HtmlBasedComponent)grid, (String)"min");
        grid.setMold("paging");
        grid.setPageSize(10);
        grid.setPagingPosition("top");
        center.appendChild((Component)grid);
        Columns columns = new Columns();
        columns.setSizable(true);
        grid.appendChild((Component)columns);
        Column column = null;
        column = new Column();
        columns.appendChild((Component)column);
        column.setLabel("");
        column.setWidth("30px");
        column = new Column();
        columns.appendChild((Component)column);
        column.setLabel(Msg.getElement((Properties)this.ctx, (String)"JP_ToDo_RemindTime"));
        if ("JP_ToDo_Team".equals(this.p_iToDo.get_TableName())) {
            column = new Column();
            columns.appendChild((Component)column);
            column.setLabel(Msg.getElement((Properties)this.ctx, (String)"JP_ToDo_RemindTarget"));
            column = new Column();
            columns.appendChild((Component)column);
            column.setLabel(Msg.getElement((Properties)this.ctx, (String)"JP_Team_ID"));
        }
        column = new Column();
        columns.appendChild((Component)column);
        column.setLabel(Msg.getElement((Properties)this.ctx, (String)"JP_ToDo_ReminderType"));
        column = new Column();
        columns.appendChild((Component)column);
        ZKUpdateUtil.setWidth((HtmlBasedComponent)column, (String)"180px");
        column.setLabel(Msg.getElement((Properties)this.ctx, (String)"Frequency"));
        column = new Column();
        columns.appendChild((Component)column);
        column.setLabel(Msg.getMsg((Properties)this.ctx, (String)"JP_Sent"));
        column = new Column();
        columns.appendChild((Component)column);
        column.setLabel(Msg.getElement((Properties)this.ctx, (String)"Processed"));
        if ("JP_ToDo".equals(this.p_iToDo.get_TableName())) {
            column = new Column();
            columns.appendChild((Component)column);
            column.setLabel(Msg.getElement((Properties)this.ctx, (String)"IsConfirmed"));
        }
        ReminderMenuListModel listModel = new ReminderMenuListModel(list);
        grid.setModel((ListModel)listModel);
        ReminderMenuRowRenderer rowRenderer = new ReminderMenuRowRenderer(this);
        grid.setRowRenderer((RowRenderer)rowRenderer);
    }

    public void onEvent(Event event) throws Exception {
        Component comp = event.getTarget();
        Button btn = (Button)comp;
        String btnName = btn.getName();
        if (BUTTON_NEW_REMINDER.equals(btnName)) {
            ReminderPopupWindow rpw = null;
            if (this.p_TodoPopupWindow != null) {
                rpw = new ReminderPopupWindow(this.p_TodoPopupWindow, this.p_iToDo, 0);
                this.p_TodoPopupWindow.appendChild((Component)rpw);
                if (ClientInfo.isMobile()) {
                    rpw.doHighlighted();
                } else {
                    this.p_TodoPopupWindow.showBusyMask(rpw);
                    LayoutUtils.openOverlappedWindow((Component)this.p_TodoPopupWindow, (Window)rpw, (String)"middle_center");
                    rpw.focus();
                }
            } else {
                rpw = new ReminderPopupWindow(this.p_PersonalTodoListWindow, this.p_iToDo, 0);
                this.p_PersonalTodoListWindow.appendChild((Component)rpw);
                if (ClientInfo.isMobile()) {
                    rpw.doHighlighted();
                } else {
                    this.p_PersonalTodoListWindow.showBusyMask(rpw);
                    LayoutUtils.openOverlappedWindow((Component)this.p_PersonalTodoListWindow, (Window)rpw, (String)"middle_center");
                    rpw.focus();
                }
            }
        } else if (BUTTON_UPDATE_REMINDER.equals(btnName)) {
            if (this.p_TodoPopupWindow != null) {
                I_ToDoReminder reminder = (I_ToDoReminder)comp.getAttribute(I_REMINDER);
                ReminderPopupWindow rpw = new ReminderPopupWindow(this.p_TodoPopupWindow, this.p_iToDo, reminder.get_ID());
                this.p_TodoPopupWindow.appendChild((Component)rpw);
                if (ClientInfo.isMobile()) {
                    rpw.doHighlighted();
                } else {
                    this.p_TodoPopupWindow.showBusyMask(rpw);
                    LayoutUtils.openOverlappedWindow((Component)this.p_TodoPopupWindow, (Window)rpw, (String)"middle_center");
                    rpw.focus();
                }
            } else {
                I_ToDoReminder reminder = (I_ToDoReminder)comp.getAttribute(I_REMINDER);
                ReminderPopupWindow rpw = new ReminderPopupWindow(this.p_PersonalTodoListWindow, this.p_iToDo, reminder.get_ID());
                this.p_PersonalTodoListWindow.appendChild((Component)rpw);
                if (ClientInfo.isMobile()) {
                    rpw.doHighlighted();
                } else {
                    this.p_PersonalTodoListWindow.showBusyMask(rpw);
                    LayoutUtils.openOverlappedWindow((Component)this.p_PersonalTodoListWindow, (Window)rpw, (String)"middle_center");
                    rpw.focus();
                }
            }
        }
        this.close();
    }
}

