/*
 * Decompiled with CFR 0.152.
 */
package jpiere.plugin.groupware.form;

import java.io.File;
import java.io.FileNotFoundException;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Properties;
import javax.activation.MimetypesFileTypeMap;
import jpiere.plugin.groupware.model.MInfoGadget;
import jpiere.plugin.groupware.model.MInfoGadgetCategory;
import org.adempiere.webui.component.DynamicMediaLink;
import org.adempiere.webui.component.Grid;
import org.adempiere.webui.component.GridFactory;
import org.adempiere.webui.component.Group;
import org.adempiere.webui.component.Row;
import org.adempiere.webui.dashboard.DashboardPanel;
import org.adempiere.webui.theme.ThemeManager;
import org.compiere.model.MAttachment;
import org.compiere.model.MAttachmentEntry;
import org.compiere.model.MClient;
import org.compiere.model.MRole;
import org.compiere.model.MTable;
import org.compiere.model.MUser;
import org.compiere.util.Env;
import org.compiere.util.Language;
import org.zkoss.util.media.AMedia;
import org.zkoss.zk.ui.Component;
import org.zkoss.zul.Html;
import org.zkoss.zul.Rows;

public class JPiereCreateInfoGadget
extends DashboardPanel {
    private Grid grid = GridFactory.newGridLayout();
    private org.adempiere.webui.component.Rows gridRows = this.grid.newRows();
    private Language lang = Env.getLanguage((Properties)Env.getCtx());
    private boolean isMultiLingual = true;
    MTable table_Trl = MTable.get((Properties)Env.getCtx(), (String)"JP_InfoGadget_Trl");
    MClient client = MClient.get((Properties)Env.getCtx());

    public JPiereCreateInfoGadget(int JP_InfoGadgetCategory_ID) {
        this.appendChild((Component)this.grid);
        MInfoGadgetCategory infoGadgetCategory = new MInfoGadgetCategory(Env.getCtx(), JP_InfoGadgetCategory_ID, null);
        if (infoGadgetCategory.getJP_PageSize() > 0) {
            this.grid.setMold("paging");
            this.grid.setPageSize(infoGadgetCategory.getJP_PageSize());
            this.grid.setPagingPosition("top");
        }
        Calendar calendar = Calendar.getInstance();
        long longtime = calendar.getTimeInMillis();
        Timestamp timestamp = new Timestamp(longtime);
        String systemTime = timestamp.toString();
        StringBuilder whereClause = new StringBuilder(" AND IsActive='Y' AND DateFrom <= TO_DATE('" + systemTime + "','YYYY-MM-DD HH24:MI:SS') AND DateTo >= TO_DATE('" + systemTime + "','YYYY-MM-DD HH24:MI:SS')");
        whereClause.append(" AND PublishStatus = 'R' ");
        if (Env.getAD_Client_ID((Properties)Env.getCtx()) == 0) {
            whereClause.append(" AND AD_Client_ID = 0");
        } else {
            whereClause.append(" AND AD_Client_ID in(0," + Env.getAD_Client_ID((Properties)Env.getCtx()) + ") ");
        }
        MRole role = MRole.get((Properties)Env.getCtx(), (int)Env.getAD_Role_ID((Properties)Env.getCtx()));
        String orgAccessSQL = role.getOrgWhere(false);
        if (orgAccessSQL != null) {
            whereClause.append(" AND ").append(orgAccessSQL);
        }
        StringBuilder orderClause = new StringBuilder(" Date1 DESC, JP_InfoGadget_ID DESC");
        MInfoGadget[] infoGadgets = infoGadgetCategory.getInfoGadgets(whereClause.toString(), orderClause.toString(), infoGadgetCategory.getMaxQueryRecords());
        int i = 0;
        while (infoGadgets.length > i) {
            this.createInfo(infoGadgets[i]);
            ++i;
        }
        if (infoGadgets.length == 0) {
            Row row = this.gridRows.newRow();
            row.setClass("jpiere-infogadget-content");
            row.appendChild((Component)new Html(infoGadgetCategory.getHelp()));
        }
    }

    private void createInfo(MInfoGadget infoGadget) {
        this.isMultiLingual = this.table_Trl == null ? false : this.client.isMultiLingualDocument();
        Row outerRow = new Row();
        this.gridRows.appendChild((Component)outerRow);
        Grid innerGrid = new Grid();
        innerGrid.setSclass("jpiere-infogadget");
        outerRow.appendChild((Component)innerGrid);
        Rows innerRows = new Rows();
        innerGrid.appendChild((Component)innerRows);
        SimpleDateFormat sdf = this.lang.getDateFormat();
        String groupTitle = null;
        MUser user = null;
        if (infoGadget.get_Value("AD_User_ID") != null) {
            user = MUser.get((Properties)Env.getCtx(), (int)infoGadget.getAD_User_ID());
        }
        groupTitle = this.isMultiLingual ? (user == null || infoGadget.getJP_InfoGadgetCategory().getJP_UserDisplayPosition().equals("N") ? new String(String.valueOf(sdf.format(infoGadget.getDate1())) + " " + infoGadget.get_Translation("Name")) : (infoGadget.getJP_InfoGadgetCategory().getJP_UserDisplayPosition().equals("R") ? new String(String.valueOf(sdf.format(infoGadget.getDate1())) + " " + infoGadget.get_Translation("Name") + " [" + user.getName() + "]") : new String(String.valueOf(sdf.format(infoGadget.getDate1())) + " [" + user.getName() + "] " + infoGadget.get_Translation("Name")))) : (user == null || infoGadget.getJP_InfoGadgetCategory().getJP_UserDisplayPosition().equals("N") ? new String(String.valueOf(sdf.format(infoGadget.getDate1())) + " " + infoGadget.getName()) : (infoGadget.getJP_InfoGadgetCategory().getJP_UserDisplayPosition().equals("R") ? new String(String.valueOf(sdf.format(infoGadget.getDate1())) + " " + infoGadget.getName() + " [" + user.getName() + "]") : new String(String.valueOf(sdf.format(infoGadget.getDate1())) + " [" + user.getName() + "] " + infoGadget.getName())));
        Group innerRowGroup = new Group(groupTitle);
        innerRowGroup.setSclass("jpiere-infogadget-header");
        innerRows.appendChild((Component)innerRowGroup);
        Row innerRow = new Row();
        innerRow.setSclass("jpiere-infogadget-content");
        Html html = null;
        html = this.isMultiLingual ? new Html(infoGadget.get_Translation("HTML")) : new Html(infoGadget.getHTML());
        innerRow.appendChild((Component)html);
        innerRow.setGroup(innerRowGroup);
        innerRows.appendChild((Component)innerRow);
        MAttachment attachment = infoGadget.getAttachment();
        if (attachment != null) {
            MAttachmentEntry[] entry = attachment.getEntries();
            int j = 0;
            while (entry.length > j) {
                MimetypesFileTypeMap mimeMap = new MimetypesFileTypeMap();
                File file = entry[j].getFile();
                try {
                    AMedia media = new AMedia(file, mimeMap.getContentType(file), null);
                    DynamicMediaLink link = new DynamicMediaLink();
                    innerRow = new Row();
                    innerRow.setSclass("jpiere-infogadget-attachment");
                    innerRow.setGroup(innerRowGroup);
                    innerRows.appendChild((Component)innerRow);
                    innerRow.appendChild((Component)link);
                    link.setImage(ThemeManager.getThemeResource((String)"images/Attachment24.png"));
                    link.setMedia(media);
                    link.setLabel(media.getName());
                    link.setStyle("margin: 5px;");
                }
                catch (FileNotFoundException fileNotFoundException) {
                    // empty catch block
                }
                ++j;
            }
        }
        if (infoGadget.isCollapsedByDefault()) {
            innerRowGroup.setOpen(false);
            innerRow.setVisible(false);
        } else {
            innerRowGroup.setOpen(true);
            innerRow.setVisible(true);
        }
    }
}

