/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.pipo2;

import java.io.File;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import org.adempiere.pipo2.PackOut;
import org.adempiere.pipo2.PackoutDocument;
import org.adempiere.pipo2.PackoutItem;
import org.compiere.model.MPackageExp;
import org.compiere.model.MPackageExpDetail;
import org.compiere.model.MTable;
import org.compiere.model.Query;
import org.compiere.process.SvrProcess;
import org.compiere.util.Env;

public class PackOutProcess
extends SvrProcess {
    private int p_PackOut_ID = 0;
    private MPackageExp packageExp;
    private String packoutDirectory;

    protected void prepare() {
        this.p_PackOut_ID = this.getRecord_ID();
    }

    protected String doIt() throws Exception {
        if (this.log.isLoggable(Level.INFO)) {
            this.log.info("doIt - AD_PACKAGE_EXP_ID=" + this.p_PackOut_ID);
        }
        if (this.p_PackOut_ID == 0) {
            throw new IllegalArgumentException("No Record");
        }
        int processedCount = 0;
        String exportFile = "";
        try {
            this.packageExp = new MPackageExp(this.getCtx(), this.p_PackOut_ID, this.get_TrxName());
            if (this.packageExp.getAD_Package_Exp_ID() == this.p_PackOut_ID) {
                boolean success;
                this.packoutDirectory = System.getProperty("java.io.tmpdir");
                if (!this.packoutDirectory.endsWith("/") && !this.packoutDirectory.endsWith("\\")) {
                    this.packoutDirectory = String.valueOf(this.packoutDirectory) + File.separator;
                }
                this.packoutDirectory = String.valueOf(this.packoutDirectory) + "packout" + Env.getContext((Properties)this.getCtx(), (String)"#AD_User_ID") + File.separator;
                File packoutDirectoryFile = new File(this.packoutDirectory);
                if (!packoutDirectoryFile.exists() && !(success = packoutDirectoryFile.mkdirs())) {
                    this.log.warning("Failed to create target directory. " + this.packoutDirectory);
                }
                PackoutDocument packoutDocument = new PackoutDocument(this.packageExp.getName(), this.packageExp.getPK_Version(), this.packageExp.getReleaseNo(), this.packageExp.getVersion(), this.packageExp.getDescription(), this.packageExp.getInstructions(), this.packageExp.getUserName(), this.packageExp.getEMail(), this.packageExp.getCreated(), this.packageExp.getUpdated());
                ArrayList<PackoutItem> packoutItems = new ArrayList<PackoutItem>();
                Query query = new Query(this.getCtx(), MTable.get((Properties)this.getCtx(), (int)50006), "AD_Package_Exp_ID = ?", this.get_TrxName());
                List packageExpDetails = query.setOnlyActiveRecords(true).setOrderBy("Line").setParameters(new Object[]{this.p_PackOut_ID}).list();
                for (MPackageExpDetail dtl : packageExpDetails) {
                    String type = this.getTypeName(dtl.getType());
                    if (this.log.isLoggable(Level.INFO)) {
                        this.log.info(Integer.toString(dtl.getLine()));
                    }
                    PackoutItem item = new PackoutItem(type, dtl.getExpRecordId(), this.getExpProperties(dtl));
                    packoutItems.add(item);
                }
                PackOut packOut = new PackOut();
                packOut.setCtx(this.getCtx());
                Timestamp dateFromValue = this.packageExp.getDateFrom();
                if (dateFromValue != null) {
                    packOut.setFromDate(dateFromValue);
                }
                packOut.setExportDictionaryEntity(this.packageExp.isExportDictionaryEntity());
                packOut.export(this.packoutDirectory, null, packoutDocument, packoutItems, this.get_TrxName());
                processedCount = packOut.getExportCount();
                exportFile = packOut.getExportFile();
            }
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, e.getLocalizedMessage(), (Throwable)e);
            throw e;
        }
        if (this.processUI != null) {
            this.processUI.download(new File(exportFile));
        }
        return "Exported=" + processedCount + " File=" + exportFile;
    }

    private String getTypeName(String type) {
        if ("M".equals(type)) {
            return "AD_Menu";
        }
        if ("D".equals(type)) {
            return "table.genericHandler";
        }
        if ("DS".equals(type)) {
            return "table.genericSingleHandler";
        }
        if ("V".equals(type)) {
            return "AD_Val_Rule";
        }
        if ("X".equals(type)) {
            return "AD_Form";
        }
        if ("IMP".equals(type)) {
            return "AD_ImpFormat";
        }
        if ("MSG".equals(type)) {
            return "AD_Message";
        }
        if ("PFT".equals(type)) {
            return "AD_PrintFormat";
        }
        if ("P".equals(type)) {
            return "AD_Process";
        }
        if ("REF".equals(type)) {
            return "AD_Reference";
        }
        if ("R".equals(type)) {
            return "AD_ReportView";
        }
        if ("S".equals(type)) {
            return "AD_Role";
        }
        if ("SQL".equals(type)) {
            return "SQLStatement";
        }
        if ("SQM".equals(type)) {
            return "SQLMandatory";
        }
        if ("T".equals(type)) {
            return "AD_Table";
        }
        if ("W".equals(type)) {
            return "AD_Window";
        }
        if ("F".equals(type)) {
            return "AD_Workflow";
        }
        if ("MV".equals(type)) {
            return "AD_ModelValidator";
        }
        if ("ET".equals(type)) {
            return "AD_EntityType";
        }
        if ("IW".equals(type)) {
            return "AD_InfoWindow";
        }
        if ("SH".equals(type)) {
            return "ShellScript";
        }
        if ("SCJ".equals(type)) {
            return "ScriptJSR223";
        }
        return type;
    }

    private Map<String, Object> getExpProperties(MPackageExpDetail dtl) {
        HashMap<String, Object> properties = new HashMap<String, Object>();
        String type = dtl.getType();
        if ("D".equals(type) || "DS".equals(type)) {
            properties.put("AD_Table_ID", dtl.getAD_Table_ID());
            properties.put("SQLStatement", dtl.getSQLStatement());
        } else if ("SQL".equals(type) || "SQM".equals(type)) {
            properties.put("SQLStatement", dtl.getSQLStatement());
            properties.put("DBType", dtl.getDBType());
        } else if ("SH".equals(type) || "SCJ".equals(type)) {
            properties.put("ExecCode", dtl.getExecCode());
        }
        return properties;
    }
}

