/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.pipo2;

import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.adempiere.exceptions.AdempiereException;
import org.adempiere.pipo2.IDFinder;
import org.adempiere.pipo2.PIPOContext;
import org.adempiere.pipo2.PackInHandler;
import org.adempiere.pipo2.PackInNotifier;
import org.compiere.model.MSysConfig;
import org.compiere.model.PO;
import org.compiere.model.X_AD_Package_Imp_Detail;
import org.compiere.model.X_AD_Package_Imp_Proc;
import org.compiere.util.CLogger;
import org.compiere.util.Trx;
import org.xml.sax.helpers.DefaultHandler;

public class PackIn {
    private static final CLogger log = CLogger.getCLogger(PackIn.class);
    private boolean m_UpdateDictionary = false;
    private String m_packageDirectory = null;
    private Map<String, Integer> tableCache = new HashMap<String, Integer>();
    private Map<String, Integer> columnCache = new HashMap<String, Integer>();
    private String packageName = null;
    private String packageVersion = null;
    private PackInNotifier notifier = new PackInNotifier(this);
    private X_AD_Package_Imp_Proc packinProc;
    private List<X_AD_Package_Imp_Detail> importDetails;
    private boolean success = false;

    public void addTable(String tableName, int tableId) {
        this.tableCache.put(tableName, tableId);
    }

    public int getTableId(String tableName) {
        if (this.tableCache.containsKey(tableName)) {
            return this.tableCache.get(tableName);
        }
        return 0;
    }

    public void addColumn(String tableName, String columnName, int columnId) {
        this.columnCache.put(String.valueOf(tableName) + "." + columnName, columnId);
    }

    public int getColumnId(String tableName, String columnName) {
        String key = String.valueOf(tableName) + "." + columnName;
        if (this.columnCache.containsKey(key)) {
            return this.columnCache.get(key);
        }
        return 0;
    }

    public String importXML(String fileName, Properties ctx, String trxName) throws Exception {
        File in;
        if (log.isLoggable(Level.INFO)) {
            log.info("importXML:" + fileName);
        }
        if (!(in = new File(fileName)).exists()) {
            String msg = "File does not exist: " + fileName;
            if (log.isLoggable(Level.INFO)) {
                log.info("importXML:" + msg);
            }
            return msg;
        }
        try {
            Throwable msg = null;
            Object var6_9 = null;
            try (FileInputStream input = new FileInputStream(in);){
                return this.importXML(input, ctx, trxName);
            }
            catch (Throwable throwable) {
                if (msg == null) {
                    msg = throwable;
                } else if (msg != throwable) {
                    msg.addSuppressed(throwable);
                }
                throw msg;
            }
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "importXML:", (Throwable)e);
            throw e;
        }
    }

    public void addImportDetail(X_AD_Package_Imp_Detail importDetail) {
        this.importDetails.add(importDetail);
    }

    public String importXML(InputStream input, Properties ctx, String trxName) {
        try {
            log.info("starting");
            IDFinder.clearIDCache();
            this.importDetails = new ArrayList<X_AD_Package_Imp_Detail>();
            PackInHandler handler = new PackInHandler();
            PIPOContext context = new PIPOContext();
            context.trx = Trx.get((String)trxName, (boolean)true);
            context.packIn = this;
            context.ctx = ctx;
            context.ctx.setProperty("isHandleTranslations", MSysConfig.getValue((String)"2PACK_HANDLE_TRANSLATIONS"));
            handler.setCtx(context);
            handler.setProcess(this);
            SAXParserFactory factory = SAXParserFactory.newInstance();
            SAXParser parser = factory.newSAXParser();
            String msg = "Start Parser";
            log.info(msg);
            parser.parse(input, (DefaultHandler)handler);
            for (PO pO : this.importDetails) {
                pO.saveEx();
            }
            msg = "End Parser";
            log.info(msg);
            msg = "Processed=" + handler.getElementsProcessed() + " Un-Resolved=" + handler.getUnresolvedCount();
            this.getNotifier().addStatusLine(msg);
            if (handler.getUnresolvedCount() > 0) {
                handler.dumpUnresolvedElements();
                throw new AdempiereException("Unresolved elements");
            }
            return msg;
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "importXML:", (Throwable)e);
            throw new RuntimeException(e.getLocalizedMessage(), e);
        }
    }

    public String getPackageDirectory() {
        return this.m_packageDirectory;
    }

    public void setPackageDirectory(String packageDirectory) {
        this.m_packageDirectory = packageDirectory;
    }

    public boolean isUpdateDictionary() {
        return this.m_UpdateDictionary;
    }

    public void setUpdateDictionary(boolean updateDictionary) {
        this.m_UpdateDictionary = updateDictionary;
    }

    public byte[] readBlob(String fileName) throws IOException {
        byte[] data = null;
        File file = new File(String.valueOf(this.m_packageDirectory) + File.separator + "blobs" + File.separator, fileName);
        FileInputStream fis = null;
        BufferedInputStream bis = null;
        try {
            int b;
            fis = new FileInputStream(file);
            bis = new BufferedInputStream(fis);
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            while ((b = bis.read()) != -1) {
                baos.write(b);
            }
            data = baos.toByteArray();
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (IOException iOException) {}
            }
            if (bis != null) {
                try {
                    bis.close();
                }
                catch (Exception exception) {}
                bis = null;
            }
        }
        return data;
    }

    public File[] readFilesFromBlob(String fileName) throws IOException {
        ZipFile zf = new ZipFile(String.valueOf(this.m_packageDirectory) + File.separator + "blobs" + File.separator + fileName);
        Enumeration<? extends ZipEntry> e = zf.entries();
        ArrayList<File> files = new ArrayList<File>();
        File[] retValue = null;
        try {
            while (e.hasMoreElements()) {
                ZipEntry ze = e.nextElement();
                File file = new File(this.m_packageDirectory, ze.getName());
                if (!file.toPath().normalize().startsWith(this.m_packageDirectory)) {
                    throw new AdempiereException("Bad zip entry: " + ze.getName());
                }
                FileOutputStream fout = new FileOutputStream(file);
                InputStream in = zf.getInputStream(ze);
                int c = in.read();
                while (c != -1) {
                    fout.write(c);
                    c = in.read();
                }
                in.close();
                fout.close();
                files.add(file);
            }
            retValue = new File[files.size()];
            files.toArray(retValue);
        }
        finally {
            zf.close();
        }
        return retValue;
    }

    public String getPackageName() {
        return this.packageName;
    }

    public void setPackageName(String packageName) {
        this.packageName = packageName;
    }

    public String getPackageVersion() {
        return this.packageVersion;
    }

    public void setPackageVersion(String packageVersion) {
        this.packageVersion = packageVersion;
    }

    public PackInNotifier getNotifier() {
        return this.notifier;
    }

    public X_AD_Package_Imp_Proc getAD_Package_Imp_Proc() {
        if (this.packinProc.getAD_Package_Imp_Proc_ID() == 0) {
            this.packinProc.saveEx();
        }
        return this.packinProc;
    }

    public void setAD_Package_Imp_Proc(X_AD_Package_Imp_Proc packinProc) {
        this.packinProc = packinProc;
    }

    public void setSuccess(boolean success) {
        this.success = success;
    }

    public boolean isSuccess() {
        return this.success;
    }
}

