/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.pipo2;

import java.util.Properties;
import java.util.UUID;
import org.adempiere.pipo2.Element;
import org.adempiere.pipo2.PIPOContext;
import org.compiere.model.MTable;
import org.compiere.model.PO;
import org.compiere.model.Query;
import org.compiere.model.X_AD_Package_UUID_Map;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Util;

public class POFinder {
    private POFinder() {
    }

    public static String getTargetUUID(Properties ctx, String tableName, String uuid, String trxName) {
        int AD_Client_ID = Env.getAD_Client_ID((Properties)ctx);
        if (AD_Client_ID == 0) {
            return uuid;
        }
        MTable table = MTable.get((Properties)ctx, (String)tableName);
        if (table == null) {
            throw new IllegalStateException("getTargetUUID couldn't find table named " + tableName);
        }
        String sql = "SELECT Target_UUID FROM AD_Package_UUID_Map WHERE AD_Client_ID=? AND AD_Table_ID=? AND Source_UUID=?";
        String uid = DB.getSQLValueString((String)trxName, (String)sql, (Object[])new Object[]{AD_Client_ID, table.getAD_Table_ID(), uuid});
        return Util.isEmpty((String)uid) ? uuid : uid;
    }

    public static void updateUUIDMap(PIPOContext ctx, String tableName, String uuid, String targetUUID) {
        X_AD_Package_UUID_Map map = new X_AD_Package_UUID_Map(ctx.ctx, 0, ctx.trx.getTrxName());
        MTable table = MTable.get((Properties)ctx.ctx, (String)tableName);
        map.setAD_Table_ID(table.getAD_Table_ID());
        map.setSource_UUID(uuid);
        map.setTarget_UUID(targetUUID);
        map.saveEx();
    }

    public static <T extends PO> T findPO(PIPOContext ctx, Element element) {
        String id;
        String uuid;
        PO po = null;
        String tableName = element.getElementValue();
        String uuidColumn = PO.getUUIDColumnName((String)tableName);
        String idColumn = String.valueOf(tableName) + "_ID";
        if (element.properties.containsKey(uuidColumn) && (uuid = element.properties.get((Object)uuidColumn).contents.toString()) != null && uuid.trim().length() <= 36) {
            uuid = uuid.trim();
            String targetUUID = Env.getAD_Client_ID((Properties)ctx.ctx) > 0 ? POFinder.getTargetUUID(ctx.ctx, tableName, uuid, ctx.trx.getTrxName()) : uuid;
            Query query = new Query(ctx.ctx, tableName, String.valueOf(uuidColumn) + "=?", POFinder.getTrxName(ctx));
            try {
                PO.setCrossTenantSafe();
                po = query.setParameters(new Object[]{targetUUID}).firstOnly();
            }
            finally {
                PO.clearCrossTenantSafe();
            }
            if (po != null && po.getAD_Client_ID() > 0 && po.getAD_Client_ID() > 0 && po.getAD_Client_ID() != Env.getAD_Client_ID((Properties)ctx.ctx)) {
                targetUUID = UUID.randomUUID().toString();
                POFinder.updateUUIDMap(ctx, tableName, uuid, targetUUID);
                return null;
            }
        }
        if (po == null && element.properties.containsKey(idColumn) && (id = element.properties.get((Object)idColumn).contents.toString()) != null && id.trim().length() > 0) {
            Query query = new Query(ctx.ctx, tableName, String.valueOf(idColumn) + "=?", POFinder.getTrxName(ctx));
            try {
                PO.setCrossTenantSafe();
                po = query.setParameters(new Object[]{Integer.valueOf(id.trim())}).firstOnly();
            }
            finally {
                PO.clearCrossTenantSafe();
            }
            if (po != null && po.getAD_Client_ID() > 0 && po.getAD_Client_ID() != Env.getAD_Client_ID((Properties)ctx.ctx)) {
                throw new IllegalStateException("2Pack cannot update/access record that belongs to another tenant. TableName=" + po.get_TableName() + ", Record_ID=" + po.get_ID() + ", AD_Client_ID=" + po.getAD_Client_ID() + " Context AD_Client_ID=" + Env.getAD_Client_ID((Properties)ctx.ctx));
            }
        }
        return (T)po;
    }

    private static String getTrxName(PIPOContext ctx) {
        return ctx.trx != null ? ctx.trx.getTrxName() : null;
    }
}

