/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.pipo2;

import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import org.adempiere.pipo2.exception.DatabaseAccessException;
import org.apache.commons.codec.DecoderException;
import org.apache.commons.codec.binary.Hex;
import org.compiere.model.MColumn;
import org.compiere.model.MTable;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;

public class IDFinder {
    private static final CLogger log = CLogger.getCLogger(IDFinder.class);
    private static Map<String, Integer> idCache = new ConcurrentHashMap<String, Integer>();

    public static int findIdByColumn(String tableName, String columnName, Object value, int AD_Client_ID, boolean ignorecase, String trxName) {
        if (value == null) {
            return 0;
        }
        int id = -1;
        StringBuilder key = new StringBuilder();
        key.append(tableName).append(".").append(columnName).append("=").append(value.toString()).append(" AND AD_Client_ID=").append(AD_Client_ID);
        if (idCache.containsKey(key.toString())) {
            return idCache.get(key.toString());
        }
        StringBuilder sqlB = new StringBuilder("SELECT ").append(tableName).append("_ID FROM ").append(tableName).append(" WHERE ").append(" AD_Client_ID IN (0, ?) AND ");
        Object[] params = null;
        String[] columns = null;
        if (columnName.indexOf(",") > 0 && value instanceof String) {
            columns = columnName.split("[,]");
            String[] values = ((String)value).split("[,]");
            ArrayList<String> paramList = new ArrayList<String>();
            int i = 0;
            while (i < columns.length) {
                if (i > 0) {
                    sqlB.append(" AND ");
                }
                if (ignorecase) {
                    sqlB.append("UPPER(").append(columns[i]).append(")=? ");
                } else {
                    sqlB.append(columns[i]).append("=? ");
                }
                try {
                    byte[] bytes = Hex.decodeHex((char[])values[i].toCharArray());
                    String s = new String(bytes, "UTF-8");
                    if (ignorecase) {
                        paramList.add(s.toUpperCase());
                    } else {
                        paramList.add(s);
                    }
                }
                catch (DecoderException e) {
                    throw new RuntimeException(e);
                }
                catch (UnsupportedEncodingException e) {
                    throw new RuntimeException(e);
                }
                ++i;
            }
            params = paramList.toArray();
        } else {
            if (ignorecase && value != null && value instanceof String) {
                sqlB.append("UPPER(").append(columnName).append(") =? ");
                params = new Object[]{((String)value).toUpperCase()};
            } else {
                sqlB.append(columnName).append(" =? ");
                params = new Object[]{value};
            }
            columns = new String[]{columnName};
        }
        sqlB.append(" Order By AD_Client_ID Desc, ").append(tableName).append("_ID");
        MTable table = MTable.get((Properties)Env.getCtx(), (String)tableName);
        CPreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            try {
                pstmt = DB.prepareStatement((String)sqlB.toString(), (String)trxName);
                pstmt.setInt(1, AD_Client_ID);
                int i = 0;
                while (i < params.length) {
                    Object param = params[i];
                    if (param instanceof String) {
                        String s = (String)param;
                        MColumn column = table.getColumn(columns[i]);
                        if (column.getAD_Reference_ID() == 12 || column.getAD_Reference_ID() == 22 || column.getAD_Reference_ID() == 37 || column.getAD_Reference_ID() == 29) {
                            pstmt.setBigDecimal(i + 2, new BigDecimal(s));
                        } else if (column.getAD_Reference_ID() == 15 || column.getAD_Reference_ID() == 16) {
                            pstmt.setTimestamp(i + 2, Timestamp.valueOf(s));
                        } else if (column.getAD_Reference_ID() == 11) {
                            pstmt.setInt(i + 2, Integer.parseInt(s));
                        } else {
                            pstmt.setString(i + 2, s);
                        }
                    } else if (param instanceof Integer) {
                        pstmt.setInt(i + 2, (Integer)param);
                    } else {
                        pstmt.setObject(i + 2, param);
                    }
                    ++i;
                }
                rs = pstmt.executeQuery();
                if (rs.next()) {
                    id = rs.getInt(1);
                }
            }
            catch (Exception e) {
                throw new DatabaseAccessException(e);
            }
        }
        catch (Throwable throwable) {
            DB.close(rs, pstmt);
            throw throwable;
        }
        DB.close((ResultSet)rs, (Statement)pstmt);
        if (id >= 0) {
            idCache.put(key.toString(), id);
        }
        return id;
    }

    public static int findIdByColumn(String tableName, String columnName, Object value, int clientId, String trxName) {
        return IDFinder.findIdByColumn(tableName, columnName, value, clientId, false, trxName);
    }

    public static int findIdByNameAndParentName(String tableName, String name, String tableNameMaster, String nameMaster, int AD_Client_ID, String trxName) {
        int id = 0;
        StringBuilder key = new StringBuilder();
        key.append(tableName).append(".Name=").append(name).append(" and ").append(tableNameMaster).append(".Name=").append(nameMaster);
        if (idCache.containsKey(key.toString())) {
            return idCache.get(key.toString());
        }
        StringBuilder parentSql = new StringBuilder("SELECT ").append(tableNameMaster).append("_ID FROM ").append(tableNameMaster).append(" WHERE Name = ? AND AD_Client_ID IN (0, ?) ").append("ORDER BY AD_Client_ID  Desc");
        int parentId = DB.getSQLValue((String)trxName, (String)parentSql.toString(), (Object[])new Object[]{name, Env.getAD_Client_ID((Properties)Env.getCtx())});
        if (parentId > 0) {
            StringBuilder sqlB = new StringBuilder("SELECT ").append(tableName).append("_ID FROM ").append(tableName).append(" WHERE Name = ? AND ").append(tableNameMaster).append("_ID = ?");
            CPreparedStatement pstmt = null;
            ResultSet rs = null;
            try {
                try {
                    pstmt = DB.prepareStatement((String)sqlB.toString(), (String)trxName);
                    pstmt.setString(1, name);
                    pstmt.setString(2, nameMaster);
                    pstmt.setInt(3, parentId);
                    rs = pstmt.executeQuery();
                    if (rs.next()) {
                        id = rs.getInt(1);
                    }
                }
                catch (Exception e) {
                    throw new DatabaseAccessException(e);
                }
            }
            catch (Throwable throwable) {
                DB.close(rs, pstmt);
                throw throwable;
            }
            DB.close((ResultSet)rs, (Statement)pstmt);
        }
        if (id > 0) {
            idCache.put(key.toString(), id);
        }
        return id;
    }

    public static int findIdByColumnAndParentId(String tableName, String columnName, String name, String tableNameMaster, int masterID, int AD_Client_ID, String trxName) {
        return IDFinder.findIdByColumnAndParentId(tableName, columnName, name, tableNameMaster, masterID, AD_Client_ID, false, trxName);
    }

    public static int findIdByColumnAndParentId(String tableName, String columnName, String name, String tableNameMaster, int masterID, int AD_Client_ID, boolean ignoreCase, String trxName) {
        int id = 0;
        String key = String.valueOf(tableName) + "." + columnName + "=" + name + tableNameMaster + "=" + masterID;
        if (idCache.containsKey(key)) {
            return idCache.get(key);
        }
        StringBuilder sqlB = new StringBuilder("SELECT ").append(tableName).append("_ID FROM ").append(tableName).append(" WHERE ");
        if (ignoreCase) {
            sqlB.append("Upper(").append(columnName).append(") = ? and ");
        } else {
            sqlB.append(columnName).append(" = ? and ");
        }
        sqlB.append(String.valueOf(tableNameMaster) + "_ID = ? AND AD_Client_ID IN (0, ?) ").append("ORDER BY AD_Client_ID Desc ");
        if (log.isLoggable(Level.INFO)) {
            log.info(sqlB.toString());
        }
        CPreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            try {
                pstmt = DB.prepareStatement((String)sqlB.toString(), (String)trxName);
                if (ignoreCase) {
                    pstmt.setString(1, name.toUpperCase());
                } else {
                    pstmt.setString(1, name);
                }
                pstmt.setInt(2, masterID);
                pstmt.setInt(3, AD_Client_ID);
                rs = pstmt.executeQuery();
                if (rs.next()) {
                    id = rs.getInt(1);
                }
            }
            catch (Exception e) {
                throw new DatabaseAccessException(e);
            }
        }
        catch (Throwable throwable) {
            DB.close(rs, pstmt);
            throw throwable;
        }
        DB.close((ResultSet)rs, (Statement)pstmt);
        if (id > 0) {
            idCache.put(key, id);
        }
        return id;
    }

    public static int findIdByNameAndParentId(String tableName, String name, String tableNameMaster, int masterID, int AD_Client_ID, String trxName) {
        int id = 0;
        StringBuilder key = new StringBuilder();
        key.append(tableName).append(".Name=").append(name).append(" AND ").append(tableNameMaster).append(".").append(tableNameMaster).append("_ID=").append(masterID);
        if (idCache.containsKey(key.toString())) {
            return idCache.get(key.toString());
        }
        StringBuilder sqlB = new StringBuilder("SELECT ").append(tableName).append("_ID FROM ").append(tableName).append(" WHERE Name=? AND ").append(tableNameMaster).append("_ID=? AND AD_Client_ID IN (0, ?) ").append("ORDER BY AD_Client_ID Desc");
        CPreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            try {
                pstmt = DB.prepareStatement((String)sqlB.toString(), (String)trxName);
                pstmt.setString(1, name);
                pstmt.setInt(2, masterID);
                pstmt.setInt(3, AD_Client_ID);
                rs = pstmt.executeQuery();
                if (rs.next()) {
                    id = rs.getInt(1);
                }
            }
            catch (Exception e) {
                throw new DatabaseAccessException(e);
            }
        }
        catch (Throwable throwable) {
            DB.close(rs, pstmt);
            throw throwable;
        }
        DB.close((ResultSet)rs, (Statement)pstmt);
        if (id > 0) {
            idCache.put(key.toString(), id);
        }
        return id;
    }

    public static int findIdByName(String tableName, String name, int AD_Client_ID, String trxName) {
        int id = 0;
        StringBuilder key = new StringBuilder();
        key.append(tableName).append(".Name=").append(name);
        if (!tableName.startsWith("AD_")) {
            key.append(" AND AD_Client_ID=").append(AD_Client_ID);
        }
        if (idCache.containsKey(key.toString())) {
            return idCache.get(key.toString());
        }
        StringBuilder sql = new StringBuilder("SELECT ").append(tableName).append("_ID ").append("FROM ").append(tableName).append(" ").append("WHERE Name=? ").append(" AND AD_Client_ID IN (0, ?) ").append(" ORDER BY AD_Client_ID Desc");
        CPreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            try {
                pstmt = DB.prepareStatement((String)sql.toString(), (String)trxName);
                pstmt.setString(1, name);
                pstmt.setInt(2, AD_Client_ID);
                rs = pstmt.executeQuery();
                if (rs.next()) {
                    id = rs.getInt(1);
                }
            }
            catch (Exception e) {
                throw new DatabaseAccessException(e);
            }
        }
        catch (Throwable throwable) {
            DB.close(rs, pstmt);
            throw throwable;
        }
        DB.close((ResultSet)rs, (Statement)pstmt);
        if (id > 0) {
            idCache.put(key.toString(), id);
        }
        return id;
    }

    public static void clearIDCache() {
        idCache.clear();
    }
}

